/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.preference.doctype;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.core.utilShare.UtilityPreference;
import org.grits.toolbox.entry.archive.model.DocumentType;
import org.grits.toolbox.entry.archive.preference.PreferenceHandler;
import org.grits.toolbox.entry.archive.preference.doctype.DocumentTypeComparator;
import org.grits.toolbox.entry.archive.preference.doctype.DocumentTypeContentProvider;
import org.grits.toolbox.entry.archive.preference.doctype.DocumentTypeFontLabelProvider;
import org.grits.toolbox.entry.archive.preference.doctype.MakeDefaultAction;
import org.jdom.Element;

public class DocTypePreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger((String)DocTypePreference.class.getName());
    public static final String PREFERENCE_NAME_ALL = String.valueOf(DocTypePreference.class.getName()) + ".all";
    private static final String NEW_DOCUMENT_TYPE_PREFIX = "New DocumentType ";
    private static final String DEFAULT_PREFERENCE_FILE = "docType_preference.xml";
    private static int newDocumentTypeCount = 0;
    public static List<DocumentType> ALL_DOCUMENT_TYPES = null;
    public static DocumentType DEFAULT_DOCUMENT_TYPE = null;
    private TreeViewer treeViewer = null;
    private MakeDefaultAction makeDefaultAction = null;

    public static void loadPreferences() {
        ALL_DOCUMENT_TYPES = new ArrayList<DocumentType>();
        DEFAULT_DOCUMENT_TYPE = null;
        newDocumentTypeCount = 0;
        boolean loaded = false;
        try {
            try {
                PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
                if (preferenceEntity != null) {
                    DocTypePreference.addToSet(UtilityPreferenceValue.getPreferenceValuesWithSelection((PreferenceEntity)preferenceEntity));
                    loaded = true;
                } else {
                    loaded = DocTypePreference.loadValuesPreVersioning();
                }
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                loaded = DocTypePreference.loadValuesPreVersioning();
            }
            if (!loaded) {
                File preferenceFile = new File(String.valueOf(FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.entry.archive").getResource("preference")).getPath()) + File.separator + DEFAULT_PREFERENCE_FILE);
                ALL_DOCUMENT_TYPES = PreferenceHandler.getDocumentTypesFromXml(preferenceFile);
                for (DocumentType docType : ALL_DOCUMENT_TYPES) {
                    if (!docType.isMakeDefault()) continue;
                    DEFAULT_DOCUMENT_TYPE = docType;
                    break;
                }
                DocTypePreference.saveValues();
            }
            if (!ALL_DOCUMENT_TYPES.isEmpty() && DEFAULT_DOCUMENT_TYPE == null) {
                DEFAULT_DOCUMENT_TYPE = ALL_DOCUMENT_TYPES.iterator().next();
                DEFAULT_DOCUMENT_TYPE.setMakeDefault(true);
                DocTypePreference.saveValues();
            }
            DocTypePreference.updateDocumentTypeCount();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the Preference variable for DocumentType", (Throwable)ex);
        }
    }

    private static boolean loadValuesPreVersioning() {
        boolean loaded = false;
        String prevPrefName = PREFERENCE_NAME_ALL;
        Element preferenceElement = PreferenceReader.getPreferenceElement((String)prevPrefName);
        if (preferenceElement == null) {
            prevPrefName = "class " + prevPrefName;
            preferenceElement = PreferenceReader.getPreferenceElement((String)prevPrefName);
        }
        if (preferenceElement != null) {
            DocumentType documentType = null;
            for (String preferenceValueString : UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement)) {
                documentType = DocTypePreference.getDocumentTypeFromXml(preferenceValueString);
                if (documentType == null) continue;
                ALL_DOCUMENT_TYPES.add(documentType);
            }
            DEFAULT_DOCUMENT_TYPE = DocTypePreference.getDocumentTypeFromXml(UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement));
            PreferenceWriter.deletePreference((String)prevPrefName);
            DocTypePreference.saveValues();
            loaded = true;
        }
        return loaded;
    }

    private static void addToSet(Map<String, Boolean> preferenceValuesWithSelection) {
        DocumentType documentType = null;
        for (String keyword : preferenceValuesWithSelection.keySet()) {
            documentType = DocTypePreference.getDocumentTypeFromXml(keyword);
            if (documentType == null) continue;
            if (preferenceValuesWithSelection.get(keyword).booleanValue()) {
                DEFAULT_DOCUMENT_TYPE = documentType;
            }
            ALL_DOCUMENT_TYPES.add(documentType);
        }
    }

    private static DocumentType getDocumentTypeFromXml(String docTypePreference) {
        DocumentType documentType = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DocumentType.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            documentType = (DocumentType)unmarshaller.unmarshal((Reader)new StringReader(docTypePreference));
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
        }
        return documentType;
    }

    private static void updateDocumentTypeCount() {
        for (DocumentType documentType : ALL_DOCUMENT_TYPES) {
            if (!documentType.getLabel().startsWith(NEW_DOCUMENT_TYPE_PREFIX)) continue;
            String lastPart = documentType.getLabel().substring(NEW_DOCUMENT_TYPE_PREFIX.length());
            try {
                int num = Integer.parseInt(lastPart);
                newDocumentTypeCount = Math.max(newDocumentTypeCount, num);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected Control createContents(Composite parent) {
        DocTypePreference.loadPreferences();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.horizontalSpacing = 10;
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("DocumentTypes");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 4, 1));
        this.treeViewer = this.createDocumentTypesTreeViewer(container);
        ArrayList<DocumentType> documentTypes = new ArrayList<DocumentType>();
        documentTypes.addAll(ALL_DOCUMENT_TYPES);
        DocumentType defaultDocumentType = null;
        for (DocumentType docType : documentTypes) {
            if (DEFAULT_DOCUMENT_TYPE.getLabel().equals(docType.getLabel())) {
                defaultDocumentType = docType;
                continue;
            }
            docType.setMakeDefault(false);
        }
        this.treeViewer.setComparator((ViewerComparator)new DocumentTypeComparator());
        this.treeViewer.setInput(documentTypes);
        this.treeViewer.refresh();
        this.treeViewer.expandToLevel((Object)defaultDocumentType, -1);
        this.makeDefaultAction = new MakeDefaultAction(this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocTypePreference.this.makeDefaultAction.run();
            }
        });
        Button addButton = this.createButton(container, "Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List documentTypes = (List)DocTypePreference.this.treeViewer.getInput();
                DocumentType newDocumentType = new DocumentType();
                StringBuilder stringBuilder = new StringBuilder(DocTypePreference.NEW_DOCUMENT_TYPE_PREFIX);
                int n = newDocumentTypeCount + 1;
                newDocumentTypeCount = n;
                newDocumentType.setLabel(stringBuilder.append(n).toString());
                documentTypes.add(newDocumentType);
                DocTypePreference.this.treeViewer.refresh();
                TreeItem[] treeItemArray = DocTypePreference.this.treeViewer.getTree().getItems();
                int n2 = treeItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TreeItem treeItem = treeItemArray[n3];
                    if (DocTypePreference.this.matchDocumentType((DocumentType)treeItem.getData(), newDocumentType)) {
                        DocTypePreference.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newDocumentType));
                        break;
                    }
                    ++n3;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button addSubType = this.createButton(container, "Add SubType");
        addSubType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeSelection treeSelection = (TreeSelection)DocTypePreference.this.treeViewer.getSelection();
                if (!treeSelection.isEmpty()) {
                    DocumentType selectedDocumentType = null;
                    if (treeSelection.getFirstElement() instanceof DocumentType) {
                        selectedDocumentType = (DocumentType)treeSelection.getFirstElement();
                    } else {
                        TreePath[] paths = treeSelection.getPaths();
                        selectedDocumentType = (DocumentType)paths[0].getSegment(0);
                    }
                    if (selectedDocumentType != null) {
                        int suffix = selectedDocumentType.getSubTypes().size();
                        String newSubType = "SubType " + suffix;
                        while (selectedDocumentType.getSubTypes().contains(newSubType)) {
                            newSubType = "SubType " + ++suffix;
                        }
                        selectedDocumentType.addSubType(newSubType);
                        if (selectedDocumentType.getSubTypes().size() == 1) {
                            selectedDocumentType.setSelectedSubType(selectedDocumentType.getSubTypes().iterator().next());
                        }
                        DocTypePreference.this.treeViewer.refresh();
                        DocTypePreference.this.treeViewer.expandToLevel((Object)selectedDocumentType, -1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove");
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List documentTypes = (List)DocTypePreference.this.treeViewer.getInput();
                TreeSelection treeSelection = (TreeSelection)DocTypePreference.this.treeViewer.getSelection();
                int selectionIndex = -1;
                DocumentType selectedDocumentType = null;
                if (!treeSelection.isEmpty() && treeSelection.getFirstElement() instanceof DocumentType) {
                    selectedDocumentType = (DocumentType)treeSelection.getFirstElement();
                    selectionIndex = Math.max(0, this.getTreeItemIndex(selectedDocumentType) - 1);
                    documentTypes.remove(selectedDocumentType);
                } else if (treeSelection.getFirstElement() instanceof String) {
                    TreePath[] paths = treeSelection.getPaths();
                    selectedDocumentType = (DocumentType)paths[0].getSegment(0);
                    selectionIndex = this.getTreeItemIndex(selectedDocumentType);
                    logger.debug((Object)selectedDocumentType.getLabel());
                    selectedDocumentType.getSubTypes().remove(treeSelection.getFirstElement());
                    if (selectedDocumentType.getSubTypes().size() == 1 || selectedDocumentType.getSelectedSubType() == treeSelection.getFirstElement()) {
                        selectedDocumentType.setSelectedSubType(selectedDocumentType.getSubTypes().iterator().next());
                    }
                }
                DocTypePreference.this.treeViewer.refresh();
                if (documentTypes.contains(selectedDocumentType)) {
                    TreeItem[] treeItemArray = DocTypePreference.this.treeViewer.getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray[n2];
                        if (DocTypePreference.this.matchDocumentType((DocumentType)treeItem.getData(), selectedDocumentType)) {
                            DocTypePreference.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedDocumentType));
                            break;
                        }
                        ++n2;
                    }
                } else if (selectionIndex >= 0 && selectionIndex < documentTypes.size()) {
                    DocTypePreference.this.treeViewer.setSelection((ISelection)new StructuredSelection(DocTypePreference.this.treeViewer.getTree().getItems()[selectionIndex].getData()));
                }
            }

            private int getTreeItemIndex(DocumentType selectedDocumentType) {
                int selectionIndex = -1;
                int i = 0;
                TreeItem[] treeItemArray = DocTypePreference.this.treeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getData().equals(selectedDocumentType)) {
                        selectionIndex = i;
                        break;
                    }
                    ++i;
                    ++n2;
                }
                return selectionIndex;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    protected boolean matchDocumentType(DocumentType documentType, DocumentType selectedDocumentType) {
        boolean match = documentType.getLabel().equals(selectedDocumentType.getLabel());
        return match;
    }

    private Button createButton(Composite container, String label) {
        Button button = new Button(container, 0);
        button.setText(label);
        GridData buttonData = new GridData();
        buttonData.widthHint = 120;
        buttonData.verticalSpan = 1;
        buttonData.horizontalSpan = 1;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private TreeViewer createDocumentTypesTreeViewer(Composite container) {
        TreeViewer treeViewer = new TreeViewer(container, 68352);
        TreeViewerColumn treeColumn1 = new TreeViewerColumn(treeViewer, 4, 0);
        treeColumn1.getColumn().setText("DocumentTypes");
        treeColumn1.getColumn().setWidth(220);
        treeColumn1.setEditingSupport(new EditingSupport((ColumnViewer)treeViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = null;
            }

            protected void setValue(Object element, Object value) {
                String newValue;
                if (element instanceof DocumentType && value instanceof String && !(newValue = ((String)value).trim()).isEmpty()) {
                    String oldValue = ((DocumentType)element).getLabel();
                    ((DocumentType)element).setLabel(newValue);
                    if (DocTypePreference.this.validateInput() != null) {
                        ((DocumentType)element).setLabel(oldValue);
                    }
                    DocTypePreference.this.treeViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof DocumentType) {
                    return ((DocumentType)element).getLabel();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof DocumentType) {
                    if (this.textEditor == null) {
                        this.textEditor = new TextCellEditor((Composite)DocTypePreference.this.treeViewer.getTree());
                    }
                    return this.textEditor;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof DocumentType;
            }
        });
        TreeViewerColumn treeColumn2 = new TreeViewerColumn(treeViewer, 4, 1);
        treeColumn2.getColumn().setText("SubType");
        treeColumn2.getColumn().setWidth(200);
        treeColumn2.setEditingSupport(new EditingSupport((ColumnViewer)treeViewer){
            TextCellEditor textEditor;
            TreeSelection treeSelection;
            {
                this.textEditor = null;
                this.treeSelection = null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    TreePath[] paths = this.treeSelection.getPaths();
                    DocumentType selectedDocumentType = (DocumentType)paths[0].getSegment(0);
                    logger.debug((Object)selectedDocumentType.getLabel());
                    if (!newValue.isEmpty()) {
                        selectedDocumentType.getSubTypes().remove(element);
                        selectedDocumentType.addSubType(newValue);
                        if (selectedDocumentType.getSubTypes().size() == 1) {
                            selectedDocumentType.setSelectedSubType(selectedDocumentType.getSubTypes().iterator().next());
                        }
                    }
                    DocTypePreference.this.treeViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof String) {
                    return element;
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                this.treeSelection = (TreeSelection)DocTypePreference.this.treeViewer.getSelection();
                if (element instanceof String) {
                    if (this.textEditor == null) {
                        this.textEditor = new TextCellEditor((Composite)DocTypePreference.this.treeViewer.getTree());
                    }
                    return this.textEditor;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DocumentTypeFontLabelProvider(treeViewer));
        treeViewer.setContentProvider((IContentProvider)new DocumentTypeContentProvider());
        GridData gridDataTree = new GridData(1808);
        gridDataTree.grabExcessHorizontalSpace = true;
        gridDataTree.grabExcessVerticalSpace = true;
        gridDataTree.horizontalSpan = 4;
        gridDataTree.verticalSpan = 1;
        gridDataTree.minimumHeight = 250;
        gridDataTree.heightHint = 400;
        gridDataTree.minimumWidth = 300;
        gridDataTree.widthHint = 400;
        treeViewer.getTree().setLayoutData((Object)gridDataTree);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        return treeViewer;
    }

    protected void performDefaults() {
        try {
            File preferenceFile = new File(String.valueOf(FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.entry.archive").getResource("preference")).getPath()) + File.separator + DEFAULT_PREFERENCE_FILE);
            List<DocumentType> allDocumentTypes = PreferenceHandler.getDocumentTypesFromXml(preferenceFile);
            DocumentType defaultDocumentType = null;
            for (DocumentType docType : allDocumentTypes) {
                if (!docType.isMakeDefault()) continue;
                defaultDocumentType = docType;
                break;
            }
            this.initializeValues(allDocumentTypes, defaultDocumentType);
            super.performDefaults();
        }
        catch (IOException ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void initializeValues(List<DocumentType> allDocumentTypes, DocumentType defaultDocumentType) {
        this.treeViewer.setInput(allDocumentTypes);
        this.treeViewer.refresh();
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        String invalidMessage = this.validateInput();
        this.setErrorMessage(invalidMessage);
        if (invalidMessage == null) {
            this.save();
            return true;
        }
        return false;
    }

    private String validateInput() {
        String invalidMessage = null;
        List treeInput = (List)this.treeViewer.getInput();
        boolean nonUnique = false;
        int i = 0;
        int j = 0;
        DocumentType element1 = null;
        DocumentType element2 = null;
        block0: while (i < treeInput.size()) {
            element1 = (DocumentType)treeInput.get(i);
            if (element1 != null) {
                j = i + 1;
                while (j < treeInput.size()) {
                    element2 = (DocumentType)treeInput.get(j);
                    if (element2 != null && this.matchDocumentType(element1, element2)) {
                        nonUnique = true;
                        break block0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        invalidMessage = nonUnique ? "Non-unique DocumentTypes" : invalidMessage;
        return invalidMessage;
    }

    private void save() {
        List treeInput = (List)this.treeViewer.getInput();
        ALL_DOCUMENT_TYPES = new ArrayList<DocumentType>();
        DEFAULT_DOCUMENT_TYPE = null;
        for (DocumentType documentType : treeInput) {
            if (documentType.isMakeDefault()) {
                DEFAULT_DOCUMENT_TYPE = documentType;
            }
            ALL_DOCUMENT_TYPES.add(documentType);
        }
        DocTypePreference.saveValues();
        UtilityPreference.updateEditors(Arrays.asList(PREFERENCE_NAME_ALL));
    }

    private static boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setValue(UtilityPreferenceValue.getPreferenceValueString(DocTypePreference.getStringSetFromList(ALL_DOCUMENT_TYPES), (String)DocTypePreference.getXmlString(DEFAULT_DOCUMENT_TYPE)));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    private static String getXmlString(DocumentType documentType) {
        String documentTypeXml = null;
        if (documentType != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DocumentType.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.marshal((Object)documentType, (OutputStream)os);
                documentTypeXml = os.toString();
            }
            catch (JAXBException e) {
                logger.error((Object)("The DocumentType could not be serialized as xml." + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                logger.fatal((Object)("The DocumentType could not be serialized as xml." + e.getMessage()), (Throwable)e);
            }
        }
        return documentTypeXml;
    }

    private static Set<String> getStringSetFromList(List<DocumentType> documentTypes) {
        HashSet<String> valueSet = new HashSet<String>();
        String xmlString = null;
        for (DocumentType element : documentTypes) {
            xmlString = DocTypePreference.getXmlString(element);
            if (xmlString == null) continue;
            valueSet.add(xmlString);
        }
        return valueSet;
    }
}

