/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.utils.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;
import org.jat.generation.internal.helpers.ImageConverter;

public class SimianImageConverter
extends ImageConverter {
    public static BufferedImage convert(Image srcImage) {
        if (srcImage instanceof BufferedImage) {
            return (BufferedImage)srcImage;
        }
        BufferedImage bimage = new BufferedImage(srcImage.getWidth(null), srcImage.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(srcImage, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage createCartoon(Glycan glycan, BuilderWorkspaceSWT bws, double dScaleFactor, boolean bShowMasses, boolean bShowRedEnd, boolean bNoScaleLessThanOne, int iScaleType) {
        ArrayList<Glycan> lGlycans = new ArrayList<Glycan>();
        lGlycans.add(glycan);
        return SimianImageConverter.createCartoon(lGlycans, bws, dScaleFactor, bShowMasses, bShowRedEnd, bNoScaleLessThanOne, iScaleType);
    }

    public static BufferedImage createCartoon(List<Glycan> glycan, BuilderWorkspaceSWT bws, double dScaleFactor, boolean bShowMasses, boolean bShowRedEnd, boolean bNoScaleLessThanOne, int iScaleType) {
        double dScaleTo = bNoScaleLessThanOne && dScaleFactor < 1.0 ? 2.0 : dScaleFactor;
        double dScaleFrom = bNoScaleLessThanOne && dScaleFactor < 1.0 ? dScaleFactor / 2.0 : dScaleFactor;
        BufferedImage img = SimianImageConverter.createCartoonAWT(glycan, bws, dScaleTo, bShowMasses, bShowRedEnd);
        if (bNoScaleLessThanOne && dScaleFactor < 1.0) {
            int width = (int)((double)img.getWidth() * dScaleFrom);
            int height = (int)((double)img.getHeight() * dScaleFrom);
            Image newImage = img.getScaledInstance(width, height, iScaleType);
            BufferedImage newBufferedImage = SimianImageConverter.convert(newImage);
            newImage.flush();
            return newBufferedImage;
        }
        return img;
    }

    public static org.eclipse.swt.graphics.Image createCartoonSWT(List<Glycan> glycan, BuilderWorkspaceSWT bws, double dScaleFactor, boolean bShowMasses, boolean bShowRedEnd) {
        try {
            org.eclipse.swt.graphics.Image img = bws.getGlycanRenderer().getImage(glycan, true, bShowMasses, bShowRedEnd, dScaleFactor);
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage createCartoonAWT(List<Glycan> glycan, BuilderWorkspaceSWT bws, double dScaleFactor, boolean bShowMasses, boolean bShowRedEnd) {
        try {
            BufferedImage img = bws.getGlycanRendererAWT().getImage(glycan, true, bShowMasses, bShowRedEnd, dScaleFactor);
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

