/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph;

import java.util.ArrayList;
import java.util.HashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanGraph;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.traverser.ContainerTraverserBranch;
import org.glycoinfo.GlycanFormatconverter.util.traverser.FormatTraverser;
import org.glycoinfo.GlycanFormatconverter.util.visitor.ContainerVisitor;
import org.glycoinfo.GlycanFormatconverter.util.visitor.VisitorException;

public class GlycoVisitorAnalyzeGlyCoForWURCS
implements ContainerVisitor {
    private ArrayList<Edge> substituentLinkages = new ArrayList();
    private ArrayList<Edge> linkages = new ArrayList();
    private HashMap<Edge, Substituent> linkageToRepeat = new HashMap();
    private GlycanGraph graph;
    private GlycanGraph fragment;
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<Node> subGraph = new ArrayList();
    private ArrayList<Substituent> repeats = new ArrayList();
    private ArrayList<GlycanUndefinedUnit> fragments = new ArrayList();

    public ArrayList<Node> getMonosaccharides() {
        return this.nodes;
    }

    public ArrayList<Node> getRootOfSubgraphs() {
        return this.subGraph;
    }

    public ArrayList<Edge> getLinkages() {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        ret.addAll(this.linkages);
        ret.addAll(this.substituentLinkages);
        return ret;
    }

    public GlycanRepeatModification getRepeatingUnitByEdge(Edge _edge) {
        return (GlycanRepeatModification)this.linkageToRepeat.get(_edge);
    }

    public ArrayList<Substituent> getRepeatingUnits() {
        return this.repeats;
    }

    public ArrayList<GlycanUndefinedUnit> getFragments() {
        return this.fragments;
    }

    @Override
    public void visit(Monosaccharide _monosaccharide) throws VisitorException {
        if (!this.nodes.contains(_monosaccharide)) {
            this.nodes.add(_monosaccharide);
        }
        if (!this.graph.equals(this.fragment) && !this.fragment.isComposition()) {
            this.subGraph.add(_monosaccharide);
        }
    }

    @Override
    public void visit(Substituent _substituent) throws VisitorException {
    }

    @Override
    public void visit(Edge _edge) throws VisitorException {
        Node child = _edge.getChild();
        if (_edge.getSubstituent() != null) {
            Substituent sub = (Substituent)_edge.getSubstituent();
            if (sub instanceof GlycanRepeatModification && !_edge.isCyclic()) {
                this.linkageToRepeat.put(_edge, sub);
            } else {
                if (!this.substituentLinkages.contains(_edge)) {
                    this.substituentLinkages.add(_edge);
                }
                return;
            }
        }
        if (!this.linkages.contains(_edge)) {
            this.linkages.add(_edge);
        }
    }

    @Override
    public void visit(GlyCoModification _modification) throws VisitorException {
    }

    @Override
    public void start(GlyContainer _glyCo) throws VisitorException {
        this.clear();
        if (!_glyCo.getUndefinedUnit().isEmpty()) {
            for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
                this.fragments.add(und);
            }
        }
        this.graph = _glyCo;
        this.fragment = _glyCo;
        FormatTraverser traverser = this.getTraverser(this);
        traverser.traverseGraph(_glyCo);
        for (GlycanUndefinedUnit und : this.fragments) {
            this.fragment = und;
            traverser.traverseGraph(this.fragment);
        }
    }

    @Override
    public FormatTraverser getTraverser(ContainerVisitor _visitor) throws VisitorException {
        return new ContainerTraverserBranch(_visitor);
    }

    @Override
    public void clear() {
        this.linkages = new ArrayList();
        this.linkageToRepeat = new HashMap();
        this.nodes = new ArrayList();
        this.subGraph = new ArrayList();
        this.repeats = new ArrayList();
        this.fragments = new ArrayList();
    }
}

