/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.TrivialName;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameDictionary;

public class ThreeLetterCodeConverter {
    private String threeCodes = "";
    private int size = -1;
    private TrivialNameDictionary trivial;

    public String getThreeLetterCode() {
        return this.threeCodes;
    }

    public int getSize() {
        return this.size;
    }

    public TrivialNameDictionary getDictionary() {
        return this.trivial;
    }

    public void start(Node _node) throws GlycanException {
        if (((Monosaccharide)_node).getStereos().isEmpty()) {
            return;
        }
        String stereo = this.makeNotation(_node, false);
        TrivialNameDictionary trivial = null;
        for (TrivialNameDictionary dict : TrivialNameDictionary.forStereos(stereo)) {
            if (!this.checkSubstituentAndModifications(_node, dict)) continue;
            trivial = dict;
        }
        if (trivial == null) {
            stereo = this.makeNotation(_node, true);
            for (TrivialNameDictionary dict : TrivialNameDictionary.forStereos(stereo)) {
                if (!this.checkSubstituentAndModifications(_node, dict)) continue;
                trivial = dict;
            }
        }
        if ((trivial = this.checkDideoxyHexose(_node, trivial)) != null) {
            this.modifySubstituentAndModification(_node, trivial);
            this.threeCodes = trivial.getThreeLetterCode();
            this.size = trivial.getSize();
        }
        this.trivial = trivial;
    }

    private String makeNotation(Node _node, boolean _config) {
        String stereo = "";
        Iterator iterStereo = ((Monosaccharide)_node).getStereos().iterator();
        while (iterStereo.hasNext()) {
            String s = (String)iterStereo.next();
            stereo = String.valueOf(stereo) + (_config ? s.replaceFirst(this.trimConfiguration(s), "") : s);
            if (!iterStereo.hasNext()) continue;
            stereo = String.valueOf(stereo) + "_";
        }
        return stereo;
    }

    private TrivialNameDictionary checkDideoxyHexose(Node _node, TrivialNameDictionary _dict) {
        if (_dict == null) {
            return _dict;
        }
        String configuration = this.trimConfiguration(((Monosaccharide)_node).getStereos().get(0));
        if ((_dict.equals((Object)TrivialNameDictionary.ABE) || _dict.equals((Object)TrivialNameDictionary.COL)) && configuration.equals("?")) {
            return null;
        }
        if ((_dict.equals((Object)TrivialNameDictionary.ASC) || _dict.equals((Object)TrivialNameDictionary.TYV)) && configuration.equals("?")) {
            return null;
        }
        if (_dict.equals((Object)TrivialNameDictionary.ABE) && configuration.equals("l")) {
            return TrivialNameDictionary.COL;
        }
        if (_dict.equals((Object)TrivialNameDictionary.COL) && configuration.equals("d")) {
            return TrivialNameDictionary.ABE;
        }
        if (_dict.equals((Object)TrivialNameDictionary.TYV) && configuration.equals("l")) {
            return TrivialNameDictionary.ASC;
        }
        if (_dict.equals((Object)TrivialNameDictionary.ASC) && configuration.equals("d")) {
            return TrivialNameDictionary.TYV;
        }
        return _dict;
    }

    private boolean checkSubstituentAndModifications(Node _node, TrivialNameDictionary _dict) throws GlycanException {
        if (((Monosaccharide)_node).getSuperClass() != null && _dict.getSize() != ((Monosaccharide)_node).getSuperClass().getSize()) {
            return false;
        }
        ArrayList<GlyCoModification> mods = this.extractModifications(_dict.getModificationNotation());
        ArrayList<Substituent> subs = this.extractSubstituents(_dict.getSubstituentNotation());
        int subPoint = 0;
        for (Edge childEdge : _node.getChildEdges()) {
            Substituent sub;
            if (childEdge.getSubstituent() == null || (sub = (Substituent)childEdge.getSubstituent()).getSubstituent() instanceof BaseCrossLinkedTemplate || sub.getFirstPosition() == null || sub.getSecondPosition() != null || sub.getFirstPosition().getParentLinkages().size() > 1 || this.isProbability(sub)) continue;
            for (Substituent tempSub : subs) {
                if (!sub.getFirstPosition().getParentLinkages().contains(tempSub.getFirstPosition().getParentLinkages().get(0))) continue;
                if (SubstituentUtility.isNLinkedSubstituent(sub) && tempSub.getSubstituent().equals(BaseSubstituentTemplate.AMINE)) {
                    ++subPoint;
                    continue;
                }
                if (!tempSub.getSubstituent().equals(sub.getSubstituent())) continue;
                ++subPoint;
            }
        }
        int modPoint = 0;
        for (GlyCoModification tempMod : mods) {
            if (!((Monosaccharide)_node).hasModification(tempMod, tempMod.getPositionOne())) continue;
            ++modPoint;
        }
        return subs.size() == subPoint && mods.size() == modPoint;
    }

    private void modifySubstituentAndModification(Node _node, TrivialNameDictionary _dict) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        ArrayList<GlyCoModification> mods = this.extractModifications(_dict.getModificationNotation());
        ArrayList<Substituent> subs = this.extractSubstituents(_dict.getSubstituentNotation());
        block0: for (Edge childEdge : _node.getChildEdges()) {
            Substituent sub;
            if (childEdge.getSubstituent() == null || childEdge.getSubstituent() != null && childEdge.getChild() != null || (sub = (Substituent)childEdge.getSubstituent()).getFirstPosition() == null || sub.getSecondPosition() != null || sub.getFirstPosition().getParentLinkages().size() > 1) continue;
            for (Substituent tempSub : subs) {
                if (!sub.getFirstPosition().getParentLinkages().contains(tempSub.getFirstPosition().getParentLinkages().get(0))) continue;
                if (SubstituentUtility.isNLinkedSubstituent(sub)) {
                    SubstituentUtility.changePlaneTemplate(sub);
                    continue block0;
                }
                if (!tempSub.getSubstituent().equals(sub.getSubstituent())) continue;
                sub.setTemplate(null);
                continue block0;
            }
        }
        for (GlyCoModification tempMod : mods) {
            mono.removeModification(this.getModIndex(_node, tempMod));
        }
    }

    private GlyCoModification getModIndex(Node _node, GlyCoModification _ind) {
        GlyCoModification ret = null;
        for (GlyCoModification mod : ((Monosaccharide)_node).getModifications()) {
            if (!mod.getModificationTemplate().equals((Object)_ind.getModificationTemplate()) || mod.getPositionOne() != _ind.getPositionOne()) continue;
            ret = mod;
        }
        return ret;
    }

    private ArrayList<Substituent> extractSubstituents(String _item) {
        ArrayList<Substituent> ret = new ArrayList<Substituent>();
        if (_item.equals("")) {
            return ret;
        }
        String[] stringArray = _item.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            String[] split_unit = unit.split("\\*");
            LinkedList<Integer> pos = new LinkedList<Integer>();
            pos.addLast(Integer.parseInt(String.valueOf(split_unit[0])));
            Linkage lin = new Linkage();
            lin.setParentLinkages(pos);
            BaseSubstituentTemplate bsubT = BaseSubstituentTemplate.forIUPACNotation(this.makePlaneNotation(split_unit[1]));
            if (bsubT != null) {
                ret.add(new Substituent(bsubT, lin));
            }
            ++n2;
        }
        return ret;
    }

    private ArrayList<GlyCoModification> extractModifications(String _item) throws GlycanException {
        ArrayList<GlyCoModification> ret = new ArrayList<GlyCoModification>();
        if (_item.equals("")) {
            return ret;
        }
        String[] stringArray = _item.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] split_unit;
            ModificationTemplate modT;
            String unit = stringArray[n2];
            if (!unit.equals("") && (modT = ModificationTemplate.forCarbon((split_unit = unit.split("\\*"))[1].charAt(0))) != null) {
                if (modT.equals((Object)ModificationTemplate.ULOSONIC)) {
                    modT = ModificationTemplate.KETONE_U;
                }
                if (_item.startsWith("1*A") && !split_unit[0].equals("1") && modT.equals((Object)ModificationTemplate.ALDONICACID)) {
                    modT = ModificationTemplate.URONICACID;
                }
                ret.add(new GlyCoModification(modT, Integer.parseInt(String.valueOf(split_unit[0]))));
            }
            ++n2;
        }
        return ret;
    }

    private String trimConfiguration(String _stereo) {
        if (_stereo.length() == 3) {
            return "";
        }
        if (_stereo.length() == 4) {
            return _stereo.substring(0, 1);
        }
        if (_stereo.indexOf("-") != -1) {
            return _stereo.substring(0, _stereo.indexOf("-") + 1);
        }
        return "";
    }

    private String makePlaneNotation(String _notation) {
        if (_notation.startsWith("O") || _notation.startsWith("C")) {
            return _notation.substring(1, _notation.length());
        }
        if (_notation.startsWith("(")) {
            String bracket = _notation.substring(0, _notation.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            if ((_notation = _notation.replaceFirst(regex, "")).startsWith("O")) {
                _notation = _notation.replaceFirst("O", "");
            }
            if (_notation.startsWith("C") && _notation.length() == 3) {
                _notation = _notation.substring(1, _notation.length());
            }
            _notation = String.valueOf(bracket) + _notation;
        }
        return _notation;
    }

    private boolean isProbability(Substituent _sub) {
        return Double.compare(_sub.getFirstPosition().getChildProbabilityLower(), 1.0) != 0 || Double.compare(_sub.getFirstPosition().getChildProbabilityUpper(), 1.0) != 0 || Double.compare(_sub.getFirstPosition().getParentProbabilityLower(), 1.0) != 0 || Double.compare(_sub.getFirstPosition().getParentProbabilityUpper(), 1.0) != 0;
    }
}

