/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;
import org.eurocarbdb.resourcesdb.atom.Composition;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentAlias;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentSubpartTreeNode;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.util.Utils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstituentTemplateContainer {
    private Config config = null;
    private ArrayList<SubstituentTemplate> substituentTemplateList;
    private HashMap<GlycanNamescheme, ArrayList<String>> includedNameListsMap;

    public SubstituentTemplateContainer() {
        this.setConfig(new Config());
    }

    public SubstituentTemplateContainer(Config conf) {
        this.setConfig(conf);
    }

    private void setConfig(Config theConf) {
        this.config = theConf;
    }

    public Config getConfig() {
        return this.config;
    }

    public ArrayList<SubstituentTemplate> getTemplateList() throws ResourcesDbException {
        if (this.substituentTemplateList == null) {
            this.substituentTemplateList = SubstituentTemplateContainer.readTemplateList(this.getConfig());
        }
        return this.substituentTemplateList;
    }

    public ArrayList<String> getResidueIncludedNameList(GlycanNamescheme scheme) throws ResourcesDbException {
        ArrayList<String> nameList;
        if (this.includedNameListsMap == null) {
            this.includedNameListsMap = new HashMap();
        }
        if ((nameList = this.includedNameListsMap.get((Object)scheme)) == null) {
            ArrayList<SubstituentTemplate> templates = this.getTemplateList();
            nameList = new ArrayList();
            for (SubstituentTemplate template : templates) {
                for (SubstituentAlias alias : template.getAliasList(scheme, null)) {
                    if (alias.getResidueIncludedName() == null || alias.getResidueIncludedName().length() <= 0 || nameList.contains(alias.getResidueIncludedName())) continue;
                    nameList.add(alias.getResidueIncludedName());
                }
            }
            this.includedNameListsMap.put(scheme, nameList);
        }
        return nameList;
    }

    public SubstituentTemplate forResidueIncludedName(GlycanNamescheme scheme, String name) throws ResourcesDbException {
        for (SubstituentTemplate substTmpl : this.getTemplateList()) {
            for (SubstituentAlias alias : substTmpl.getAliasList()) {
                if (!alias.getNamescheme().equals((Object)scheme) || !name.equalsIgnoreCase(alias.getResidueIncludedName()) || alias.getSeparateDisplayName() != null && alias.getSeparateDisplayName().length() != 0) continue;
                return substTmpl;
            }
        }
        return null;
    }

    public SubstituentTemplate forSeparateDisplayName(GlycanNamescheme scheme, String name) throws ResourcesDbException {
        for (SubstituentTemplate substTmpl : this.getTemplateList()) {
            for (SubstituentAlias alias : substTmpl.getAliasList()) {
                if (!alias.getNamescheme().equals((Object)scheme) || !name.equalsIgnoreCase(alias.getSeparateDisplayName()) || alias.getResidueIncludedName() != null && alias.getResidueIncludedName().length() != 0) continue;
                return substTmpl;
            }
        }
        return null;
    }

    public SubstituentTemplate forName(GlycanNamescheme scheme, String name) throws ResourcesDbException {
        if (name != null) {
            for (SubstituentTemplate substTmpl : this.getTemplateList()) {
                for (SubstituentAlias alias : substTmpl.getAliasList()) {
                    if (!alias.getNamescheme().equals((Object)scheme)) continue;
                    if (name.equalsIgnoreCase(alias.getResidueIncludedName()) && alias.getSeparateDisplayName() == null) {
                        return substTmpl;
                    }
                    if (!name.equalsIgnoreCase(alias.getSeparateDisplayName()) || alias.getResidueIncludedName() != null) continue;
                    return substTmpl;
                }
            }
        }
        return null;
    }

    private static ArrayList<SubstituentTemplate> readTemplateList(Config conf) throws ResourcesDbException {
        return SubstituentTemplateContainer.getTemplateListFromXml(conf.getSubstituentTemplatesXmlUrl());
    }

    private static ArrayList<SubstituentTemplate> getTemplateListFromXml(URL xmlUrl) throws ResourcesDbException {
        SAXBuilder parser = new SAXBuilder();
        ArrayList<SubstituentTemplate> templateList = new ArrayList<SubstituentTemplate>();
        try {
            Document doc = parser.build(xmlUrl);
            Element root = doc.getRootElement();
            List xmlTemplateList = root.getChildren();
            for (Element xmlTemplate : xmlTemplateList) {
                SubstituentTemplate template = SubstituentTemplateContainer.getTemplateFromXmlTree(xmlTemplate);
                if (template == null) continue;
                templateList.add(template);
            }
        }
        catch (JDOMException je) {
            throw new ResourcesDbException("Exception in reading TrivialnameTemplate XML file.", je);
        }
        catch (IOException ie) {
            throw new ResourcesDbException("Exception in reading TrivialnameTemplate XML file.", ie);
        }
        return templateList;
    }

    private static SubstituentTemplate getTemplateFromXmlTree(Element xmlTemplate) throws ResourcesDbException {
        if (xmlTemplate.getName().equalsIgnoreCase("template")) {
            SubstituentTemplate substTemplate = new SubstituentTemplate();
            List propList = xmlTemplate.getChildren();
            for (Element property : propList) {
                String propertyName = property.getName().toLowerCase();
                String propertyValue = property.getValue();
                if (propertyValue == null) {
                    propertyValue = "";
                }
                if (propertyName.equals("name")) {
                    substTemplate.setName(propertyValue);
                    for (LinkageType link : LinkageType.values()) {
                        if (link.equals((Object)LinkageType.NONMONOSACCHARID)) continue;
                        SubstituentAlias msdbAlias = new SubstituentAlias(GlycanNamescheme.MONOSACCHARIDEDB, link, propertyValue, null, true);
                        substTemplate.addAlias(msdbAlias);
                        SubstituentAlias glycoctAlias = new SubstituentAlias(GlycanNamescheme.GLYCOCT, link, null, propertyValue, true);
                        substTemplate.addAlias(glycoctAlias);
                    }
                    continue;
                }
                if (propertyName.equals("valence") && !propertyValue.equals("")) {
                    if (property.getChildren() != null && property.getChildren().size() > 0) {
                        HashMap<String, Integer> minMaxMap = SubstituentTemplateContainer.parseMinMaxTags(property);
                        if (minMaxMap.get("MIN") != null) {
                            substTemplate.setMinValence(minMaxMap.get("MIN"));
                        }
                        if (minMaxMap.get("MAX") == null) continue;
                        substTemplate.setMaxValence(minMaxMap.get("MAX"));
                        continue;
                    }
                    substTemplate.setValence(Integer.parseInt(propertyValue));
                    continue;
                }
                if (propertyName.equals("default_linking_position1") && !propertyValue.equals("")) {
                    substTemplate.setDefaultLinkingPosition1(Integer.parseInt(propertyValue));
                    continue;
                }
                if (propertyName.equals("default_linking_position2") && !propertyValue.equals("")) {
                    substTemplate.setDefaultLinkingPosition2(Integer.parseInt(propertyValue));
                    continue;
                }
                if (propertyName.equals("default_linkage_type1") && !propertyValue.equals("") || propertyName.equals("default_linkage_type2") && !propertyValue.equals("") || propertyName.equals("bondorder1") || propertyName.equals("bondorder2") && !propertyValue.equals("")) continue;
                if (propertyName.equals("can_replace_ring_oxygen")) {
                    substTemplate.setCanReplaceRingOxygen(Utils.parseTrueFalseString(propertyValue, false));
                    continue;
                }
                if (propertyName.equals("is_linkable")) {
                    substTemplate.setLinkable(Utils.parseTrueFalseString(propertyValue, false));
                    continue;
                }
                if (propertyName.equals("haworth_name")) {
                    substTemplate.setHaworthName(propertyValue);
                    continue;
                }
                if (propertyName.equals("mirrored_haworth_name")) {
                    substTemplate.setMirroredHaworthName(propertyValue);
                    continue;
                }
                if (propertyName.equals("olinked_equivalent") && !propertyValue.equals("")) {
                    substTemplate.setOLinkedEquivalent(propertyValue);
                    continue;
                }
                if (propertyName.equals("formula")) {
                    substTemplate.setFormula(propertyValue);
                    if (substTemplate.getFormula() == null) continue;
                    substTemplate.setComposition(new Composition(substTemplate.getFormula()));
                    continue;
                }
                if (propertyName.equals("atoms")) {
                    List atomList = property.getChildren();
                    for (Element atomtag : atomList) {
                        Atom a = Atom.parseXmlAtomTag(atomtag);
                        substTemplate.addAtom(a);
                    }
                    continue;
                }
                if (propertyName.equals("atom_connections")) {
                    List connectionList = property.getChildren();
                    for (Element atomtag : connectionList) {
                        AtomConnection.parseXmlAtomConnectionTag(atomtag, substTemplate);
                    }
                    continue;
                }
                if (propertyName.equals("valid_linking_positions")) {
                    List vlpList = property.getChildren();
                    for (Element vlpTag : vlpList) {
                        int id = Integer.parseInt(vlpTag.getAttributeValue("id"));
                        int atomId = Integer.parseInt(vlpTag.getAttributeValue("atom_id"));
                        Atom linkAtom = substTemplate.getAtomById(atomId);
                        if (linkAtom == null) {
                            throw new ResourcesDbException("Cannot get atom id " + atomId + " for substituent template " + substTemplate.getName());
                        }
                        Atom replAtom = null;
                        String replAtomStr = vlpTag.getAttributeValue("replaced_atom_id");
                        if (replAtomStr != null && replAtomStr.length() > 0 && (replAtom = substTemplate.getAtomById(Integer.parseInt(replAtomStr))) == null) {
                            throw new ResourcesDbException("Cannot get atom id " + replAtomStr + " for substituent template " + substTemplate.getName());
                        }
                        Double bo = null;
                        String boStr = vlpTag.getAttributeValue("bond_order");
                        if (boStr != null && boStr.length() > 0) {
                            bo = Double.parseDouble(boStr);
                        }
                        LinkageType defaultLinktype = null;
                        String linktypeStr = vlpTag.getAttributeValue("default_linkage_type");
                        if (linktypeStr != null && linktypeStr.length() > 0) {
                            try {
                                defaultLinktype = LinkageType.forName(linktypeStr);
                            }
                            catch (GlycoconjugateException ge) {
                                throw new ResourcesDbException("Error in reading substituent template from xml: unknown LinkageType " + linktypeStr, ge);
                            }
                        }
                        substTemplate.addValidLinkingPosition(id, linkAtom, replAtom, bo, defaultLinktype);
                    }
                    continue;
                }
                if (propertyName.equals("fuzzy")) {
                    substTemplate.setFuzzy(Utils.parseTrueFalseString(propertyValue, false));
                    continue;
                }
                if (propertyName.equals("synonyms")) {
                    List synonymList = property.getChildren();
                    for (Element synonym : synonymList) {
                        SubstituentAlias alias = SubstituentTemplateContainer.parseXmlAliasTag(synonym);
                        if (alias == null) continue;
                        substTemplate.addAlias(alias);
                    }
                    continue;
                }
                if (!propertyName.equals("substituent_part")) continue;
                substTemplate.setSubparts(SubstituentTemplateContainer.parseSubstituentPartsTag(property));
            }
            return substTemplate;
        }
        return null;
    }

    private static SubstituentAlias parseXmlAliasTag(Element synonymElem) throws ResourcesDbException {
        SubstituentAlias alias = null;
        if (synonymElem.getName().equalsIgnoreCase("primary_alias") || synonymElem.getName().equalsIgnoreCase("secondary_alias")) {
            String linkTypeName2;
            alias = new SubstituentAlias();
            GlycanNamescheme scheme = GlycanNamescheme.forName(synonymElem.getAttribute("namescheme").getValue());
            if (scheme == null) {
                throw new ResourcesDbException("Unknown or empty namescheme string: '" + synonymElem.getAttribute("namescheme").getValue() + "'");
            }
            alias.setNamescheme(scheme);
            String linkTypeName = synonymElem.getAttributeValue("linkage_type");
            if (linkTypeName != null) {
                try {
                    alias.setLinktype1(LinkageType.forName(linkTypeName));
                }
                catch (GlycoconjugateException ge) {
                    throw new ResourcesDbException("Error in reading substituent alias from xml: unknown LinkageType " + linkTypeName, ge);
                }
            }
            if ((linkTypeName2 = synonymElem.getAttributeValue("linkage_type2")) != null) {
                try {
                    alias.setLinktype2(LinkageType.forName(linkTypeName2));
                }
                catch (GlycoconjugateException ge) {
                    throw new ResourcesDbException("Error in reading substituent alias from xml: unknown LinkageType " + linkTypeName2, ge);
                }
            }
            alias.setResidueIncludedName(synonymElem.getAttributeValue("residue_included"));
            alias.setSeparateDisplayName(synonymElem.getAttributeValue("separate_display"));
            if (synonymElem.getName().equalsIgnoreCase("primary_alias")) {
                alias.setIsPrimary(true);
            } else {
                alias.setIsPrimary(false);
            }
        }
        return alias;
    }

    private static SubstituentSubpartTreeNode parseSubstituentPartsTag(Element partsTag) throws ResourcesDbException {
        SubstituentSubpartTreeNode substPartNode = null;
        substPartNode = new SubstituentSubpartTreeNode();
        substPartNode.setUserObject(partsTag.getAttributeValue("name"));
        substPartNode.setName(partsTag.getAttributeValue("name"));
        List childTagsList = partsTag.getChildren();
        if (childTagsList != null) {
            for (Element childTag : childTagsList) {
                if (childTag.getName().equalsIgnoreCase("substituent_part")) {
                    substPartNode.add(SubstituentTemplateContainer.parseSubstituentPartsTag(childTag));
                    continue;
                }
                throw new ResourcesDbException("Illegal child tag of substituent_part: " + childTag.getName());
            }
        }
        return substPartNode;
    }

    private static HashMap<String, Integer> parseMinMaxTags(Element parentTag) {
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        List childList = parentTag.getChildren();
        if (childList != null) {
            for (int i = 0; i < parentTag.getChildren().size(); ++i) {
                Element childTag = (Element)parentTag.getChildren().get(i);
                if (childTag.getName().toLowerCase().equals("min")) {
                    try {
                        retMap.put("MIN", Integer.parseInt(childTag.getValue()));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (!childTag.getName().toLowerCase().equals("max")) continue;
                try {
                    retMap.put("MAX", Integer.parseInt(childTag.getValue()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return retMap;
    }
}

