/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.process.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.CustomAnnotationDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExtractDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExtractExternalQuantDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.FullMzXMLDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.FullMzXMLExternalQuantDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantDataProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuantPeak;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.InternalStandardQuantFileList;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.FileReaderUtils;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.extquant.data.ExternalQuantSettings;
import org.grits.toolbox.ms.file.extquant.data.QuantPeak;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.file.reader.IMSExtQuantFileReader;
import org.grits.toolbox.ms.file.reader.IMSFileReader;
import org.grits.toolbox.ms.file.reader.impl.ExtractReader;
import org.grits.toolbox.ms.file.reader.impl.MSXMLReader;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.widgets.progress.IProgressListener;

public class MassSpecTableDataProcessor
extends TableDataProcessor {
    private static final Logger logger = Logger.getLogger(MassSpecTableDataProcessor.class);
    protected MassSpecTableDataObject simianTableDataObject = null;
    protected List<QuantFileProcessor> quantFileProcessors = null;
    protected List<QuantFileProcessor> quantFileProcessorsToRemove = null;
    protected int iMinMSLevel = 1;
    protected Object data = null;
    protected FillTypes fillType = FillTypes.Scans;

    public MassSpecTableDataProcessor(Entry _entry, Property _sourceProperty, int iMinMSLevel) {
        super(_entry, _sourceProperty);
        this.iMinMSLevel = iMinMSLevel;
    }

    public MassSpecTableDataProcessor(Entry _entry, Property _sourceProperty, FillTypes fillType, int iMinMSLevel) {
        this(_entry, _sourceProperty, iMinMSLevel);
        this.fillType = fillType;
    }

    public MassSpecTableDataProcessor(TableDataProcessor _parent, Property _sourceProperty, FillTypes fillType) {
        super(_parent.getEntry(), _sourceProperty);
        this.data = ((MassSpecTableDataProcessor)_parent).getData();
        this.quantFileProcessors = ((MassSpecTableDataProcessor)_parent).getQuantFileProcessors();
        this.fillType = fillType;
        this.iMinMSLevel = ((MassSpecTableDataProcessor)_parent).iMinMSLevel;
    }

    public MSPropertyDataFile getMSSourceFile() {
        if (this.entry == null) {
            return null;
        }
        return ((MassSpecEntityProperty)this.getEntry().getProperty()).getDataFile();
    }

    public int getMinMSLevel() {
        return this.iMinMSLevel;
    }

    public void setMinMSLevel(int iMinMSLevel) {
        this.iMinMSLevel = iMinMSLevel;
    }

    protected Map<Integer, Scan> getScanData() {
        return (Map)this.data;
    }

    public List<QuantFileProcessor> getQuantFileProcessors() {
        return this.quantFileProcessors;
    }

    public Object getData() {
        return this.data;
    }

    protected int addCustomAnnotationPeaks(MassSpecViewerPreference _preferences, CustomAnnotationDataProcessor _processor) {
        int iColCnt = MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsCustomAnnotation(_preferences.getPreferenceSettings(), _preferences.getPreferenceSettings().getUnrecognizedHeaders(), this.getMassSpecEntityProperty().getMsLevel(), _processor.getMassSpecCustomAnnotation());
        return iColCnt;
    }

    protected int addUnrecognizedHeaders(MassSpecViewerPreference _preferences) {
        int iColCnt = 0;
        if (this.quantFileProcessors != null) {
            for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                if (quantFileProcessor instanceof ExtractDataProcessor) {
                    iColCnt += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsExternalQuantWCharge(_preferences.getPreferenceSettings(), _preferences.getPreferenceSettings().getUnrecognizedHeaders(), QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "extract"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Extract"));
                    continue;
                }
                if (quantFileProcessor instanceof FullMzXMLDataProcessor) {
                    iColCnt += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsExternalQuant(_preferences.getPreferenceSettings(), _preferences.getPreferenceSettings().getUnrecognizedHeaders(), QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "full_ms"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Full MS"));
                    continue;
                }
                if (!(quantFileProcessor instanceof CustomAnnotationDataProcessor)) continue;
                iColCnt += this.addCustomAnnotationPeaks(_preferences, (CustomAnnotationDataProcessor)quantFileProcessor);
            }
        }
        return iColCnt;
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new MassSpecViewerPreference();
    }

    public TableViewerPreference initializePreferences() {
        try {
            MassSpecViewerPreference newPreferences = (MassSpecViewerPreference)super.initializePreferences();
            newPreferences.setFillType(this.fillType);
            newPreferences.setMSLevel(this.getMassSpecEntityProperty().getMsLevel().intValue());
            return newPreferences;
        }
        catch (Exception e) {
            logger.error((Object)"initializePreferences: unable to initialize preferences.", (Throwable)e);
            return null;
        }
    }

    public void initializeTableDataObject(Property _sourceProperty) {
        this.setSimianTableDataObject(new MassSpecTableDataObject(((MassSpecEntityProperty)_sourceProperty).getMsLevel().intValue(), this.fillType));
        this.getSimianTableDataObject().initializePreferences();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            TableViewerPreference tvp = this.initializePreferences();
            MassSpecTableDataProcessor.setDefaultColumnViewSettings(this.fillType, tvp.getPreferenceSettings());
            tvp.setColumnSettings(tvp.getPreferenceSettings().toString());
            this.getSimianTableDataObject().setTablePreferences(tvp);
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
    }

    protected MassSpecEntityProperty getMassSpecEntityProperty() {
        return (MassSpecEntityProperty)this.sourceProperty;
    }

    public MassSpecTableDataObject getSimianTableDataObject() {
        return this.simianTableDataObject;
    }

    public void setSimianTableDataObject(MassSpecTableDataObject simianTableDataObject) {
        this.simianTableDataObject = simianTableDataObject;
    }

    public static ArrayList<Object> getNewRow(int iMaxNumCols) {
        ArrayList<Object> alRow = new ArrayList<Object>(iMaxNumCols);
        int i = 0;
        while (i < iMaxNumCols) {
            alRow.add(null);
            ++i;
        }
        return alRow;
    }

    public boolean saveChanges() throws Exception {
        return true;
    }

    protected void showUnrecognizedCols() {
        TableViewerColumnSettings prefSettings = this.getSimianTableDataObject().getTablePreferences().getPreferenceSettings();
        for (GRITSColumnHeader tempHeader : this.getTempPreference().getPreferenceSettings().getHeaders()) {
            GRITSColumnHeader prefHeader = prefSettings.getColumnHeader(tempHeader.getKeyValue());
            if (prefHeader != null) continue;
            logger.warn((Object)("In new settings but not preferences: " + tempHeader));
        }
        for (String sTempCol : this.getTempPreference().getPreferenceSettings().getUnrecognizedHeaders().keySet()) {
            logger.warn((Object)("In new settings unrecognized headers: " + sTempCol));
        }
        for (GRITSColumnHeader prefHeader : prefSettings.getHeaders()) {
            GRITSColumnHeader tempHeader = this.getTempPreference().getPreferenceSettings().getColumnHeader(prefHeader.getKeyValue());
            if (tempHeader != null) continue;
            logger.warn((Object)("In pref settings but not new: " + prefHeader));
        }
        for (String sTempCol : prefSettings.getUnrecognizedHeaders().keySet()) {
            logger.warn((Object)("In pref settings unrecognized headers: " + sTempCol));
        }
    }

    protected void loadExternalQuant() {
        try {
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Indeterminant);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Loading external quant...");
            this.initializeQuantFiles();
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Done...");
        }
        catch (Exception e) {
            logger.error((Object)"loadExternalQuant: unable to load external quant.", (Throwable)e);
        }
    }

    protected void addUnrecognizedHeaders() {
        try {
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Indeterminant);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Adding unrecognized headers...");
            if (this.getSimianTableDataObject().getTablePreferences().getPreferenceSettings().hasUnrecognizedHeaders()) {
                int iNumCols = this.addUnrecognizedHeaders((MassSpecViewerPreference)this.getSimianTableDataObject().getTablePreferences());
                this.setLastVisibleCol(this.getLastVisibleCol() + iNumCols);
            }
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Done...");
        }
        catch (Exception e) {
            logger.error((Object)"addUnrecognizedHeaders: unable to add unrecognized headers.", (Throwable)e);
        }
    }

    public boolean createTable() throws Exception {
        block6: {
            try {
                this.loadExternalQuant();
                this.addUnrecognizedHeaders();
                this.setTempPreference(this.initializePreferences());
                this.buildTable();
                this.quantFileProcessorsToRemove = null;
                if (!this.bCancel) break block6;
                return true;
            }
            catch (Exception e) {
                logger.error((Object)"createTable: unable to read mzXML.", (Throwable)e);
                return false;
            }
        }
        int iNumPref = this.getSimianTableDataObject().getTablePreferences().getPreferenceSettings().getNumColumns();
        int iNumNew = this.getTempPreference().getPreferenceSettings().getNumColumns();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            this.showUnrecognizedCols();
            MassSpecTableDataProcessor.setDefaultColumnViewSettings(this.fillType, this.getTempPreference().getPreferenceSettings());
            this.getSimianTableDataObject().getTablePreferences().setPreferenceSettings(this.getTempPreference().getPreferenceSettings());
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        } else if (iNumPref > iNumNew) {
            logger.warn((Object)"Unrecognized headers in preferences. Saving them, but this is really an error.");
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
        this.getSimianTableDataObject().getTablePreferences().mergeSettings(this.getTempPreference().getPreferenceSettings());
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Done loading from XML..");
        return true;
    }

    public static void setDefaultColumnPosition(TableViewerColumnSettings tvs, GRITSColumnHeader header, int iPos) {
        int iLastPos = 0;
        int iCurHeaderPos = tvs.getColumnPosition(header);
        for (GRITSColumnHeader curHeader : tvs.getHeaders()) {
            int iVisInx = tvs.getColumnPosition(curHeader);
            if (iVisInx < 0) continue;
            if (iVisInx <= iPos && iVisInx > iCurHeaderPos) {
                tvs.setVisColInx(curHeader, Integer.valueOf(iVisInx - 1));
            } else if (iVisInx >= iPos && iVisInx < iCurHeaderPos) {
                tvs.setVisColInx(curHeader, Integer.valueOf(iVisInx + 1));
            }
            if (iLastPos >= iVisInx) continue;
            iLastPos = iVisInx;
        }
        if (iPos > iLastPos) {
            tvs.setVisColInx(header, Integer.valueOf(iLastPos));
        } else {
            tvs.setVisColInx(header, Integer.valueOf(iPos));
        }
    }

    public static void setDefaultColumnViewSettings(FillTypes fillType, TableViewerColumnSettings tvs) {
        GRITSColumnHeader header;
        if ((fillType == FillTypes.PeakList || fillType == FillTypes.PeaksWithFeatures) && (header = tvs.getColumnHeader(DMPeak.peak_id.name())) != null) {
            tvs.setVisColInx(header, Integer.valueOf(-1));
        }
    }

    protected TableViewerColumnSettings initializeColumnSettings() {
        try {
            boolean bHasScanNum;
            int iNumCols = 0;
            TableViewerColumnSettings newSettings = this.getNewTableViewerSettings();
            boolean bHasSubScans = !this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType().equals("MS Profile");
            boolean bl = bHasScanNum = this.getMassSpecEntityProperty().getMsLevel() == 1 || bHasSubScans;
            if (this.fillType == FillTypes.Scans) {
                iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsScan(newSettings, this.getMassSpecEntityProperty().getMsLevel(), !bHasScanNum, bHasSubScans);
                iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsCorrectedPeakScanData(newSettings, this.getMassSpecEntityProperty());
                if (this.quantFileProcessors != null) {
                    for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                        if (quantFileProcessor instanceof ExtractDataProcessor) {
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsExternalQuantWCharge(newSettings, this.getMassSpecEntityProperty().getMsLevel(), QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "extract"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Extract"));
                            continue;
                        }
                        if (quantFileProcessor instanceof FullMzXMLDataProcessor) {
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsExternalQuant(newSettings, this.getMassSpecEntityProperty().getMsLevel(), QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "full_ms"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Full MS"));
                            continue;
                        }
                        if (quantFileProcessor instanceof CustomAnnotationDataProcessor) {
                            MassSpecCustomAnnotation msca = ((CustomAnnotationDataProcessor)quantFileProcessor).getMassSpecCustomAnnotation();
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsCustomAnnotation(newSettings, this.getMassSpecEntityProperty().getMsLevel(), msca);
                            continue;
                        }
                        if (quantFileProcessor instanceof StandardQuantDataProcessor) {
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsStandardQuantitation(newSettings, (StandardQuantDataProcessor)quantFileProcessor);
                            continue;
                        }
                        throw new Exception("Unrecognized ExternalQuantFileProcessor: " + quantFileProcessor);
                    }
                }
            } else if (this.fillType == FillTypes.PeakList) {
                iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakList(newSettings);
            } else if (this.fillType == FillTypes.PeaksWithFeatures) {
                iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakWithFeatures(newSettings, !bHasScanNum);
                iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsCorrectedPeakScanData(newSettings, this.getMassSpecEntityProperty());
                if (this.quantFileProcessors != null) {
                    for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                        if (quantFileProcessor instanceof ExtractDataProcessor) {
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakWithFeaturesExternalQuantWCharge(newSettings, QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "extract"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Extract"));
                            continue;
                        }
                        if (quantFileProcessor instanceof FullMzXMLDataProcessor) {
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsPeakWithFeaturesExternalQuant(newSettings, QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "full_ms"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Full MS"));
                            continue;
                        }
                        if (quantFileProcessor instanceof CustomAnnotationDataProcessor) {
                            MassSpecCustomAnnotation msca = ((CustomAnnotationDataProcessor)quantFileProcessor).getMassSpecCustomAnnotation();
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsCustomAnnotation(newSettings, this.getMassSpecEntityProperty().getMsLevel(), msca);
                            continue;
                        }
                        if (quantFileProcessor instanceof StandardQuantDataProcessor) {
                            iNumCols += MassSpecTableDataProcessorUtil.fillMassSpecColumnSettingsStandardQuantitation(newSettings, (StandardQuantDataProcessor)quantFileProcessor);
                            continue;
                        }
                        throw new Exception("Unrecognized ExternalQuantFileProcessor: " + quantFileProcessor);
                    }
                }
            }
            this.setLastVisibleCol(iNumCols);
            return newSettings;
        }
        catch (Exception e) {
            logger.error((Object)"initializeColumnSettings: unable to initialize all columns.", (Throwable)e);
            return null;
        }
    }

    protected boolean processExternalQuant() {
        if (this.quantFileProcessors == null) {
            return false;
        }
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Loading external quantitation data...");
        boolean bLoaded = false;
        try {
            for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                if (quantFileProcessor instanceof CustomAnnotationDataProcessor) {
                    bLoaded |= this.loadSubScanExternalQuant(quantFileProcessor);
                    continue;
                }
                int iParentScanNum = -1;
                if (this.getMassSpecEntityProperty().getParentScanNum() != null) {
                    iParentScanNum = this.getMassSpecEntityProperty().getParentScanNum();
                }
                if (iParentScanNum == -1) continue;
                bLoaded |= this.loadPrecursorExternalQuantData(iParentScanNum, quantFileProcessor, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"processExternalQuant: unable to initialize all columns.", (Throwable)e);
        }
        return bLoaded;
    }

    protected boolean loadSubScanExternalQuant(QuantFileProcessor _processor, Scan msScan) {
        boolean bUpdated = false;
        try {
            this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(this.getScanData().size());
            int iScanNum = msScan.getScanNo();
            ((CustomAnnotationDataProcessor)_processor).setCurScan(msScan);
            _processor.loadExternalData();
            _processor.getQuantPeakData().setScanNo(iScanNum);
            _processor.getSettings().setTargetScanNumber(Integer.valueOf(iScanNum));
            _processor.setSourcePeakList(this.getScanData());
            bUpdated = _processor.matchExternalPeaks(false);
        }
        catch (Exception e) {
            logger.error((Object)"loadSubScanExternalQuant: unable to initialize all columns.", (Throwable)e);
        }
        return bUpdated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadSubScanExternalQuant(QuantFileProcessor _processor) {
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(this.getScanData().size());
        boolean bUpdated = false;
        try {
            Iterator<Integer> iterator = this.getScanData().keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return bUpdated;
                }
                Integer iScan = iterator.next();
                Scan msScan = this.getScanData().get(iScan);
                if (this.getMassSpecEntityProperty().getMsLevel() != null && !msScan.getMsLevel().equals(this.getMassSpecEntityProperty().getMsLevel()) && !msScan.getMsLevel().equals(this.getMassSpecEntityProperty().getMsLevel() - 1) || this.getMassSpecEntityProperty().getScanNum() != null && this.getMassSpecEntityProperty().getScanNum() != -1 && !msScan.getScanNo().equals(this.getMassSpecEntityProperty().getScanNum()) || this.getMassSpecEntityProperty().getParentScanNum() != null && this.getMassSpecEntityProperty().getParentScanNum() != -1 && (msScan.getParentScan() == null || !this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType().equals("Direct Infusion") && !msScan.getParentScan().equals(this.getMassSpecEntityProperty().getParentScanNum()) && !msScan.getScanNo().equals(this.getMassSpecEntityProperty().getParentScanNum()))) continue;
                bUpdated |= this.loadSubScanExternalQuant(_processor, msScan);
                if (this.bCancel) break;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"loadSubScanExternalQuant: unable to initialize all columns.", (Throwable)e);
        }
        return bUpdated;
    }

    public void buildTable() throws Exception {
        this.processExternalQuant();
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building table...");
        int iMax = this.getScanData().size();
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(iMax);
        ArrayList<GRITSColumnHeader> alHeader = new ArrayList<GRITSColumnHeader>();
        try {
            this.addHeaderLine(alHeader);
        }
        catch (Exception e) {
            throw new Exception("Unable to build table", e);
        }
        this.getSimianTableDataObject().getTableHeader().add(alHeader);
        if (this.fillType == FillTypes.Scans) {
            this.addScansTableData();
        } else if (this.getMassSpecEntityProperty().getPeakListNumber() == 1) {
            this.addPeaksTableData();
        } else {
            this.addAdditionalPeaksTableData(this.getMassSpecEntityProperty().getPeakListNumber() - 1);
        }
        if (this.getSimianTableDataObject().getTableData().isEmpty()) {
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
        }
    }

    protected void addHeaderLine(ArrayList<GRITSColumnHeader> alHeader) throws Exception {
        for (GRITSColumnHeader colHeader : this.getTempPreference().getPreferenceSettings().keySet()) {
            int iPrefColNum = this.getTempPreference().getPreferenceSettings().getColumnPosition(colHeader);
            this.addHeaderLine(iPrefColNum, colHeader, alHeader);
        }
    }

    protected void addHeaderLine(int iPrefColNum, GRITSColumnHeader colHeader, ArrayList<GRITSColumnHeader> alHeader) {
        if (colHeader.getKeyValue().equals(DMScan.scan_scanNo.name()) || colHeader.getKeyValue().equals(DMScan.scan_pseudoScanNo.name())) {
            this.getSimianTableDataObject().addScanNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMScan.scan_parentScan.name())) {
            this.getSimianTableDataObject().addParentNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_id.name())) {
            this.getSimianTableDataObject().addPeakIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_mz.name())) {
            this.getSimianTableDataObject().addMzCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_intensity.name())) {
            this.getSimianTableDataObject().addPeakIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_is_precursor.name())) {
            this.getSimianTableDataObject().addPeakIsPrecursorCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPrecursorPeak.precursor_peak_intensity.name())) {
            this.getSimianTableDataObject().addPrecursorIntensityCol(iPrefColNum);
        }
        MassSpecTableDataProcessorUtil.setHeaderValue(iPrefColNum, colHeader, alHeader);
    }

    protected InternalStandardQuantFileList getInternalStandardQuantFileList(MSPropertyDataFile quantFile) {
        MassSpecMetaData uiSettings = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData();
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(quantFile);
        if (uiSettings.getInternalStandardQuantFiles() == null || uiSettings.getInternalStandardQuantFiles().isEmpty()) {
            return null;
        }
        InternalStandardQuantFileList isqfl = uiSettings.getInternalStandardQuantFiles().get(sExtQuantType);
        return isqfl;
    }

    protected ExternalQuantAlias getExternalQuantAliasForInternalQuant(String sQuantSetName, MSPropertyDataFile quantFile) {
        InternalStandardQuantFileList isqfl = this.getInternalStandardQuantFileList(quantFile);
        if (isqfl == null) {
            return null;
        }
        ExternalQuantFileToAlias mAliases = isqfl.getExternalQuantToAliasByQuantType(sQuantSetName);
        if (mAliases == null) {
            return null;
        }
        ExternalQuantAlias foundAlias = null;
        if (mAliases != null) {
            for (String sFileName : mAliases.getSourceDataFileNameToAlias().keySet()) {
                ExternalQuantAlias aliasInfo = mAliases.getSourceDataFileNameToAlias().get(sFileName);
                if (aliasInfo == null || !sFileName.equals(quantFile.getName())) continue;
                foundAlias = aliasInfo;
            }
        }
        return foundAlias;
    }

    protected ExternalQuantAlias getExternalQuantAlias(MSPropertyDataFile quantFile) {
        MassSpecMetaData uiSettings = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData();
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(quantFile);
        ExternalQuantFileToAlias mAliases = uiSettings.getExternalQuantToAliasByQuantType(sExtQuantType);
        ExternalQuantAlias foundAlias = null;
        if (mAliases != null) {
            for (String sFileName : mAliases.getSourceDataFileNameToAlias().keySet()) {
                ExternalQuantAlias aliasInfo = mAliases.getSourceDataFileNameToAlias().get(sFileName);
                if (aliasInfo == null || !sFileName.equals(quantFile.getName())) continue;
                foundAlias = aliasInfo;
            }
        }
        return foundAlias;
    }

    private QuantFileProcessor getNewQuantProcessor(MSPropertyDataFile quantFile, ExternalQuantAlias aliasInfo) {
        String sExpType = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType();
        String sMSPath = this.getMSPath();
        MSFile msFile = quantFile.getMSFileWithReader(sMSPath, sExpType);
        IMSFileReader reader = msFile.getReader();
        if (reader == null || !(reader instanceof IMSExtQuantFileReader)) {
            logger.error((Object)("Null or invalid external quantreader for msFile: " + msFile.getFileName()));
            return null;
        }
        QuantFileProcessor processor = null;
        if (reader instanceof MSXMLReader) {
            ExternalQuantSettings parameter = new ExternalQuantSettings(msFile, true, Double.valueOf(500.0));
            processor = new FullMzXMLExternalQuantDataProcessor(parameter);
        } else if (reader instanceof ExtractReader) {
            ExternalQuantSettings parameter = new ExternalQuantSettings(msFile, true, Double.valueOf(500.0));
            processor = new ExtractExternalQuantDataProcessor(parameter);
        } else {
            logger.error((Object)("Unsupported external quant reader for file: " + msFile.getFileName()));
            return null;
        }
        processor.setKeyID(aliasInfo.getKey());
        processor.setLabelAlias(aliasInfo.getAlias());
        return processor;
    }

    protected void setQuantFiles(List<QuantFileProcessor> lQuantFiles) {
        if (this.quantFileProcessors == null) {
            this.quantFileProcessors = new ArrayList<QuantFileProcessor>();
        } else {
            this.quantFileProcessors.clear();
        }
        for (QuantFileProcessor newQuantFile : lQuantFiles) {
            this.quantFileProcessors.add(newQuantFile);
        }
    }

    protected List<MassSpecCustomAnnotation> getCustomAnnotationList() {
        if (this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData() != null && this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getCustomAnnotations() != null && !this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getCustomAnnotations().isEmpty()) {
            MassSpecMetaData msSettings = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData();
            return msSettings.getCustomAnnotations();
        }
        return null;
    }

    protected CustomAnnotationDataProcessor getNewCustomAnnotationProcessor(ExternalQuantSettings quantSettings) {
        CustomAnnotationDataProcessor spdf = new CustomAnnotationDataProcessor(quantSettings);
        return spdf;
    }

    private List<Peak> getPeakListForInternalStandardQuant(MassSpecStandardQuant mssq) {
        if (mssq == null || mssq == null) {
            return null;
        }
        int iMSLevel = this.getMassSpecEntityProperty().getMsLevel() - 1;
        ArrayList<Peak> peakList = new ArrayList<Peak>();
        Collection<MassSpecStandardQuantPeak> quantPeaks = mssq.getStandardQuantPeaks().values();
        for (MassSpecStandardQuantPeak customPeak : quantPeaks) {
            if (customPeak.getMSLevel() != iMSLevel) continue;
            Peak p = new Peak();
            p.setMz(customPeak.getPeakMz());
            p.setIntensity(Double.valueOf(1.0));
            p.setIsPrecursor(true);
            peakList.add(p);
        }
        return peakList;
    }

    protected List<MassSpecStandardQuant> getStandardQuantitationList() {
        if (this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData() != null && this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getStandardQuant() != null && !this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getStandardQuant().isEmpty()) {
            MassSpecMetaData msSettings = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData();
            return msSettings.getStandardQuant();
        }
        return null;
    }

    protected HashMap<String, InternalStandardQuantFileList> getStandardQuantitationFileList() {
        if (this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData() != null && this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getInternalStandardQuantFiles() != null && !this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getInternalStandardQuantFiles().isEmpty()) {
            MassSpecMetaData msSettings = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData();
            return msSettings.getInternalStandardQuantFiles();
        }
        return null;
    }

    protected void initializeQuantFiles() {
        ArrayList<QuantFileProcessor> loadedProcessors = new ArrayList<QuantFileProcessor>();
        List<MSPropertyDataFile> quantMSPDFs = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getQuantificationFiles();
        List<MSPropertyDataFile> annotMSPDFs = this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getAnnotationFiles();
        for (MSPropertyDataFile mspdf : quantMSPDFs) {
            ExternalQuantAlias aliasInfo = this.getExternalQuantAlias(mspdf);
            if (aliasInfo == null) continue;
            try {
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading peak file...");
                QuantFileProcessor quantFileProcessor = this.getNewQuantProcessor(mspdf, aliasInfo);
                if (quantFileProcessor == null) continue;
                loadedProcessors.add(quantFileProcessor);
            }
            catch (Exception e) {
                logger.error((Object)"initializeExternalQuantProcessors: unable to add external quant file file.", (Throwable)e);
            }
        }
        List<MassSpecCustomAnnotation> customAnnotations = this.getCustomAnnotationList();
        if (customAnnotations != null && !customAnnotations.isEmpty()) {
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading special peak file...");
            for (MassSpecCustomAnnotation annotation : customAnnotations) {
                ExternalQuantSettings quantSettings = new ExternalQuantSettings(null, annotation.getIsPPM().booleanValue(), annotation.getMassTolerance());
                CustomAnnotationDataProcessor spdf = new CustomAnnotationDataProcessor(quantSettings);
                spdf.setMassSpecCustomAnnotation(annotation);
                spdf.setCustomAnnotationPeakList();
                loadedProcessors.add(spdf);
            }
        }
        List<MassSpecStandardQuant> internalStdQuantList = this.getStandardQuantitationList();
        HashMap<String, InternalStandardQuantFileList> internalStdQuantFileList = this.getStandardQuantitationFileList();
        if (internalStdQuantList != null && !internalStdQuantList.isEmpty() && internalStdQuantFileList != null && !internalStdQuantFileList.isEmpty()) {
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Processing internal standard quant...");
            for (String sQuantType : internalStdQuantFileList.keySet()) {
                InternalStandardQuantFileList fileList = internalStdQuantFileList.get(sQuantType);
                if (fileList == null || fileList.getQuantNameToFileAlias() == null || fileList.getQuantNameToFileAlias().isEmpty()) continue;
                for (MassSpecStandardQuant mssq : internalStdQuantList) {
                    List<Peak> peakList = this.getPeakListForInternalStandardQuant(mssq);
                    ExternalQuantFileToAlias eqfa = fileList.getQuantNameToFileAlias().get(mssq.getStandardQuantName());
                    if (eqfa == null) continue;
                    for (String sFilePath : eqfa.getSourceDataFileNameToAlias().keySet()) {
                        boolean bMatched = false;
                        for (MSPropertyDataFile quantFile : quantMSPDFs) {
                            if (!quantFile.getName().equals(sFilePath)) continue;
                            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading peak file...");
                            ExternalQuantAlias aliasInfo = this.getExternalQuantAliasForInternalQuant(mssq.getStandardQuantName(), quantFile);
                            QuantFileProcessor externalProcessor = this.getNewQuantProcessor(quantFile, aliasInfo);
                            if (externalProcessor == null) continue;
                            StandardQuantDataProcessor standardProcessor = new StandardQuantDataProcessor(externalProcessor);
                            standardProcessor.setLabelAlias(String.valueOf(mssq.getStandardQuantName()) + " : " + externalProcessor.getLabelAlias());
                            standardProcessor.setKeyID(String.valueOf(mssq.getStandardQuantName()) + ":" + externalProcessor.getKeyID());
                            standardProcessor.setSourcePeakListToMatch(peakList);
                            loadedProcessors.add(standardProcessor);
                            bMatched = true;
                        }
                        if (bMatched) continue;
                        for (MSPropertyDataFile quantFile : annotMSPDFs) {
                            if (!quantFile.getName().equals(sFilePath)) continue;
                            MSPropertyDataFile extQuantFile = (MSPropertyDataFile)((Object)quantFile.clone());
                            extQuantFile.setCategory(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY);
                            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading peak file...");
                            ExternalQuantAlias aliasInfo = this.getExternalQuantAliasForInternalQuant(mssq.getStandardQuantName(), quantFile);
                            QuantFileProcessor externalProcessor = this.getNewQuantProcessor(extQuantFile, aliasInfo);
                            if (externalProcessor == null) continue;
                            StandardQuantDataProcessor standardProcessor = new StandardQuantDataProcessor(externalProcessor);
                            standardProcessor.setLabelAlias(String.valueOf(mssq.getStandardQuantName()) + " : " + externalProcessor.getLabelAlias());
                            standardProcessor.setKeyID(String.valueOf(mssq.getStandardQuantName()) + ":" + externalProcessor.getKeyID());
                            standardProcessor.setSourcePeakListToMatch(peakList);
                            loadedProcessors.add(standardProcessor);
                            bMatched = true;
                        }
                    }
                }
            }
        }
        this.setQuantFiles(loadedProcessors);
    }

    protected int[] getMSReadParameters() {
        int iMSLevel = -1;
        int iParentScanNum = -1;
        int iScanNum = -1;
        if (this.getMassSpecEntityProperty().getMsLevel() != null && this.fillType != FillTypes.PeakList) {
            iMSLevel = this.getMassSpecEntityProperty().getMsLevel();
        }
        if (this.getMassSpecEntityProperty().getParentScanNum() != null) {
            iParentScanNum = this.getMassSpecEntityProperty().getParentScanNum();
        }
        if (this.getMassSpecEntityProperty().getScanNum() != null) {
            iScanNum = this.getMassSpecEntityProperty().getScanNum();
        }
        return new int[]{iMSLevel, iParentScanNum, iScanNum};
    }

    public boolean readDataFromFile() {
        IMSFileReader reader;
        MSFile msFile;
        int iScanNum;
        int iParentScanNum;
        int iMSLevel;
        block6: {
            MSPropertyDataFile msSourceFile;
            block5: {
                int[] iParams = this.getMSReadParameters();
                iMSLevel = iParams[0];
                iParentScanNum = iParams[1];
                iScanNum = iParams[2];
                try {
                    msSourceFile = this.getMSSourceFile();
                    if (msSourceFile != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)"readDataFromFile: unable to read mzXML.", (Throwable)e);
                    return false;
                }
            }
            Entry msEntry = MassSpecProperty.getMSParentEntry(this.getEntry());
            MassSpecProperty msProp = (MassSpecProperty)msEntry.getProperty();
            msFile = msSourceFile.getMSFileWithReader(this.getMSPath(), msProp.getMassSpecMetaData().getMsExperimentType(), true);
            reader = msFile.getReader();
            if (reader != null && reader instanceof IMSAnnotationFileReader) break block6;
            return false;
        }
        int iMax = ((IMSAnnotationFileReader)reader).getMaxScanNumber(msFile);
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(iMax);
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading data file...");
        reader.addProgressListeners((IProgressListener)this.progressBarDialog.getMinorProgressBarListener(0));
        this.getlLongRunningProcesses().add(reader);
        List scans = ((IMSAnnotationFileReader)reader).readMSFile(msFile, iMSLevel, iParentScanNum, iScanNum);
        if (scans == null || scans.isEmpty()) {
            logger.error((Object)"No scan data returned from mzXML.");
        }
        this.data = FileReaderUtils.listToHashMap((List)scans);
        this.getlLongRunningProcesses().remove(reader);
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Done...");
        return true;
    }

    public String getMSPath() {
        Entry msEntry = MassSpecProperty.getMSParentEntry(this.getEntry());
        MassSpecProperty msProp = (MassSpecProperty)msEntry.getProperty();
        String folderName = MassSpecProperty.getFullyQualifiedFolderName(msEntry);
        return folderName;
    }

    protected void loadExternalQuantDataForDirectInfusion(int _iParentScanNum, int _iExternalScanNum) {
        try {
            Scan scan = this.getScanData().get(_iParentScanNum);
            if (scan == null || scan.getPeaklist().isEmpty()) {
                MSPropertyDataFile msSourceFile = this.getMSSourceFile();
                if (msSourceFile == null) {
                    return;
                }
                Entry msEntry = MassSpecProperty.getMSParentEntry(this.getEntry());
                MassSpecProperty msProp = (MassSpecProperty)msEntry.getProperty();
                String folderName = MassSpecProperty.getFullyQualifiedFolderName(msEntry);
                MSFile msFile = msSourceFile.getMSFileWithReader(folderName, msProp.getMassSpecMetaData().getMsExperimentType());
                IMSFileReader reader = msFile.getReader();
                if (reader == null || !(reader instanceof IMSAnnotationFileReader)) {
                    return;
                }
                reader.addProgressListeners((IProgressListener)this.progressBarDialog.getMinorProgressBarListener(0));
                this.getlLongRunningProcesses().add(reader);
                int iMSLevel = this.getScanData().get(_iExternalScanNum).getMsLevel();
                List scans = ((IMSAnnotationFileReader)reader).readMSFile(msFile, iMSLevel, -1, _iParentScanNum);
                LinkedHashMap tmpData = FileReaderUtils.listToHashMap((List)scans);
                this.getScanData().put(_iParentScanNum, (Scan)tmpData.get(_iParentScanNum));
                this.getlLongRunningProcesses().remove(reader);
            }
            this.getScanData().put(_iExternalScanNum, this.getScanData().get(_iParentScanNum));
        }
        catch (Exception e) {
            logger.error((Object)"loadExternalQuantDataForDirectInfusion: error loading the scan data necessary for external quant.", (Throwable)e);
        }
    }

    protected boolean loadPrecursorExternalQuantData(int _iParentScanNum, QuantFileProcessor _quantFileProcessor, boolean _bRemove) {
        if (this.fillType == FillTypes.PeakList) {
            return false;
        }
        boolean bUpdated = false;
        QuantFileProcessor subProc = null;
        try {
            this.loadExternalQuantDataForDirectInfusion(_iParentScanNum, _iParentScanNum);
            if (_quantFileProcessor.getQuantPeakData() == null || _quantFileProcessor.getQuantPeakData().getPeaks().isEmpty()) {
                if (_quantFileProcessor instanceof FullMzXMLDataProcessor) {
                    ((FullMzXMLDataProcessor)_quantFileProcessor).setPrecursorPeaks(this.getScanData().get(_iParentScanNum).getPeaklist());
                } else if (_quantFileProcessor instanceof StandardQuantDataProcessor && (subProc = ((StandardQuantDataProcessor)_quantFileProcessor).getQuantFileProcessor()) instanceof FullMzXMLDataProcessor) {
                    ((FullMzXMLDataProcessor)subProc).setPrecursorPeaks(this.getScanData().get(_iParentScanNum).getPeaklist());
                    ((FullMzXMLDataProcessor)subProc).getPrecursorPeaks().addAll(_quantFileProcessor.getSourcePeakListToMatch());
                }
                _quantFileProcessor.loadExternalData();
            }
            _quantFileProcessor.getQuantPeakData().setScanNo(_iParentScanNum);
            _quantFileProcessor.getSettings().setTargetScanNumber(Integer.valueOf(_iParentScanNum));
            if (_quantFileProcessor.getSourcePeakListToMatch() == null || _quantFileProcessor.getSourcePeakListToMatch().isEmpty()) {
                _quantFileProcessor.setSourcePeakList(this.getScanData());
            }
            if (subProc != null && (subProc.getSourcePeakListToMatch() == null || subProc.getSourcePeakListToMatch().isEmpty())) {
                _quantFileProcessor.setQuantPeakData(subProc.getQuantPeakData());
                _quantFileProcessor.getSettings().setTargetScanNumber(subProc.getSettings().getTargetScanNumber());
                subProc.setSourcePeakList(this.getScanData());
            }
            bUpdated = _bRemove ? (bUpdated |= _quantFileProcessor.removeExternalPeakMatches(true)) : (bUpdated |= _quantFileProcessor.matchExternalPeaks(true));
        }
        catch (Exception e) {
            logger.error((Object)"loadExtractData: unable to read extract file.", (Throwable)e);
        }
        return bUpdated;
    }

    protected void addScanRow(Scan msScan) {
        if (this.getMassSpecEntityProperty().getMsLevel() != null && !msScan.getMsLevel().equals(this.getMassSpecEntityProperty().getMsLevel())) {
            return;
        }
        if (this.getMassSpecEntityProperty().getParentScanNum() != null && this.getMassSpecEntityProperty().getParentScanNum() != -1 && !msScan.getParentScan().equals(this.getMassSpecEntityProperty().getParentScanNum())) {
            return;
        }
        if (this.getMassSpecEntityProperty().getScanNum() != null && this.getMassSpecEntityProperty().getScanNum() != -1 && !msScan.getScanNo().equals(this.getMassSpecEntityProperty().getScanNum())) {
            return;
        }
        GRITSListDataRow alRow = this.getNewRow();
        this.addScanData(msScan, this.getTempPreference().getPreferenceSettings(), alRow);
        this.getSimianTableDataObject().getTableData().add(alRow);
    }

    protected void addScansTableData() {
        int iCnt = 1;
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(this.getScanData().size());
        for (Integer iScan : this.getScanData().keySet()) {
            Scan msScan = this.getScanData().get(iScan);
            if (iCnt % 100 == 0) {
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building scans table. Scan: " + iCnt + " of " + this.getScanData().size());
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(iCnt);
            }
            ++iCnt;
            this.addScanRow(msScan);
            if (!this.bCancel) continue;
            this.setSimianTableDataObject(null);
            return;
        }
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Done.");
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(this.getScanData().size());
    }

    protected void addPeaksTableData() {
        int iCnt = 1;
        for (Integer iScan : this.getScanData().keySet()) {
            Scan msScan = this.getScanData().get(iScan);
            if (iCnt % 100 == 0) {
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building peaks table. Scan: " + iCnt + " of " + this.getScanData().size());
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(iCnt);
            }
            this.addPeakData(msScan, this.getTempPreference().getPreferenceSettings());
            if (!this.bCancel) continue;
            this.setSimianTableDataObject(null);
            return;
        }
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Done.");
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(this.getScanData().size());
    }

    protected void addAdditionalPeaksTableData(int _iQuantFileNum) {
        try {
            if (this.quantFileProcessors == null || _iQuantFileNum > this.quantFileProcessors.size() - 1) {
                return;
            }
            int iCnt = 1;
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Scan: 1");
            QuantFileProcessor processor = this.quantFileProcessors.get(_iQuantFileNum);
            for (QuantPeak extPeak : processor.getQuantPeakData().getPeaks()) {
                for (QuantPeakMatch match : extPeak.getMatch()) {
                    Peak peak = new Peak();
                    peak.setMz(match.getMzMostAbundant());
                    peak.setIntensity(match.getIntensitySum());
                    peak.setCharge(match.getCharge());
                    this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Scan: " + iCnt++);
                    GRITSListDataRow alRow = this.getNewRow();
                    this.addPeaksData(null, null, peak, this.getTempPreference().getPreferenceSettings(), alRow);
                    this.getSimianTableDataObject().getTableData().add(alRow);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addAdditionalPeaksTableData: error adding external quant to table model.", (Throwable)e);
        }
    }

    protected void addPeakData(Scan msScan, TableViewerColumnSettings _settings) {
        if (this.fillType != FillTypes.PeakList && this.getMassSpecEntityProperty().getMsLevel() != null && this.getMassSpecEntityProperty().getMsLevel() != -1 && msScan.getMsLevel() != null && !msScan.getMsLevel().equals(this.getMassSpecEntityProperty().getMsLevel())) {
            return;
        }
        if (this.getMassSpecEntityProperty().getParentScanNum() != null && this.getMassSpecEntityProperty().getParentScanNum() != -1 && msScan.getParentScan() != null && !msScan.getParentScan().equals(this.getMassSpecEntityProperty().getParentScanNum())) {
            return;
        }
        if (this.getMassSpecEntityProperty().getScanNum() != null && this.getMassSpecEntityProperty().getScanNum() != -1 && msScan.getScanNo() != null && !msScan.getScanNo().equals(this.getMassSpecEntityProperty().getScanNum())) {
            return;
        }
        for (Peak peak : msScan.getPeaklist()) {
            if (peak == null) continue;
            GRITSListDataRow alRow = this.getNewRow();
            this.addPeaksData(msScan.getScanNo(), null, peak, _settings, alRow);
            this.getSimianTableDataObject().getTableData().add(alRow);
        }
    }

    protected boolean removeExternalQuantPeaksData(Peak _peak, QuantFileProcessor quantFileProcessor) {
        boolean bRemoveQuant = false;
        try {
            ArrayList<String> sKeysToRemove;
            if (!quantFileProcessor.getSettings().getQuantifyPrecursor().booleanValue()) {
                return bRemoveQuant;
            }
            if (_peak.getIntegerProp() != null && !_peak.getIntegerProp().isEmpty()) {
                sKeysToRemove = new ArrayList<String>();
                for (String sKey : _peak.getIntegerProp().keySet()) {
                    if (!quantFileProcessor.matchesExternalQuantKey(sKey)) continue;
                    sKeysToRemove.add(sKey);
                }
                for (String sKey : sKeysToRemove) {
                    _peak.getIntegerProp().remove(sKey);
                    bRemoveQuant = true;
                }
            }
            if (_peak.getDoubleProp() != null && !_peak.getDoubleProp().isEmpty()) {
                sKeysToRemove = new ArrayList();
                for (String sKey : _peak.getDoubleProp().keySet()) {
                    if (!quantFileProcessor.matchesExternalQuantKey(sKey)) continue;
                    sKeysToRemove.add(sKey);
                }
                for (String sKey : sKeysToRemove) {
                    _peak.getDoubleProp().remove(sKey);
                    bRemoveQuant = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addPeaksData: error adding peaks data to table model.", (Throwable)e);
        }
        return bRemoveQuant;
    }

    protected boolean removeExternalQuantPeaksData(Peak _peak) {
        boolean bRemoveQuant;
        block5: {
            bRemoveQuant = false;
            if (this.fillType == FillTypes.PeaksWithFeatures) break block5;
            return false;
        }
        try {
            if (this.quantFileProcessorsToRemove != null) {
                for (QuantFileProcessor quantFileProcessor : this.quantFileProcessorsToRemove) {
                    bRemoveQuant |= this.removeExternalQuantPeaksData(_peak, quantFileProcessor);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addPeaksData: error adding peaks data to table model.", (Throwable)e);
        }
        return bRemoveQuant;
    }

    protected boolean addPeaksData(Integer _parentScanNum, Scan _scan, Peak _peak, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        boolean bAddQuant = false;
        boolean bHasSubScans = !this.getMassSpecEntityProperty().getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType().equals("MS Profile");
        boolean bHasScanNum = this.getMassSpecEntityProperty().getMsLevel() == 1 || bHasSubScans;
        try {
            if (this.fillType == FillTypes.PeakList) {
                MassSpecTableDataProcessorUtil.fillMassSpecPeakListData(_scan, _peak, alRow.getDataRow(), _settings);
            } else if (this.fillType == FillTypes.PeaksWithFeatures) {
                MassSpecTableDataProcessorUtil.fillMassSpecPeakWithFeaturesData(_parentScanNum, _scan, _peak, alRow.getDataRow(), _settings, !bHasScanNum);
                if (_scan != null && _scan.getPrecursor() != null) {
                    MassSpecTableDataProcessorUtil.fillMassSpecScanDataCorrectedPeakScanData(_scan.getPrecursor(), alRow.getDataRow(), _settings, this.getMassSpecEntityProperty());
                }
                if (this.quantFileProcessors != null && _scan != null && _scan.getPrecursor() != null) {
                    Peak extPeak;
                    for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                        if (!quantFileProcessor.getSettings().getQuantifyPrecursor().booleanValue() || (extPeak = this.getPrecursorPeak(_scan.getPrecursor().getMz(), quantFileProcessor.getSettings().getTargetScanNumber())) == null) continue;
                        if (!(quantFileProcessor instanceof CustomAnnotationDataProcessor)) {
                            MassSpecTableDataProcessorUtil.fillMassSpecScanDataCorrectedPeakScanData(extPeak, alRow.getDataRow(), _settings, this.getMassSpecEntityProperty(), quantFileProcessor);
                        }
                        if (quantFileProcessor instanceof ExtractDataProcessor) {
                            MassSpecTableDataProcessorUtil.fillMassSpecPeakWithFeaturesDataExternalQuantWCharge(_scan, extPeak, alRow.getDataRow(), _settings, QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "extract"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Extract"));
                            continue;
                        }
                        if (quantFileProcessor instanceof FullMzXMLDataProcessor) {
                            MassSpecTableDataProcessorUtil.fillMassSpecPeakWithFeaturesDataExternalQuant(_scan, extPeak, alRow.getDataRow(), _settings, QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "full_ms"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Full MS"));
                            continue;
                        }
                        if (quantFileProcessor instanceof StandardQuantDataProcessor) {
                            MassSpecTableDataProcessorUtil.fillMassSpecScanDataStandardQuant(_scan, extPeak, alRow.getDataRow(), _settings, (StandardQuantDataProcessor)quantFileProcessor);
                            continue;
                        }
                        if (quantFileProcessor instanceof CustomAnnotationDataProcessor) {
                            CustomAnnotationDataProcessor cfr_ignored_0 = (CustomAnnotationDataProcessor)quantFileProcessor;
                            this.addSubScanPeaksData(_scan, extPeak, _settings, alRow);
                            continue;
                        }
                        throw new Exception("Unrecognized ExternalQuantFileProcessor: " + quantFileProcessor);
                    }
                    for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                        extPeak = this.getPrecursorPeak(_scan.getPrecursor().getMz(), quantFileProcessor.getSettings().getTargetScanNumber());
                        if (extPeak == null) continue;
                        if (quantFileProcessor instanceof StandardQuantDataProcessor) {
                            MassSpecTableDataProcessorUtil.fillMassSpecScanDataStandardQuantPeakScanData(extPeak, alRow.getDataRow(), _settings, this.getMassSpecEntityProperty(), (StandardQuantDataProcessor)quantFileProcessor);
                        }
                        if (_peak.getIntegerProp() != null && _peak.getIntegerProp().size() == extPeak.getIntegerProp().size() && _peak.getDoubleProp() != null && _peak.getDoubleProp().size() == extPeak.getDoubleProp().size()) continue;
                        for (String sKey : extPeak.getIntegerProp().keySet()) {
                            Integer iVal = (Integer)extPeak.getIntegerProp().get(sKey);
                            if (_peak.getIntegerProp().containsKey(sKey) && _peak.getIntegerProp().get(sKey) == iVal) continue;
                            _peak.getIntegerProp().put(sKey, iVal);
                            bAddQuant = true;
                        }
                        for (String sKey : extPeak.getDoubleProp().keySet()) {
                            Double dVal = (Double)extPeak.getDoubleProp().get(sKey);
                            if (_peak.getDoubleProp().containsKey(sKey) && _peak.getDoubleProp().get(sKey) == dVal) continue;
                            _peak.getDoubleProp().put(sKey, dVal);
                            bAddQuant = true;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addPeaksData: error adding peaks data to table model.", (Throwable)e);
        }
        return bAddQuant;
    }

    protected boolean addSubScanPeaksData(Scan _scan, Peak _peak, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        boolean bAddQuant = false;
        try {
            MassSpecEntityProperty eProp = this.getMassSpecEntityProperty();
            MassSpecProperty prop = eProp.getMassSpecParentProperty();
            if (prop.getMassSpecMetaData().getCustomAnnotations() != null && _scan != null) {
                for (MassSpecCustomAnnotation annotation : prop.getMassSpecMetaData().getCustomAnnotations()) {
                    int i = 0;
                    while (i < _scan.getPeaklist().size()) {
                        Peak subpeak = (Peak)_scan.getPeaklist().get(i);
                        bAddQuant |= MassSpecTableDataProcessorUtil.fillMassSpecScanDataCustomAnnotation(_peak, subpeak, alRow.getDataRow(), _settings, annotation.getAnnotatedPeaks());
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addSubScanPeaksData: error adding peaks data to table model.", (Throwable)e);
        }
        return bAddQuant;
    }

    protected Peak getPrecursorPeak(double _dMz, int _iScanNo) {
        Peak precursor = null;
        double minDelta = Double.MAX_VALUE;
        for (Peak extractPeak : this.getScanData().get(_iScanNo).getPeaklist()) {
            double delta = Math.abs(_dMz - extractPeak.getMz());
            if (!(delta < minDelta)) continue;
            precursor = extractPeak;
            minDelta = delta;
        }
        return precursor;
    }

    protected void addScanData(Scan _scan, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        try {
            MassSpecTableDataProcessorUtil.fillMassSpecScanData(_scan, alRow.getDataRow(), _settings);
            MassSpecTableDataProcessorUtil.fillMassSpecScanDataCorrectedPeakScanData(_scan.getPrecursor(), alRow.getDataRow(), _settings, this.getMassSpecEntityProperty());
            if (this.quantFileProcessors != null && _scan != null && _scan.getPrecursor() != null) {
                Peak extPeak;
                for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                    extPeak = this.getPrecursorPeak(_scan.getPrecursor().getMz(), quantFileProcessor.getSettings().getTargetScanNumber());
                    if (!(quantFileProcessor instanceof CustomAnnotationDataProcessor)) {
                        MassSpecTableDataProcessorUtil.fillMassSpecScanDataCorrectedPeakScanData(extPeak, alRow.getDataRow(), _settings, this.getMassSpecEntityProperty(), quantFileProcessor);
                    }
                    if (quantFileProcessor instanceof ExtractDataProcessor) {
                        MassSpecTableDataProcessorUtil.fillMassSpecScanDataExternalQuantWCharge(_scan, alRow.getDataRow(), _settings, extPeak, QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "extract"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Extract"));
                        continue;
                    }
                    if (quantFileProcessor instanceof FullMzXMLDataProcessor) {
                        MassSpecTableDataProcessorUtil.fillMassSpecScanDataExternalQuant(_scan, alRow.getDataRow(), _settings, extPeak, QuantFileProcessor.getExternalQuantProcessorKey(quantFileProcessor.getKeyID(), "full_ms"), QuantFileProcessor.getExternalQuantProcessorLabel(quantFileProcessor.getLabelAlias(), "Full MS"));
                        continue;
                    }
                    if (quantFileProcessor instanceof StandardQuantDataProcessor) {
                        MassSpecTableDataProcessorUtil.fillMassSpecScanDataStandardQuant(_scan, extPeak, alRow.getDataRow(), _settings, (StandardQuantDataProcessor)quantFileProcessor);
                        continue;
                    }
                    if (quantFileProcessor instanceof CustomAnnotationDataProcessor) {
                        CustomAnnotationDataProcessor cfr_ignored_0 = (CustomAnnotationDataProcessor)quantFileProcessor;
                        this.addSubScanPeaksData(_scan, extPeak, _settings, alRow);
                        continue;
                    }
                    throw new Exception("Unrecognized ExternalQuantFileProcessor: " + quantFileProcessor);
                }
                for (QuantFileProcessor quantFileProcessor : this.quantFileProcessors) {
                    if (!(quantFileProcessor instanceof StandardQuantDataProcessor)) continue;
                    extPeak = this.getPrecursorPeak(_scan.getPrecursor().getMz(), quantFileProcessor.getSettings().getTargetScanNumber());
                    MassSpecTableDataProcessorUtil.fillMassSpecScanDataStandardQuantPeakScanData(extPeak, alRow.getDataRow(), _settings, this.getMassSpecEntityProperty(), (StandardQuantDataProcessor)quantFileProcessor);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"addScanData: error adding scans data to table model.", (Throwable)e);
        }
    }

    protected GRITSListDataRow getNewRow() {
        return TableDataProcessor.getNewRow((int)((ArrayList)this.getSimianTableDataObject().getTableHeader().get(this.getSimianTableDataObject().getTableHeader().size() - 1)).size(), (int)this.getSimianTableDataObject().getTableData().size());
    }
}

