/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import javax.inject.Inject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerData;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;

public class MassSpecSpectraControlPanelView {
    protected MassSpecSpectraView parentView = null;
    protected Button cbShowSpectra = null;
    protected Composite parent;
    protected Button cbAnnotatedPeaks = null;
    protected Button cbAnnotatedPeakLabels = null;
    protected Button cbPickedPeaks = null;
    protected Button cbPickedPeakLabels = null;

    @Inject
    public MassSpecSpectraControlPanelView(MassSpecSpectraView parentView) {
        this.parentView = parentView;
    }

    public boolean showRaw() {
        return this.cbShowSpectra.getSelection();
    }

    public Button getShowSpectra() {
        return this.cbShowSpectra;
    }

    protected void updateChart() {
        this.parentView.updateChartPlot();
    }

    public MassSpecSpectraView getParentView() {
        return this.parentView;
    }

    public void enableComponents(GRITSSpectralViewerData svd) {
        this.cbShowSpectra.setEnabled(svd.getRawData() != null && !svd.getRawData().isEmpty());
        boolean bHasPicked = svd.getPickedPeaks() != null && !svd.getPickedPeaks().isEmpty();
        this.cbPickedPeaks.setEnabled(bHasPicked);
        boolean bHasAnnotated = svd.getAnnotatedPeaks() != null && !svd.getAnnotatedPeaks().isEmpty();
        this.cbAnnotatedPeaks.setEnabled(bHasAnnotated);
    }

    public boolean showPickedPeaks() {
        return this.cbPickedPeaks.getSelection();
    }

    public Button getPickedPeaks() {
        return this.cbPickedPeaks;
    }

    public boolean showPickedPeakLabels() {
        return this.cbPickedPeakLabels.getSelection();
    }

    public Button getPickedPeakLabels() {
        return this.cbPickedPeakLabels;
    }

    public boolean showAnnotatedPeakLabels() {
        return this.cbAnnotatedPeakLabels.getSelection();
    }

    public Button getAnnotatedPeakLabels() {
        return this.cbAnnotatedPeakLabels;
    }

    public boolean showAnnotatedPeaks() {
        return this.cbAnnotatedPeaks.getSelection();
    }

    public Button getAnnotatedPeaks() {
        return this.cbAnnotatedPeaks;
    }

    protected GridLayout getNewGridLayout() {
        return new GridLayout(3, false);
    }

    protected void setMSElements() {
        this.cbShowSpectra = new Button(this.parent, 32);
        this.cbShowSpectra.setText("Raw Spectra");
        GridData gdRawSpectra = new GridData(1, 1, false, false, 3, 1);
        this.cbShowSpectra.setLayoutData((Object)gdRawSpectra);
        this.cbShowSpectra.setSelection(true);
        this.cbShowSpectra.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecSpectraControlPanelView.this.updateChart();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setPickedPeaksElements() {
        this.cbPickedPeaks = new Button(this.parent, 32);
        this.cbPickedPeaks.setText("Picked Peaks");
        GridData gdPickedPeaks = new GridData(1, 1, false, false, 1, 1);
        this.cbPickedPeaks.setLayoutData((Object)gdPickedPeaks);
        this.cbPickedPeaks.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MassSpecSpectraControlPanelView.this.cbPickedPeaks.getSelection()) {
                    MassSpecSpectraControlPanelView.this.cbPickedPeakLabels.setSelection(false);
                }
                MassSpecSpectraControlPanelView.this.cbPickedPeakLabels.setEnabled(MassSpecSpectraControlPanelView.this.cbPickedPeaks.getSelection());
                MassSpecSpectraControlPanelView.this.updateChart();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cbPickedPeakLabels = new Button(this.parent, 32);
        this.cbPickedPeakLabels.setText("Show labels");
        GridData gdPickedPeakLabels = new GridData(1, 1, false, false, 2, 1);
        this.cbPickedPeakLabels.setLayoutData((Object)gdPickedPeakLabels);
        this.cbPickedPeakLabels.setEnabled(false);
        this.cbPickedPeakLabels.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecSpectraControlPanelView.this.updateChart();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setAnnotatedElements() {
        this.cbAnnotatedPeaks = new Button(this.parent, 32);
        this.cbAnnotatedPeaks.setText("Annotated Peaks");
        GridData gdAnnotatedPeaks = new GridData(1, 1, false, false, 1, 1);
        this.cbAnnotatedPeaks.setLayoutData((Object)gdAnnotatedPeaks);
        this.cbAnnotatedPeaks.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MassSpecSpectraControlPanelView.this.cbAnnotatedPeaks.getSelection()) {
                    MassSpecSpectraControlPanelView.this.cbAnnotatedPeakLabels.setSelection(false);
                }
                MassSpecSpectraControlPanelView.this.cbAnnotatedPeakLabels.setEnabled(MassSpecSpectraControlPanelView.this.cbAnnotatedPeaks.getSelection());
                MassSpecSpectraControlPanelView.this.updateChart();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cbAnnotatedPeakLabels = new Button(this.parent, 32);
        this.cbAnnotatedPeakLabels.setText("Show labels");
        GridData gdAnnotatedPeakLabels = new GridData(1, 1, false, false, 2, 1);
        this.cbAnnotatedPeakLabels.setLayoutData((Object)gdAnnotatedPeakLabels);
        this.cbAnnotatedPeakLabels.setEnabled(false);
        this.cbAnnotatedPeakLabels.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecSpectraControlPanelView.this.updateChart();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void addElements() {
        this.setMSElements();
        this.setPickedPeaksElements();
        this.setAnnotatedElements();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout layout = this.getNewGridLayout();
        layout.horizontalSpacing = 25;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        parent.setLayout((Layout)layout);
        this.addElements();
    }
}

