/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages.BatchOfAnalytesPageOne;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages.BatchOfAnalytesTablePageTwo;

public class AnalyteListEditingSupport
extends EditingSupport {
    private BatchOfAnalytesTablePageTwo pageTwo;
    private TableViewer tableViewer = null;
    private int columnNumber = 0;
    TextCellEditor textEditor = null;

    public AnalyteListEditingSupport(BatchOfAnalytesTablePageTwo pageTwo, int columnNumber) {
        super((ColumnViewer)pageTwo.getTableViewer());
        this.pageTwo = pageTwo;
        this.tableViewer = pageTwo.getTableViewer();
        this.columnNumber = columnNumber;
    }

    protected void setValue(Object element, Object value) {
        switch (this.columnNumber) {
            case 0: {
                if (!(element instanceof Sample) || !(value instanceof String)) break;
                String name = (String)value;
                if (((BatchOfAnalytesPageOne)this.pageTwo.getPreviousPage()).findSameNameEntry(name, true)) {
                    this.pageTwo.setErrorMessage("This name \"" + name + "\" is already used for an Analyte. " + "Please use a different name.");
                    this.pageTwo.setPageComplete(false);
                    break;
                }
                if (name.length() > 80 || name.length() <= 0) {
                    this.pageTwo.setErrorMessage("The name cannot be left empty or longer than 80 characters");
                    this.pageTwo.setPageComplete(false);
                    break;
                }
                if (this.pageTwo.findSameNameEntry(name, (Sample)element)) {
                    this.pageTwo.setErrorMessage("This name \"" + name + "\" is already used for an Analyte. " + "Please use a different name.");
                    this.pageTwo.setPageComplete(false);
                    break;
                }
                ((Sample)element).setName(name);
                this.pageTwo.setErrorMessage(null);
                this.pageTwo.setPageComplete(true);
                break;
            }
            case 1: {
                if (!(element instanceof Sample) || !(value instanceof String)) break;
                ((Sample)element).setDescription((String)value);
            }
        }
        this.tableViewer.refresh();
    }

    protected Object getValue(Object element) {
        String value = null;
        switch (this.columnNumber) {
            case 0: {
                if (!(element instanceof Sample)) break;
                value = ((Sample)element).getName();
                break;
            }
            case 1: {
                if (!(element instanceof Sample)) break;
                value = ((Sample)element).getDescription();
            }
        }
        return value;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof Sample) {
            if (this.textEditor == null) {
                this.textEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
            }
            return this.textEditor;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof Sample;
    }
}

