/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.preference.SamplePreferenceStore;
import org.grits.toolbox.entry.sample.utilities.UtilityFile;

@Singleton
public class AnalyteFactory {
    private static final Logger logger = Logger.getLogger(AnalyteFactory.class);
    @Inject
    private static ISampleOntologyApi ontologyApi = null;

    public static String createSampleFileForOldSample(String projectName, String sampleName, String description) throws IOException {
        logger.info((Object)("Creating sample file from old description. Sample : " + sampleName + " with description " + description));
        File sampleFolder = UtilityFile.getSampleGroupDirectory(projectName);
        String newSampleFileName = UtilityFile.generateFileName(sampleFolder.list());
        AnalyteFactory.createFileContent(sampleFolder, newSampleFileName, sampleName, description);
        logger.info((Object)("The sample file created for old sample : " + newSampleFileName));
        return newSampleFileName;
    }

    private static void createFileContent(File sampleGroupFolder, String newSampleFileName, String sampleName, String description) throws IOException {
        try {
            logger.info((Object)("Creating file content for sample " + sampleName + " in sample file " + newSampleFileName));
            Sample sample = new Sample();
            sample.setName(sampleName);
            sample.setDescription(description);
            AnalyteFactory.addDefaultTemplateComponents(sample);
            logger.info((Object)"Serializing the sample object to xml");
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sample.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.marshal((Object)sample, (OutputStream)os);
                logger.info((Object)"write the serialized data in the file");
                FileWriter fileWriter = new FileWriter(String.valueOf(sampleGroupFolder.getAbsolutePath()) + File.separator + newSampleFileName);
                fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                fileWriter.close();
                os.close();
                logger.info((Object)("Sample file " + newSampleFileName + " created"));
            }
            catch (IOException | JAXBException e) {
                logger.error((Object)("Error creating new file.\n" + e.getMessage()), e);
                throw new IOException("Error creating new file");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error creating components for new file.\n" + e.getMessage()), (Throwable)e);
            throw new IOException("Error creating components for new file");
        }
    }

    public static void addDefaultTemplateComponents(Sample sample) {
        Template selectedTemplate = SamplePreferenceStore.getDefaultTemplateUri() == null ? null : ontologyApi.getTemplate(SamplePreferenceStore.getDefaultTemplateUri());
        String sampleName = sample.getName();
        Component comp = null;
        String label = null;
        int i = 1;
        while (i <= SamplePreferenceStore.getDefaultNumberOfComponents()) {
            comp = selectedTemplate == null ? new Component() : AnalyteFactory.createComponentFromTemplate(selectedTemplate);
            label = SamplePreferenceStore.getDefaultNumberOfComponents() == 1 ? sampleName : String.valueOf(sampleName) + " component " + i;
            comp.setLabel(label);
            comp.setComponentId(sample.getNextAvailableComponentId());
            sample.addComponent(comp);
            ++i;
        }
    }

    public static Component createComponentFromTemplate(Template template) {
        Component component = null;
        if (template != null) {
            component = new Component();
            component.setTemplateUri(template.getUri());
            String description = "Initially created from Template : " + template.getLabel();
            description = String.valueOf(description) + " (" + template.getUri() + ")";
            component.setDescription(description);
            Category sampleInfo = new Category();
            sampleInfo.setUri("http://www.grits-toolbox.org/ontology/sample#category_sample");
            sampleInfo.setDescriptors(AnalyteFactory.getDescriptorsFromCategoryTemplate(template.getSampleInformationTemplate()));
            sampleInfo.setDescriptorGroups(AnalyteFactory.getDescriptorGroupsFromCategoryTemplate(template.getSampleInformationTemplate()));
            component.setSampleInformation(sampleInfo);
            Category tracking = new Category();
            tracking.setUri("http://www.grits-toolbox.org/ontology/sample#category_sample_tracking");
            tracking.setDescriptors(AnalyteFactory.getDescriptorsFromCategoryTemplate(template.getTrackingTemplate()));
            tracking.setDescriptorGroups(AnalyteFactory.getDescriptorGroupsFromCategoryTemplate(template.getTrackingTemplate()));
            component.setTracking(tracking);
            Category amount = new Category();
            amount.setUri("http://www.grits-toolbox.org/ontology/sample#category_amount");
            amount.setDescriptors(AnalyteFactory.getDescriptorsFromCategoryTemplate(template.getAmountTemplate()));
            amount.setDescriptorGroups(AnalyteFactory.getDescriptorGroupsFromCategoryTemplate(template.getAmountTemplate()));
            component.setAmount(amount);
            Category purityQC = new Category();
            purityQC.setUri("http://www.grits-toolbox.org/ontology/sample#category_qc");
            purityQC.setDescriptors(AnalyteFactory.getDescriptorsFromCategoryTemplate(template.getPurityQCTemplate()));
            purityQC.setDescriptorGroups(AnalyteFactory.getDescriptorGroupsFromCategoryTemplate(template.getPurityQCTemplate()));
            component.setPurityQC(purityQC);
        }
        return component;
    }

    private static List<DescriptorGroup> getDescriptorGroupsFromCategoryTemplate(CategoryTemplate categoryTemplate) {
        ArrayList<DescriptorGroup> descriptorGroups = new ArrayList<DescriptorGroup>();
        for (DescriptorGroup descriptorGroup : categoryTemplate.getMandatoryDescriptorGroups()) {
            descriptorGroups.add(descriptorGroup.getACopy());
        }
        for (DescriptorGroup descriptorGroup : categoryTemplate.getOptionalDescriptorGroups()) {
            descriptorGroups.add(descriptorGroup.getACopy());
        }
        return descriptorGroups;
    }

    private static List<Descriptor> getDescriptorsFromCategoryTemplate(CategoryTemplate categoryTemplate) {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (Descriptor descriptor : categoryTemplate.getMandatoryDescriptors()) {
            descriptors.add(descriptor.getACopy());
        }
        for (Descriptor descriptor : categoryTemplate.getOptionalDescriptors()) {
            descriptors.add(descriptor.getACopy());
        }
        return descriptors;
    }
}

