/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.ontologymanager;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.rdf.model.EmptyListException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.model.Template;

public class SampleOntologyManager {
    private Logger logger = Logger.getLogger(SampleOntologyManager.class);
    public static final String baseURI = "http://www.grits-toolbox.org/ontology/sample#";
    public static final String CATEGORY_SAMPLE_INFO_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_sample";
    public static final String CATEGORY_TRACKING_INFO_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking";
    public static final String CATEGORY_AMOUNT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_amount";
    public static final String CATEGORY_PURITY_QC_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_qc";
    public static final String DESCRIPTOR_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#descriptor";
    public static final String DESCRIPTOR_GROUP_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#descriptor_group";
    public static final String TEMPLATE_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#template";
    public static final String UNIT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#unit";
    public static final String CATEGORY_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category";
    public static final String TEMPLATE_CONTEXT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#template_context";
    public static final String MEASUREMENT_UNIT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#unit";
    public static final String NAMESPACE_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#namespace";
    public static final String GUIDELINE_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#StandardGuideline";
    protected OntModel standardOntModel = null;

    protected SampleOntologyManager(OntModel standardOntModel) {
        this.standardOntModel = standardOntModel;
    }

    protected OntModel getStandardOntModel() {
        return this.standardOntModel;
    }

    protected List<Individual> getIndividualsForClass(OntModel ontModel, String classUri) {
        if (ontModel == null || classUri == null || classUri.isEmpty()) {
            return null;
        }
        OntClass ontClass = ontModel.getOntClass(classUri);
        if (ontClass == null) {
            return null;
        }
        return ontModel.listIndividuals((Resource)ontClass).toList();
    }

    protected Descriptor getDescriptor(RDFNode descriptorNode) throws ResourceRequiredException, NotFoundException, DatatypeFormatException {
        if (descriptorNode == null) {
            return null;
        }
        if (!descriptorNode.isResource()) {
            throw new ResourceRequiredException(descriptorNode);
        }
        String resourceUri = descriptorNode.asResource().getURI();
        OntModel nodeModel = (OntModel)descriptorNode.getModel();
        Individual descriptorIndiv = null;
        if (nodeModel.isInBaseModel((Statement)new StatementImpl(descriptorNode.asResource(), RDF.type, (RDFNode)nodeModel.getOntClass(DESCRIPTOR_CLASS_URI)))) {
            descriptorIndiv = nodeModel.getIndividual(resourceUri);
        } else if (nodeModel != this.standardOntModel) {
            descriptorIndiv = this.standardOntModel.getIndividual(resourceUri);
        }
        if (descriptorIndiv == null) {
            throw new NotFoundException(resourceUri);
        }
        if (!DESCRIPTOR_CLASS_URI.equals(descriptorIndiv.getOntClass().getURI())) {
            throw new DatatypeFormatException("\"" + resourceUri + "\" is not a descriptor but is \"" + descriptorIndiv.getOntClass().getURI() + "\"");
        }
        return this.getDescriptor(descriptorIndiv);
    }

    protected DescriptorGroup getDescriptorGroup(RDFNode descriptorGroupNode) throws ResourceRequiredException, NotFoundException, DatatypeFormatException {
        if (descriptorGroupNode == null) {
            return null;
        }
        if (!descriptorGroupNode.isResource()) {
            throw new ResourceRequiredException(descriptorGroupNode);
        }
        String resourceUri = descriptorGroupNode.asResource().getURI();
        OntModel nodeModel = (OntModel)descriptorGroupNode.getModel();
        Individual descriptorGroupIndiv = null;
        if (nodeModel.isInBaseModel((Statement)new StatementImpl(descriptorGroupNode.asResource(), RDF.type, (RDFNode)nodeModel.getOntClass(DESCRIPTOR_GROUP_CLASS_URI)))) {
            descriptorGroupIndiv = nodeModel.getIndividual(resourceUri);
        } else if (nodeModel != this.standardOntModel) {
            descriptorGroupIndiv = this.standardOntModel.getIndividual(resourceUri);
        }
        if (descriptorGroupIndiv == null) {
            throw new NotFoundException(resourceUri);
        }
        if (!DESCRIPTOR_GROUP_CLASS_URI.equals(descriptorGroupIndiv.getOntClass().getURI())) {
            throw new DatatypeFormatException("\"" + resourceUri + "\" is not a descriptor group but is \"" + descriptorGroupIndiv.getOntClass().getURI() + "\"");
        }
        return this.getDescriptorGroup(descriptorGroupIndiv);
    }

    private Resource getRDFType(RDFNode rdfNode) throws NotFoundException {
        this.logger.info((Object)("get class for this rdf node : " + rdfNode));
        if (rdfNode == null) {
            return null;
        }
        if (!rdfNode.isResource()) {
            throw new ResourceRequiredException(rdfNode);
        }
        OntResource ontResource = (OntResource)rdfNode.asResource();
        Resource rdfType = ontResource.getRDFType();
        if (rdfType == null || rdfType.getURI() == null) {
            this.logger.error((Object)"resource type not found in its current ontology");
            OntResource standardOntResource = this.standardOntModel.getOntResource(ontResource.getURI());
            if (standardOntResource == null) {
                throw new NotFoundException(ontResource.getURI());
            }
            rdfType = standardOntResource.getRDFType();
            if (rdfType == null || rdfType.getURI() == null) {
                this.logger.fatal((Object)"resource type not found in its standard ontology either");
                throw new NotFoundException(ontResource.getURI());
            }
            this.logger.info((Object)("class type  is : " + rdfType.getURI()));
            return standardOntResource.getRDFType();
        }
        this.logger.info((Object)("class type is : " + rdfType.getURI()));
        return rdfType;
    }

    protected MeasurementUnit getMeasurementUnit(RDFNode rdfNode) throws ResourceRequiredException, NotFoundException, DatatypeFormatException {
        if (rdfNode == null) {
            return null;
        }
        if (!rdfNode.isResource()) {
            throw new ResourceRequiredException(rdfNode);
        }
        String resourceUri = rdfNode.asResource().getURI();
        OntModel nodeModel = (OntModel)rdfNode.getModel();
        Individual unitIndiv = null;
        if (nodeModel.isInBaseModel((Statement)new StatementImpl(rdfNode.asResource(), RDF.type, (RDFNode)nodeModel.getOntClass("http://www.grits-toolbox.org/ontology/sample#unit")))) {
            unitIndiv = nodeModel.getIndividual(resourceUri);
        } else if (nodeModel != this.standardOntModel) {
            unitIndiv = this.standardOntModel.getIndividual(resourceUri);
        }
        if (unitIndiv == null) {
            throw new NotFoundException(resourceUri);
        }
        if (!"http://www.grits-toolbox.org/ontology/sample#unit".equals(unitIndiv.getOntClass().getURI())) {
            throw new DatatypeFormatException("\"" + resourceUri + "\" is not a measurement unit but is \"" + unitIndiv.getOntClass().getURI() + "\"");
        }
        return new MeasurementUnit(unitIndiv.getURI(), unitIndiv.getLabel(null));
    }

    protected Namespace getNamespace(RDFNode rdfNode) throws NotFoundException, DatatypeFormatException {
        if (rdfNode == null) {
            return null;
        }
        String resourceUri = rdfNode.asResource().getURI();
        this.logger.info((Object)(String.valueOf(resourceUri) + " resource could have multiple rdf types"));
        OntResource namespaceResource = this.standardOntModel.getOntResource(resourceUri);
        if (namespaceResource == null) {
            throw new NotFoundException(resourceUri);
        }
        if (!namespaceResource.hasRDFType(NAMESPACE_CLASS_URI)) {
            throw new DatatypeFormatException("\"" + resourceUri + "\" is not a namespace but of type : " + namespaceResource.getRDFType().getURI());
        }
        String fileName = null;
        String idFileName = null;
        Property property = this.standardOntModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_file");
        RDFNode node = namespaceResource.getPropertyValue(property);
        if (node != null && node.isLiteral()) {
            fileName = node.asLiteral().getString();
            property = this.standardOntModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_id_file");
            node = namespaceResource.getPropertyValue(property);
            if (node != null && node.isLiteral()) {
                idFileName = node.asLiteral().getString();
            }
        }
        return new Namespace(namespaceResource.getURI(), namespaceResource.getLabel(null), fileName, idFileName);
    }

    protected DescriptorGroup getDescriptorGroup(Individual descriptorGroupIndiv) throws NotFoundException {
        this.logger.info((Object)"loading descriptor group");
        if (descriptorGroupIndiv == null) {
            return null;
        }
        String descriptorGroupUri = descriptorGroupIndiv.getURI();
        this.logger.info((Object)("uri : " + descriptorGroupUri));
        if (DESCRIPTOR_GROUP_CLASS_URI.equals(descriptorGroupIndiv.getOntClass().getURI())) {
            List<RDFNode> guidelinesFromContext;
            DescriptorGroup descriptorGroup = new DescriptorGroup();
            descriptorGroup.setUri(descriptorGroupUri);
            descriptorGroup.setLabel(descriptorGroupIndiv.getLabel(null));
            descriptorGroup.setDescription(descriptorGroupIndiv.getComment(null));
            Literal maxOccurrence = this.getLiteralValue(descriptorGroupIndiv, "has_abbundance");
            if (maxOccurrence != null) {
                descriptorGroup.setMaxOccurrence(maxOccurrence.getInt());
            }
            Literal position = this.getLiteralValue(descriptorGroupIndiv, "has_position");
            int pos = 0;
            if (position != null) {
                pos = position.getInt();
                descriptorGroup.setPosition(pos);
            }
            if ((guidelinesFromContext = this.getAllObjectNodes(descriptorGroupIndiv, "guideline_info")) != null) {
                ArrayList<String> guidelines = new ArrayList<String>();
                for (RDFNode guideline : guidelinesFromContext) {
                    Individual guidelineIndiv = this.standardOntModel.getIndividual(guideline.asResource().getURI());
                    if (guidelineIndiv == null) continue;
                    guidelines.add(guidelineIndiv.getLabel(null));
                }
                descriptorGroup.setGuidelineURIs(guidelines);
            }
            for (RDFNode category : this.getAllObjectNodes(descriptorGroupIndiv, "has_category")) {
                descriptorGroup.addCategory(category.asResource().getURI());
            }
            RDFNode descriptorNode = null;
            Individual groupContextIndiv = null;
            Descriptor descriptor = null;
            Literal mandatoryLiteral = null;
            for (RDFNode groupContextNode : this.getAllObjectNodes(descriptorGroupIndiv, "has_descriptor_group_context")) {
                groupContextIndiv = descriptorGroupIndiv.getOntModel().getIndividual(groupContextNode.asResource().getURI());
                if (groupContextIndiv == null) {
                    throw new NotFoundException("no descriptor group context for " + groupContextNode.asResource().getURI());
                }
                descriptorNode = this.getObjectNode(groupContextIndiv, "has_descriptor");
                if (descriptorNode == null) {
                    throw new NotFoundException("no descriptor for " + groupContextIndiv.getURI());
                }
                descriptor = this.getDescriptor(descriptorNode);
                maxOccurrence = this.getLiteralValue(groupContextIndiv, "has_abbundance");
                if (maxOccurrence != null) {
                    descriptor.setMaxOccurrence(maxOccurrence.getInt());
                } else {
                    descriptor.setMaxOccurrence(null);
                }
                mandatoryLiteral = this.getLiteralValue(groupContextIndiv, "is_mandatory");
                if (mandatoryLiteral.getBoolean()) {
                    descriptorGroup.addMandatoryDescriptor(descriptor);
                    continue;
                }
                descriptorGroup.addOptionalDescriptor(descriptor);
            }
            return descriptorGroup;
        }
        String errorMessage = "The given descriptor group uri \"" + descriptorGroupUri + "\" is not of type Descriptor Group but is of type \"" + descriptorGroupIndiv.getOntClass().getURI() + "\"";
        this.logger.error((Object)errorMessage);
        throw new DatatypeFormatException(errorMessage);
    }

    protected Descriptor getDescriptor(Individual descriptorIndiv) throws DatatypeFormatException {
        this.logger.info((Object)"loading descriptor");
        if (descriptorIndiv == null) {
            return null;
        }
        String descriptorUri = descriptorIndiv.getURI();
        this.logger.info((Object)("uri : " + descriptorUri));
        if (DESCRIPTOR_CLASS_URI.equals(descriptorIndiv.getOntClass().getURI())) {
            List<RDFNode> guidelinesFromContext;
            Descriptor descriptor = new Descriptor();
            descriptor.setUri(descriptorUri);
            descriptor.setLabel(descriptorIndiv.getLabel(null));
            descriptor.setDescription(descriptorIndiv.getComment(null));
            Literal maxOccurrence = this.getLiteralValue(descriptorIndiv, "has_abbundance");
            if (maxOccurrence != null) {
                descriptor.setMaxOccurrence(maxOccurrence.getInt());
            }
            Literal position = this.getLiteralValue(descriptorIndiv, "has_position");
            int pos = 0;
            if (position != null) {
                pos = position.getInt();
                descriptor.setPosition(pos);
            }
            if ((guidelinesFromContext = this.getAllObjectNodes(descriptorIndiv, "guideline_info")) != null) {
                ArrayList<String> guidelines = new ArrayList<String>();
                for (RDFNode guideline : guidelinesFromContext) {
                    Individual guidelineIndiv = this.standardOntModel.getIndividual(guideline.asResource().getURI());
                    if (guidelineIndiv == null) continue;
                    guidelines.add(guidelineIndiv.getLabel(null));
                }
                descriptor.setGuidelineURIs(guidelines);
            }
            for (RDFNode namespaceNode : this.getAllObjectNodes(descriptorIndiv, "has_namespace")) {
                descriptor.addNamespace(this.getNamespace(namespaceNode));
            }
            RDFNode defaultUnitNode = this.getObjectNode(descriptorIndiv, "has_default_unit_of_measurement");
            if (defaultUnitNode != null) {
                descriptor.setDefaultMeasurementUnit(this.getMeasurementUnit(defaultUnitNode).getUri());
            }
            for (RDFNode unit : this.getAllObjectNodes(descriptorIndiv, "has_unit_of_measurement")) {
                descriptor.addValidUnit(this.getMeasurementUnit(unit));
            }
            for (RDFNode category : this.getAllObjectNodes(descriptorIndiv, "has_category")) {
                descriptor.addCategory(category.asResource().getURI());
            }
            return descriptor;
        }
        String errorMessage = "The given descriptor uri \"" + descriptorUri + "\" is not of type Descriptor but is of type \"" + descriptorIndiv.getOntClass().getURI() + "\"";
        this.logger.error((Object)errorMessage);
        throw new DatatypeFormatException(errorMessage);
    }

    protected Template getTemplate(Individual templateIndiv) throws DatatypeFormatException, EmptyListException, NotFoundException {
        this.logger.info((Object)"loading template");
        if (templateIndiv == null) {
            return null;
        }
        String templateUri = templateIndiv.getURI();
        this.logger.info((Object)("uri : " + templateUri));
        if (!TEMPLATE_CLASS_URI.equals(templateIndiv.getOntClass().getURI())) {
            String errorMessage = "The given template uri \"" + templateUri + "\" is not a Template but is of type \"" + templateIndiv.getOntClass().getURI() + "\"";
            this.logger.error((Object)errorMessage);
            throw new DatatypeFormatException(errorMessage);
        }
        Template template = new Template();
        template.setUri(templateUri);
        template.setLabel(templateIndiv.getLabel(null));
        template.setDescription(templateIndiv.getComment(null));
        block8: for (RDFNode templateContextNode : this.getAllObjectNodes(templateIndiv, "has_template_context")) {
            Individual templateContextIndiv = templateIndiv.getOntModel().getIndividual(templateContextNode.asResource().getURI());
            List<RDFNode> categoryNodes = this.getAllObjectNodes(templateContextIndiv, "has_category");
            if (categoryNodes.isEmpty()) {
                throw new EmptyListException("no category found for template context " + templateContextIndiv.getURI());
            }
            ArrayList<String> categoryUris = new ArrayList<String>();
            for (RDFNode category : categoryNodes) {
                categoryUris.add(category.asResource().getURI());
            }
            RDFNode descriptorNode = this.getObjectNode(templateContextIndiv, "has_template_descriptor");
            String descriptorNodeClassUri = this.getRDFType(descriptorNode).getURI();
            boolean isManadatory = this.getLiteralValue(templateContextIndiv, "is_mandatory").getBoolean();
            Literal maxOccurrenceLiteral = this.getLiteralValue(templateContextIndiv, "has_abbundance");
            Integer maxOccurrence = maxOccurrenceLiteral == null ? null : Integer.valueOf(maxOccurrenceLiteral.getInt());
            switch (descriptorNodeClassUri) {
                case "http://www.grits-toolbox.org/ontology/sample#descriptor_group": {
                    DescriptorGroup descriptorGroup = this.getDescriptorGroup(descriptorNode);
                    descriptorGroup.setMaxOccurrence(maxOccurrence);
                    descriptorGroup.setCategories(categoryUris);
                    for (String categoryUri : categoryUris) {
                        if (isManadatory) {
                            SampleOntologyManager.getCategoryTemplate(template, categoryUri).addMandatoryDescriptorGroup(descriptorGroup.getACopy());
                            continue;
                        }
                        SampleOntologyManager.getCategoryTemplate(template, categoryUri).addOptionalDescriptorGroup(descriptorGroup.getACopy());
                    }
                    continue block8;
                }
                case "http://www.grits-toolbox.org/ontology/sample#descriptor": {
                    Descriptor descriptor = this.getDescriptor(descriptorNode);
                    descriptor.setMaxOccurrence(maxOccurrence);
                    descriptor.setCategories(categoryUris);
                    for (String categoryUri : categoryUris) {
                        if (isManadatory) {
                            SampleOntologyManager.getCategoryTemplate(template, categoryUri).addMandatoryDescriptor(descriptor.getACopy());
                            continue;
                        }
                        SampleOntologyManager.getCategoryTemplate(template, categoryUri).addOptionalDescriptor(descriptor.getACopy());
                    }
                    continue block8;
                }
                default: {
                    throw new DatatypeFormatException("unknown node type for a template context : " + descriptorNodeClassUri);
                }
            }
        }
        return template;
    }

    protected List<Descriptor> getDescriptorsForCategory(Individual categoryIndiv) {
        this.logger.info((Object)"loading descriptors for category");
        if (categoryIndiv == null) {
            return null;
        }
        this.logger.info((Object)("category uri : " + categoryIndiv.getURI()));
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (Individual descriptorIndiv : this.getIndivsForCategory(categoryIndiv, DESCRIPTOR_CLASS_URI)) {
            descriptors.add(this.getDescriptor(descriptorIndiv));
        }
        return descriptors;
    }

    protected List<DescriptorGroup> getDescriptorGroupsForCategory(Individual categoryIndiv) {
        this.logger.info((Object)"loading descriptor groups for category");
        if (categoryIndiv == null) {
            return null;
        }
        this.logger.info((Object)("category uri : " + categoryIndiv.getURI()));
        ArrayList<DescriptorGroup> descriptorGroups = new ArrayList<DescriptorGroup>();
        for (Individual descriptorGroupIndiv : this.getIndivsForCategory(categoryIndiv, DESCRIPTOR_GROUP_CLASS_URI)) {
            descriptorGroups.add(this.getDescriptorGroup(descriptorGroupIndiv));
        }
        return descriptorGroups;
    }

    private List<Individual> getIndivsForCategory(final Individual categoryIndiv, String individualClass) throws OntologyException {
        final OntModel model = categoryIndiv.getOntModel();
        final Property hasCategoryProperty = model.getProperty("http://www.grits-toolbox.org/ontology/sample#has_category");
        if (hasCategoryProperty == null) {
            throw new OntologyException("Property \"http://www.grits-toolbox.org/ontology/sample#has_category\" not found in the model");
        }
        ExtendedIterator extendedDescriptorIterator = model.listIndividuals((Resource)model.getOntClass(individualClass)).filterKeep((Filter)new Filter<Individual>(){

            public boolean accept(Individual individual) {
                SampleOntologyManager.this.logger.debug((Object)("matching \"" + individual.getURI() + "\" in category \"" + categoryIndiv.getURI() + "\""));
                return model.contains((Resource)individual, hasCategoryProperty, (RDFNode)categoryIndiv);
            }
        });
        return extendedDescriptorIterator.toList();
    }

    private Literal getLiteralValue(Individual indiv, String propertyName) throws InvalidPropertyURIException {
        if (indiv == null || propertyName == null || propertyName.isEmpty()) {
            return null;
        }
        Property property = indiv.getOntModel().getProperty(baseURI + propertyName);
        if (property == null) {
            throw new InvalidPropertyURIException("Property \"" + propertyName + "\" not found in the model ");
        }
        RDFNode node = indiv.getPropertyValue(property);
        if (node != null && node.isLiteral()) {
            return node.asLiteral();
        }
        return null;
    }

    private RDFNode getObjectNode(Individual subjectIndiv, String propertyName) throws InvalidPropertyURIException {
        if (subjectIndiv == null || propertyName == null || propertyName.isEmpty()) {
            return null;
        }
        Property property = subjectIndiv.getOntModel().getProperty(baseURI + propertyName);
        if (property == null) {
            throw new InvalidPropertyURIException("Property \"" + propertyName + "\" not found in the model ");
        }
        return subjectIndiv.getPropertyValue(property);
    }

    private List<RDFNode> getAllObjectNodes(Individual subjectIndiv, String propertyName) throws InvalidPropertyURIException {
        if (subjectIndiv == null || propertyName == null || propertyName.isEmpty()) {
            return null;
        }
        Property property = subjectIndiv.getOntModel().getProperty(baseURI + propertyName);
        if (property == null) {
            throw new InvalidPropertyURIException("Property \"" + propertyName + "\" not found in the model ");
        }
        return subjectIndiv.getOntModel().listObjectsOfProperty((Resource)subjectIndiv, property).toList();
    }

    protected String createTemplate(OntModel ontModel, Template template) throws AlreadyExistsException {
        this.logger.info((Object)"creating template in the ontology");
        if (template == null) {
            return null;
        }
        this.logger.info((Object)("template name : " + template.getLabel()));
        String templateUri = template.getUri();
        if (templateUri == null) {
            templateUri = this.getUriFromUniqueLabel("template " + template.getLabel());
            if (ontModel.getOntResource(templateUri) != null) {
                this.logger.error((Object)("some template with this label already exists in this ontology : " + template.getLabel()));
                throw new AlreadyExistsException("template label : " + template.getLabel());
            }
            template.setUri(templateUri);
        } else if (ontModel.getOntResource(template.getUri()) != null) {
            this.logger.error((Object)("some resource with this uri already exists in this ontology : " + template.getUri()));
            throw new AlreadyExistsException(template.getUri());
        }
        Individual templateIndiv = ontModel.createIndividual(template.getUri(), (Resource)ontModel.getOntClass(TEMPLATE_CLASS_URI));
        templateIndiv.setLabel(template.getLabel(), null);
        if (template.getDescription() != null) {
            templateIndiv.setComment(template.getDescription(), null);
        }
        this.addTemplateMembers(templateIndiv, template.getSampleInformationTemplate());
        this.addTemplateMembers(templateIndiv, template.getTrackingTemplate());
        this.addTemplateMembers(templateIndiv, template.getAmountTemplate());
        this.addTemplateMembers(templateIndiv, template.getPurityQCTemplate());
        return templateUri;
    }

    private void addTemplateMembers(Individual templateIndiv, CategoryTemplate categoryTemplate) {
        for (Descriptor descriptor : categoryTemplate.getMandatoryDescriptors()) {
            this.addDescriptorOrGroupToCategoryTemplate(templateIndiv, categoryTemplate.getUri(), DESCRIPTOR_CLASS_URI, descriptor.getUri(), descriptor.getLabel(), descriptor.getMaxOccurrence(), true);
        }
        for (Descriptor descriptor : categoryTemplate.getOptionalDescriptors()) {
            this.addDescriptorOrGroupToCategoryTemplate(templateIndiv, categoryTemplate.getUri(), DESCRIPTOR_CLASS_URI, descriptor.getUri(), descriptor.getLabel(), descriptor.getMaxOccurrence(), false);
        }
        for (DescriptorGroup descriptorGroup : categoryTemplate.getMandatoryDescriptorGroups()) {
            this.addDescriptorOrGroupToCategoryTemplate(templateIndiv, categoryTemplate.getUri(), DESCRIPTOR_GROUP_CLASS_URI, descriptorGroup.getUri(), descriptorGroup.getLabel(), descriptorGroup.getMaxOccurrence(), true);
        }
        for (DescriptorGroup descriptorGroup : categoryTemplate.getOptionalDescriptorGroups()) {
            this.addDescriptorOrGroupToCategoryTemplate(templateIndiv, categoryTemplate.getUri(), DESCRIPTOR_GROUP_CLASS_URI, descriptorGroup.getUri(), descriptorGroup.getLabel(), descriptorGroup.getMaxOccurrence(), false);
        }
    }

    private void addDescriptorOrGroupToCategoryTemplate(Individual templateIndiv, String categoryURI, String descriptorClassURI, final String descriptorURI, String descriptorLabel, Integer maxOcurrence, boolean mandatory) throws AlreadyExistsException {
        this.logger.debug((Object)("adding descriptor (or group) " + descriptorURI + " to template " + templateIndiv.getURI() + " in category " + categoryURI + " in the ontology"));
        final OntModel ontModel = templateIndiv.getOntModel();
        final OntResource categoryResource = ontModel.getOntResource(categoryURI);
        Property hasTemplateContext = ontModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_template_context");
        final Property hasTemplateDescriptor = ontModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_template_descriptor");
        final Property hasCategory = ontModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_category");
        Property isMandatory = ontModel.getProperty("http://www.grits-toolbox.org/ontology/sample#is_mandatory");
        Property hasAbundance = ontModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_abbundance");
        OntResource descriptorResource = ontModel.getOntResource(descriptorURI);
        if (descriptorResource == null) {
            this.logger.info((Object)("creating descriptor resource in the ontology " + descriptorLabel));
            descriptorResource = ontModel.createOntResource(descriptorURI);
        }
        Individual templateContextIndiv = null;
        List templateContexts = ontModel.listObjectsOfProperty((Resource)templateIndiv, hasTemplateContext).filterKeep((Filter)new Filter<RDFNode>(){

            public boolean accept(RDFNode templateContextNode) {
                return ontModel.contains(templateContextNode.asResource(), hasTemplateDescriptor, descriptorURI);
            }
        }).filterKeep((Filter)new Filter<RDFNode>(){

            public boolean accept(RDFNode templateContextNode) {
                return ontModel.contains(templateContextNode.asResource(), hasCategory, (RDFNode)categoryResource);
            }
        }).toList();
        if (templateContexts.size() == 1) {
            templateContextIndiv = ontModel.getIndividual(((RDFNode)templateContexts.iterator().next()).asResource().getURI());
            if (templateContextIndiv == null) {
                throw new NotFoundException("template context is already there for descriptor \"" + descriptorLabel + "\" in template\"" + templateIndiv.getLabel(null) + "\"" + "\" in category\"" + categoryResource.getLabel(null) + "\"");
            }
            templateContextIndiv.removeAll(isMandatory);
            templateContextIndiv.removeAll(hasAbundance);
        } else if (templateContexts.size() > 1) {
            throw new AlreadyExistsException("more than 1 template context is there for descriptor \"" + descriptorLabel + "\" in template\"" + templateIndiv.getLabel(null) + "\"" + "\" in category\"" + categoryResource.getLabel(null) + "\"");
        }
        if (templateContextIndiv == null) {
            String templateContextLabel = "template_context_" + categoryResource.getLabel(null) + "_" + descriptorLabel + "_in_" + templateIndiv.getLabel(null);
            String contextUri = this.getUriFromUniqueLabel(templateContextLabel);
            if (ontModel.getOntResource(contextUri) != null) {
                this.logger.error((Object)("Error generating uri for tamplate context.Template context uri already exist : " + contextUri));
                throw new AlreadyExistsException("Template context uri already exist : " + contextUri);
            }
            templateContextIndiv = ontModel.createIndividual(contextUri, (Resource)ontModel.getOntClass(TEMPLATE_CONTEXT_CLASS_URI));
            templateContextIndiv.setLabel(templateContextLabel, null);
            templateIndiv.addProperty(hasTemplateContext, (RDFNode)templateContextIndiv);
            templateContextIndiv.addProperty(hasCategory, (RDFNode)categoryResource);
            templateContextIndiv.addProperty(hasTemplateDescriptor, (RDFNode)descriptorResource);
        }
        templateContextIndiv.addLiteral(isMandatory, mandatory);
        if (maxOcurrence != null) {
            templateContextIndiv.addLiteral(hasAbundance, (long)maxOcurrence.intValue());
        } else {
            templateContextIndiv.removeAll(hasAbundance);
        }
    }

    private String getUriFromUniqueLabel(String givenLabel) {
        String uri = baseURI + givenLabel.toLowerCase().trim().replaceAll(" ", "_").replaceAll("/", "_").replaceAll("%", "_");
        return uri;
    }

    public static CategoryTemplate getCategoryTemplate(Template template, String categoryUri) {
        CategoryTemplate categoryTemplate = null;
        switch (categoryUri) {
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                categoryTemplate = template.getSampleInformationTemplate();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                categoryTemplate = template.getTrackingTemplate();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                categoryTemplate = template.getAmountTemplate();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                categoryTemplate = template.getPurityQCTemplate();
                break;
            }
        }
        return categoryTemplate;
    }
}

