/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.dialog.listener.CopyFromComponentListener;
import org.grits.toolbox.entry.sample.dialog.listener.CopyFromTemplateListener;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.preference.SamplePreferenceStore;
import org.grits.toolbox.entry.sample.utilities.ComponentNameValidator;
import org.grits.toolbox.entry.sample.utilities.TemplateLabelProvider;

public class AddComponentDialog
extends TitleAreaDialog {
    private ISampleOntologyApi sampleOntologyApi = null;
    private String componentName = null;
    private Template selectedTemplate = null;
    private Component componentToBeCopied = null;
    private Text componentText = null;
    private Button radioButton2 = null;
    private Button radioButton3 = null;
    public int selectedOption = 0;
    public static final int COPY_FROM_SAMPLE = 1;
    public static final int COPY_FROM_TEMPLATE = 2;
    private CopyFromComponentListener copyFromComponentListener = null;
    private CopyFromTemplateListener copyFromTemplateListener = null;
    private ComponentNameValidator validator = null;

    public AddComponentDialog(Shell parentShell, Sample sample, ISampleOntologyApi sampleOntologyApi) {
        super(parentShell);
        this.sampleOntologyApi = sampleOntologyApi;
        this.componentName = this.getNewComponentName(sample);
        this.validator = new ComponentNameValidator(sample, this.componentName);
    }

    private String getNewComponentName(Sample sample) {
        int untitledNumber = 1;
        Set<String> existingComponentNames = sample.getAllComponentLabels();
        while (existingComponentNames.contains("New Component " + untitledNumber)) {
            ++untitledNumber;
        }
        return "New Component " + untitledNumber;
    }

    public void create() {
        super.create();
        this.setTitle("New Component");
        this.setMessage("Please provide the following information");
    }

    public Control createDialogArea(Composite parent) {
        Composite comp;
        block5: {
            comp = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(comp, 0);
            container.getShell().setImage(ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.ADD_COMPONENT_LAUNCHER_ICON).createImage());
            container.setLayoutData((Object)new GridData(4, 4, false, false));
            GridLayout layout = new GridLayout(4, false);
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            container.setLayout((Layout)layout);
            GridData textDataName = this.getRowInDialog(container, "Component Name");
            this.componentText = new Text(container, 2048);
            this.componentText.setLayoutData((Object)textDataName);
            this.componentText.setText(this.componentName);
            this.addDecoratorValidationForName();
            this.componentText.selectAll();
            this.getLabel(container, "Create Component : ", 4);
            this.getLabel(container, "", 1);
            Button radioButton1 = new Button(container, 16);
            radioButton1.setSelection(true);
            radioButton1.setText("New");
            this.getLabel(container, "", 2);
            this.getLabel(container, "", 1);
            this.radioButton2 = new Button(container, 16);
            this.radioButton2.setText("Copy Component");
            this.getLabel(container, "     Component    ", 1);
            Text selectedSampleText = new Text(container, 128);
            selectedSampleText.setLayoutData((Object)new GridData(1808));
            selectedSampleText.setText("");
            selectedSampleText.setEnabled(false);
            try {
                this.copyFromComponentListener = new CopyFromComponentListener(radioButton1, selectedSampleText);
                this.radioButton2.addSelectionListener((SelectionListener)this.copyFromComponentListener);
            }
            catch (Exception exception) {
                MessageDialog.openWarning((Shell)parent.getShell(), (String)"Error Retrieving Component List", (String)"Component List could not be retrieved");
                this.radioButton2.setEnabled(false);
            }
            this.getLabel(container, "", 1);
            this.radioButton3 = new Button(container, 16);
            this.radioButton3.setText("Use Template");
            this.getLabel(container, "     Template  ", 1);
            ComboViewer selectedTemplateCombo = new ComboViewer(container, 8);
            selectedTemplateCombo.getCombo().setLayoutData((Object)new GridData(1808));
            selectedTemplateCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
            selectedTemplateCombo.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
            try {
                ArrayList<Template> templates = new ArrayList<Template>(this.sampleOntologyApi.getAllTemplates());
                selectedTemplateCombo.setInput(templates);
                this.copyFromTemplateListener = new CopyFromTemplateListener(container, selectedTemplateCombo);
                this.radioButton3.addSelectionListener((SelectionListener)this.copyFromTemplateListener);
                if (SamplePreferenceStore.getDefaultTemplateUri() == null) break block5;
                for (Template template : templates) {
                    if (!SamplePreferenceStore.getDefaultTemplateUri().equals(template.getUri())) continue;
                    selectedTemplateCombo.getCombo().select(selectedTemplateCombo.getCombo().indexOf(template.getLabel()));
                    radioButton1.setSelection(false);
                    this.radioButton3.setSelection(true);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openWarning((Shell)parent.getShell(), (String)"Error Retrieving Template List", (String)"Template List could not be retrieved");
                this.radioButton3.setEnabled(false);
            }
        }
        this.componentText.setFocus();
        return comp;
    }

    private void addDecoratorValidationForName() {
        final ControlDecoration controlDecoration = new ControlDecoration((Control)this.componentText, 16384);
        controlDecoration.setMarginWidth(2);
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        controlDecoration.hide();
        this.componentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text sampleLabelText = (Text)e.getSource();
                String currentValue = sampleLabelText.getText().trim();
                String errorMessage = AddComponentDialog.this.validator.isValid(currentValue);
                controlDecoration.setDescriptionText(errorMessage);
                if (errorMessage == null) {
                    AddComponentDialog.this.getButton(0).setEnabled(true);
                    controlDecoration.hide();
                    AddComponentDialog.this.componentName = currentValue;
                } else {
                    AddComponentDialog.this.getButton(0).setEnabled(false);
                    controlDecoration.show();
                }
            }
        });
    }

    private GridData getRowInDialog(Composite container, String labelTitle) {
        this.getLabel(container, labelTitle, 1);
        GridData textDataName = new GridData();
        textDataName.grabExcessHorizontalSpace = true;
        textDataName.horizontalAlignment = 4;
        textDataName.horizontalSpan = 3;
        return textDataName;
    }

    private void getLabel(Composite container, String labelTitle, int horizontalSpan) {
        Label label = new Label(container, 0);
        label.setText(labelTitle);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        if (this.radioButton2.getSelection()) {
            this.componentToBeCopied = this.copyFromComponentListener.selectedComponent;
            this.selectedOption = 1;
        }
        if (this.radioButton3.getSelection()) {
            if (this.copyFromTemplateListener.getSelectedTemplate() != null) {
                this.selectedTemplate = this.copyFromTemplateListener.getSelectedTemplate();
                this.selectedOption = 2;
            } else {
                MessageDialog.openError((Shell)this.getParentShell(), (String)"Error", (String)"You need to select a Template");
                return;
            }
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Component getComponentToBeCopied() {
        return this.componentToBeCopied;
    }

    public Template getSelectedTemplate() {
        return this.selectedTemplate;
    }
}

