/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.dialog.listener.CopyFromComponentListener;
import org.grits.toolbox.entry.sample.dialog.listener.CopyFromTemplateListener;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.ontologymanager.SampleOntologyApi;
import org.grits.toolbox.entry.sample.preference.SamplePreferenceStore;
import org.grits.toolbox.entry.sample.utilities.TemplateLabelProvider;

public class BatchOfAnalytesPageOne
extends WizardPage {
    private static final Logger logger = Logger.getLogger(BatchOfAnalytesPageOne.class);
    private static final String PAGE_NAME = "NewAnalytePage";
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Label projectNameLabel = null;
    private Text projectNameText = null;
    private Entry projectEntry = null;
    private Label nameLabel = null;
    public Text nameText = null;
    private Spinner numberSpinner = null;
    public Button radioButton2 = null;
    private CopyFromComponentListener copyFromComponentListener = null;
    public Button radioButton3 = null;
    private ComboViewer selectedTemplateCombo = null;
    private CopyFromTemplateListener copyFromTemplateListener = null;
    private ISampleOntologyApi sampleOntologyApi = null;
    private Label descriptionLabel = null;
    private Text descriptionText = null;
    private Composite container = null;

    public BatchOfAnalytesPageOne() {
        super(PAGE_NAME);
        this.setTitle("Batch of Analytes");
        this.setDescription("Create a batch of Analytes");
        try {
            this.sampleOntologyApi = new SampleOntologyApi();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Entry getProjectEntry() {
        return this.projectEntry;
    }

    public String getPrefixName() {
        return this.nameText.getText().trim();
    }

    public int getNumberOfAnalytes() {
        return this.numberSpinner.getSelection();
    }

    public int getRadioSelection() {
        int i = 0;
        if (this.radioButton2.getSelection() && this.radioButton2.getText() != null && this.radioButton2.getText().equals("Copy Component")) {
            i = 1;
        } else if (this.radioButton3.getSelection() && this.radioButton3.getText() != null && this.radioButton3.getText().equals("Use Template")) {
            i = 2;
        }
        return i;
    }

    public Component getComponentTobeCopied() {
        return this.copyFromComponentListener.selectedComponent;
    }

    public Template getTemplateTobeCopied() {
        return this.copyFromTemplateListener.getSelectedTemplate();
    }

    public String getDescription() {
        return this.descriptionText.getText().trim();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 15;
        gridLayout.makeColumnsEqualWidth = false;
        this.container.setLayout((Layout)gridLayout);
        Composite projectComposite = new Composite(this.container, 4);
        GridLayout projectCompositeLayout = new GridLayout(4, false);
        projectCompositeLayout.marginBottom = 20;
        projectComposite.setLayout((Layout)projectCompositeLayout);
        projectComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.projectNameLabel = new Label(projectComposite, 0);
        this.projectNameLabel.setText("Project");
        this.projectNameLabel = this.setMandatoryLabel(this.projectNameLabel);
        GridData projectNameData = new GridData();
        projectNameData.horizontalSpan = 1;
        this.projectNameLabel.setLayoutData((Object)projectNameData);
        this.projectNameText = new Text(projectComposite, 2048);
        GridData projectnameTextData = new GridData(4);
        projectnameTextData.grabExcessHorizontalSpace = true;
        projectnameTextData.horizontalAlignment = 4;
        projectnameTextData.horizontalSpan = 2;
        this.projectNameText.setLayoutData((Object)projectnameTextData);
        if (this.projectEntry != null) {
            this.projectNameText.setText(this.projectEntry.getDisplayName());
        }
        this.projectNameText.setEditable(false);
        Button button = new Button(projectComposite, 8);
        button.setText("Browse");
        GridData browseButtonData = new GridData();
        browseButtonData.horizontalSpan = 1;
        browseButtonData.widthHint = 80;
        button.setLayoutData((Object)browseButtonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Entry selected;
                Shell newShell = new Shell(BatchOfAnalytesPageOne.this.getWizard().getContainer().getShell(), 0x10008000);
                newShell.setLayout((Layout)new GridLayout());
                ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
                dlg.addFilter("org.grits.toolbox.property.project");
                dlg.setTitle("Project Selection");
                dlg.setMessage("Choose a project");
                if (dlg.open() == 0 && (selected = dlg.getEntry()) != null) {
                    BatchOfAnalytesPageOne.this.projectEntry = selected;
                    BatchOfAnalytesPageOne.this.projectNameText.setText(BatchOfAnalytesPageOne.this.projectEntry.getDisplayName());
                    BatchOfAnalytesPageOne.this.setPageComplete(BatchOfAnalytesPageOne.this.isValidInput());
                }
            }
        });
        this.createSeparator(this.container, 1);
        Composite genericComposite = new Composite(this.container, 4);
        GridLayout genericCompositeLayout = new GridLayout(4, false);
        genericCompositeLayout.marginBottom = 10;
        genericCompositeLayout.marginTop = 10;
        genericCompositeLayout.verticalSpacing = 15;
        genericComposite.setLayout((Layout)genericCompositeLayout);
        genericComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridData nameData = new GridData();
        this.nameLabel = new Label(genericComposite, 16384);
        this.nameLabel.setText("Name Prefix");
        this.nameLabel = this.setMandatoryLabel(this.nameLabel);
        this.nameLabel.setLayoutData((Object)nameData);
        GridData nameTextData = new GridData();
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalAlignment = 4;
        nameTextData.horizontalSpan = 3;
        this.nameText = new Text(genericComposite, 2048);
        this.nameText.setLayoutData((Object)nameTextData);
        this.nameText.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    BatchOfAnalytesPageOne.this.setPageComplete(BatchOfAnalytesPageOne.this.isValidInput());
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BatchOfAnalytesPageOne.this.setPageComplete(BatchOfAnalytesPageOne.this.isValidInput());
            }
        });
        GridData numberData = new GridData();
        Label numberLabel = new Label(genericComposite, 16384);
        numberLabel.setText("Num. of Analytes");
        numberLabel.setLayoutData((Object)numberData);
        GridData numberSpinnerData = new GridData();
        numberSpinnerData.grabExcessHorizontalSpace = false;
        numberSpinnerData.grabExcessVerticalSpace = false;
        numberSpinnerData.horizontalAlignment = 16384;
        numberSpinnerData.horizontalSpan = 1;
        this.numberSpinner = new Spinner(genericComposite, 2056);
        this.numberSpinner.setMinimum(2);
        this.numberSpinner.setLayoutData((Object)numberSpinnerData);
        this.getLabel(genericComposite, "", 2);
        GridData descriptionData = new GridData();
        this.descriptionLabel = new Label(genericComposite, 16512);
        this.descriptionLabel.setText("Description");
        descriptionData.horizontalSpan = 1;
        descriptionData.verticalAlignment = 128;
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 3;
        descriptionTextData.verticalSpan = 3;
        this.descriptionText = new Text(genericComposite, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
        this.createSeparator(this.container, 1);
        Composite creationModeComposite = new Composite(this.container, 4);
        GridLayout creationModeCompositeLayout = new GridLayout(4, false);
        creationModeCompositeLayout.marginBottom = 15;
        creationModeCompositeLayout.verticalSpacing = 15;
        creationModeComposite.setLayout((Layout)creationModeCompositeLayout);
        creationModeComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.getLabel(creationModeComposite, "Choose Creation mode", 4);
        this.getLabel(creationModeComposite, "        ", 1);
        Button radioButton1 = new Button(creationModeComposite, 16);
        radioButton1.setSelection(true);
        radioButton1.setText("New");
        this.getLabel(creationModeComposite, "", 2);
        this.getLabel(creationModeComposite, "", 1);
        this.radioButton2 = new Button(creationModeComposite, 16);
        this.radioButton2.setText("Copy Component");
        this.getLabel(creationModeComposite, "     Component    ", 1);
        Text selectedSampleText = new Text(creationModeComposite, 128);
        selectedSampleText.setLayoutData((Object)new GridData(768));
        selectedSampleText.setText("");
        selectedSampleText.setEnabled(false);
        try {
            this.copyFromComponentListener = new CopyFromComponentListener(radioButton1, selectedSampleText);
            this.radioButton2.addSelectionListener((SelectionListener)this.copyFromComponentListener);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)parent.getShell(), (String)"Error Compiling Component List", (String)"Component List could not be retrieved");
            this.radioButton2.setEnabled(false);
        }
        this.getLabel(creationModeComposite, "", 1);
        this.radioButton3 = new Button(creationModeComposite, 16);
        this.radioButton3.setText("Use Template");
        this.getLabel(creationModeComposite, "     Template  ", 1);
        this.selectedTemplateCombo = new ComboViewer(creationModeComposite, 8);
        this.selectedTemplateCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.selectedTemplateCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.selectedTemplateCombo.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        try {
            ArrayList<Template> templates = new ArrayList<Template>(this.sampleOntologyApi.getAllTemplates());
            this.selectedTemplateCombo.setInput(templates);
            this.copyFromTemplateListener = new CopyFromTemplateListener(creationModeComposite, this.selectedTemplateCombo);
            this.radioButton3.addSelectionListener((SelectionListener)this.copyFromTemplateListener);
            if (SamplePreferenceStore.getDefaultTemplateUri() != null) {
                if (this.loadPreferenceTemplate(templates)) {
                    radioButton1.setSelection(false);
                    this.radioButton3.setSelection(true);
                }
            } else {
                this.selectedTemplateCombo.getCombo().setEnabled(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)parent.getShell(), (String)"Error Compiling Component List", (String)"Component List could not be retrieved");
            this.radioButton3.setEnabled(false);
        }
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void getLabel(Composite container, String labelTitle, int horizontalSpan) {
        Label label = new Label(container, 0);
        label.setText(labelTitle);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gd);
    }

    private boolean loadPreferenceTemplate(List<Template> templates) {
        boolean foundAndSelected = false;
        for (Template template : templates) {
            if (!template.getUri().equals(SamplePreferenceStore.getDefaultTemplateUri())) continue;
            this.selectedTemplateCombo.getCombo().select(this.selectedTemplateCombo.getCombo().indexOf(template.getLabel()));
            foundAndSelected = true;
            break;
        }
        return foundAndSelected;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.nameText.setFocus();
    }

    private Label createSeparator(Composite parent, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    private Label setMandatoryLabel(Label label) {
        label.setText(String.valueOf(label.getText()) + "*");
        label.setFont(this.boldFont);
        return label;
    }

    private boolean isValidInput() {
        if (!this.checkBasicLengthCheck(this.projectNameLabel, this.projectNameText, 0, 32)) {
            return false;
        }
        if (!this.checkBasicLengthCheck(this.nameLabel, this.nameText, 0, 80)) {
            return false;
        }
        if (this.findSameNameEntry(this.nameText.getText().trim(), false)) {
            this.setError(this.nameLabel, "Same prefix name exists for other Analyte(s). Please use a different name.");
            return false;
        }
        this.removeError(this.nameLabel);
        return this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength")));
    }

    protected boolean checkBasicLengthCheck(Label targetLabel, Text targetText, int min, int max) {
        if (targetLabel.getFont().equals((Object)this.boldFont) && targetText.getText().length() == min) {
            this.setError(targetLabel, String.valueOf(targetLabel.getText()) + " cannot be empty. Please provide a name.");
            return false;
        }
        if (targetText.getText().length() > max || targetText.getText().length() < min) {
            this.setError(targetLabel, String.valueOf(targetLabel.getText()) + " cannot be longer than " + max + " characters");
            return false;
        }
        this.removeError(targetLabel);
        return true;
    }

    protected void setError(Label targetLabel, String string) {
        this.setErrorMessage(string);
        targetLabel.setForeground(Display.getCurrent().getSystemColor(3));
    }

    public boolean findSameNameEntry(String _entryName, boolean exactMatch) {
        boolean match = false;
        if (this.projectEntry != null) {
            List children = this.projectEntry.getChildren();
            for (Entry child : children) {
                if (!child.getProperty().getType().equals("org.grits.toolbox.property.sample") || (!exactMatch || !child.getDisplayName().equals(_entryName)) && (exactMatch || !child.getDisplayName().startsWith(_entryName))) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    protected void removeError(Label targetLabel) {
        targetLabel.setForeground(Display.getCurrent().getSystemColor(2));
        this.setErrorMessage(null);
    }

    public void setProjectEntry(Entry projectEntry) {
        this.projectEntry = projectEntry;
    }
}

