/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.spectrafiltering.process;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.grits.toolbox.tools.spectrafiltering.dialog.process.ProgressDialogThread;
import org.grits.toolbox.tools.spectrafiltering.om.SpectraPickerSettings;
import org.grits.toolbox.tools.spectrafiltering.process.CancelProcessException;
import org.grits.toolbox.tools.spectrafiltering.utils.MzXMLFormatException;
import org.grits.toolbox.tools.spectrafiltering.utils.MzXMLWriter;
import org.systemsbiology.jrap.grits.stax.MSXMLParser;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanHeader;

public class SpectraPickerThread
extends ProgressDialogThread {
    private SpectraPickerSettings m_filter;
    private MSXMLParser m_parser;
    private boolean m_writeParentScan = false;

    public SpectraPickerThread(SpectraPickerSettings a_filter) {
        this.m_filter = a_filter;
        this.m_parser = new MSXMLParser(this.m_filter.getOpenFrom());
    }

    @Override
    public boolean threadStart() throws Exception {
        LinkedList<Integer> lFilteredScans;
        this.m_progressReporter.setProcessMessageLabel("Task 1 of 2: Filter scans");
        try {
            lFilteredScans = this.filterScans();
        }
        catch (CancelProcessException e) {
            return false;
        }
        catch (Exception e) {
            this.m_progressReporter.setDescriptionText("Error reading scans from " + this.m_filter.getOpenFrom() + "\n" + e.getMessage());
            return false;
        }
        this.m_progressReporter.setProcessMessageLabel("Task 2 of 2: Create filtered mzXML file");
        try {
            this.writeMzXML(lFilteredScans);
        }
        catch (IOException e) {
            this.m_progressReporter.setDescriptionText("Error when writting the new mzXML file: " + e.getMessage());
            this.deleteMzXMLFile();
            return false;
        }
        catch (CancelProcessException e) {
            this.deleteMzXMLFile();
            return false;
        }
        return true;
    }

    private LinkedList<Integer> filterScans() throws CancelProcessException {
        LinkedList<Integer> lFilteredScans = new LinkedList<Integer>();
        int nMax = this.m_parser.getMaxScanNumber();
        this.m_progressReporter.setMax(nMax);
        int nCheckPoint = 1;
        if (nMax > 1000) {
            this.m_progressReporter.setMax(1000);
            nCheckPoint = nMax / 1000;
        }
        for (int i = 1; i < nMax + 1; ++i) {
            ScanHeader header = this.m_parser.rapHeader(i);
            if (header == null || header.getMsLevel() != 1) continue;
            if (i % nCheckPoint == 0) {
                this.m_progressReporter.updateProgresBar("Reading Scan #" + header.getNum());
            }
            int iMS1 = i;
            if (this.m_canceled.booleanValue()) {
                throw new CancelProcessException();
            }
            ArrayList<Integer> lScans = new ArrayList<Integer>();
            lScans.add(iMS1);
            while (i < nMax + 1) {
                ++i;
                if (this.m_canceled.booleanValue()) {
                    throw new CancelProcessException();
                }
                ScanHeader headerSub = this.m_parser.rapHeader(i);
                if (headerSub == null) continue;
                if (headerSub.getMsLevel() == header.getMsLevel()) {
                    --i;
                    break;
                }
                if (i % nCheckPoint == 0) {
                    this.m_progressReporter.updateProgresBar("Reading Scan #" + header.getNum());
                }
                if (headerSub.getPrecursorScanNum() != iMS1 || headerSub.getPeaksCount() == 0 || !this.filterScan(this.m_parser.rap(i))) continue;
                lScans.add(i);
            }
            if (!this.m_writeParentScan) {
                lScans.remove(0);
            }
            if (lScans.isEmpty()) continue;
            lFilteredScans.addAll(lScans);
        }
        return lFilteredScans;
    }

    private boolean filterScan(Scan a_scan) throws CancelProcessException {
        if (a_scan == null) {
            return false;
        }
        if (this.m_canceled.booleanValue()) {
            throw new CancelProcessException();
        }
        Double mzValue = this.m_filter.getMzValue();
        Double accuracyValue = this.m_filter.getAccuracy();
        if (this.m_filter.getPPM().booleanValue()) {
            accuracyValue = mzValue / 1000000.0 * accuracyValue;
        }
        Double minInterval = mzValue - accuracyValue;
        Double maxInterval = mzValue + accuracyValue;
        double[][] massIntensityList = a_scan.getMassIntensityList();
        Double highestPeakIntensity = massIntensityList[1][0];
        for (int i = 1; i < massIntensityList[1].length; ++i) {
            if (this.m_canceled.booleanValue()) {
                throw new CancelProcessException();
            }
            highestPeakIntensity = Math.max(highestPeakIntensity, massIntensityList[1][i]);
        }
        Double cutOffValue = this.m_filter.getCutOffValue();
        if (this.m_filter.getPercentage().booleanValue()) {
            cutOffValue = highestPeakIntensity * cutOffValue / 100.0;
        }
        for (int i = 0; i < massIntensityList[0].length; ++i) {
            if (this.m_canceled.booleanValue()) {
                throw new CancelProcessException();
            }
            if (massIntensityList[1][i] < cutOffValue || massIntensityList[0][i] > maxInterval || massIntensityList[0][i] < minInterval) continue;
            return true;
        }
        return false;
    }

    private void writeMzXML(LinkedList<Integer> a_lScanIndexes) throws IOException, CancelProcessException, MzXMLFormatException {
        this.m_progressReporter.setMax(a_lScanIndexes.size() + 3);
        MzXMLWriter writer = new MzXMLWriter();
        writer.createMZXML(this.m_filter.getSaveLocation());
        if (this.m_canceled.booleanValue()) {
            throw new CancelProcessException();
        }
        String strStartTime = this.m_parser.rapHeader(a_lScanIndexes.getFirst().intValue()).getRetentionTime();
        String strEndTime = this.m_parser.rapHeader(a_lScanIndexes.getLast().intValue()).getRetentionTime();
        writer.setMsRun(a_lScanIndexes.size(), strStartTime, strEndTime);
        this.m_progressReporter.updateProgresBar("Writing header");
        writer.write(writer.getHeader());
        Iterator iterator = a_lScanIndexes.iterator();
        while (iterator.hasNext()) {
            int iScan = (Integer)iterator.next();
            if (this.m_canceled.booleanValue()) {
                writer.closeFile();
                throw new CancelProcessException();
            }
            Scan scan = this.m_parser.rap(iScan);
            this.m_progressReporter.updateProgresBar("Writing scan #" + scan.getHeader().getNum());
            writer.write(writer.getScan(scan));
        }
        this.m_progressReporter.updateProgresBar("Writing footer");
        writer.write(writer.getFooter());
        writer.closeFile();
        this.m_progressReporter.updateProgresBar("Done!");
    }

    private void deleteMzXMLFile() throws IOException {
        if (!Files.exists(Paths.get(this.m_filter.getSaveLocation(), new String[0]), new LinkOption[0])) {
            return;
        }
        Files.delete(Paths.get(this.m_filter.getSaveLocation(), new String[0]));
    }
}

