/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterSetup;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;

public class Filtering
extends TitleAreaDialog
implements FilterChangedListener {
    private static final Logger logger = Logger.getLogger(Filtering.class);
    private List<Filter> preFilters = null;
    FilterTableSetup filterTableSetup;
    FilterSetting filterSetting;
    private Category preferredCategory;
    private FiltersLibrary filterLibrary;

    public Filtering(Shell parentShell, FiltersLibrary fLib, Category filterCategory, FilterSetting filterSetting) {
        super(parentShell);
        this.filterLibrary = fLib;
        this.preFilters = fLib.getFilters();
        this.filterSetting = filterSetting;
        this.preferredCategory = filterCategory;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Filtering Settings");
        Composite area = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(area, 2816);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 400;
        data.widthHint = 700;
        sc.setLayoutData((Object)data);
        Composite comp1 = new Composite((Composite)sc, 0);
        comp1.setLayout((Layout)new GridLayout(4, false));
        Composite container = new Composite(comp1, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.filterTableSetup = this.filterLibrary.getCategories() != null ? new MSGlycanAnnotationFilterSetup(this.filterLibrary.getCategories()) : new MSGlycanAnnotationFilterSetup();
        this.filterTableSetup.setFilterList(this.preFilters);
        ((MSGlycanAnnotationFilterSetup)this.filterTableSetup).setSelectedCategory(this.preferredCategory);
        try {
            this.filterTableSetup.createFilterTableSection(container);
            if (this.filterSetting != null) {
                this.filterTableSetup.setExistingFilters(this.filterSetting);
            }
            this.filterTableSetup.addFilterChangedListener((FilterChangedListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating the filter table", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error creating the filter table!");
        }
        sc.setContent((Control)comp1);
        sc.setMinSize(comp1.computeSize(-1, -1));
        return area;
    }

    public void filterChanged() {
        if (this.filterTableSetup != null) {
            this.filterSetting = this.filterTableSetup.getFilterSetting();
        }
    }

    public FilterSetting getFilterSetting() {
        return this.filterSetting;
    }

    public void setFilterSetting(FilterSetting filterSetting) {
        this.filterSetting = filterSetting;
    }
}

