/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.spectrum.chart;

import java.awt.Graphics2D;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.display.control.spectrum.chart.GRITSXYPlot;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.experimental.swt.SWTGraphics2D;

public class GRITSChartComposite
extends ChartComposite {
    private String sMzXMLFile;
    private Integer iScanNum;
    private Double dScale = 1.0;

    public GRITSChartComposite(Composite comp, int style, JFreeChart chart, boolean useBuffer) {
        super(comp, style, chart, useBuffer);
    }

    public void setChart(JFreeChart arg0) {
        super.setChart(arg0);
    }

    public Display getDisplay() {
        return super.getDisplay();
    }

    public void drawGRITSAnnotations(SWTGraphics2D sg2) {
        GRITSXYPlot xyPlot = (GRITSXYPlot)this.getChart().getPlot();
        xyPlot.initializeGrid((int)(80.0 * this.dScale), (int)(40.0 * this.dScale), this.getScaleX(), this.getScaleY());
        xyPlot.initAnnotationGrid(0.5);
        PlotOrientation orientation = xyPlot.getOrientation();
        ValueAxis axis = null;
        axis = orientation == PlotOrientation.VERTICAL ? xyPlot.getRangeAxis() : xyPlot.getDomainAxis();
        this.setGridScale(1.0);
        xyPlot.drawPostPaintAnnotations((Graphics2D)sg2, this, axis, false);
    }

    public void paintControl(PaintEvent arg0) {
        super.paintControl(arg0);
    }

    public void setGridScale(double dScale) {
        this.dScale = dScale;
    }

    public double getGridScale() {
        return this.dScale;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return super.getChartRenderingInfo();
    }

    public void chartChanged(ChartChangeEvent arg0) {
        super.chartChanged(arg0);
    }

    public void setBounds(int x, int y, int width, int height) {
        double dScaleFactor = (double)width / (double)height;
        GRITSXYPlot xyPlot = (GRITSXYPlot)this.getChart().getPlot();
        xyPlot.setChartHeight(height);
        xyPlot.setChartWidth(width);
        xyPlot.setChartScale(dScaleFactor);
        super.setBounds(x, y, width, height);
    }

    public void reskin(int flags) {
        super.reskin(flags);
    }

    public void redraw() {
        super.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, all);
    }

    public void setMzXMLFile(String sMzXMLFile) {
        this.sMzXMLFile = sMzXMLFile;
    }

    public String getMzXMLFile() {
        return this.sMzXMLFile;
    }

    public void setScanNum(Integer iScanNum) {
        this.iScanNum = iScanNum;
    }

    public Integer getScanNum() {
        return this.iScanNum;
    }
}

