/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractDeleteAction;
import org.grits.toolbox.editor.samplemanager.input.ClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;

public class DeleteObjectFromOntology
extends AbstractDeleteAction {
    public DeleteObjectFromOntology(AbstractManagementPage page, TableViewer tableViewer) {
        super(page, tableViewer);
        this.setToolTipText("Delete from the ontology");
    }

    @Override
    public void run() {
        this.selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        if (this.selectionIndex != -1) {
            ClassesWithFeatures classWithFeatures = (ClassesWithFeatures)this.tableViewer.getElementAt(this.selectionIndex);
            if (classWithFeatures.isEditable()) {
                this.ontologyManagerApi.removeIndividual(classWithFeatures.getUri());
                ((List)this.tableViewer.getInput()).remove(classWithFeatures);
                this.refreshModifed();
            } else {
                MessageDialog.openInformation((Shell)this.page.getLeftSectionOfPage().getShell(), (String)"Cannot delete the selected item", (String)"You do not have the permission to delete item from the standard ontology.");
            }
        }
    }
}

