/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.sugar;

import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreeSingle;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorResidueBased;

public class GlycoVisitorGlycanType
extends GlycoVisitorResidueBased {
    protected static final String N_Glycan = "N-Glycan";
    protected static final String O_GalNAc = "O-GalNAc";
    protected static final String O_Man = "O-Man";
    protected static final String O_Fuc = "O-Fuc";
    protected static final String GSL = "GSL";
    protected static final String N_Glycan_complex = "complex";
    protected static final String N_Glycan_hybrid = "hybrid";
    protected static final String N_Glycan_high_man = "high mannose";
    protected static final String N_Glycan_pauci_man = "pauci mannose";
    protected static final String GSL_LACTO = "lacto";
    protected static final String GSL_NEO_LACTO = "neo lacto";
    protected static final String GSL_GANGLIO = "ganglio";
    protected static final String GSL_GLOBO = "globo";
    protected static final String GSL_ISOGLOBO = "isoglobo";
    protected static final String GSL_MUCO = "muco";
    protected static final String GSL_ARTHRO = "arthro";
    protected static final String GSL_MOLLU = "mollu";
    protected static final String GSL_GALA = "gala";
    private HashMap<GlycoNode, Boolean> m_hashGlcNac = new HashMap();
    private HashMap<GlycoNode, Boolean> m_hashGal = new HashMap();
    private HashMap<GlycoNode, Boolean> m_hashMan = new HashMap();
    private HashMap<GlycoNode, Boolean> m_hashGalNAc = new HashMap();
    private HashMap<GlycoNode, Boolean> m_hashFuc = new HashMap();
    private HashMap<GlycoNode, Boolean> m_hashGlc = new HashMap();
    private String m_type = null;
    private String m_subType = null;

    public void clear() {
        this.m_hashUsedResidue.clear();
        this.m_hashGlcNac.clear();
        this.m_hashGal.clear();
        this.m_hashMan.clear();
        this.m_hashGalNAc.clear();
        this.m_hashFuc.clear();
        this.m_hashGlc.clear();
        this.m_type = null;
        this.m_subType = null;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String a_type) {
        this.m_type = a_type;
    }

    public String getSubType() {
        return this.m_subType;
    }

    public void setSubType(String a_subType) {
        this.m_subType = a_subType;
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_visitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeSingle(a_visitor);
    }

    public void start(Sugar a_sugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_sugar);
        this.figureTypeOut();
    }

    private void figureTypeOut() {
        if (this.testN()) {
            return;
        }
        if (this.testO()) {
            return;
        }
        if (this.testGSL()) {
            return;
        }
    }

    private boolean testGSL() {
        this.m_hashUsedResidue.clear();
        for (GlycoNode t_glc : this.m_hashGlc.keySet()) {
            GlycoNode t_man;
            if (t_glc.getParentEdge() != null) continue;
            GlycoNode t_gal = this.findChild(t_glc, this.m_hashGal, false);
            if (t_gal != null) {
                GlycoNode t_gal2;
                GlycoNode t_gal22;
                GlycoNode t_glcnac = this.findChild(t_gal, this.m_hashGlcNac, false);
                if (t_glcnac != null && (t_gal22 = this.findChild(t_glcnac, this.m_hashGal, false)) != null) {
                    if (this.testLinkage(t_gal22.getParentEdge(), 3)) {
                        this.m_type = GSL;
                        this.m_subType = GSL_LACTO;
                        return true;
                    }
                    this.m_type = GSL;
                    this.m_subType = GSL_NEO_LACTO;
                    return true;
                }
                GlycoNode t_galnac = this.findChild(t_gal, this.m_hashGalNAc, false);
                if (t_galnac != null && (t_gal2 = this.findChild(t_galnac, this.m_hashGal, false)) != null) {
                    this.m_type = GSL;
                    this.m_subType = GSL_GANGLIO;
                    return true;
                }
                t_gal2 = this.findChild(t_gal, this.m_hashGal, false);
                GlycoNode t_gal3 = this.findChild(t_gal2, this.m_hashGal, false);
                if (t_gal2 != null && t_gal3 != null) {
                    this.m_type = GSL;
                    this.m_subType = GSL_MUCO;
                    return true;
                }
                t_galnac = this.findChild(t_gal2, this.m_hashGalNAc, false);
                if (t_gal2 != null && t_galnac != null) {
                    if (this.testLinkage(t_gal2.getParentEdge(), 3)) {
                        this.m_type = GSL;
                        this.m_subType = GSL_GLOBO;
                        return true;
                    }
                    this.m_type = GSL;
                    this.m_subType = GSL_ISOGLOBO;
                    return true;
                }
            }
            if ((t_man = this.findChild(t_glc, this.m_hashMan, false)) == null) continue;
            GlycoNode t_manB = this.findChild(t_man, this.m_hashMan, false);
            GlycoNode t_glcnac = this.findChild(t_manB, this.m_hashGlcNac, false);
            if (t_manB != null && t_glcnac != null) {
                this.m_type = GSL;
                this.m_subType = GSL_MOLLU;
                return true;
            }
            t_glcnac = this.findChild(t_man, this.m_hashGlcNac, false);
            GlycoNode t_galnac = this.findChild(t_glcnac, this.m_hashGalNAc, false);
            if (t_glcnac == null || t_galnac == null) continue;
            this.m_type = GSL;
            this.m_subType = GSL_ARTHRO;
            return true;
        }
        for (GlycoNode t_gal : this.m_hashGal.keySet()) {
            GlycoNode t_galB;
            if (t_gal.getParentEdge() != null || (t_galB = this.findChild(t_gal, this.m_hashGal, false)) == null) continue;
            this.m_type = GSL;
            this.m_subType = GSL_GALA;
            return true;
        }
        return false;
    }

    private boolean testO() {
        this.m_hashUsedResidue.clear();
        for (GlycoNode t_galnac : this.m_hashGalNAc.keySet()) {
            if (t_galnac.getParentEdge() != null || !this.testOGalNAc(t_galnac)) continue;
            return true;
        }
        for (GlycoNode t_fuc : this.m_hashFuc.keySet()) {
            if (t_fuc.getParentEdge() != null) continue;
            this.m_type = O_Fuc;
            return true;
        }
        for (GlycoNode t_man : this.m_hashMan.keySet()) {
            if (t_man.getParentEdge() != null) continue;
            this.m_type = O_Man;
            return true;
        }
        return false;
    }

    private boolean testOGalNAc(GlycoNode a_galnac) {
        GlycoNode t_gal = this.findChild(a_galnac, this.m_hashGal, false);
        GlycoNode t_glcnac = this.findChild(a_galnac, this.m_hashGlcNac, false);
        if (t_gal != null && t_glcnac != null) {
            this.m_type = O_GalNAc;
            this.m_subType = "core 2";
            return true;
        }
        if (t_gal != null) {
            this.m_type = O_GalNAc;
            this.m_subType = "core 1";
            return true;
        }
        if (t_glcnac != null) {
            this.m_hashUsedResidue.put(t_glcnac, Boolean.TRUE);
            GlycoNode t_glcnacB = this.findChild(a_galnac, this.m_hashGlcNac, false);
            if (t_glcnacB != null) {
                this.m_type = O_GalNAc;
                this.m_subType = "core 4";
                return true;
            }
            if (this.testLinkage(t_glcnac.getParentEdge(), 3)) {
                this.m_type = O_GalNAc;
                this.m_subType = "core 3";
                return true;
            }
            this.m_type = O_GalNAc;
            this.m_subType = "core 6";
            return true;
        }
        GlycoNode t_galnac = this.findChild(a_galnac, this.m_hashGalNAc, false);
        if (t_galnac != null) {
            if (this.testLinkage(t_galnac.getParentEdge(), 3)) {
                this.m_type = O_GalNAc;
                this.m_subType = "core 5";
                return true;
            }
            this.m_type = O_GalNAc;
            this.m_subType = "core 7";
            return true;
        }
        return false;
    }

    private boolean testN() {
        this.m_hashUsedResidue.clear();
        for (GlycoNode t_glcnacA : this.m_hashGlcNac.keySet()) {
            GlycoNode t_man;
            GlycoNode t_glcnacB;
            if (t_glcnacA.getParentEdge() != null || (t_glcnacB = this.findChild(t_glcnacA, this.m_hashGlcNac, false)) == null || (t_man = this.findChild(t_glcnacB, this.m_hashMan, false)) == null) continue;
            GlycoNode t_manA = this.findChild(t_man, this.m_hashMan, false);
            this.m_type = N_Glycan;
            if (t_manA != null) {
                this.m_hashUsedResidue.put(t_manA, Boolean.TRUE);
                GlycoNode t_manB = this.findChild(t_man, this.m_hashMan, false);
                if (t_manB != null) {
                    this.m_subType = this.testNsubType(t_manA, t_manB);
                    return true;
                }
                this.m_subType = N_Glycan_pauci_man;
                return true;
            }
            this.m_subType = N_Glycan_pauci_man;
            return true;
        }
        return false;
    }

    private String testNsubType(GlycoNode a_manA, GlycoNode a_manB) {
        GlycoNode t_glcnacA = this.findChild(a_manA, this.m_hashGlcNac, false);
        GlycoNode t_glcnacB = this.findChild(a_manB, this.m_hashGlcNac, false);
        if (t_glcnacA != null && t_glcnacB != null) {
            return N_Glycan_complex;
        }
        GlycoNode t_manA = this.findChild(a_manA, this.m_hashMan, false);
        GlycoNode t_manB = this.findChild(a_manB, this.m_hashMan, false);
        if (t_manA != null && t_manB != null) {
            return N_Glycan_high_man;
        }
        if (t_manA != null && t_glcnacB != null || t_manB != null && t_glcnacA != null) {
            return N_Glycan_hybrid;
        }
        if (t_glcnacA != null && t_manB == null || t_glcnacB != null && t_manA == null) {
            if (t_glcnacA != null) {
                this.m_hashUsedResidue.put(t_glcnacA, Boolean.TRUE);
                GlycoNode t_glcnacA2 = this.findChild(a_manA, this.m_hashGlcNac, false);
                if (t_glcnacA2 == null) {
                    return N_Glycan_hybrid;
                }
                return N_Glycan_complex;
            }
            this.m_hashUsedResidue.put(t_glcnacB, Boolean.TRUE);
            GlycoNode t_glcnacB2 = this.findChild(a_manB, this.m_hashGlcNac, false);
            if (t_glcnacB2 == null) {
                return N_Glycan_hybrid;
            }
            return N_Glycan_complex;
        }
        if (t_glcnacA == null && t_manB != null || t_glcnacB == null && t_manA != null) {
            return N_Glycan_high_man;
        }
        if (t_glcnacA == null && t_manA == null && t_glcnacB == null && t_manB == null) {
            return N_Glycan_pauci_man;
        }
        return null;
    }

    public void visit(NonMonosaccharide a_nonMs) throws GlycoVisitorException {
        throw new GlycoVisitorException("NonMonosaccharide is not supported.");
    }

    public void visit(SugarUnitRepeat a_repeat) throws GlycoVisitorException {
    }

    public void visit(Substituent a_subst) throws GlycoVisitorException {
    }

    public void visit(SugarUnitCyclic a_cyclic) throws GlycoVisitorException {
    }

    public void visit(SugarUnitAlternative a_alternative) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative is not supported.");
    }

    public void visit(UnvalidatedGlycoNode a_unvalidated) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNode is not supported.");
    }

    public void visit(GlycoEdge a_edge) throws GlycoVisitorException {
    }

    public void visit(Monosaccharide a_ms) throws GlycoVisitorException {
        int t_numberOfSubstituents = this.calcNumberOfSubstituents(a_ms);
        if (a_ms.getSuperclass().equals((Object)Superclass.HEX)) {
            if (this.isGlucose(a_ms) && a_ms.getModification().size() == 0) {
                if (t_numberOfSubstituents == 0) {
                    this.m_hashGlc.put((GlycoNode)a_ms, Boolean.TRUE);
                } else {
                    for (GlycoEdge t_edge : a_ms.getChildEdges()) {
                        if (!this.isPosition(2, t_edge) || !this.isSubst(SubstituentType.N_ACETYL, t_edge.getChild()) || !this.isLinkageType(LinkageType.DEOXY, t_edge) || t_numberOfSubstituents != 1) continue;
                        this.m_hashGlcNac.put((GlycoNode)a_ms, Boolean.TRUE);
                        return;
                    }
                }
            }
            if (this.isGalactose(a_ms)) {
                if (a_ms.getModification().size() == 0) {
                    for (GlycoEdge t_edge : a_ms.getChildEdges()) {
                        if (!this.isPosition(2, t_edge) || !this.isSubst(SubstituentType.N_ACETYL, t_edge.getChild()) || !this.isLinkageType(LinkageType.DEOXY, t_edge) || t_numberOfSubstituents != 1) continue;
                        this.m_hashGalNAc.put((GlycoNode)a_ms, Boolean.TRUE);
                        return;
                    }
                    if (t_numberOfSubstituents == 0) {
                        this.m_hashGal.put((GlycoNode)a_ms, Boolean.TRUE);
                        return;
                    }
                }
                for (Modification t_modi : a_ms.getModification()) {
                    if (!this.isModiPosition(6, t_modi.getPositionOne()) || !t_modi.getModificationType().equals((Object)ModificationType.DEOXY) || a_ms.getModification().size() != 1 || t_numberOfSubstituents != 0) continue;
                    this.m_hashFuc.put((GlycoNode)a_ms, Boolean.TRUE);
                    return;
                }
            }
            if (this.isMannose(a_ms) && a_ms.getModification().size() == 0 && t_numberOfSubstituents == 0) {
                this.m_hashMan.put((GlycoNode)a_ms, Boolean.TRUE);
                return;
            }
        }
    }
}

