/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato.glycan;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanMatcherDirectInfusion;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class GlycanStructureAnnotationDirectInfusion
extends GlycanStructureAnnotation {
    private static final Logger logger = Logger.getLogger(GlycanStructureAnnotationDirectInfusion.class);
    private int iFirstMS1Scan = -1;

    public GlycanStructureAnnotationDirectInfusion(Data data, String path, String archiveName, MSFile msFile) {
        super(data, path, archiveName, msFile);
    }

    @Override
    public List<Integer> determineScanBounds() {
        int iFirstMS1Scan = this.getFirstMS1Scan();
        ArrayList<Integer> firstScan = new ArrayList<Integer>();
        firstScan.add(iFirstMS1Scan);
        return firstScan;
    }

    private int getFirstMS1Scan() {
        if (this.iFirstMS1Scan > 0) {
            return this.iFirstMS1Scan;
        }
        if (this.msFile.getReader() instanceof IMSAnnotationFileReader) {
            IMSAnnotationFileReader reader = (IMSAnnotationFileReader)this.msFile.getReader();
            List scans = reader.getScanList(this.msFile, -1);
            if (scans == null || scans.isEmpty()) {
                return -1;
            }
            this.iFirstMS1Scan = (Integer)scans.get(0);
            return this.getFirstMS1Scan();
        }
        return -1;
    }

    @Override
    protected void populateScanFeatureData(String glycanFilesPath) {
        Scan scan;
        super.populateScanFeatureData(glycanFilesPath);
        int iFirstMS1Scan = this.getFirstMS1Scan();
        Scan firstMS1Scan = (Scan)this.data.getScans().get(iFirstMS1Scan);
        ScanFeatures scan1Features = new ScanFeatures();
        scan1Features.setScanId(iFirstMS1Scan);
        scan1Features.setScanPeaks(new HashSet(firstMS1Scan.getPeaklist()));
        scan1Features.setUsesComplexRowId(Boolean.valueOf(true));
        for (Integer scanId : this.data.getScanFeatures().keySet()) {
            if (this.isCanceled()) {
                return;
            }
            scan = (Scan)this.data.getScans().get(scanId);
            if (scan.getMsLevel() != 1) continue;
            ScanFeatures sFeatures = (ScanFeatures)this.data.getScanFeatures().get(scanId);
            for (Feature f : sFeatures.getFeatures()) {
                if (scan1Features.getFeatures().contains(f)) continue;
                scan1Features.getFeatures().add(f);
            }
        }
        for (Integer scanId : this.data.getScans().keySet()) {
            if (this.isCanceled()) {
                return;
            }
            scan = (Scan)this.data.getScans().get(scanId);
            scan.setNumAnnotatedPeaks(firstMS1Scan.getNumAnnotatedPeaks());
            if (((Scan)this.data.getScans().get(scanId)).getMsLevel() != 1) continue;
            this.data.getScanFeatures().put(scanId, scan1Features);
        }
    }

    @Override
    protected HashMap<Integer, Scan> getScans(MSFile msFile, int _iScanNumber, double dFragCutoff, String sFragCutoffType, double dPreCutoff, String sPreCutoffType) {
        if (msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)msFile.getReader()).readMSFile(msFile);
            return GelatoUtils.listToHashMap(scans, dFragCutoff, sFragCutoffType, dPreCutoff, sPreCutoffType);
        }
        return null;
    }

    @Override
    public String getFinalArchiveName() {
        return this.m_finalArchive;
    }

    @Override
    public boolean needsOverview() {
        return false;
    }

    @Override
    public String getOverviewFileName() {
        return null;
    }

    @Override
    protected AnalyteMatcher getNewAnalyteMatcher(int iCurScan) {
        return new GlycanMatcherDirectInfusion(iCurScan, this);
    }

    @Override
    protected void cleanAfterCancel() {
        try {
            File file = new File(this.m_finalArchive);
            file.delete();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setArchiveFilePaths() {
        this.m_finalArchive = AnnotationWriter.getArchiveFilePath((String)this.m_preArchive);
    }
}

