/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.filter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.io.Glyde.SugarImporterGlydeII;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngine;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngineException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.grits.toolbox.ms.annotation.filter.IFilter;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;

@XmlType(name="filter")
public class Filter
implements IFilter {
    @XmlTransient
    private static final Logger logger = Logger.getLogger(Filter.class);
    private String filterName;
    private String filterGlyde;
    @XmlTransient
    private boolean included;
    @XmlTransient
    private boolean enabled;

    @XmlTransient
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFilterName() {
        return this.filterName;
    }

    @XmlAttribute(name="filterName")
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getFilterGlyde() {
        return this.filterGlyde;
    }

    @XmlAttribute(name="filterGlyde")
    public void setFilterGlyde(String filterGlyde) {
        this.filterGlyde = filterGlyde;
    }

    @XmlTransient
    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public boolean isMatch(Sugar _candidateSugar, GlycanStructure glycan) {
        try {
            SearchEngine search = new SearchEngine();
            SugarImporterGlydeII t_importer = new SugarImporterGlydeII();
            Sugar t_subStructure = t_importer.parse(this.filterGlyde);
            search.setQueryStructure(t_subStructure);
            search.setQueriedStructure(_candidateSugar);
            search.match();
            if (search.isExactMatch().booleanValue()) {
                return this.included;
            }
            return !this.included;
        }
        catch (SugarImporterException e) {
            logger.error((Object)("Incorrect Glyde: \n" + glycan.getId() + " \n" + glycan.getSequence()), (Throwable)e);
            return false;
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (SearchEngineException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (GlycoconjugateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isMatch(GlycanStructure glycan) {
        try {
            SugarImporterGlydeII t_importer = new SugarImporterGlydeII();
            Sugar t_structure = t_importer.parse(glycan.getSequence());
            return this.isMatch(t_structure, glycan);
        }
        catch (SugarImporterException e) {
            logger.error((Object)("Incorrect Glyde: \n" + glycan.getId() + " \n" + glycan.getSequence()), (Throwable)e);
            return false;
        }
    }
}

