/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.glycoconjugate_derived;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.ComparatorModification;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbAnomer;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbBaseType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModification;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModificationType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbSuperclass;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcdbMonosaccharide {
    private EcdbAnomer m_enumAnomer;
    private ArrayList<EcdbBaseType> m_aBaseType = new ArrayList();
    private EcdbSuperclass m_enumSuperclass;
    public static final int UNKNOWN_RING = -1;
    public static final int OPEN_CHAIN = 0;
    private int m_iRingStart;
    private int m_iRingEnd;
    private ArrayList<EcdbModification> m_aModifications = new ArrayList();

    public EcdbMonosaccharide(EcdbAnomer a_enumAnomer, EcdbSuperclass a_enumSuperclass) throws GlycoconjugateException {
        if (a_enumAnomer == null) {
            throw new GlycoconjugateException("Anomer can't be null");
        }
        this.m_enumAnomer = a_enumAnomer;
        if (a_enumSuperclass == null) {
            throw new GlycoconjugateException("Superclass can't be null");
        }
        this.m_enumSuperclass = a_enumSuperclass;
        this.m_iRingEnd = -1;
        this.m_iRingStart = -1;
        this.m_aModifications.clear();
        this.m_aBaseType.clear();
    }

    public void setAnomer(EcdbAnomer a_enumAnomer) throws GlycoconjugateException {
        if (a_enumAnomer == null) {
            throw new GlycoconjugateException("Anomer can't be null");
        }
        this.m_enumAnomer = a_enumAnomer;
    }

    public void setSuperclass(EcdbSuperclass a_enumSuperclass) throws GlycoconjugateException {
        if (a_enumSuperclass == null) {
            throw new GlycoconjugateException("Superclass can't be null");
        }
        this.m_enumSuperclass = a_enumSuperclass;
    }

    public EcdbSuperclass getSuperclass() {
        return this.m_enumSuperclass;
    }

    public EcdbAnomer getAnomer() {
        return this.m_enumAnomer;
    }

    public void setRing(int a_iStart, int a_iEnd) throws GlycoconjugateException {
        if (a_iStart > a_iEnd) {
            throw new GlycoconjugateException("Endpoint must be larger than startpoint");
        }
        if (a_iStart < -1) {
            throw new GlycoconjugateException("Startpoint must be equal or larger than -1");
        }
        this.m_iRingStart = a_iStart;
        if (a_iEnd < -1) {
            throw new GlycoconjugateException("Endpoint must be equal or larger than -1");
        }
        this.m_iRingEnd = a_iEnd;
    }

    public int getRingStart() {
        return this.m_iRingStart;
    }

    public int getRingEnd() {
        return this.m_iRingEnd;
    }

    public ArrayList<EcdbModification> getModificationList() {
        return this.m_aModifications;
    }

    public int getModificationCount() {
        return this.m_aModifications.size();
    }

    public EcdbModification getModification(int a_iModification) throws IndexOutOfBoundsException {
        return this.m_aModifications.get(a_iModification);
    }

    public void addModification(EcdbModification a_objModification) throws GlycoconjugateException {
        if (a_objModification == null) {
            throw new GlycoconjugateException("Modification can't be null");
        }
        this.m_aModifications.add(a_objModification);
    }

    public void removeModification(EcdbModification a_objModification) {
        this.m_aModifications.remove(a_objModification);
    }

    public ArrayList<EcdbBaseType> getBaseTypeList() {
        return this.m_aBaseType;
    }

    public int getBaseTypeCount() {
        return this.m_aBaseType.size();
    }

    public EcdbBaseType getBaseType(int a_iBaseType) throws IndexOutOfBoundsException {
        return this.m_aBaseType.get(a_iBaseType);
    }

    public void addBaseType(EcdbBaseType a_objBaseType) throws GlycoconjugateException {
        if (a_objBaseType == null) {
            throw new GlycoconjugateException("Basetype can't be null");
        }
        this.m_aBaseType.add(a_objBaseType);
    }

    public void setBaseType(ArrayList<EcdbBaseType> a_basetypeList) {
        this.m_aBaseType = a_basetypeList;
    }

    public void removeBaseType(EcdbBaseType a_objBaseType) {
        this.m_aBaseType.remove((Object)a_objBaseType);
    }

    public String getGlycoCTName() {
        String anomer = null;
        String name = null;
        String basetypes = "";
        String t_Modifications = "";
        String ringstart = null;
        String ringend = null;
        anomer = this.getAnomer().getSymbol();
        for (EcdbBaseType element : this.getBaseTypeList()) {
            basetypes = basetypes + "-" + element.getName();
        }
        ringstart = this.getRingStart() == -1 ? "x" : String.valueOf(this.getRingStart());
        ringend = this.getRingEnd() == -1 ? "x" : String.valueOf(this.getRingEnd());
        ComparatorModification cf = new ComparatorModification();
        Collections.sort(this.m_aModifications, cf);
        for (EcdbModification element : this.getModificationList()) {
            if (element.hasPositionTwo()) {
                t_Modifications = t_Modifications + "|" + element.getPositionOne() + "," + element.getPositionTwo() + ":" + element.getName();
                continue;
            }
            t_Modifications = t_Modifications + "|" + element.getPositionOne() + ":" + element.getName();
        }
        if (t_Modifications != "") {
            t_Modifications = t_Modifications.substring(1, t_Modifications.length());
        }
        name = anomer + basetypes + "-" + (Object)((Object)this.getSuperclass()) + "-" + ringstart + ":" + ringend;
        if (t_Modifications != "") {
            name = name + "|" + t_Modifications;
        }
        return name;
    }

    public boolean isValid() throws GlycoconjugateException {
        return true;
    }

    public String getStereoCode() throws GlycoconjugateException {
        StringBuilder stereocode = null;
        if (!this.isValid()) {
            throw new GlycoconjugateException("Monosaccharide is invalid, cannot compute stereocode");
        }
        if (this.getBaseTypeCount() == 0) {
            stereocode = new StringBuilder("*");
            Integer count = this.getSuperclass().getNumberOfC();
            for (int i = 0; i < count - 1; ++i) {
                stereocode.append("*");
            }
            return stereocode.toString();
        }
        for (EcdbBaseType element : this.getBaseTypeList()) {
            if (!element.getStereo().contains("*")) continue;
            stereocode = new StringBuilder("*");
            Integer count = this.getSuperclass().getNumberOfC();
            for (int i = 0; i < count - 1; ++i) {
                stereocode.append("*");
            }
            return stereocode.toString();
        }
        stereocode = new StringBuilder("0");
        for (EcdbBaseType element : this.getBaseTypeList()) {
            stereocode = stereocode.insert(1, element.getStereo());
        }
        stereocode.append("0");
        ComparatorModification cf = new ComparatorModification();
        Collections.sort(this.m_aModifications, cf);
        for (EcdbModification element : this.getModificationList()) {
            if (this.getSuperclass().getNumberOfC() == element.getPositionOne() | element.getPositionOne() == 1) continue;
            Boolean deoxyTrue = false;
            if (element.hasPositionTwo()) {
                for (EcdbModification element2 : this.getModificationList()) {
                    if ((element.getPositionOne() != element2.getPositionOne() || element2.getName() != EcdbModificationType.DEOXY.getName()) && (element.getPositionTwo() != element2.getPositionOne() || element2.getName() != EcdbModificationType.DEOXY.getName())) continue;
                    deoxyTrue = true;
                }
            }
            if (element.hasPositionTwo() && !deoxyTrue.booleanValue()) {
                stereocode.insert(element.getPositionOne() - 1, "1");
                stereocode.insert(element.getPositionTwo() - 1, "1");
                continue;
            }
            stereocode.insert(element.getPositionOne() - 1, "1");
        }
        return stereocode.toString();
    }

    public Integer getBitfield() throws GlycoconjugateException {
        return null;
    }

    public String getChemoCentricBitfield() throws GlycoconjugateException {
        return null;
    }

    public Boolean hasModification(EcdbModification a_objModification) {
        if (this.m_aModifications.contains(a_objModification)) {
            return true;
        }
        return false;
    }

    public Boolean hasModification(EcdbModificationType a_objModiType, Integer positionOne) {
        for (EcdbModification m : this.m_aModifications) {
            if (m.getName() != a_objModiType.getName() || m.getPositionOne() != positionOne.intValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasModification(EcdbModificationType a_objModiType, Integer positionOne, Integer positionTwo) {
        for (EcdbModification m : this.m_aModifications) {
            if (m.getName() != a_objModiType.getName() || m.getPositionOne() != positionOne.intValue() || m.getPositionTwo() != positionTwo.intValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasChild(Integer position, LinkageType linkageType) {
        return null;
    }

    public EcdbMonosaccharide clone() {
        EcdbMonosaccharide t_objMS = null;
        try {
            t_objMS = new EcdbMonosaccharide(this.m_enumAnomer, this.m_enumSuperclass);
            t_objMS.setRing(this.m_iRingStart, this.m_iRingEnd);
            Iterator<EcdbBaseType> t_iterBase = this.m_aBaseType.iterator();
            while (t_iterBase.hasNext()) {
                t_objMS.addBaseType(t_iterBase.next());
            }
            Iterator<EcdbModification> t_iterModi = this.m_aModifications.iterator();
            while (t_iterModi.hasNext()) {
                t_objMS.addModification(t_iterModi.next());
            }
        }
        catch (GlycoconjugateException glycoconjugateException) {
            // empty catch block
        }
        return t_objMS;
    }

    public String toString() {
        String outStr = "[";
        outStr = outStr + "Anomer: " + (Object)((Object)this.getAnomer());
        outStr = outStr + ", Basetype: " + this.getBaseTypeList();
        outStr = outStr + ", Superclass: " + (Object)((Object)this.getSuperclass());
        outStr = outStr + ", Ring: " + this.getRingStart() + ":" + this.getRingEnd();
        outStr = outStr + ", Mod: " + this.getModificationList();
        outStr = outStr + "]";
        return outStr;
    }
}

