/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.handlers;

import edu.brandeis.glycodenovo.wizard.GlycoDeNovoWizard;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;

public class OpenGlycoDeNovo {
    private static final Logger logger = Logger.getLogger(OpenGlycoDeNovo.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    @Inject
    MApplication application;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell, EPartService partService) {
        List<Entry> msEntries = this.getMSEntries(object);
        GlycoDeNovoWizard wizard = new GlycoDeNovoWizard();
        if (msEntries != null) {
            if (msEntries.size() > 1) {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Please only select only one MS Entry at a time");
            } else if (msEntries.size() == 1) {
                wizard.getSettingForm().setEntry(msEntries.get(0));
            }
        }
        Shell shell2 = new Shell(shell);
        WizardDialog wizardDialog = new WizardDialog(shell2, (IWizard)wizard);
        wizardDialog.open();
        if (wizardDialog.getReturnCode() == 0) {
            Entry[] res = wizard.getResult();
            if (res == null || res.length == 0) {
                logger.error((Object)"GlycoDeNovo: Error while saving result");
                logger.fatal((Object)"Corrupted data for MS Entry or MS Annotation Entry");
                return null;
            }
            gritsDataModelService.addEntry(res[0], res[1]);
            try {
                ProjectFileHandler.saveProject((Entry)res[0].getParent().getParent());
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)"GlycoDeNovo: File Not Found when saving project");
            }
            catch (IOException iOException) {
                logger.error((Object)"GlycoDeNovo: IO Exception when saving project");
            }
            this.lockFiles(wizard, res[0], res[1]);
            eventBroker.send("grits_entry_selected", (Object)res[1]);
            try {
                gritsUIService.setPartService(partService);
                gritsUIService.openEntryInPart(res[1]);
            }
            catch (Exception e) {
                logger.debug((Object)"Could not open the part", (Throwable)e);
            }
            ArrayList<Entry[]> resultList = new ArrayList<Entry[]>();
            resultList.add(res);
            return resultList;
        }
        return null;
    }

    private List<Entry> getMSEntries(Object object) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        StructuredSelection to = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            to = (StructuredSelection)object;
        }
        if (selectedEntry != null && selectedEntry.getProperty().getType().equals("org.grits.toolbox.property.ms")) {
            entries.add(selectedEntry);
        }
        if (gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            to = gritsDataModelService.getLastSelection();
        }
        if (to != null) {
            List selList = to.toList();
            int i = 0;
            while (i < selList.size()) {
                Entry msEntry = (Entry)selList.get(i);
                if (msEntry.getProperty().getType().equals("org.grits.toolbox.property.ms") && !entries.contains(msEntry)) {
                    entries.add(msEntry);
                }
                ++i;
            }
        }
        return entries;
    }

    private void lockFiles(GlycoDeNovoWizard wizard, Entry msEntry, Entry msAnnotationEntry) {
        MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
        try {
            String lockFileLocation = prop.getLockFilePath(msEntry);
            FileLockManager mng = FileLockingUtils.readLockFile((String)lockFileLocation);
            MSPropertyDataFile file = wizard.getSettingForm().getDataFile();
            if (file != null) {
                mng.lockFile(file.getName(), msAnnotationEntry);
                FileLockingUtils.writeLockFile((FileLockManager)mng, (String)lockFileLocation);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not lock the file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Could not lock the file", (Throwable)e);
        }
    }
}

