/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.datamodel;

import edu.brandeis.glycodenovo.core.CSpectrum;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;

public class SettingForm {
    private boolean isBrandeisFormat = true;
    private String mPath = null;
    private String mFileName = null;
    private String mOptionalResultFileName = null;
    private CSpectrum mSpectrum = null;
    private String mMetal = null;
    private String mExperimentType = "Direct Infusion";
    private String mDerivationMethod = null;
    private String mReducingEnd = null;
    private boolean mPermethylated;
    private String mDescription = null;
    private boolean mReconstructionCheck2H;
    private boolean mReconstructionCheckGap;
    private double mReconstructionPPM = -1.0;
    private int mReconstructionBranchNumber = 2;
    private int mCheck2H_previous = 0;
    private int mCheckGap_previous = 0;
    private double mPPM_previous = -1.0;
    private final String[] legal_exp_type = new String[]{"Direct Infusion"};
    private String mResultFileName;
    private Entry mEntry;
    private MSPropertyDataFile mDataFile;

    public SettingForm(boolean BrandeisFormat) {
        this.isBrandeisFormat = BrandeisFormat;
    }

    public void setSpectrum(CSpectrum spectrum) {
        this.mSpectrum = spectrum;
        this.mDerivationMethod = spectrum.getDerivationMethod();
        this.mMetal = spectrum.getMetal();
        this.mPermethylated = spectrum.getPermethyldated();
        this.mReducingEnd = spectrum.getReducingEndMode();
        if (this.mReconstructionPPM < 0.0) {
            this.mReconstructionPPM = spectrum.getMassAccuracyPPM();
        }
        this.mDescription = "Metal: " + spectrum.getMetal() + "\nPrecursor: " + spectrum.getPrecursorRawMZ();
        String temp = null;
        temp = spectrum.getDerivationMethod();
        if (temp != null) {
            this.mDescription = String.valueOf(this.mDescription) + "\nDerivation: " + temp;
        }
        if ((temp = spectrum.getReducingEndMode()) != null) {
            this.mDescription = String.valueOf(this.mDescription) + "\nReducing end mode: " + temp;
        }
        Double massAccu = -1.0;
        massAccu = spectrum.getMassAccuracyPPM();
        if (massAccu > 0.0) {
            this.mDescription = String.valueOf(this.mDescription) + "\nMass accuracy (PPM): " + massAccu;
        }
    }

    public CSpectrum getSpectrum() {
        return this.mSpectrum;
    }

    public void setFilePath(String path, String file) {
        this.mPath = path;
        this.mFileName = file;
    }

    public String getFilePath() {
        return String.valueOf(this.mPath) + System.getProperty("file.separator") + this.mFileName;
    }

    public String getPath() {
        return this.mPath;
    }

    public boolean isPathValid() {
        return this.mPath != null && this.mFileName != null && this.mEntry != null;
    }

    public String getDerivationMethod() {
        return this.mDerivationMethod;
    }

    public void setDerivationMethod(String derivation) {
        this.mDerivationMethod = derivation;
    }

    public void setExperimentType(String type) {
        this.mExperimentType = type;
    }

    public String[] getLegalExperimentType() {
        return this.legal_exp_type;
    }

    public String getExperimentType() {
        return this.mExperimentType;
    }

    public void setReconstructionPPM(double ppm) {
        this.mReconstructionPPM = ppm;
    }

    public double getReconstructionPPM() {
        return this.mReconstructionPPM;
    }

    public void setReconstructionBranchNumber(int num) {
        this.mReconstructionBranchNumber = num;
    }

    public int getReconstructionBranchNumber() {
        return this.mReconstructionBranchNumber;
    }

    public void setCheck2H(boolean check_2H) {
        this.mReconstructionCheck2H = check_2H;
    }

    public boolean getCheck2H() {
        return this.mReconstructionCheck2H;
    }

    public void setCheckGap(boolean check_gap) {
        this.mReconstructionCheckGap = check_gap;
    }

    public boolean getCheckGap() {
        return this.mReconstructionCheckGap;
    }

    public void setReducingEnd(String reducing_end) {
        this.mReducingEnd = reducing_end;
    }

    public String getReducingEnd() {
        return this.mReducingEnd;
    }

    public void setMetal(String metal) {
        this.mMetal = metal;
    }

    public String getMetal() {
        return this.mMetal;
    }

    public void setPermethylated(boolean permethylated) {
        this.mPermethylated = permethylated;
    }

    public boolean getPermethylated() {
        return this.mPermethylated;
    }

    public void setResName(String name) {
        this.mResultFileName = name;
    }

    public String getResName() {
        return this.mResultFileName;
    }

    public void setOptionalResName(String name) {
        this.mOptionalResultFileName = name;
    }

    public String getOptionalResName() {
        return this.mOptionalResultFileName;
    }

    public void setEntry(Entry entry) {
        this.mEntry = entry;
    }

    public Entry getEntry() {
        return this.mEntry;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public MSPropertyDataFile getDataFile() {
        return this.mDataFile;
    }

    public void setDataFile(MSPropertyDataFile dataFile) {
        this.mDataFile = dataFile;
    }

    public boolean isReconstructed() {
        int cgh;
        if (this.mCheck2H_previous == 0 || this.mCheckGap_previous == 0 || this.mPPM_previous == -1.0) {
            return false;
        }
        int c2h = this.mReconstructionCheck2H ? 1 : -1;
        int n = cgh = this.mReconstructionCheckGap ? 1 : -1;
        return c2h == this.mCheck2H_previous && cgh == this.mCheckGap_previous && this.mPPM_previous == this.mReconstructionPPM;
    }

    public void setReconstructed() {
        this.mCheck2H_previous = this.mReconstructionCheck2H ? 1 : -1;
        this.mCheckGap_previous = this.mReconstructionCheckGap ? 1 : -1;
        this.mPPM_previous = this.mReconstructionPPM;
    }

    public void updateResultName() {
        this.mResultFileName = String.valueOf(this.mResultFileName) + ".PPM" + Integer.toString((int)this.mReconstructionPPM);
        if (this.mReconstructionCheck2H) {
            this.mResultFileName = String.valueOf(this.mResultFileName) + ".2H";
        }
        if (this.mReconstructionCheckGap) {
            this.mResultFileName = String.valueOf(this.mResultFileName) + ".Gap";
        }
    }

    public boolean isValid() {
        if (this.isBrandeisFormat) {
            return this.mReconstructionPPM > 0.0;
        }
        return this.mExperimentType != null && this.mReducingEnd != null && this.mMetal != null && this.mReconstructionPPM > 0.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Parameter Setting {");
        sb.append("\n\tAbsoulte Path: " + this.getFilePath());
        sb.append("\n\tExperiment Type: " + this.mExperimentType);
        sb.append("\n\tDerivation method: " + this.mDerivationMethod);
        sb.append("\n\tPPM: " + this.mReconstructionPPM);
        sb.append("\n\tMetal: " + this.mMetal);
        sb.append("\n\tReducing End Method: " + this.mReducingEnd);
        sb.append("\n}");
        return sb.toString();
    }
}

