/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import java.util.ArrayList;

public class HLightArrayList<T extends Comparable<? super T>>
extends ArrayList<T> {
    public boolean Ascend = true;
    public boolean AllowDuplication = false;
    public boolean Sorted = true;

    public HLightArrayList() {
    }

    public HLightArrayList(boolean sorted, boolean allowDuplication) {
        this.Sorted = sorted;
        this.AllowDuplication = allowDuplication;
    }

    @Override
    public boolean add(T data) {
        if (this.Sorted && this.size() > 0) {
            float r = this.rank(data);
            int closestInd = (int)(r + 0.5f);
            if ((float)closestInd == r) {
                if (this.AllowDuplication) {
                    super.add(closestInd, data);
                    return true;
                }
                return false;
            }
            super.add(closestInd, data);
            return true;
        }
        return super.add(data);
    }

    public T addOne(T data) {
        if (this.Sorted && this.size() > 0) {
            float r = this.rank(data);
            int closestInd = (int)(r + 0.5f);
            if ((float)closestInd == r) {
                if (this.AllowDuplication) {
                    super.add(closestInd, data);
                    return data;
                }
                return (T)((Comparable)this.get(closestInd));
            }
            super.add(closestInd, data);
            return data;
        }
        super.add(data);
        return data;
    }

    @Override
    public boolean addAll(HLightArrayList<T> data) {
        if (data == null) {
            return false;
        }
        for (Comparable item : data) {
            this.add((T)item);
        }
        return true;
    }

    public float rank(T obj) {
        if (obj == null) {
            return -1.0f;
        }
        int c = 0;
        int left = 0;
        int right = this.size() - 1;
        int mid = right / 2;
        if (right < left) {
            return -1.0f;
        }
        float offset = this.Ascend ? 0.5f : -0.5f;
        while (right >= left) {
            Comparable middle_obj = (Comparable)this.get(mid);
            c = middle_obj.compareTo(obj);
            if (c == 0) {
                return mid;
            }
            if (c < 0) {
                if (left == right) {
                    return (float)mid + offset;
                }
                if (this.Ascend) {
                    left = mid + 1;
                } else {
                    right = mid;
                }
                mid = (left + right) / 2;
                continue;
            }
            if (left == right) {
                return (float)mid - offset;
            }
            if (this.Ascend) {
                right = mid;
            } else {
                left = mid + 1;
            }
            mid = (left + right) / 2;
        }
        return -1.0f;
    }

    public int binarySearch(T obj) {
        float r = this.rank(obj);
        int closest = (int)(r + 0.5f);
        if ((float)closest == r) {
            return closest;
        }
        return -1;
    }

    @Override
    public boolean remove(T obj) {
        if (obj == null) {
            return true;
        }
        if (this.Sorted) {
            int index = this.binarySearch(obj);
            if (index >= 0) {
                super.remove(index);
                return true;
            }
            return false;
        }
        return super.remove(obj);
    }

    @Override
    public int indexOf(T obj) {
        if (this.Sorted) {
            return this.binarySearch(obj);
        }
        return super.indexOf(obj);
    }

    public void sort() {
        this.sort(0, this.size() - 1);
    }

    private void sort(int p, int r) {
        if (p < r) {
            int q = this.partition(p, r);
            this.sort(p, q);
            this.sort(q + 1, r);
        }
    }

    private int partition(int p, int r) {
        Comparable x = (Comparable)this.get(p);
        int c = 0;
        int i = p - 1;
        int j = r + 1;
        while (true) {
            Comparable temp = (Comparable)this.get(--j);
            c = this.compare((String)((Object)temp), (String)((Object)x));
            if (!this.Ascend) {
                c = -c;
            }
            if (c > 0) continue;
            do {
                temp = (Comparable)this.get(++i);
                c = this.compare((String)((Object)temp), (String)((Object)x));
                if (this.Ascend) continue;
                c = -c;
            } while (c < 0);
            if (i >= j) break;
            temp = (Comparable)this.get(i);
            this.set(i, (Comparable)this.get(j));
            this.set(j, temp);
        }
        return j;
    }

    private int compare(String obj1, String obj2) {
        int len2;
        int len1 = obj1.length();
        int result = len1 < (len2 = obj2.length()) ? -1 : (len1 > len2 ? 1 : obj1.compareTo(obj2));
        return result;
    }
}

