/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.HLightArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class CTopology
implements Comparable<CTopology> {
    protected String mType;
    protected double mMass;
    protected int mRootMonoClassID;
    protected String mFormula;
    protected String mGWAFormula;
    protected double mScore;
    protected int[] mCopositionCount = new int[8];
    protected int mMinusH = 0;
    protected ArrayList<CPeak> mSupportPeaks = null;
    protected HLightArrayList<CTopology> mChildrenTopologies = null;

    public CTopology(String formula, String gwaFormula, int ClassID, Set<CPeak> peaks, double size, double mass, String type, int[] compositionCountMerged) {
        this.mFormula = formula;
        this.mGWAFormula = gwaFormula;
        this.mRootMonoClassID = ClassID;
        this.mSupportPeaks = new ArrayList<CPeak>(peaks);
        Collections.sort(this.mSupportPeaks);
        this.mScore = size;
        this.mMass = mass;
        this.mType = type;
        this.mCopositionCount = compositionCountMerged;
        this.mMinusH = 0;
    }

    public String getFormula() {
        return this.mFormula;
    }

    public String getGWAFormula() {
        return this.mGWAFormula;
    }

    public String getType() {
        return this.mType;
    }

    public void addSupportPeak(CPeak peak) {
        if (peak == null) {
            return;
        }
        if (this.mSupportPeaks == null) {
            this.mSupportPeaks = new ArrayList();
            this.mSupportPeaks.add(peak);
        } else if (this.mSupportPeaks.indexOf((Object)peak) < 0) {
            this.mSupportPeaks.add(peak);
        }
    }

    public void addSupportPeaks(ArrayList<CPeak> peaks) {
        if (peaks == null) {
            return;
        }
        if (this.mSupportPeaks == null) {
            this.mSupportPeaks = new ArrayList();
        }
        for (CPeak peak : peaks) {
            if (this.mSupportPeaks.indexOf((Object)peak) >= 0) continue;
            this.mSupportPeaks.add(peak);
        }
    }

    public int numberOfSupportPeaks() {
        if (this.mSupportPeaks == null) {
            return 0;
        }
        return this.mSupportPeaks.size();
    }

    public CTopology addChild(CTopology c) {
        if (this.mChildrenTopologies == null) {
            this.mChildrenTopologies = new HLightArrayList(true, true);
        }
        return this.mChildrenTopologies.addOne(c);
    }

    public void getDescendantGWAFormula(HLightArrayList<String> descendant) {
        descendant.add(this.mGWAFormula);
        if (this.mChildrenTopologies != null) {
            for (CTopology ctp : this.mChildrenTopologies) {
                ctp.getDescendantGWAFormula(descendant);
            }
        }
    }

    public ArrayList<CPeak> getSupportPeaks() {
        return this.mSupportPeaks;
    }

    public double getScore() {
        return this.mScore;
    }

    @Override
    public int compareTo(CTopology o) {
        int temp = this.mType.compareTo(o.mType);
        if (temp == 0) {
            int result = this.mFormula.compareTo(o.mFormula);
            if (result == 0) {
                return -Double.compare(this.mScore, o.mScore);
            }
            return result;
        }
        return temp;
    }

    public void sortSupportPeaks() {
        Collections.sort(this.mSupportPeaks, new Comparator<CPeak>(){

            @Override
            public int compare(CPeak c1, CPeak c2) {
                ArrayList<CPeak> peaklist = c1.mSpectrum.getPeakList();
                return peaklist.indexOf((Object)c1) - peaklist.indexOf((Object)c2);
            }
        });
    }
}

