/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CMass;
import edu.brandeis.glycodenovo.core.CSpectrum;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySuperSet;
import java.util.ArrayList;
import org.grits.toolbox.ms.om.data.Peak;

public class CPeak
extends Peak {
    protected CSpectrum mSpectrum;
    protected int mID = -1;
    private double mMass = -1.0;
    private double mMassLowBound = -1.0;
    private double mMassHighBound = -1.0;
    private double mRawMZ = -1.0;
    private int mRawZ = -1;
    private double mIntensity = -1.0;
    private CPeak mComplementPeak = null;
    private ArrayList<CPeak> mOriginalPeaks = null;
    private ArrayList<CTopologySuperSet> mInferredSuperSets = new ArrayList();
    private ArrayList<String> mInferredFormulas;
    private ArrayList<CTopology> mInferredTopologies;
    private ArrayList<String> mInferredGWAFormulas;
    private ArrayList<Double> mInferredMasses;
    private ArrayList<Integer> mInferredScores;
    private ArrayList<Double> mInferredDoubleScores;

    public CPeak(int peakid, int complement, double mass, double rawMZ, int rawZ, double intensity) {
        this.mID = peakid;
        this.mMass = mass;
        this.mRawMZ = rawMZ;
        this.mRawZ = rawZ;
        this.mIntensity = intensity;
    }

    public CPeak(CSpectrum spectrum, double intensity, double rawMZ, int rawZ) {
        this.mSpectrum = spectrum;
        this.mRawMZ = rawMZ;
        this.mRawZ = rawZ;
        this.mIntensity = intensity;
        super.setCharge(Integer.valueOf(rawZ));
        super.setIntensity(Double.valueOf(intensity));
        super.setMz(Double.valueOf(rawMZ));
    }

    public CPeak(CSpectrum spectrum, double mass, double intensity, double rawMZ, int rawZ) {
        this(spectrum, intensity, rawMZ, rawZ);
        this.mMass = mass;
    }

    public CPeak(CSpectrum spectrum, double mass, double intensity, double rawMZ, int rawZ, double massHigh, double massLow) {
        this(spectrum, intensity, rawMZ, rawZ);
        this.mMass = mass;
        this.mMassLowBound = massLow;
        this.mMassHighBound = massHigh;
    }

    public CPeak(CSpectrum spectrum, double mass, double intensity, CPeak complement, double massHigh, double massLow) {
        this.mSpectrum = spectrum;
        this.mMass = mass;
        this.mMassLowBound = massLow;
        this.mMassHighBound = massHigh;
        this.mComplementPeak = complement;
        this.mIntensity = intensity;
        super.setIntensity(Double.valueOf(intensity));
        super.setCharge(Integer.valueOf(1));
        super.setMz(Double.valueOf(mass));
    }

    public void setID(int id) {
        super.setId(Integer.valueOf(id));
    }

    public int compareTo(Peak peak) {
        if (peak.getClass().equals(((Object)((Object)this)).getClass())) {
            double otherMass;
            double thisMass = this.getMass();
            if (thisMass > 0.0 && (otherMass = ((CPeak)peak).getMass()) > 0.0) {
                return Double.compare(thisMass, otherMass);
            }
            return Double.compare(this.getRawMZ(), ((CPeak)peak).getRawMZ());
        }
        return Double.compare(this.getMz(), peak.getMz());
    }

    public ArrayList<Double> protonate() {
        double rawMZ = this.mRawMZ * (double)this.mRawZ;
        double metalMass = CMass.getAtomMass(this.mSpectrum.getMetal());
        double metalMZ = -1.0;
        ArrayList<Double> protonatedMasses = new ArrayList<Double>();
        int i = 1;
        while (i <= this.mRawZ) {
            metalMZ = rawMZ - (double)i * (metalMass - 5.489E-4);
            protonatedMasses.add(metalMZ - (double)(this.mRawZ - i) * 1.007276432 + 1.007276432);
            ++i;
        }
        return protonatedMasses;
    }

    public Double getIntensity() {
        return this.mIntensity;
    }

    public double getRawMZ() {
        return this.mRawMZ;
    }

    public int getRawZ() {
        return this.mRawZ;
    }

    public double getMass() {
        return this.mMass;
    }

    public double getMassLowBound() {
        return this.mMassLowBound;
    }

    public double getMassHighBound() {
        return this.mMassHighBound;
    }

    public CSpectrum getSpectrum() {
        return this.mSpectrum;
    }

    public ArrayList<CTopologySuperSet> getInferredSuperSets() {
        return this.mInferredSuperSets;
    }

    public ArrayList<String> getInferredGWAFormulas() {
        return this.mInferredGWAFormulas;
    }

    public void setInferredGWAFormulas(ArrayList<String> formulas) {
        this.mInferredGWAFormulas = formulas;
    }

    public ArrayList<String> getInferredFormulas() {
        return this.mInferredFormulas;
    }

    public void setInferredFormulas(ArrayList<String> formulas) {
        this.mInferredFormulas = formulas;
    }

    public ArrayList<CTopology> getInferredTopologies() {
        return this.mInferredTopologies;
    }

    public void setInferredTopologies(ArrayList<CTopology> topologies) {
        this.mInferredTopologies = topologies;
    }

    public ArrayList<Double> getInferredMasses() {
        return this.mInferredMasses;
    }

    public void setInferredMasses(ArrayList<Double> masses) {
        this.mInferredMasses = masses;
    }

    public ArrayList<Integer> getInferredScores() {
        return this.mInferredScores;
    }

    public void setInferredScores(ArrayList<Integer> scores) {
        this.mInferredScores = scores;
    }

    public ArrayList<CPeak> getOriginalPeaks() {
        return this.mOriginalPeaks;
    }

    public void addOriginalPeak(CPeak ori) {
        if (this.mOriginalPeaks == null) {
            this.mOriginalPeaks = new ArrayList();
            this.mOriginalPeaks.add(ori);
        } else {
            for (CPeak a : this.mOriginalPeaks) {
                if (a != ori) continue;
                return;
            }
            this.mOriginalPeaks.add(ori);
        }
    }

    public void setOriginalPeaks(ArrayList<CPeak> oriPeaks) {
        this.mOriginalPeaks = oriPeaks;
    }

    public CPeak getComplementPeak() {
        return this.mComplementPeak;
    }

    public void setComplementPeak(CPeak complement) {
        this.mComplementPeak = complement;
    }

    public boolean isComplement() {
        return this.mRawMZ < 0.0;
    }

    public boolean isProtonated() {
        return !(this.mMass < 0.0);
    }

    void clearInferred() {
        if (this.mInferredSuperSets != null) {
            this.mInferredSuperSets.clear();
        }
        if (this.mInferredFormulas != null) {
            this.mInferredFormulas.clear();
        }
        if (this.mInferredMasses != null) {
            this.mInferredMasses.clear();
        }
        if (this.mInferredScores != null) {
            this.mInferredScores.clear();
        }
    }

    public void setInferredDoubleScores(ArrayList<Double> x) {
        this.mInferredDoubleScores = x;
    }

    public ArrayList<Double> getInferredDoubleScores() {
        return this.mInferredDoubleScores;
    }

    public void addOriginalPeaks(ArrayList<CPeak> add) {
        if (this.mOriginalPeaks == null) {
            this.mOriginalPeaks = new ArrayList();
        }
        this.mOriginalPeaks.addAll(add);
    }

    public String toString() {
        String out = "mass: " + this.getMass() + ", m/z: " + this.getMz() + ", intensity: " + this.getIntensity() + ", charge: " + this.getCharge();
        return out;
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return Math.abs(this.getMz() - ((CPeak)((Object)object)).getMz()) < 1.0E-4;
    }
}

