/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CMass;
import edu.brandeis.glycodenovo.core.CMonosaccharide;
import edu.brandeis.glycodenovo.core.CMonosaccharideSet;
import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CSpectrum;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySet;
import edu.brandeis.glycodenovo.core.CTopologySuperSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CGlycoDeNovo {
    static String[] cMonosaccharideClasses = new String[]{"Xyl", "Fuc", "Hex", "HexA", "HexNAc", "Kdo", "NeuAc", "NeuGc"};
    private CMonosaccharide[] cMonosaccharideArrays = new CMonosaccharide[cMonosaccharideClasses.length];
    static boolean[][] cLegalGlycosidicBonds;
    double mMassAccuracyPPM = 5.0;
    double mMassAccuracyPP = 5.0E-7;
    double mMassAccuracyDalton = 0.005;
    int mMaxBranchingNum = 2;
    double mIonMass = 0.0;
    String mIonMetal;
    double mIntensityThreshold = 0.0;
    boolean mNLinked = false;
    boolean mPermethylated = false;
    String mReducingEndMode;
    double mReducingEndCompensation = 0.0;
    double mFinalPeakCompensation = 0.0;
    int[] mCompositionCountThreshold = new int[8];
    boolean mCheckMinus2H = false;
    boolean mCheckGap = false;
    String mComment;
    ArrayList<CPeak> mPeaks;
    ArrayList<CTopologySuperSet> mTopologySuperSets;
    ArrayList<String> mPossibleMonosaccharideClasses = null;
    private Delta mDelta;
    private Delta2 mDelta2;
    private int mNumPeaks = 0;
    private CPeak mCurrentPeak = null;
    private int mCurrentPeakIdx = -1;
    private boolean mFinalPeak = false;
    private double mCurrentTargetMass = 0.0;
    private double mCurrentTargetMassLow = 0.0;
    private double mCurrentTargetMassHigh = 0.0;
    private int mCurrentTPSuperSetSize = 0;
    private boolean mTryCIon = false;
    private boolean mLeafPeak = false;
    private CTopologySuperSet mCurrentTopologySuperSetB;
    private CTopologySuperSet mCurrentTopologySuperSetB2;
    private CTopologySuperSet mCurrentTopologySuperSetC;
    private CTopologySuperSet mCurrentTopologySuperSetC2;
    private CTopologySuperSet[] mCurrentBranches;

    static {
        boolean[][] blArrayArray = new boolean[8][];
        blArrayArray[0] = new boolean[]{true, true, true, true, true, true, true, true};
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArrayArray[1] = blArray;
        boolean[] blArray2 = new boolean[8];
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArrayArray[2] = blArray2;
        boolean[] blArray3 = new boolean[8];
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        blArray3[5] = true;
        blArray3[6] = true;
        blArray3[7] = true;
        blArrayArray[3] = blArray3;
        boolean[] blArray4 = new boolean[8];
        blArray4[2] = true;
        blArray4[3] = true;
        blArray4[4] = true;
        blArray4[5] = true;
        blArray4[6] = true;
        blArray4[7] = true;
        blArrayArray[4] = blArray4;
        boolean[] blArray5 = new boolean[8];
        blArray5[2] = true;
        blArray5[3] = true;
        blArray5[4] = true;
        blArray5[5] = true;
        blArray5[6] = true;
        blArray5[7] = true;
        blArrayArray[5] = blArray5;
        boolean[] blArray6 = new boolean[8];
        blArray6[2] = true;
        blArray6[3] = true;
        blArray6[4] = true;
        blArray6[5] = true;
        blArray6[6] = true;
        blArray6[7] = true;
        blArrayArray[6] = blArray6;
        boolean[] blArray7 = new boolean[8];
        blArray7[2] = true;
        blArray7[3] = true;
        blArray7[4] = true;
        blArray7[5] = true;
        blArray7[6] = true;
        blArray7[7] = true;
        blArrayArray[7] = blArray7;
        cLegalGlycosidicBonds = blArrayArray;
    }

    public CGlycoDeNovo(String fileName) {
        this.mPeaks = new ArrayList();
        Scanner sc = null;
        File specFile = new File(fileName);
        try {
            sc = new Scanner(specFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("No such file");
        }
        String currentLine = sc.nextLine().trim();
        while (currentLine.startsWith("#")) {
            Pattern p1 = Pattern.compile("Check -2H");
            Pattern p2 = Pattern.compile("Allow gap");
            Matcher m1 = p1.matcher(currentLine);
            Matcher m2 = p2.matcher(currentLine);
            if (m1.find()) {
                this.mCheckMinus2H = currentLine.charAt(currentLine.length() - 1) != '\u0000';
            } else if (m2.find()) {
                this.mCheckGap = currentLine.charAt(currentLine.length() - 1) != '\u0000';
            } else {
                this.mComment = currentLine;
            }
            currentLine = sc.nextLine().trim();
        }
        while (sc.hasNextLine()) {
            String currLine = sc.nextLine().trim();
            Scanner lineSc = new Scanner(currLine);
            if (!lineSc.hasNext()) continue;
            String head = lineSc.next();
            if (head.equals("@")) {
                int peakid = 0;
                int complement = 0;
                int rawZ = 0;
                double mass = 0.0;
                double rawMZ = 0.0;
                double intensity = 0.0;
                while (lineSc.hasNext()) {
                    String read = lineSc.next();
                    if (read.equals("Peak")) {
                        peakid = lineSc.nextInt() - 1;
                        continue;
                    }
                    if (read.equals("complement")) {
                        complement = lineSc.nextInt();
                        continue;
                    }
                    if (read.equals("mass")) {
                        mass = lineSc.nextDouble();
                        continue;
                    }
                    if (read.equals("rawMZ")) {
                        rawMZ = lineSc.nextDouble();
                        continue;
                    }
                    if (read.equals("rawZ")) {
                        rawZ = lineSc.nextInt();
                        continue;
                    }
                    if (!read.equals("intensity")) continue;
                    intensity = lineSc.nextDouble();
                }
                this.mPeaks.add(new CPeak(peakid, complement, mass, rawMZ, rawZ, intensity));
            }
            if (!head.equals("**")) continue;
            String formula = "";
            HashSet<CPeak> peaks = new HashSet<CPeak>();
            while (lineSc.hasNext()) {
                String read = lineSc.next();
                if (read.equals("Peak")) {
                    int cfr_ignored_0 = lineSc.nextInt() - 1;
                    continue;
                }
                if (read.equals("type")) {
                    lineSc.next();
                    continue;
                }
                if (read.equals("Formula")) {
                    String rread = lineSc.next();
                    while (!rread.equals("\\Formula")) {
                        formula = String.valueOf(formula) + " " + rread;
                        rread = lineSc.next();
                    }
                    continue;
                }
                if (read.equals("Peaks")) {
                    while (lineSc.hasNextInt()) {
                        peaks.add(this.mPeaks.get(lineSc.nextInt() - 1));
                    }
                    lineSc.next();
                    continue;
                }
                if (!read.equals("Scores")) continue;
                lineSc.next();
                lineSc.nextDouble();
            }
        }
    }

    public CGlycoDeNovo(double massAccuracyPPM) {
        this.mMassAccuracyPPM = massAccuracyPPM;
        this.mMassAccuracyPP = this.mMassAccuracyPPM / 1000000.0;
        Arrays.fill(this.mCompositionCountThreshold, 8000);
    }

    public CGlycoDeNovo(double massAccuracyPPM, boolean checkMinus2H, boolean checkGap) {
        this.mCheckMinus2H = checkMinus2H;
        this.mCheckGap = checkGap;
        this.mMassAccuracyPPM = massAccuracyPPM;
        this.mMassAccuracyPP = this.mMassAccuracyPPM / 1000000.0;
        Arrays.fill(this.mCompositionCountThreshold, 8000);
    }

    public void setMaxBranchNum(int num) {
        if (num > 1 && num < 5) {
            this.mMaxBranchingNum = num;
        }
    }

    private boolean acceptable_monosaccharide(String monoClass) {
        if (this.mPossibleMonosaccharideClasses == null || this.mPossibleMonosaccharideClasses.size() == 0) {
            return true;
        }
        return this.mPossibleMonosaccharideClasses.indexOf(monoClass) >= 0;
    }

    public void interpretPeaks(CSpectrum spec) {
        block23: {
            block22: {
                if (!spec.isProtonated()) break block22;
                this.mIonMetal = "Proton";
                this.mIonMass = 1.007276432;
                break block23;
            }
            switch (this.mIonMetal = spec.getMetal()) {
                case "Lithium": {
                    this.mIonMass = 7.0149064836;
                }
                case "Sodium": 
                case "Na": {
                    this.mIonMass = 22.9892201;
                    break;
                }
                default: {
                    throw new InvalidParameterException("ionMetal not found");
                }
            }
        }
        this.mMassAccuracyDalton = spec.getPrecursorMZ() * this.mMassAccuracyPP;
        this.mPermethylated = spec.isPermethylated();
        this.mNLinked = spec.isNLinked();
        this.mReducingEndMode = spec.getReducingEndMode();
        if (this.mReducingEndMode != null) {
            this.mReducingEndCompensation = CMass.reducingEndMassCompensation(this.mReducingEndMode, this.mPermethylated);
        }
        this.mFinalPeakCompensation = this.mPermethylated ? this.mReducingEndCompensation + 14.0156500642 + 18.0105646863 : this.mReducingEndCompensation;
        int i = 0;
        while (i < cMonosaccharideClasses.length) {
            this.cMonosaccharideArrays[i] = new CMonosaccharide(cMonosaccharideClasses[i], this.mPermethylated);
            ++i;
        }
        this.mDelta = new Delta(cMonosaccharideClasses.length, this.mPermethylated);
        this.mDelta2 = new Delta2(cMonosaccharideClasses.length, this.mPermethylated);
        spec.clearInferred();
        this.mPeaks = spec.getPeaks(0);
        this.mNumPeaks = this.mPeaks.size();
        this.mCurrentPeakIdx = -1;
        this.mTopologySuperSets = new ArrayList();
        this.mFinalPeak = false;
        spec.updatePeakIDs();
        int k = 0;
        while (k < this.mPeaks.size()) {
            this.mCurrentPeak = this.mPeaks.get(k);
            if (!(this.mCurrentPeak.getIntensity() < this.mIntensityThreshold)) {
                this.mCurrentTargetMass = this.mCurrentPeak.getMass();
                if (!(this.mPermethylated ? this.mCurrentTargetMass < 175.0 : this.mCurrentTargetMass < 131.0)) {
                    this.mCurrentPeakIdx = k;
                    this.mCurrentTargetMassLow = this.mCurrentPeak.getMassLowBound();
                    this.mCurrentTargetMassHigh = this.mCurrentPeak.getMassHighBound();
                    this.mCurrentTopologySuperSetB = null;
                    this.mCurrentTopologySuperSetB2 = null;
                    this.mCurrentTopologySuperSetC = null;
                    this.mCurrentTopologySuperSetC2 = null;
                    this.mCurrentTPSuperSetSize = this.mTopologySuperSets.size();
                    this.mCurrentBranches = new CTopologySuperSet[4];
                    if (this.mCurrentPeakIdx == this.mNumPeaks - 1) {
                        this.mTryCIon = false;
                        this.mFinalPeak = true;
                    } else {
                        this.mTryCIon = true;
                        double bIonMassLow = this.mCurrentTargetMassLow - 18.0105646863;
                        double bIonMassHigh = this.mCurrentTargetMassHigh - 18.0105646863;
                        int m = this.mCurrentTPSuperSetSize - 1;
                        while (m >= 0) {
                            CTopologySuperSet ctss = this.mTopologySuperSets.get(m);
                            if (ctss.mType.equals("C") || bIonMassLow < ctss.mMassLow || bIonMassHigh > ctss.mMassHigh) {
                                // empty if block
                            }
                            --m;
                        }
                    }
                    this.interpretAPeak();
                    if (this.mFinalPeak && this.mCurrentTopologySuperSetB == null && this.mCurrentTopologySuperSetC == null) {
                        this.appendNLinkedRoot();
                    }
                    this.addCurrentTSSToPool();
                }
            }
            ++k;
        }
        System.out.println("CGlycoDeNovo::interpretPeaks() done!");
    }

    private void appendNLinkedRoot() {
        double mass_error = this.mMassAccuracyPP * this.mPeaks.get(this.mPeaks.size() - 1).getMass();
        double targetMLow = this.mPeaks.get(this.mPeaks.size() - 1).getMass() - mass_error;
        double targetMHigh = this.mPeaks.get(this.mPeaks.size() - 1).getMass() + mass_error;
        double dMassBIonNoFuc = CMonosaccharideSet.GlcNAc.sacPermethylated.mass * 2.0 - (28.0313001284 * (double)(this.mPermethylated ? 1 : 0) + 18.0105646863) * 2.0 + this.mFinalPeakCompensation;
        CTopologySuperSet ssFuc = null;
        for (CTopologySuperSet mTSS : this.mTopologySuperSets) {
            for (CTopologySet cs : mTSS.mTopologySets) {
                if (cs.mRootMono.mClassID != 2 || cs.mBranches[0] != null) continue;
                ssFuc = mTSS;
                break;
            }
            if (ssFuc != null) break;
        }
        double dMassBIonWithFuc = 0.0;
        if (ssFuc != null) {
            dMassBIonWithFuc = dMassBIonNoFuc + CMonosaccharideSet.dHex.sacPermethylated.mass - (28.0313001284 * (double)(this.mPermethylated ? 1 : 0) + 18.0105646863);
        }
        int cidx = this.mTopologySuperSets.size() - 1;
        while (cidx >= 0) {
            CTopologySuperSet mTSS = this.mTopologySuperSets.get(cidx);
            double tMassLow = mTSS.mMassLow + dMassBIonNoFuc;
            double tMassHigh = mTSS.mMassHigh + dMassBIonNoFuc;
            if (tMassHigh < targetMLow - 2.0 && ssFuc == null) break;
            if (targetMHigh > tMassLow && targetMLow < tMassHigh) {
                CTopologySuperSet[] cTopologySuperSetArray = new CTopologySuperSet[4];
                cTopologySuperSetArray[0] = mTSS;
                this.insertIntoCurrentTSS(new CTopologySet("T", this.mCurrentTargetMass, tMassLow, tMassHigh, this.mDelta.B2B.unit[4], this.mDelta.B2B.unit[4], cTopologySuperSetArray, this));
            }
            if (ssFuc != null) {
                tMassLow = mTSS.mMassLow + dMassBIonWithFuc;
                tMassHigh = mTSS.mMassHigh + dMassBIonWithFuc;
                if (targetMHigh > tMassLow && targetMLow < tMassHigh) {
                    CTopologySuperSet[] cTopologySuperSetArray = new CTopologySuperSet[4];
                    cTopologySuperSetArray[0] = ssFuc;
                    cTopologySuperSetArray[1] = mTSS;
                    this.insertIntoCurrentTSS(new CTopologySet("T", this.mCurrentTargetMass, tMassLow, tMassHigh, this.mDelta.B2B.unit[4], this.mDelta.B2B.unit[4], cTopologySuperSetArray, this));
                    CTopologySuperSet[] cTopologySuperSetArray2 = new CTopologySuperSet[4];
                    cTopologySuperSetArray2[0] = ssFuc;
                    cTopologySuperSetArray2[1] = mTSS;
                    this.insertIntoCurrentTSS(new CTopologySet("T", this.mCurrentTargetMass, tMassLow, tMassHigh, this.mDelta.B2B.unit[4], this.mDelta.B2B.unit[4], 1, cTopologySuperSetArray2, this));
                }
            }
            --cidx;
        }
    }

    private void addCurrentTSSToPool() {
        int i;
        CPeak curPeak = this.mPeaks.get(this.mCurrentPeakIdx);
        if (this.mCurrentTopologySuperSetC2 != null) {
            if (this.mTopologySuperSets.isEmpty() || this.mCurrentTopologySuperSetC2.mMassLow > this.mTopologySuperSets.get((int)(this.mTopologySuperSets.size() - 1)).mMassLow) {
                this.mTopologySuperSets.add(this.mCurrentTopologySuperSetC2);
                curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetC2);
            } else {
                i = this.mTopologySuperSets.size() - 1;
                while (i >= 0) {
                    if (this.mTopologySuperSets.get(i).contains(this.mCurrentTopologySuperSetC2)) {
                        curPeak.getInferredSuperSets().add(this.mTopologySuperSets.get(i));
                        this.mTopologySuperSets.get(i).addPeak(this.mCurrentPeakIdx, 22);
                        break;
                    }
                    if (this.mCurrentTopologySuperSetC2.mMassLow > this.mTopologySuperSets.get((int)i).mMassLow) {
                        this.mTopologySuperSets.add(i + 1, this.mCurrentTopologySuperSetC2);
                        curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetC2);
                        break;
                    }
                    --i;
                }
            }
        }
        if (this.mCurrentTopologySuperSetC != null) {
            if (this.mTopologySuperSets.isEmpty() || this.mCurrentTopologySuperSetC.mMassLow > this.mTopologySuperSets.get((int)(this.mTopologySuperSets.size() - 1)).mMassLow) {
                this.mTopologySuperSets.add(this.mCurrentTopologySuperSetC);
                curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetC);
            } else {
                i = this.mTopologySuperSets.size() - 1;
                while (i >= 0) {
                    if (this.mTopologySuperSets.get(i).contains(this.mCurrentTopologySuperSetC)) {
                        curPeak.getInferredSuperSets().add(this.mTopologySuperSets.get(i));
                        this.mTopologySuperSets.get(i).addPeak(this.mCurrentPeakIdx, 2);
                        break;
                    }
                    if (this.mCurrentTopologySuperSetC.mMassLow > this.mTopologySuperSets.get((int)i).mMassLow) {
                        this.mTopologySuperSets.add(i + 1, this.mCurrentTopologySuperSetC);
                        curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetC);
                        break;
                    }
                    --i;
                }
            }
        }
        if (this.mCurrentTopologySuperSetB2 != null) {
            if (this.mTopologySuperSets.isEmpty() || this.mCurrentTopologySuperSetB2.mMassLow > this.mTopologySuperSets.get((int)(this.mTopologySuperSets.size() - 1)).mMassLow) {
                this.mTopologySuperSets.add(this.mCurrentTopologySuperSetB2);
                curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetB2);
            } else {
                i = this.mTopologySuperSets.size() - 1;
                while (i >= 0) {
                    if (this.mTopologySuperSets.get(i).contains(this.mCurrentTopologySuperSetB2)) {
                        curPeak.getInferredSuperSets().add(this.mTopologySuperSets.get(i));
                        this.mTopologySuperSets.get(i).addPeak(this.mCurrentPeakIdx, 21);
                        break;
                    }
                    if (this.mCurrentTopologySuperSetB2.mMassLow > this.mTopologySuperSets.get((int)i).mMassLow) {
                        this.mTopologySuperSets.add(i + 1, this.mCurrentTopologySuperSetB2);
                        curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetB2);
                        break;
                    }
                    --i;
                }
            }
        }
        if (this.mCurrentTopologySuperSetB != null) {
            this.mTopologySuperSets.add(this.mCurrentTopologySuperSetB);
            curPeak.getInferredSuperSets().add(this.mCurrentTopologySuperSetB);
        }
    }

    private void interpretAPeak() {
        if (this.mCurrentTargetMass < 438.0) {
            double massCompensationLow = this.mIonMass;
            if (this.mPermethylated) {
                massCompensationLow += 14.0156500642;
            }
            if (this.mFinalPeak) {
                massCompensationLow += this.mFinalPeakCompensation;
            }
            double massCompensationHigh = massCompensationLow * (1.0 + this.mMassAccuracyPP);
            this.mLeafPeak = true;
            if (this.testAddTopologySet(massCompensationLow *= 1.0 - this.mMassAccuracyPP, massCompensationHigh) == -1) {
                return;
            }
        }
        this.mLeafPeak = false;
        double[] branchMassesLow = new double[4];
        double[] branchMassesHigh = new double[4];
        int testAddResult = 0;
        double massD = this.mIonMass + (double)(this.mPermethylated ? 1 : 0) * 14.0156500642;
        int k = 0;
        while (k < this.mCurrentTPSuperSetSize) {
            this.mCurrentBranches[0] = this.mTopologySuperSets.get(k);
            if (this.mFinalPeak) {
                branchMassesLow[0] = this.mCurrentBranches[0].mMassLow + this.mFinalPeakCompensation * (1.0 - this.mMassAccuracyPP);
                branchMassesHigh[0] = this.mCurrentBranches[0].mMassHigh + this.mFinalPeakCompensation * (1.0 + this.mMassAccuracyPP);
            } else {
                branchMassesLow[0] = this.mCurrentBranches[0].mMassLow;
                branchMassesHigh[0] = this.mCurrentBranches[0].mMassHigh;
            }
            if (this.testAddTopologySet(branchMassesLow[0], branchMassesHigh[0]) == -1) break;
            int kk = k;
            while (kk < this.mCurrentTPSuperSetSize) {
                this.mCurrentBranches[1] = this.mTopologySuperSets.get(kk);
                branchMassesLow[1] = this.mCurrentBranches[1].mMassLow - massD;
                branchMassesHigh[1] = this.mCurrentBranches[1].mMassHigh - massD;
                if (this.testAddTopologySet(branchMassesLow[1] + branchMassesLow[0], branchMassesHigh[1] + branchMassesHigh[0]) == -1) break;
                if (this.mMaxBranchingNum >= 3 || this.mCheckGap) {
                    int kkk = kk;
                    while (kkk < this.mCurrentTPSuperSetSize) {
                        this.mCurrentBranches[2] = this.mTopologySuperSets.get(kkk);
                        branchMassesLow[2] = this.mCurrentBranches[2].mMassLow - massD * (1.0 + this.mMassAccuracyPP);
                        branchMassesHigh[2] = this.mCurrentBranches[2].mMassHigh - massD * (1.0 - this.mMassAccuracyPP);
                        testAddResult = this.mCheckGap && this.mMaxBranchingNum < 3 ? this.testAddTopologySet_2BranchWithGap(branchMassesLow[1] + branchMassesLow[0], branchMassesHigh[1] + branchMassesHigh[0]) : this.testAddTopologySet(branchMassesLow[2] + branchMassesLow[1] + branchMassesLow[0], branchMassesHigh[2] + branchMassesHigh[1] + branchMassesHigh[0]);
                        if (testAddResult == -1) break;
                        if (this.mMaxBranchingNum >= 4) {
                            int kkkk = kkk;
                            while (kkkk < this.mCurrentTPSuperSetSize) {
                                this.mCurrentBranches[3] = this.mTopologySuperSets.get(kkkk);
                                branchMassesLow[3] = this.mCurrentBranches[3].mMassLow - massD * (1.0 - this.mMassAccuracyPP);
                                branchMassesHigh[3] = this.mCurrentBranches[3].mMassHigh - massD * (1.0 + this.mMassAccuracyPP);
                                testAddResult = this.testAddTopologySet(branchMassesLow[3] + branchMassesLow[2] + branchMassesLow[1] + branchMassesLow[0], branchMassesHigh[3] + branchMassesHigh[2] + branchMassesHigh[1] + branchMassesHigh[0]);
                                if (testAddResult == -1) break;
                                ++kkkk;
                            }
                            this.mCurrentBranches[3] = null;
                            branchMassesLow[3] = 0.0;
                            branchMassesHigh[3] = 0.0;
                        }
                        ++kkk;
                    }
                    this.mCurrentBranches[2] = null;
                    branchMassesLow[2] = 0.0;
                    branchMassesHigh[2] = 0.0;
                }
                ++kk;
            }
            this.mCurrentBranches[1] = null;
            branchMassesLow[1] = 0.0;
            branchMassesHigh[1] = 0.0;
            ++k;
        }
        this.mCurrentBranches[0] = null;
        branchMassesLow[0] = 0.0;
        branchMassesHigh[0] = 0.0;
    }

    public void reconstructFormulas() {
        CPeak lastPeak = this.mPeaks.get(this.mPeaks.size() - 1);
        HashSet<CTopologySuperSet> frontier = new HashSet<CTopologySuperSet>(lastPeak.getInferredSuperSets());
        HashSet<CTopologySuperSet> buffer = new HashSet<CTopologySuperSet>(frontier);
        while (!frontier.isEmpty()) {
            ArrayList<CTopologySuperSet> newFrontier = new ArrayList<CTopologySuperSet>();
            for (CTopologySuperSet tss : frontier) {
                for (CTopologySet ts : tss.mTopologySets) {
                    ts.mTargetPeaks = tss.mTargetPeaks;
                    newFrontier.addAll(Arrays.asList(ts.mBranches));
                }
            }
            newFrontier.removeIf(Objects::isNull);
            frontier = new HashSet(newFrontier);
            buffer.addAll(frontier);
        }
        ArrayList<CTopologySuperSet> sortedUniqueTSS = new ArrayList<CTopologySuperSet>(buffer);
        Collections.sort(sortedUniqueTSS);
        for (CTopologySuperSet ts : sortedUniqueTSS) {
            ts.reconstructFormulas();
        }
        System.out.println("CGlycoDeNovo::reconstruct_formulas done!");
        for (CPeak peak : this.mPeaks) {
            peak.getInferredSuperSets().removeIf(e -> !e.mLegal);
            if (peak.getInferredSuperSets().isEmpty()) continue;
            peak.getInferredSuperSets().forEach(e -> Collections.sort(e.mTopologies));
            HashMap<String, CTopology> formulaToTSS = new HashMap<String, CTopology>();
            for (CTopologySuperSet superSet : peak.getInferredSuperSets()) {
                for (CTopology mTopology : superSet.mTopologies) {
                    formulaToTSS.putIfAbsent(mTopology.mFormula, mTopology);
                }
            }
            peak.setInferredFormulas(new ArrayList<String>(formulaToTSS.keySet()));
            peak.setInferredTopologies(new ArrayList<CTopology>(formulaToTSS.values()));
            int size = peak.getInferredFormulas().size();
            peak.setInferredMasses(new ArrayList<Double>(size));
            peak.setInferredScores(new ArrayList<Integer>(size));
            peak.setInferredGWAFormulas(new ArrayList<String>(size));
            for (String formula : peak.getInferredFormulas()) {
                peak.getInferredMasses().add(((CTopology)formulaToTSS.get((Object)formula)).mMass);
                peak.getInferredScores().add(((CTopology)formulaToTSS.get((Object)formula)).mSupportPeaks.size());
                peak.getInferredGWAFormulas().add(((CTopology)formulaToTSS.get((Object)formula)).mGWAFormula);
            }
        }
        ArrayList<String> formula = this.mPeaks.get(this.mPeaks.size() - 1).getInferredFormulas();
        if (formula == null || formula.size() == 0) {
            System.out.println("Failed to reconstruct topologies.");
        } else {
            System.out.printf("Reconstruct %d topologies.\n", formula.size());
            for (String s : formula) {
                System.out.println(s);
            }
        }
    }

    private int testAddTopologySet(double massCompensationLow, double massCompensationHigh) {
        int k;
        boolean failed;
        CTopologySet newTS;
        String ionType;
        int countH;
        int unitID;
        double theoreticalMassHigh;
        double theoreticalMassLow;
        CMonosaccharide newUnit;
        int result = 0;
        double temp = this.mCurrentTargetMass - massCompensationLow;
        if (this.mPermethylated) {
            if (temp < 160.0) {
                return -1;
            }
            if (this.mCheckGap ? temp > 860.0 : temp > 420.0) {
                return 0;
            }
        } else {
            if (temp < 105.0) {
                return -1;
            }
            if (this.mCheckGap ? temp > 660.0 : temp > 335.0) {
                return 0;
            }
        }
        ArrayList<Integer> unitIndexes = new ArrayList<Integer>();
        ArrayList<Integer> minusHCount = new ArrayList<Integer>();
        ArrayList<Double> lowMasses = new ArrayList<Double>();
        ArrayList<Double> highMasses = new ArrayList<Double>();
        int k2 = 0;
        while (k2 < this.mDelta.B2B.mass.length) {
            newUnit = this.mDelta.B2B.unit[k2];
            if (this.acceptable_monosaccharide(newUnit.mClass) && (newUnit.mClassID != 2 || this.mLeafPeak) && this.mCompositionCountThreshold[newUnit.mClassID - 1] >= 1) {
                theoreticalMassLow = this.mDelta.B2B.mass[k2] + massCompensationLow;
                theoreticalMassHigh = this.mDelta.B2B.mass[k2] + massCompensationHigh;
                if (this.mCurrentTargetMassHigh > theoreticalMassLow && this.mCurrentTargetMassLow < theoreticalMassHigh) {
                    unitIndexes.add(k2);
                    minusHCount.add(0);
                    lowMasses.add(theoreticalMassLow);
                    highMasses.add(theoreticalMassHigh);
                } else if (this.mCheckMinus2H && this.mCurrentTargetMassHigh + 2.0156500642 > theoreticalMassLow && this.mCurrentTargetMassLow + 2.0156500642 < theoreticalMassHigh) {
                    unitIndexes.add(k2);
                    minusHCount.add(2);
                    lowMasses.add(theoreticalMassLow);
                    highMasses.add(theoreticalMassHigh);
                }
            }
            ++k2;
        }
        int a = 0;
        while (a < unitIndexes.size()) {
            unitID = (Integer)unitIndexes.get(a);
            countH = (Integer)minusHCount.get(a);
            ionType = this.mFinalPeak ? "T" : "B";
            newTS = new CTopologySet(ionType, this.mCurrentTargetMass, (double)((Double)lowMasses.get(a)), (double)((Double)highMasses.get(a)), this.mDelta.B2B.unit[unitID], this.mCurrentBranches, this, countH);
            this.insertIntoCurrentTSS(newTS);
            result = 1;
            ++a;
        }
        boolean bl = failed = unitIndexes.size() == 0;
        if (this.mTryCIon) {
            unitIndexes.clear();
            minusHCount.clear();
            lowMasses.clear();
            highMasses.clear();
            k = 0;
            while (k < this.mDelta.B2C.mass.length) {
                newUnit = this.mDelta.B2C.unit[k];
                if (this.acceptable_monosaccharide(newUnit.mClass) && (newUnit.mClassID != 2 || this.mLeafPeak) && this.mCompositionCountThreshold[newUnit.mClassID - 1] >= 1) {
                    theoreticalMassLow = this.mDelta.B2C.mass[k] + massCompensationLow;
                    theoreticalMassHigh = this.mDelta.B2C.mass[k] + massCompensationHigh;
                    if (this.mCurrentTargetMassHigh > theoreticalMassLow && this.mCurrentTargetMassLow < theoreticalMassHigh) {
                        unitIndexes.add(k);
                        minusHCount.add(0);
                        lowMasses.add(theoreticalMassLow);
                        highMasses.add(theoreticalMassHigh);
                    } else if (this.mCheckMinus2H && this.mCurrentTargetMassHigh + 2.0156500642 > theoreticalMassLow && this.mCurrentTargetMassLow + 2.0156500642 < theoreticalMassHigh) {
                        unitIndexes.add(k);
                        minusHCount.add(2);
                        lowMasses.add(theoreticalMassLow);
                        highMasses.add(theoreticalMassHigh);
                    }
                }
                ++k;
            }
            int a2 = 0;
            while (a2 < unitIndexes.size()) {
                unitID = (Integer)unitIndexes.get(a2);
                countH = (Integer)minusHCount.get(a2);
                newTS = new CTopologySet("C", this.mCurrentTargetMass, (Double)lowMasses.get(a2) - 18.0105646863, (Double)highMasses.get(a2) - 18.0105646863, this.mDelta.B2C.unit[unitID], this.mCurrentBranches, this, countH);
                this.insertIntoCurrentTSS(newTS);
                result = 1;
                ++a2;
            }
        }
        boolean bl2 = failed = failed && unitIndexes.size() == 0;
        if (failed && this.mCheckGap) {
            int idxGapInBranch;
            CMonosaccharide newUnit2;
            if (this.mCurrentBranches[1] == null && this.mCurrentBranches[0] != null) {
                boolean possible = false;
                for (CTopologySet aTPS : this.mCurrentBranches[0].mTopologySets) {
                    if (aTPS.mRootMono.mClassID == 2) continue;
                    possible = true;
                    break;
                }
                if (!possible) {
                    return 0;
                }
            }
            unitIndexes.clear();
            minusHCount.clear();
            lowMasses.clear();
            highMasses.clear();
            k = 0;
            while (k < this.mDelta2.B2B.len) {
                theoreticalMassLow = this.mDelta2.B2B.mass[k] + massCompensationLow;
                theoreticalMassHigh = this.mDelta2.B2B.mass[k] + massCompensationHigh;
                if (this.mCurrentTargetMassHigh > theoreticalMassLow && this.mCurrentTargetMassLow < theoreticalMassHigh) {
                    unitIndexes.add(k);
                    minusHCount.add(0);
                    lowMasses.add(theoreticalMassLow);
                    highMasses.add(theoreticalMassHigh);
                } else if (this.mCheckMinus2H && this.mCurrentTargetMassHigh + 2.0156500642 > theoreticalMassLow && this.mCurrentTargetMassLow + 2.0156500642 < theoreticalMassHigh) {
                    unitIndexes.add(k);
                    minusHCount.add(2);
                    lowMasses.add(theoreticalMassLow);
                    highMasses.add(theoreticalMassHigh);
                }
                ++k;
            }
            int a3 = 0;
            while (a3 < unitIndexes.size()) {
                unitID = (Integer)unitIndexes.get(a3);
                CMonosaccharide newUnit1 = this.mDelta2.B2B.unit[unitID][0];
                if (newUnit1.mClassID != 2) {
                    newUnit2 = this.mDelta2.B2B.unit[unitID][1];
                    countH = (Integer)minusHCount.get(a3);
                    double cfr_ignored_0 = (double)countH * 1.0078250321;
                    ionType = this.mFinalPeak ? "T" : "B";
                    newTS = new CTopologySet(ionType, this.mCurrentTargetMass, (double)((Double)lowMasses.get(a3)), (double)((Double)highMasses.get(a3)), newUnit2, newUnit1, this.mCurrentBranches, this, countH);
                    this.insertIntoCurrentTSS(newTS);
                    result = 1;
                    idxGapInBranch = 0;
                    while (idxGapInBranch < 4) {
                        if (this.mCurrentBranches[idxGapInBranch] == null) break;
                        newTS = new CTopologySet(ionType, this.mCurrentTargetMass, (Double)lowMasses.get(a3), (Double)highMasses.get(a3), newUnit2, newUnit1, idxGapInBranch, this.mCurrentBranches, this, countH);
                        this.insertIntoCurrentTSS(newTS);
                        ++idxGapInBranch;
                    }
                }
                ++a3;
            }
            if (this.mTryCIon && !this.mFinalPeak) {
                unitIndexes.clear();
                minusHCount.clear();
                lowMasses.clear();
                highMasses.clear();
                int k3 = 0;
                while (k3 < this.mDelta2.B2C.len) {
                    theoreticalMassLow = this.mDelta2.B2C.mass[k3] + massCompensationLow;
                    theoreticalMassHigh = this.mDelta2.B2C.mass[k3] + massCompensationHigh;
                    if (this.mCurrentTargetMassHigh > theoreticalMassLow && this.mCurrentTargetMassLow < theoreticalMassHigh) {
                        unitIndexes.add(k3);
                        minusHCount.add(0);
                        lowMasses.add(theoreticalMassLow);
                        highMasses.add(theoreticalMassHigh);
                    } else if (this.mCheckMinus2H && this.mCurrentTargetMassHigh - 2.0156500642 > theoreticalMassLow && this.mCurrentTargetMassLow - 2.0156500642 < theoreticalMassHigh) {
                        unitIndexes.add(k3);
                        minusHCount.add(2);
                        lowMasses.add(theoreticalMassLow);
                        highMasses.add(theoreticalMassHigh);
                    }
                    ++k3;
                }
                a3 = 0;
                while (a3 < unitIndexes.size()) {
                    unitID = (Integer)unitIndexes.get(a3);
                    CMonosaccharide newUnit1 = this.mDelta2.B2C.unit[unitID][0];
                    if (newUnit1.mClassID != 2) {
                        newUnit2 = this.mDelta2.B2C.unit[unitID][1];
                        countH = (Integer)minusHCount.get(a3);
                        newTS = new CTopologySet("C", this.mCurrentTargetMass, (Double)lowMasses.get(a3) - 18.0105646863, (Double)highMasses.get(a3) - 18.0105646863, newUnit2, newUnit1, this.mCurrentBranches, this, countH);
                        this.insertIntoCurrentTSS(newTS);
                        result = 1;
                        idxGapInBranch = 0;
                        while (idxGapInBranch < 4) {
                            if (this.mCurrentBranches[idxGapInBranch] == null) break;
                            newTS = new CTopologySet("C", this.mCurrentTargetMass, (Double)lowMasses.get(a3) - 18.0105646863, (Double)highMasses.get(a3) - 18.0105646863, newUnit2, newUnit1, idxGapInBranch, this.mCurrentBranches, this, countH);
                            this.insertIntoCurrentTSS(newTS);
                            ++idxGapInBranch;
                        }
                    }
                    ++a3;
                }
            }
        }
        return result;
    }

    private int testAddTopologySet_2BranchWithGap(double massCompensationLow, double massCompensationHigh) {
        CTopologySet newTS;
        int countH;
        CMonosaccharide newUnit2;
        CMonosaccharide newUnit1;
        int unitID;
        double theoreticalMassHigh;
        double theoreticalMassLow;
        int result = 0;
        double linkageMassLoss = 18.0105646863 + (double)(3 * (this.mPermethylated ? 1 : 0)) * 14.0156500642;
        double temp = this.mCurrentTargetMass - massCompensationLow;
        if (this.mPermethylated) {
            if (temp < 160.0) {
                return -1;
            }
            if (this.mCheckGap ? temp > 860.0 : temp > 420.0) {
                return 0;
            }
        } else {
            if (temp < 105.0) {
                return -1;
            }
            if (this.mCheckGap ? temp > 660.0 : temp > 335.0) {
                return 0;
            }
        }
        if (this.mCheckGap) {
            boolean possible = false;
            if (this.mCurrentBranches[2] == null && this.mCurrentBranches[1] != null) {
                for (CTopologySet aTS : this.mCurrentBranches[1].mTopologySets) {
                    if (aTS.mRootMono.mClassID == 2) continue;
                    possible = true;
                    break;
                }
            }
            if (!possible) {
                return 0;
            }
        }
        ArrayList<Integer> unitIndexes = new ArrayList<Integer>();
        ArrayList<Integer> minusHCount = new ArrayList<Integer>();
        ArrayList<Double> massLow = new ArrayList<Double>();
        ArrayList<Double> massHigh = new ArrayList<Double>();
        int k = 0;
        while (k < this.mDelta2.B2B.mass.length) {
            theoreticalMassLow = this.mDelta2.B2B.mass[k] + massCompensationLow;
            theoreticalMassHigh = this.mDelta2.B2B.mass[k] + massCompensationHigh;
            if (this.mCurrentTargetMassHigh > theoreticalMassLow && this.mCurrentTargetMassLow < theoreticalMassHigh) {
                unitIndexes.add(k);
                minusHCount.add(0);
                massLow.add(theoreticalMassLow);
                massHigh.add(theoreticalMassHigh);
            }
            ++k;
        }
        if (!this.mFinalPeak && this.mCheckMinus2H) {
            k = 0;
            while (k < this.mDelta.B2B.mass.length) {
                theoreticalMassLow = this.mDelta2.B2B.mass[k] + massCompensationLow;
                theoreticalMassHigh = this.mDelta2.B2B.mass[k] + massCompensationHigh;
                if (this.mCurrentTargetMassHigh + 2.0156500642 > theoreticalMassLow && this.mCurrentTargetMassLow + 2.0156500642 < theoreticalMassHigh) {
                    unitIndexes.add(k);
                    minusHCount.add(2);
                    massLow.add(theoreticalMassLow);
                    massHigh.add(theoreticalMassHigh);
                }
                ++k;
            }
        }
        if (unitIndexes.size() > 0) {
            result = 1;
        }
        double massH = 0.0;
        int a = 0;
        while (a < unitIndexes.size()) {
            unitID = (Integer)unitIndexes.get(a);
            newUnit1 = this.mDelta2.B2B.unit[unitID][0];
            if (newUnit1.mClassID != 2) {
                newUnit2 = this.mDelta2.B2B.unit[unitID][1];
                double tempMassLow = this.mDelta2.B2B.mass[unitID] + massCompensationLow;
                double tempMassHigh = this.mDelta2.B2B.mass[unitID] + massCompensationHigh;
                countH = (Integer)minusHCount.get(a);
                massH = (double)countH * 1.0078250321;
                String ionType = this.mFinalPeak ? "T" : "B";
                newTS = new CTopologySet(ionType, this.mCurrentTargetMass, Math.max(tempMassLow, this.mCurrentTargetMassLow + massH), Math.min(tempMassHigh, this.mCurrentTargetMassHigh + massH), newUnit2, newUnit1, this.mCurrentBranches, this, countH);
                this.insertIntoCurrentTSS(newTS);
                int b = 0;
                while (b < 4) {
                    if (this.mCurrentBranches[b] == null) break;
                    newTS = new CTopologySet(ionType, this.mCurrentTargetMass, Math.max(tempMassLow, this.mCurrentTargetMassLow + massH), Math.min(tempMassHigh, this.mCurrentTargetMassHigh + massH), newUnit2, newUnit1, b, this.mCurrentBranches, this, countH);
                    this.insertIntoCurrentTSS(newTS);
                    ++b;
                }
            }
            ++a;
        }
        int a2 = 0;
        while (a2 < unitIndexes.size()) {
            unitID = (Integer)unitIndexes.get(a2);
            newUnit1 = this.mDelta2.B2B.unit[unitID][0];
            if (newUnit1.mClassID != 2) {
                newUnit2 = this.mDelta2.B2B.unit[unitID][1];
                countH = (Integer)minusHCount.get(a2);
                massH = (double)countH * 1.0078250321;
                double tempMassLow = Math.max(this.mDelta2.B2B.mass[unitID] + massCompensationLow, this.mCurrentTargetMassLow + massH);
                double tempMassHigh = Math.min(this.mDelta2.B2B.mass[unitID] + massCompensationHigh, this.mCurrentTargetMassHigh + massH);
                CTopologySet gapTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit1, this.mCurrentBranches, this, countH);
                gapTS.mBranches[2] = null;
                gapTS.mMassPeak -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[2].mMassPeak - 1.007276432);
                gapTS.mMassLow -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[2].mMassLow - 1.007276432);
                gapTS.mMassHigh -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[2].mMassHigh - 1.007276432);
                CTopologySuperSet gapSS = new CTopologySuperSet("B", gapTS.mMassPeak, this, this.mCurrentPeakIdx);
                gapSS.mMassHigh = gapTS.mMassHigh;
                gapSS.mMassLow = gapTS.mMassLow;
                gapSS.mTopologySets.add(gapTS);
                newTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit2, this.mCurrentBranches, this, countH);
                newTS.mBranches[0] = gapSS;
                newTS.mBranches[1] = this.mCurrentBranches[2];
                newTS.mBranches[2] = null;
                if (this.mFinalPeak) {
                    newTS.mType = "T";
                    newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 23);
                } else {
                    newTS.mType = "B";
                    newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 21);
                }
                this.insertIntoCurrentTSS(newTS);
                if (this.mCurrentBranches[1] != this.mCurrentBranches[2]) {
                    gapTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit1, this.mCurrentBranches, this, countH);
                    gapTS.mBranches[1] = this.mCurrentBranches[2];
                    gapTS.mBranches[2] = null;
                    gapTS.mMassPeak -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[1].mMassPeak - 1.007276432);
                    gapTS.mMassLow -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[1].mMassLow - 1.007276432);
                    gapTS.mMassHigh -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[1].mMassHigh - 1.007276432);
                    gapSS = new CTopologySuperSet("B", gapTS.mMassPeak, this, this.mCurrentPeakIdx);
                    gapSS.mMassHigh = gapTS.mMassHigh;
                    gapSS.mMassLow = gapTS.mMassLow;
                    gapSS.mTopologySets.add(gapTS);
                    newTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit2, this.mCurrentBranches, this, countH);
                    newTS.mBranches[0] = gapSS;
                    newTS.mBranches[1] = this.mCurrentBranches[1];
                    newTS.mBranches[2] = null;
                    if (this.mFinalPeak) {
                        newTS.mType = "T";
                        newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 23);
                    } else {
                        newTS.mType = "B";
                        newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 21);
                    }
                    this.insertIntoCurrentTSS(newTS);
                    if (this.mCurrentBranches[0] != this.mCurrentBranches[1]) {
                        gapTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit1, this.mCurrentBranches, this, countH);
                        gapTS.mBranches[0] = this.mCurrentBranches[1];
                        gapTS.mBranches[1] = this.mCurrentBranches[2];
                        gapTS.mBranches[2] = null;
                        gapTS.mMassPeak -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[0].mMassPeak - 1.007276432);
                        gapTS.mMassLow -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[0].mMassLow - 1.007276432);
                        gapTS.mMassHigh -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[0].mMassHigh - 1.007276432);
                        gapSS = new CTopologySuperSet("B", gapTS.mMassPeak, this, this.mCurrentPeakIdx);
                        gapSS.mMassHigh = gapTS.mMassHigh;
                        gapSS.mMassLow = gapTS.mMassLow;
                        gapSS.mTopologySets.add(gapTS);
                        newTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit2, this.mCurrentBranches, this, countH);
                        newTS.mBranches[0] = gapSS;
                        newTS.mBranches[1] = this.mCurrentBranches[0];
                        newTS.mBranches[2] = null;
                        if (this.mFinalPeak) {
                            newTS.mType = "T";
                            newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 23);
                        } else {
                            newTS.mType = "B";
                            newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 21);
                        }
                        this.insertIntoCurrentTSS(newTS);
                    }
                } else if (this.mCurrentBranches[0] != this.mCurrentBranches[1]) {
                    gapTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit1, this.mCurrentBranches, this, countH);
                    gapTS.mBranches[0] = this.mCurrentBranches[1];
                    gapTS.mBranches[1] = this.mCurrentBranches[2];
                    gapTS.mBranches[2] = null;
                    gapTS.mMassPeak -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[0].mMassPeak - 1.007276432);
                    gapTS.mMassLow -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[0].mMassLow - 1.007276432);
                    gapTS.mMassHigh -= newUnit2.mMass - linkageMassLoss - (this.mCurrentBranches[0].mMassHigh - 1.007276432);
                    gapSS = new CTopologySuperSet("B", gapTS.mMassPeak, this, this.mCurrentPeakIdx);
                    gapSS.mMassHigh = gapTS.mMassHigh;
                    gapSS.mMassLow = gapTS.mMassLow;
                    gapSS.mTopologySets.add(gapTS);
                    newTS = new CTopologySet("B", this.mCurrentTargetMass, tempMassLow, tempMassHigh, newUnit2, this.mCurrentBranches, this, countH);
                    newTS.mBranches[0] = gapSS;
                    newTS.mBranches[1] = this.mCurrentBranches[0];
                    newTS.mBranches[2] = null;
                    if (this.mFinalPeak) {
                        newTS.mType = "T";
                        newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 23);
                    } else {
                        newTS.mType = "B";
                        newTS.mTargetPeaks.put(this.mCurrentPeakIdx, 21);
                    }
                    this.insertIntoCurrentTSS(newTS);
                }
            }
            ++a2;
        }
        return result;
    }

    private void insertIntoCurrentTSS(CTopologySet newSet) {
        CTopologySuperSet tss = null;
        if (newSet.mType.equals("B") || newSet.mType.equals("T")) {
            if (newSet.mMinusH == 0) {
                if (this.mCurrentTopologySuperSetB == null) {
                    this.mCurrentTopologySuperSetB = new CTopologySuperSet(newSet.mType, this.mCurrentTargetMass, this, this.mCurrentPeakIdx);
                }
                if (newSet.mType.equals("B")) {
                    this.mCurrentTopologySuperSetB.mTargetPeaks.put(this.mCurrentPeakIdx, 1);
                } else {
                    this.mCurrentTopologySuperSetB.mTargetPeaks.put(this.mCurrentPeakIdx, 3);
                }
                tss = this.mCurrentTopologySuperSetB;
            } else if (newSet.mMinusH == 2) {
                if (this.mCurrentTopologySuperSetB2 == null) {
                    this.mCurrentTopologySuperSetB2 = new CTopologySuperSet(newSet.mType, this.mCurrentTargetMass, this, this.mCurrentPeakIdx);
                    if (newSet.mType.equals("T")) {
                        this.mCurrentTopologySuperSetB2.mTargetPeaks.put(this.mCurrentPeakIdx, 23);
                    } else {
                        this.mCurrentTopologySuperSetB2.mTargetPeaks.put(this.mCurrentPeakIdx, 21);
                    }
                }
                tss = this.mCurrentTopologySuperSetB2;
            }
        } else if (newSet.mType.equals("C")) {
            if (newSet.mMinusH == 0) {
                if (this.mCurrentTopologySuperSetC == null) {
                    this.mCurrentTopologySuperSetC = new CTopologySuperSet(newSet.mType, this.mCurrentTargetMass, this, this.mCurrentPeakIdx);
                }
                this.mCurrentTopologySuperSetC.mTargetPeaks.put(this.mCurrentPeakIdx, 2);
                tss = this.mCurrentTopologySuperSetC;
            } else if (newSet.mMinusH == 2) {
                if (this.mCurrentTopologySuperSetC2 == null) {
                    this.mCurrentTopologySuperSetC2 = new CTopologySuperSet(newSet.mType, this.mCurrentTargetMass, this, this.mCurrentPeakIdx);
                    this.mCurrentTopologySuperSetC2.mTargetPeaks.put(this.mCurrentPeakIdx, 22);
                }
                tss = this.mCurrentTopologySuperSetC2;
            }
        } else {
            throw new InvalidParameterException("wrong mtype");
        }
        tss.addATopologySet(newSet);
    }

    class Delta {
        Link B2B;
        Link B2C;
        Link C2C;
        Link C2B;

        private Delta(int numClass, boolean permethylated) {
            double perMassLoss = (double)(2 * (permethylated ? 1 : 0)) * 14.0156500642;
            double linkageMassLoss = 18.0105646863 + perMassLoss;
            this.B2B = new Link(numClass);
            this.B2C = new Link(numClass);
            this.C2C = new Link(numClass);
            this.C2B = new Link(numClass);
            int i = 0;
            while (i < numClass) {
                CMonosaccharide mono = CGlycoDeNovo.this.cMonosaccharideArrays[i];
                this.B2B.mass[i] = mono.mMass - linkageMassLoss;
                this.B2B.unit[i] = mono;
                this.B2C.mass[i] = mono.mMass - perMassLoss;
                this.B2C.unit[i] = mono;
                this.C2B.mass[i] = mono.mMass - 18.0105646863 - linkageMassLoss;
                this.C2B.unit[i] = mono;
                this.C2C.mass[i] = mono.mMass - 18.0105646863 - perMassLoss;
                this.C2C.unit[i] = mono;
                ++i;
            }
        }
    }

    class Delta2 {
        Link2 B2B;
        Link2 B2C;
        Link2 C2C;
        Link2 C2B;

        private Delta2(int numClass, boolean permethylated) {
            double perMassLoss = (double)(2 * (permethylated ? 1 : 0)) * 14.0156500642;
            double linkageMassLoss = 18.0105646863 + perMassLoss;
            this.B2B = new Link2(numClass * numClass);
            this.B2C = new Link2(numClass * numClass);
            this.C2C = new Link2(numClass * numClass);
            this.C2B = new Link2(numClass * numClass);
            int index = 0;
            int i = 0;
            while (i < numClass) {
                CMonosaccharide mono1 = CGlycoDeNovo.this.cMonosaccharideArrays[i];
                int j = 0;
                while (j < numClass) {
                    CMonosaccharide mono2 = CGlycoDeNovo.this.cMonosaccharideArrays[j];
                    if (cLegalGlycosidicBonds[i][j]) {
                        this.B2B.mass[index] = mono1.mMass + mono2.mMass - 2.0 * linkageMassLoss;
                        this.B2B.unit[index][0] = mono1;
                        this.B2B.unit[index][1] = mono2;
                        this.B2C.mass[index] = mono1.mMass + mono2.mMass - linkageMassLoss + 18.0105646863;
                        this.B2C.unit[index][0] = mono1;
                        this.B2C.unit[index][1] = mono2;
                        this.C2B.mass[index] = mono1.mMass + mono2.mMass - 18.0105646863 - 2.0 * linkageMassLoss;
                        this.C2B.unit[index][0] = mono1;
                        this.C2B.unit[index][1] = mono2;
                        this.C2C.mass[index] = mono1.mMass - linkageMassLoss * 2.0;
                        this.C2C.unit[index][0] = mono1;
                        this.C2C.unit[index][1] = mono2;
                        ++index;
                    }
                    ++j;
                }
                this.B2B.len = index;
                this.B2C.len = index;
                this.C2B.len = index;
                this.C2C.len = index;
                ++i;
            }
        }
    }

    class Link {
        double[] mass;
        CMonosaccharide[] unit;

        private Link(int numClass) {
            this.mass = new double[numClass];
            this.unit = new CMonosaccharide[numClass];
        }
    }

    class Link2 {
        double[] mass;
        CMonosaccharide[][] unit;
        int len;

        private Link2(int numClass) {
            this.mass = new double[numClass];
            this.unit = new CMonosaccharide[numClass][2];
        }
    }
}

