/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.clustering;

import edu.brandeis.glycodenovo.clustering.Cluster;
import edu.brandeis.glycodenovo.clustering.ClusterPair;
import edu.brandeis.glycodenovo.clustering.ClusteringAlgorithm;
import edu.brandeis.glycodenovo.clustering.DistanceMap;
import edu.brandeis.glycodenovo.clustering.HierarchyBuilder;
import edu.brandeis.glycodenovo.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.List;

public class PDistClusteringAlgorithm
implements ClusteringAlgorithm {
    @Override
    public Cluster performClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy) {
        if (distances != null && distances.length != 0) {
            if (distances[0].length != clusterNames.length * (clusterNames.length - 1) / 2) {
                throw new IllegalArgumentException("Invalid cluster name array");
            }
            if (linkageStrategy == null) {
                throw new IllegalArgumentException("Undefined linkage strategy");
            }
            List<Cluster> clusters = this.createClusters(clusterNames);
            DistanceMap linkages = this.createLinkages(distances, clusters);
            HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
            while (!builder.isTreeComplete()) {
                builder.agglomerate(linkageStrategy);
            }
            return builder.getRootCluster();
        }
        throw new IllegalArgumentException("Invalid distance matrix");
    }

    @Override
    public List<Cluster> performFlatClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy, Double threshold) {
        if (distances != null && distances.length != 0) {
            if (distances[0].length != clusterNames.length * (clusterNames.length - 1) / 2) {
                throw new IllegalArgumentException("Invalid cluster name array");
            }
            if (linkageStrategy == null) {
                throw new IllegalArgumentException("Undefined linkage strategy");
            }
            List<Cluster> clusters = this.createClusters(clusterNames);
            DistanceMap linkages = this.createLinkages(distances, clusters);
            HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
            return builder.flatAgg(linkageStrategy, threshold);
        }
        throw new IllegalArgumentException("Invalid distance matrix");
    }

    @Override
    public Cluster performWeightedClustering(double[][] distances, String[] clusterNames, double[] weights, LinkageStrategy linkageStrategy) {
        return this.performClustering(distances, clusterNames, linkageStrategy);
    }

    private DistanceMap createLinkages(double[][] distances, List<Cluster> clusters) {
        DistanceMap linkages = new DistanceMap();
        int col = 0;
        while (col < clusters.size()) {
            Cluster cluster_col = clusters.get(col);
            int row = col + 1;
            while (row < clusters.size()) {
                ClusterPair link = new ClusterPair();
                Double d = distances[0][PDistClusteringAlgorithm.accessFunction(row, col, clusters.size())];
                link.setLinkageDistance(d);
                link.setlCluster(cluster_col);
                link.setrCluster(clusters.get(row));
                linkages.add(link);
                ++row;
            }
            ++col;
        }
        return linkages;
    }

    private List<Cluster> createClusters(String[] clusterNames) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        String[] var3 = clusterNames;
        int var4 = clusterNames.length;
        int var5 = 0;
        while (var5 < var4) {
            String clusterName = var3[var5];
            Cluster cluster = new Cluster(clusterName);
            cluster.addLeafName(clusterName);
            clusters.add(cluster);
            ++var5;
        }
        return clusters;
    }

    private static int accessFunction(int i, int j, int n) {
        return n * j - j * (j + 1) / 2 + i - 1 - j;
    }
}

