/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.template.AddDescriptorGroupToTemplateAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.template.AddDescriptorToTemplateAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.template.DeleteDescriptorFromTemplateAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.template.DeleteDescriptorGroupFromTemplateAction;
import org.grits.toolbox.editor.samplemanager.input.TemplateWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.CategoryManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.general.CheckboxTableUtility;
import org.grits.toolbox.editor.samplemanager.pages.general.SectionUtility;
import org.grits.toolbox.editor.samplemanager.pages.rightside.RightSideSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.CategoryComboContentProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.CategoryComboLabelProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptorgroups.CheckListenerMandatoryGroupInTemplate;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptorgroups.DescriptorGroupLabelProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptorgroups.MandatoryCheckTemplateDescriptorGroupProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptorgroups.TemplateCategoryDescriptorGroupListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptorgroups.TemplateDescriptorGroupMembersContentProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptors.CheckMandatoryDescriptorInCategoryTemplateListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptors.DescriptorLabelProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptors.MandatoryCheckTemplateDescriptorProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptors.TemplateCategoryDescriptorListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.template.memberdescriptors.TemplateDescriptorMembersContentProvider;
import org.grits.toolbox.editor.samplemanager.util.GenericColumnsWithCheckboxSelectionListener;
import org.grits.toolbox.editor.samplemanager.util.GenericViewerComparatorCheckboxTable;
import org.grits.toolbox.entry.sample.model.Category;

public class RightSideTemplateSection
extends RightSideSection {
    private Logger logger = Logger.getLogger(RightSideTemplateSection.class);
    private Composite descriptorListSectionComposite = null;
    private CheckboxTableViewer tableViewer;
    private AddDescriptorToTemplateAction addDescriptorToTemplateAction;
    private DeleteDescriptorFromTemplateAction deleteDescriptorFromTemplateAction;
    private ComboViewer categoryComboForDescriptors = null;
    private ComboViewer categoryCombo = null;
    private Composite descriptorGroupListSectionComposite;
    private CheckboxTableViewer dgTableViewer;
    private AddDescriptorGroupToTemplateAction addDescriptorGroupToTemplateAction;
    private DeleteDescriptorGroupFromTemplateAction deleteDescriptorGroupFromTemplateAction;
    private HashMap<String, String> uriLabelMap;
    private List<Category> categories;
    private TemplateCategoryDescriptorListener categoryChangedForDescriptorsListener;
    private TemplateCategoryDescriptorGroupListener categoryChangedForDescriptorGroupsListener;

    public RightSideTemplateSection(AbstractManagementPage page) {
        super(page);
        this.uriLabelMap = ((ManagementEditor)page.getEditor()).getAllCategoriesURILabelMap();
    }

    @Override
    protected void createSpecificPart() {
        this.logger.debug((Object)"- START : Creating specific part in right side Template section.");
        try {
            List<String> existingLabels = ((ManagementEditor)this.page.getEditor()).getAllIndividualLabels("http://www.grits-toolbox.org/ontology/sample#template");
            this.labelModifyListener.setExistingLabels(existingLabels);
            this.categories = new ArrayList<Category>(((CategoryManagementPage)((ManagementEditor)this.page.getEditor()).findPage("3")).getAllCategories());
            this.createDescriptorTableSection();
            this.createDescriptorGroupTableSection();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating specific part in right side Template section.");
    }

    private void createDescriptorTableSection() {
        Section descriptorListSection = SectionUtility.createSectionForCategory(this.toolkit, this.page.getRightComposite(), "Descriptors");
        this.descriptorListSectionComposite = SectionUtility.getCompositeInsideSection(this.toolkit, descriptorListSection, 1, 10, 2, 2);
        Composite categoryComboComposite = this.toolkit.createComposite(this.descriptorListSectionComposite);
        TableWrapLayout comboCompositeLayout = new TableWrapLayout();
        comboCompositeLayout.numColumns = 2;
        comboCompositeLayout.horizontalSpacing = 30;
        categoryComboComposite.setLayout((Layout)comboCompositeLayout);
        Label categoryLabel = this.toolkit.createLabel(categoryComboComposite, "Category");
        categoryLabel.setFont(this.boldFont);
        TableWrapData labelData = new TableWrapData();
        categoryLabel.setLayoutData((Object)labelData);
        this.categoryComboForDescriptors = new ComboViewer(categoryComboComposite, 8);
        TableWrapData comboData = new TableWrapData(2);
        this.categoryComboForDescriptors.getCombo().setLayoutData((Object)comboData);
        this.setUpContentForCombo(this.categoryComboForDescriptors);
        TableWrapData comboCompositeData = new TableWrapData();
        comboCompositeData.colspan = 1;
        categoryComboComposite.setLayoutData((Object)comboCompositeData);
        this.tableViewer = CheckboxTableUtility.createCheckboxTableViewer(this.page, this.descriptorListSectionComposite, 32, "Descriptors");
        this.tableViewer.setContentProvider((IContentProvider)new TemplateDescriptorMembersContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DescriptorLabelProvider());
        this.tableViewer.setCheckStateProvider((ICheckStateProvider)new MandatoryCheckTemplateDescriptorProvider(this.tableViewer));
        this.tableViewer.addCheckStateListener((ICheckStateListener)new CheckMandatoryDescriptorInCategoryTemplateListener(this.page, (TableViewer)this.tableViewer));
        GenericViewerComparatorCheckboxTable simpleTypeViewerComparator = new GenericViewerComparatorCheckboxTable();
        this.tableViewer.setComparator((ViewerComparator)simpleTypeViewerComparator);
        this.addColumnSelectionListenerForCheckbox(this.tableViewer);
        TableWrapData tableData = new TableWrapData(256);
        tableData.colspan = 1;
        tableData.heightHint = 150;
        this.tableViewer.getTable().setLayoutData((Object)tableData);
        ToolBarManager toolBarManager = new ToolBarManager(4096);
        this.addDescriptorToTemplateAction = this.getAddDescriptorToTemplateAction();
        toolBarManager.add((IAction)this.addDescriptorToTemplateAction);
        this.deleteDescriptorFromTemplateAction = this.getDeleteDescriptorFromTemplateAction();
        toolBarManager.add((IAction)this.deleteDescriptorFromTemplateAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)descriptorListSection);
        descriptorListSection.setTextClient((Control)toolbar);
        this.categoryChangedForDescriptorsListener = new TemplateCategoryDescriptorListener(this.tableViewer);
        this.categoryComboForDescriptors.addSelectionChangedListener((ISelectionChangedListener)this.categoryChangedForDescriptorsListener);
        this.categoryComboForDescriptors.getCombo().select(this.categories.size() - 1);
    }

    private void addColumnSelectionListenerForCheckbox(CheckboxTableViewer checkboxTableViewer) {
        int totalColumns = checkboxTableViewer.getTable().getColumns().length;
        int i = 0;
        while (i < totalColumns) {
            checkboxTableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new GenericColumnsWithCheckboxSelectionListener(checkboxTableViewer));
            ++i;
        }
    }

    private void setUpContentForCombo(ComboViewer categoryComboForDescriptors) {
        categoryComboForDescriptors.setContentProvider((IContentProvider)new CategoryComboContentProvider());
        categoryComboForDescriptors.setLabelProvider((IBaseLabelProvider)new CategoryComboLabelProvider(this.uriLabelMap));
        categoryComboForDescriptors.setInput(this.categories);
    }

    private void createDescriptorGroupTableSection() {
        Section descriptorGroupListSection = SectionUtility.createSectionForCategory(this.toolkit, this.page.getRightComposite(), "Descriptor Groups");
        this.descriptorGroupListSectionComposite = SectionUtility.getCompositeInsideSection(this.toolkit, descriptorGroupListSection, 1, 10, 2, 2);
        Composite categoryComboComposite = this.toolkit.createComposite(this.descriptorGroupListSectionComposite);
        TableWrapLayout comboCompositeLayout = new TableWrapLayout();
        comboCompositeLayout.numColumns = 2;
        comboCompositeLayout.horizontalSpacing = 30;
        categoryComboComposite.setLayout((Layout)comboCompositeLayout);
        Label categoryLabel = this.toolkit.createLabel(categoryComboComposite, "Category");
        categoryLabel.setFont(this.boldFont);
        TableWrapData labelData = new TableWrapData(8);
        categoryLabel.setLayoutData((Object)labelData);
        this.categoryCombo = new ComboViewer(categoryComboComposite, 8);
        TableWrapData comboData = new TableWrapData(2);
        this.categoryCombo.getCombo().setLayoutData((Object)comboData);
        this.setUpContentForCombo(this.categoryCombo);
        this.categoryCombo.getCombo().select(this.categories.size() - 1);
        TableWrapData comboCompositeData = new TableWrapData();
        comboCompositeData.colspan = 1;
        categoryComboComposite.setLayoutData((Object)comboCompositeData);
        this.dgTableViewer = CheckboxTableUtility.createCheckboxTableViewer(this.page, this.descriptorGroupListSectionComposite, 32, "Descriptor Groups");
        this.dgTableViewer.setContentProvider((IContentProvider)new TemplateDescriptorGroupMembersContentProvider());
        this.dgTableViewer.setLabelProvider((IBaseLabelProvider)new DescriptorGroupLabelProvider());
        this.dgTableViewer.setCheckStateProvider((ICheckStateProvider)new MandatoryCheckTemplateDescriptorGroupProvider(this.dgTableViewer));
        this.dgTableViewer.addCheckStateListener((ICheckStateListener)new CheckListenerMandatoryGroupInTemplate(this.page, this.dgTableViewer));
        this.dgTableViewer.setComparator((ViewerComparator)new GenericViewerComparatorCheckboxTable());
        this.addColumnSelectionListenerForCheckbox(this.dgTableViewer);
        TableWrapData tableData = new TableWrapData(256);
        tableData.colspan = 1;
        tableData.heightHint = 150;
        this.dgTableViewer.getTable().setLayoutData((Object)tableData);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.addDescriptorGroupToTemplateAction = this.getAddDescriptorGroupToTemplateAction();
        toolBarManager.add((IAction)this.addDescriptorGroupToTemplateAction);
        this.deleteDescriptorGroupFromTemplateAction = this.getDeleteDescriptorGroupFromTemplateAction();
        toolBarManager.add((IAction)this.deleteDescriptorGroupFromTemplateAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)descriptorGroupListSection);
        descriptorGroupListSection.setTextClient((Control)toolbar);
        this.categoryChangedForDescriptorGroupsListener = new TemplateCategoryDescriptorGroupListener(this.dgTableViewer);
        this.categoryCombo.addSelectionChangedListener((ISelectionChangedListener)this.categoryChangedForDescriptorGroupsListener);
        this.categoryCombo.getCombo().select(this.categories.size() - 1);
    }

    private DeleteDescriptorGroupFromTemplateAction getDeleteDescriptorGroupFromTemplateAction() {
        return new DeleteDescriptorGroupFromTemplateAction(this.page, (TableViewer)this.dgTableViewer);
    }

    private AddDescriptorGroupToTemplateAction getAddDescriptorGroupToTemplateAction() {
        return new AddDescriptorGroupToTemplateAction(this.page, (TableViewer)this.dgTableViewer);
    }

    private DeleteDescriptorFromTemplateAction getDeleteDescriptorFromTemplateAction() {
        return new DeleteDescriptorFromTemplateAction(this.page, (TableViewer)this.tableViewer);
    }

    private AddDescriptorToTemplateAction getAddDescriptorToTemplateAction() {
        return new AddDescriptorToTemplateAction(this.page, (TableViewer)this.tableViewer);
    }

    @Override
    protected void resetSpecificPart() {
        this.logger.debug((Object)"- START : Resetting right side Template section for the selection.");
        try {
            TemplateWithFeatures selectedTemplate = (TemplateWithFeatures)this.selectedObject;
            this.categoryChangedForDescriptorsListener.setSelectedTemplate(selectedTemplate);
            List<String> existingLabels = ((ManagementEditor)this.page.getEditor()).getAllIndividualLabels("http://www.grits-toolbox.org/ontology/sample#template");
            this.labelModifyListener.setExistingLabels(existingLabels);
            this.categoryComboForDescriptors.setInput(this.categories);
            this.categoryComboForDescriptors.getCombo().select(this.categories.size() - 1);
            this.categoryComboForDescriptors.setSelection(this.categoryComboForDescriptors.getSelection());
            this.addDescriptorToTemplateAction.setEnabled(this.editable);
            this.deleteDescriptorFromTemplateAction.setEnabled(this.editable);
            this.tableViewer.getTable().setEnabled(this.editable);
            this.categoryChangedForDescriptorGroupsListener.setSelectedTemplate(selectedTemplate);
            this.categoryCombo.setInput(this.categories);
            this.categoryCombo.getCombo().select(this.categories.size() - 1);
            this.categoryCombo.setSelection(this.categoryCombo.getSelection());
            this.addDescriptorGroupToTemplateAction.setEnabled(this.editable);
            this.deleteDescriptorGroupFromTemplateAction.setEnabled(this.editable);
            this.dgTableViewer.getTable().setEnabled(this.editable);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resetting right side Template section for the selection.");
    }
}

