/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside;

import org.apache.log4j.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.grits.toolbox.editor.samplemanager.input.ClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.rightside.listeners.DescriptionModifyListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.listeners.LabelModifyListener;

public abstract class RightSideSection {
    private Logger logger = Logger.getLogger(RightSideSection.class);
    protected AbstractManagementPage page = null;
    protected FormToolkit toolkit = null;
    protected Section rightSideSection = null;
    protected Composite rightSideComposite;
    protected ClassesWithFeatures selectedObject;
    protected boolean editable = false;
    protected Font boldFont = null;
    protected Label labelLabel = null;
    protected Label labelDescription = null;
    protected Text labelText = null;
    protected Text descriptionText = null;
    protected LabelModifyListener labelModifyListener = null;
    protected DescriptionModifyListener descriptionModifyListener = null;

    public RightSideSection(AbstractManagementPage page) {
        this.page = page;
        this.rightSideSection = page.getRightSectionOfPage();
        this.toolkit = page.getToolkit();
        Font currentFont = Display.getCurrent().getSystemFont();
        FontData fontData = currentFont.getFontData()[0];
        this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
    }

    public void setSelectedObject(ClassesWithFeatures selectedObject) {
        this.logger.debug((Object)"- START : Setting selected object for the right side section.");
        try {
            if (selectedObject != null) {
                if (this.labelLabel == null) {
                    this.createGeneralPart();
                }
                this.selectedObject = selectedObject;
                this.editable = selectedObject.isEditable();
                this.reset();
            } else {
                this.rightSideSection.setText("No Selection    ");
                this.rightSideSection.setExpanded(false);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Setting selected object for the right side section.");
    }

    protected void createGeneralPart() {
        this.logger.debug((Object)"- START : Creating part for the right side section.");
        try {
            this.rightSideComposite = this.toolkit.createComposite((Composite)this.rightSideSection, 0);
            GridLayout rightSideCompositeLayout = new GridLayout();
            rightSideCompositeLayout.verticalSpacing = 30;
            rightSideCompositeLayout.horizontalSpacing = 10;
            rightSideCompositeLayout.numColumns = 4;
            rightSideCompositeLayout.makeColumnsEqualWidth = false;
            this.rightSideComposite.setLayout((Layout)rightSideCompositeLayout);
            this.createLineForLabel(this.rightSideComposite);
            this.createDescriptionLine(this.rightSideComposite);
            this.createSpecificPart();
            this.rightSideComposite.setLayoutData((Object)new TableWrapData(256));
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating part for the right side section.");
    }

    protected abstract void createSpecificPart();

    public void reset() {
        this.logger.debug((Object)"- START : Resetting part for the right side section.");
        try {
            this.rightSideSection.setExpanded(false);
            this.rightSideSection.setText("General Info : " + this.selectedObject.getLabel());
            this.labelText.setEnabled(this.editable);
            this.setSelectedObjectForLabelListener();
            this.labelText.setText(this.selectedObject.getLabel());
            this.resetDescriptionPart();
            this.resetSpecificPart();
            this.rightSideSection.setClient((Control)this.rightSideComposite);
            this.rightSideSection.setExpanded(true);
            this.rightSideSection.update();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resetting part for the right side section.");
    }

    protected void resetDescriptionPart() {
        this.descriptionText.setEditable(this.editable);
        this.descriptionModifyListener.setSelectedObject(this.selectedObject);
        if (this.selectedObject.getDescription() != null) {
            this.descriptionText.setText(this.selectedObject.getDescription());
        } else {
            this.descriptionText.setText("");
        }
    }

    protected abstract void resetSpecificPart();

    protected void createLineForLabel(Composite rightSideComposite) {
        this.labelLabel = this.toolkit.createLabel(rightSideComposite, "Label*");
        this.labelLabel.setFont(this.boldFont);
        GridData labelGridData = new GridData();
        labelGridData.widthHint = 168;
        this.labelLabel.setLayoutData((Object)labelGridData);
        this.labelText = this.toolkit.createText(rightSideComposite, "", 68);
        this.labelText.setTextLimit(80);
        this.setLabelModificationListener();
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.widthHint = 550;
        textGridData.horizontalSpan = 3;
        this.labelText.setLayoutData((Object)textGridData);
        this.toolkit.paintBordersFor(rightSideComposite);
    }

    protected void setLabelModificationListener() {
        ControlDecoration labelControlDecoration = new ControlDecoration((Control)this.labelText, 16384);
        this.labelModifyListener = new LabelModifyListener(this.page, labelControlDecoration);
        this.labelText.addModifyListener((ModifyListener)this.labelModifyListener);
    }

    protected void setSelectedObjectForLabelListener() {
        this.labelModifyListener.setSelectedObject(this.selectedObject);
    }

    protected void createDescriptionLine(Composite rightSideComposite) {
        this.labelDescription = this.toolkit.createLabel(rightSideComposite, "Description");
        this.labelDescription.setFont(this.boldFont);
        this.labelDescription.setLayoutData((Object)new GridData());
        this.descriptionText = new Text(rightSideComposite, 2624);
        this.descriptionText.setTextLimit(10000);
        this.setDescriptionModificationListener();
        GridData descriptionGridData = new GridData();
        descriptionGridData.grabExcessHorizontalSpace = true;
        descriptionGridData.widthHint = 540;
        descriptionGridData.heightHint = 80;
        descriptionGridData.horizontalSpan = 3;
        this.descriptionText.setLayoutData((Object)descriptionGridData);
    }

    private void setDescriptionModificationListener() {
        this.descriptionModifyListener = new DescriptionModifyListener(this.page);
        this.descriptionText.addModifyListener((ModifyListener)this.descriptionModifyListener);
        this.descriptionText.addKeyListener((KeyListener)this.descriptionModifyListener);
    }
}

