/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.ontology;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.model.Template;

public class OntologyManager {
    public static final String baseURI = "http://www.grits-toolbox.org/ontology/sample#";
    public static final String baseURIWithoutHash = "http://www.grits-toolbox.org/ontology/sample";
    public static final String CATEGORY_SAMPLE_INFO_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_sample";
    public static final String CATEGORY_TRACKING_INFO_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking";
    public static final String CATEGORY_AMOUNT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_amount";
    public static final String CATEGORY_PURITY_QC_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category_qc";
    public static final String DESCRIPTOR_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#descriptor";
    public static final String DESCRIPTOR_GROUP_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#descriptor_group";
    public static final String TEMPLATE_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#template";
    public static final String UNIT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#unit";
    public static final String CATEGORY_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#category";
    public static final String TEMPLATE_CONTEXT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#template_context";
    public static final String MEASUREMENT_UNIT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#unit";
    public static final String NAMESPACE_CLASS = "http://www.grits-toolbox.org/ontology/sample#namespace";
    public static final String GUIDELINE_CLASS = "http://www.grits-toolbox.org/ontology/sample#StandardGuideline";
    public OntModel standardOntologymodel = null;
    public OntModel localOntologymodel = null;

    public OntologyManager(OntModel localOntologyModel) {
        this.localOntologymodel = localOntologyModel;
    }

    public OntologyManager(OntModel standardOntologyModel, OntModel localOntologyModel) {
        this.standardOntologymodel = standardOntologyModel;
        this.localOntologymodel = localOntologyModel;
    }

    public OntologyManager(InputStream standardInputOntology, InputStream locaInputOntology) {
        this.standardOntologymodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.standardOntologymodel.read(standardInputOntology, baseURI);
        this.localOntologymodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.localOntologymodel.read(locaInputOntology, baseURI);
    }

    public void writeOntology(OntModel model, OutputStream outputOntology) {
        model.write(outputOntology);
    }

    public void addProperty(OntModel model, String subjectUri, String property, String objectUri) {
        Individual indiv = model.getIndividual(subjectUri);
        String propertyUri = baseURI + property;
        ObjectProperty prop = model.getObjectProperty(propertyUri);
        if (model.getObjectProperty(propertyUri) != null) {
            indiv.addProperty((Property)prop, (RDFNode)model.getIndividual(objectUri));
        }
    }

    public void addLiteral(OntModel model, String subjectUri, String property, Literal literalValue) {
        Individual indiv = model.getIndividual(subjectUri);
        String propertyUri = baseURI + property;
        Property prop = model.getProperty(propertyUri);
        if (prop != null) {
            indiv.addLiteral(prop, literalValue);
        }
    }

    public List<Individual> getAllIndependentDescriptors(OntModel model) {
        List<Individual> individuals = this.getAllIndiviudalsOfClass(model, DESCRIPTOR_CLASS_URI);
        List dependentDescriptors = model.listObjectsOfProperty(model.getProperty("http://www.grits-toolbox.org/ontology/sample#has_descriptor")).toList();
        ArrayList<String> dependentDescriptorsUris = new ArrayList<String>();
        for (RDFNode node : dependentDescriptors) {
            dependentDescriptorsUris.add(node.toString());
        }
        ArrayList<Individual> independentIndividuals = new ArrayList<Individual>();
        for (Individual indiv : individuals) {
            if (dependentDescriptorsUris.contains(indiv.getURI())) continue;
            independentIndividuals.add(indiv);
        }
        return independentIndividuals;
    }

    public Literal getLiteralValue(OntModel model, Individual indiv, String propertyName) {
        Literal val = null;
        RDFNode node = indiv.getPropertyValue(model.getProperty(baseURI + propertyName));
        if (node != null && node.isLiteral()) {
            val = node.asLiteral();
        }
        return val;
    }

    public List<Literal> getLiteralValues(OntModel model, Individual indiv, String propertyName) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        NodeIterator nodeIterator = indiv.listPropertyValues(model.getProperty(baseURI + propertyName));
        RDFNode node = null;
        while (nodeIterator.hasNext()) {
            node = nodeIterator.next();
            if (!node.isLiteral()) continue;
            literals.add(node.asLiteral());
        }
        return literals;
    }

    public List<Individual> getAllDescriptorGroup(OntModel model) {
        List<Individual> individuals = this.getAllIndiviudalsOfClass(model, DESCRIPTOR_GROUP_CLASS_URI);
        return individuals;
    }

    public List<Individual> getAllTemplates(OntModel model) {
        List<Individual> individuals = this.getAllIndiviudalsOfClass(model, TEMPLATE_CLASS_URI);
        return individuals;
    }

    public List<Individual> getAllIndiviudalsOfClass(OntModel model, String classUri) {
        OntClass thisClass = model.getOntClass(classUri);
        Set individuals = model.listIndividuals((Resource)thisClass).toSet();
        ArrayList<Individual> actualIndividuals = new ArrayList<Individual>(individuals);
        return actualIndividuals;
    }

    public List<Individual> getAllObjects(OntModel model, Individual subject, String property) {
        NodeIterator objectIterator = model.listObjectsOfProperty((Resource)subject, model.getProperty(baseURI + property));
        ArrayList<Individual> objects = new ArrayList<Individual>();
        for (RDFNode n : objectIterator.toList()) {
            String uri = n.asResource().getURI();
            Individual indiv = model.getIndividual(uri);
            objects.add(indiv);
        }
        return objects;
    }

    public Individual getObject(OntModel model, Individual individual, String propertyUri) {
        Property property = model.getProperty(baseURI + propertyUri);
        NodeIterator objects = model.listObjectsOfProperty((Resource)individual, property);
        Individual objectIndiv = null;
        if (objects.hasNext()) {
            objectIndiv = model.getIndividual(objects.next().asResource().getURI());
        }
        return objectIndiv;
    }

    public Descriptor getDescriptorByUri(OntModel model, String uri) throws Exception {
        Individual indiv = model.getIndividual(uri);
        if (indiv != null) {
            String classUri = indiv.getOntClass().getURI();
            if (indiv.getOntClass().getURI().equals(DESCRIPTOR_CLASS_URI)) {
                List<Individual> guidelinesFromContext;
                Descriptor descriptor = new Descriptor();
                descriptor.setUri(uri);
                descriptor.setLabel(indiv.getLabel(null));
                descriptor.setDescription(indiv.getComment(null));
                Literal maxOccurrence = this.getLiteralValue(model, indiv, "has_abbundance");
                if (maxOccurrence != null) {
                    descriptor.setMaxOccurrence(Integer.valueOf(maxOccurrence.getInt()));
                }
                Literal position = this.getLiteralValue(model, indiv, "has_position");
                int pos = 0;
                if (position != null) {
                    pos = position.getInt();
                    descriptor.setPosition(Integer.valueOf(pos));
                }
                if ((guidelinesFromContext = this.getAllObjects(model, indiv, "guideline_info")) != null) {
                    ArrayList<String> guidelines = new ArrayList<String>();
                    for (Individual guideline : guidelinesFromContext) {
                        guidelines.add(guideline.getLabel(null));
                    }
                    descriptor.setGuidelineURIs(guidelines);
                }
                List<Namespace> namespaces = this.getNamespacesForDescriptor(model, indiv);
                descriptor.setNamespaces(namespaces);
                List<Individual> units = this.getAllObjects(model, indiv, "has_default_unit_of_measurement");
                if (!units.isEmpty()) {
                    descriptor.setDefaultMeasurementUnit(units.iterator().next().getURI());
                }
                units = this.getAllObjects(model, indiv, "has_unit_of_measurement");
                for (Individual unit : units) {
                    MeasurementUnit mUnit = new MeasurementUnit(unit.getURI(), unit.getLabel(null));
                    descriptor.addValidUnit(mUnit);
                }
                List<Individual> categories = this.getAllObjects(model, indiv, "has_category");
                for (Individual category : categories) {
                    descriptor.addCategory(category.getURI());
                }
                return descriptor;
            }
            throw new Exception("The given uri" + uri + classUri + "is not of type Descriptor but is of type " + indiv.getOntClass().getURI());
        }
        return null;
    }

    public DescriptorGroup getDescriptorGroupByUri(OntModel model, String uri) throws Exception {
        Individual indiv = model.getIndividual(uri);
        if (indiv != null) {
            if (indiv.getOntClass().getURI().equals(DESCRIPTOR_GROUP_CLASS_URI)) {
                List<Individual> guidelinesFromContext;
                DescriptorGroup descriptorGroup = new DescriptorGroup();
                descriptorGroup.setUri(uri);
                descriptorGroup.setLabel(indiv.getLabel(null));
                descriptorGroup.setDescription(indiv.getComment(null));
                Literal maxOccurrence = this.getLiteralValue(model, indiv, "has_abbundance");
                if (maxOccurrence != null) {
                    descriptorGroup.setMaxOccurrence(Integer.valueOf(maxOccurrence.getInt()));
                }
                Literal position = this.getLiteralValue(model, indiv, "has_position");
                int pos = 0;
                if (position != null) {
                    pos = position.getInt();
                    descriptorGroup.setPosition(Integer.valueOf(pos));
                }
                if ((guidelinesFromContext = this.getAllObjects(model, indiv, "guideline_info")) != null) {
                    ArrayList<String> guidelines = new ArrayList<String>();
                    for (Individual guideline : guidelinesFromContext) {
                        guidelines.add(guideline.getLabel(null));
                    }
                    descriptorGroup.setGuidelineURIs(guidelines);
                }
                List<Individual> categories = this.getAllObjects(model, indiv, "has_category");
                for (Individual category : categories) {
                    descriptorGroup.addCategory(category.getURI());
                }
                List<Individual> dgContextIndividuals = this.getAllObjects(model, indiv, "has_descriptor_group_context");
                for (Individual dgContext : dgContextIndividuals) {
                    Descriptor descriptor = new Descriptor();
                    Individual descriptorIndiv = this.getObject(model, dgContext, "has_descriptor");
                    descriptor.setUri(descriptorIndiv.getURI());
                    descriptor.setLabel(descriptorIndiv.getLabel(null));
                    descriptor.setDescription(descriptorIndiv.getComment(null));
                    List<Namespace> namespaces = this.getNamespacesForDescriptor(model, descriptorIndiv);
                    descriptor.setNamespaces(namespaces);
                    List<Individual> units = this.getAllObjects(model, descriptorIndiv, "has_default_unit_of_measurement");
                    if (!units.isEmpty()) {
                        descriptor.setDefaultMeasurementUnit(units.iterator().next().getURI());
                    }
                    units = this.getAllObjects(model, descriptorIndiv, "has_unit_of_measurement");
                    for (Individual unit : units) {
                        MeasurementUnit mUnit = new MeasurementUnit(unit.getURI(), unit.getLabel(null));
                        descriptor.addValidUnit(mUnit);
                    }
                    maxOccurrence = this.getLiteralValue(model, dgContext, "has_abbundance");
                    if (maxOccurrence != null) {
                        descriptor.setMaxOccurrence(Integer.valueOf(maxOccurrence.getInt()));
                    } else {
                        descriptor.setMaxOccurrence(null);
                    }
                    Literal mandatoryLiteral = this.getLiteralValue(model, dgContext, "is_mandatory");
                    if (mandatoryLiteral.getBoolean()) {
                        descriptorGroup.addMandatoryDescriptor(descriptor);
                        continue;
                    }
                    descriptorGroup.addOptionalDescriptor(descriptor);
                }
                return descriptorGroup;
            }
            throw new Exception("The given uri " + uri + " is not of type descriptorGroup but is of type " + indiv.getOntClass().getURI());
        }
        return null;
    }

    private List<Namespace> getNamespacesForDescriptor(OntModel model, Individual descriptorIndiv) {
        NodeIterator objectIterator = model.listObjectsOfProperty((Resource)descriptorIndiv, model.getProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace"));
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        Individual nsIndiv = null;
        String nsURI = null;
        for (RDFNode n : objectIterator.toList()) {
            nsURI = n.asResource().getURI();
            nsIndiv = model.getIndividual(nsURI);
            if (nsIndiv != null) {
                String namespaceFile = null;
                String namespaceIdFile = null;
                List nodes = model.listObjectsOfProperty((Resource)nsIndiv, (Property)model.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_file")).toList();
                if (!nodes.isEmpty()) {
                    namespaceFile = ((RDFNode)nodes.get(0)).asLiteral().toString();
                    nodes = model.listObjectsOfProperty((Resource)nsIndiv, (Property)model.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_id_file")).toList();
                    if (!nodes.isEmpty()) {
                        namespaceIdFile = ((RDFNode)nodes.get(0)).asLiteral().toString();
                    }
                }
                namespaces.add(new Namespace(nsURI, nsIndiv.getLabel(null), namespaceFile, namespaceIdFile));
                continue;
            }
            namespaces.add(new Namespace(nsURI, n.asResource().getLocalName(), null, null));
        }
        return namespaces;
    }

    public Set<String> getAllSubjectURIs(OntModel model, String propertyLabel, String objectUri) {
        Property property = model.getProperty(baseURI + propertyLabel);
        ResIterator subjectIterator = model.listSubjectsWithProperty(property, (RDFNode)model.getIndividual(objectUri));
        HashSet<String> subjects = new HashSet<String>();
        while (subjectIterator.hasNext()) {
            subjects.add(((Resource)subjectIterator.next()).getURI());
        }
        return subjects;
    }

    public List<Individual> getAllSubjects(OntModel model, String propertyLabel, String objectUri) {
        Property property = model.getProperty(baseURI + propertyLabel);
        ResIterator subjectIterator = model.listSubjectsWithProperty(property, (RDFNode)model.getIndividual(objectUri));
        ArrayList<Individual> subjects = new ArrayList<Individual>();
        while (subjectIterator.hasNext()) {
            Resource subject = (Resource)subjectIterator.next();
            if (model.getIndividual(subject.getURI()) == null) continue;
            subjects.add(model.getIndividual(subject.getURI()));
        }
        return subjects;
    }

    public Template getTemplate(OntModel model, String uri) throws Exception {
        Template template = null;
        Individual indiv = model.getIndividual(uri);
        if (indiv != null) {
            if (indiv.getOntClass().getURI().equals(TEMPLATE_CLASS_URI)) {
                template = new Template();
                template.setUri(uri);
                template.setLabel(indiv.getLabel(null));
                template.setDescription(indiv.getComment(null));
                Literal glycovaultId = this.getLiteralValue(model, indiv, "has_glycovault_id");
                if (glycovaultId != null) {
                    template.setGlycovaultId(Integer.valueOf(glycovaultId.getInt()));
                }
                List<Individual> templateContexts = this.getAllObjects(model, indiv, "has_template_context");
                CategoryTemplate sampleInfoTemplate = new CategoryTemplate();
                CategoryTemplate amountTemplate = new CategoryTemplate();
                CategoryTemplate purityQCTemplate = new CategoryTemplate();
                CategoryTemplate trackingTemplate = new CategoryTemplate();
                amountTemplate.setUri(CATEGORY_AMOUNT_CLASS_URI);
                amountTemplate.setTemplateURI(indiv.getURI());
                purityQCTemplate.setUri(CATEGORY_PURITY_QC_CLASS_URI);
                purityQCTemplate.setTemplateURI(indiv.getURI());
                sampleInfoTemplate.setUri(CATEGORY_SAMPLE_INFO_CLASS_URI);
                sampleInfoTemplate.setTemplateURI(indiv.getURI());
                trackingTemplate.setUri(CATEGORY_TRACKING_INFO_CLASS_URI);
                trackingTemplate.setTemplateURI(indiv.getURI());
                for (Individual templateContext : templateContexts) {
                    Individual indivFromContext = this.getObject(model, templateContext, "has_template_descriptor");
                    indivFromContext = this.getResourceIndiv(indivFromContext.getURI());
                    boolean isManadatory = this.getLiteralValue(model, templateContext, "is_mandatory").getBoolean();
                    Literal maxOccurrence = this.getLiteralValue(model, templateContext, "has_abbundance");
                    List<Individual> categories = this.getAllObjects(model, templateContext, "has_category");
                    for (Individual category : categories) {
                        String categoryUri = category.getURI();
                        String descUri = indivFromContext.getOntClass().getURI();
                        ArrayList<String> singleCategory = new ArrayList<String>();
                        singleCategory.add(categoryUri);
                        if (categoryUri != null) {
                            if (descUri.equals(DESCRIPTOR_GROUP_CLASS_URI)) {
                                DescriptorGroup descriptorGroup = this.getDescriptorGroupFromEitherOntology(indivFromContext.getURI());
                                if (maxOccurrence != null) {
                                    descriptorGroup.setMaxOccurrence(Integer.valueOf(maxOccurrence.getInt()));
                                } else {
                                    descriptorGroup.setMaxOccurrence(null);
                                }
                                descriptorGroup.setCategories(singleCategory);
                                if (categoryUri.equals(CATEGORY_SAMPLE_INFO_CLASS_URI)) {
                                    if (isManadatory) {
                                        sampleInfoTemplate.addMandatoryDescriptorGroup(descriptorGroup);
                                        continue;
                                    }
                                    sampleInfoTemplate.addOptionalDescriptorGroup(descriptorGroup);
                                    continue;
                                }
                                if (categoryUri.equals(CATEGORY_AMOUNT_CLASS_URI)) {
                                    if (isManadatory) {
                                        amountTemplate.addMandatoryDescriptorGroup(descriptorGroup);
                                        continue;
                                    }
                                    amountTemplate.addOptionalDescriptorGroup(descriptorGroup);
                                    continue;
                                }
                                if (categoryUri.equals(CATEGORY_PURITY_QC_CLASS_URI)) {
                                    if (isManadatory) {
                                        purityQCTemplate.addMandatoryDescriptorGroup(descriptorGroup);
                                        continue;
                                    }
                                    purityQCTemplate.addOptionalDescriptorGroup(descriptorGroup);
                                    continue;
                                }
                                if (!categoryUri.equals(CATEGORY_TRACKING_INFO_CLASS_URI)) continue;
                                if (isManadatory) {
                                    trackingTemplate.addMandatoryDescriptorGroup(descriptorGroup);
                                    continue;
                                }
                                trackingTemplate.addOptionalDescriptorGroup(descriptorGroup);
                                continue;
                            }
                            if (!descUri.equals(DESCRIPTOR_CLASS_URI)) continue;
                            Descriptor descriptor = this.getDescriptorFromEitherOntology(indivFromContext.getURI());
                            if (maxOccurrence != null) {
                                descriptor.setMaxOccurrence(Integer.valueOf(maxOccurrence.getInt()));
                            } else {
                                descriptor.setMaxOccurrence(null);
                            }
                            descriptor.setCategories(singleCategory);
                            if (categoryUri == null) continue;
                            if (categoryUri.equals(CATEGORY_SAMPLE_INFO_CLASS_URI)) {
                                if (isManadatory) {
                                    sampleInfoTemplate.addMandatoryDescriptor(descriptor);
                                    continue;
                                }
                                sampleInfoTemplate.addOptionalDescriptor(descriptor);
                                continue;
                            }
                            if (categoryUri.equals(CATEGORY_AMOUNT_CLASS_URI)) {
                                if (isManadatory) {
                                    amountTemplate.addMandatoryDescriptor(descriptor);
                                    continue;
                                }
                                amountTemplate.addOptionalDescriptor(descriptor);
                                continue;
                            }
                            if (categoryUri.equals(CATEGORY_PURITY_QC_CLASS_URI)) {
                                if (isManadatory) {
                                    purityQCTemplate.addMandatoryDescriptor(descriptor);
                                    continue;
                                }
                                purityQCTemplate.addOptionalDescriptor(descriptor);
                                continue;
                            }
                            if (!categoryUri.equals(CATEGORY_TRACKING_INFO_CLASS_URI)) continue;
                            if (isManadatory) {
                                trackingTemplate.addMandatoryDescriptor(descriptor);
                                continue;
                            }
                            trackingTemplate.addOptionalDescriptor(descriptor);
                            continue;
                        }
                        throw new Exception("category is not defined for " + templateContext.getURI());
                    }
                }
                template.setSampleInformationTemplate(sampleInfoTemplate);
                template.setAmountTemplate(amountTemplate);
                template.setPurityQCTemplate(purityQCTemplate);
                template.setTrackingTemplate(trackingTemplate);
            } else {
                throw new Exception("The given uri is not of type Template but is of type " + indiv.getOntClass().getURI());
            }
        }
        return template;
    }

    public DescriptorGroup getDescriptorGroupFromEitherOntology(String uri) throws Exception {
        DescriptorGroup descriptorGroup = null;
        if (this.standardOntologymodel != null) {
            descriptorGroup = this.getDescriptorGroupByUri(this.standardOntologymodel, uri);
        }
        if (descriptorGroup == null) {
            descriptorGroup = this.getDescriptorGroupByUri(this.localOntologymodel, uri);
        }
        return descriptorGroup;
    }

    public Descriptor getDescriptorFromEitherOntology(String uri) throws Exception {
        Descriptor descriptor = null;
        if (this.standardOntologymodel != null) {
            descriptor = this.getDescriptorByUri(this.standardOntologymodel, uri);
        }
        if (descriptor == null) {
            descriptor = this.getDescriptorByUri(this.localOntologymodel, uri);
        }
        return descriptor;
    }

    public Individual getResourceIndiv(String uri) {
        Individual resourceIndividual = null;
        if (this.standardOntologymodel != null) {
            resourceIndividual = this.standardOntologymodel.getIndividual(uri);
        }
        if (resourceIndividual == null) {
            resourceIndividual = this.localOntologymodel.getIndividual(uri);
        }
        return resourceIndividual;
    }
}

