/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.viewers.TableViewer;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractAddAction;
import org.grits.toolbox.editor.samplemanager.dialogs.addunit.AddMeasurementUnitDialog;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.UnitListLabelProvider;
import org.grits.toolbox.entry.sample.config.Config;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddUnitToDescriptorAction
extends AbstractAddAction {
    private static final Logger logger = Logger.getLogger(AddUnitToDescriptorAction.class);
    private ArrayList<MeasurementUnit> allUnits;
    private HashMap<String, String> unitLabelToUriMap;
    private AddMeasurementUnitDialog unitSelectionDialog;

    public AddUnitToDescriptorAction(AbstractManagementPage page, TableViewer tableViewer) {
        super(page, tableViewer);
        this.init();
    }

    private void init() {
        List unitURIs = new ArrayList();
        this.allUnits = new ArrayList();
        if (!this.editor.managerMode) {
            List<MeasurementUnit> unitsInStdOntology = this.ontologyManagerApi.getAllMeasurementUnits(this.standardOntology);
            this.allUnits = new ArrayList<MeasurementUnit>(unitsInStdOntology);
            unitURIs = UtilityDescriptorDescriptorGroup.getURIs(unitsInStdOntology);
        }
        List<MeasurementUnit> unitsInLocalOntology = this.ontologyManagerApi.getAllMeasurementUnits(this.localOntology);
        this.unitLabelToUriMap = new HashMap();
        for (MeasurementUnit localUnit : unitsInLocalOntology) {
            if (unitURIs.contains(localUnit.getUri())) continue;
            this.allUnits.add(localUnit);
        }
        for (MeasurementUnit unit : this.allUnits) {
            this.unitLabelToUriMap.put(unit.getLabel(), unit.getUri());
        }
        OntModel ontologyModel = null;
        try {
            URL resourceFileUrl = FileLocator.toFileURL((URL)Config.ONTOLOGY_RESOURCE_URL);
            String ontologyFilePath = String.valueOf(resourceFileUrl.getPath()) + "units" + File.separator + "uo.owl";
            FileInputStream inputStream = new FileInputStream(new File(ontologyFilePath));
            ontologyModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
            ontologyModel.read((InputStream)inputStream, "http://www.grits-toolbox.org/ontology/sample#");
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.unitSelectionDialog = new AddMeasurementUnitDialog(this.page.getRightSectionOfPage().getShell(), ontologyModel);
    }

    @Override
    public void run() {
        Descriptor descriptor = (Descriptor)this.tableViewer.getInput();
        List validUnits = descriptor.getValidUnits();
        List existingURIs = UtilityDescriptorDescriptorGroup.getURIs((List)validUnits);
        this.unitSelectionDialog.setExistingURIs(existingURIs);
        this.unitSelectionDialog.open();
        if (this.unitSelectionDialog.getReturnCode() == 0) {
            String selectedUnitURI = this.unitSelectionDialog.getSelectedMeasurementUnit().getUri();
            String selectedUnitLabel = this.unitSelectionDialog.getSelectedMeasurementUnit().getLabel();
            this.unitLabelToUriMap.put(selectedUnitLabel, selectedUnitURI);
            ArrayList<String> selectedUnits = new ArrayList<String>();
            selectedUnits.add(selectedUnitLabel);
            Set<String> unitLabels = this.unitLabelToUriMap.keySet();
            for (String unitLabel : selectedUnits) {
                if (!unitLabels.contains(unitLabel)) continue;
                MeasurementUnit unit = this.unitSelectionDialog.getSelectedMeasurementUnit();
                validUnits.add(unit);
                this.addUnitToDescriptorInOntology(descriptor.getUri(), unit);
                if (validUnits.size() == 1) {
                    this.ontologyManagerApi.setDefaultUnitForDescriptor(descriptor.getUri(), unit.getUri());
                    descriptor.setDefaultMeasurementUnit(selectedUnitURI);
                    ((UnitListLabelProvider)this.tableViewer.getLabelProvider()).setDefaultUnitURI(unit.getUri());
                }
                this.refreshModifed();
            }
        }
    }

    private void addUnitToDescriptorInOntology(String descriptorURI, MeasurementUnit unit) {
        this.ontologyManagerApi.addUnitToDescriptor(descriptorURI, unit);
    }
}

