/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.experimentdesigner.dialog.SaveAsDialog;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolFileHandler;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolVariantExistsException;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.views.ProtocolView;

public class SaveProtocolVariantAction {
    private static final Logger logger = Logger.getLogger(SaveProtocolVariantAction.class);
    @Inject
    ProtocolView view;

    @Execute
    public void run() {
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner BEGIN SaveProtocolVariantAction");
        this.openDialog(this.view.getProtocol());
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner END SaveProtocolVariantAction");
    }

    @CanExecute
    public boolean canExecute() {
        return this.view.getProtocol() != null;
    }

    private void openDialog(ProtocolNode protocol) {
        if (protocol != null) {
            Shell shell = Display.getCurrent().getActiveShell();
            String uri = protocol.getTemplateUri();
            if (uri == null) {
                logger.info((Object)"org.grits.toolbox.editor.experimentdesigner Could not save it as a protocol variant since there is not template. ");
                MessageDialog.openInformation((Shell)shell, (String)"Not Allowed", (String)"Protocol does not follow any protocol templates. Please save it as a template first before saving as a protocol variant");
                return;
            }
            SaveAsDialog dialog = new SaveAsDialog(shell, SaveAsDialog.PROTOCOL_VARIANT, uri);
            dialog.create();
            dialog.getShell().setSize(550, 300);
            if (dialog.open() == 0) {
                try {
                    ProtocolNode protocolVariant = new ProtocolNode();
                    protocolVariant.setLabel(dialog.getName());
                    protocolVariant.setCategory(protocol.getCategory());
                    protocolVariant.setDescription(protocol.getDescription());
                    protocolVariant.setColor(protocol.getColor());
                    protocolVariant.setCreator(protocol.getCreator());
                    protocolVariant.setTemplate(protocol.getTemplate());
                    protocolVariant.setTemplateUri(protocol.getTemplateUri());
                    protocolVariant.setUri(protocol.getUri());
                    protocolVariant.setUrl(protocol.getUrl());
                    if (protocol.getFile() != null) {
                        protocolVariant.setFile(ProtocolFileHandler.copyFromWorkspaceToConfig(protocol.getFile(), this.view.getProjectEntry().getDisplayName()));
                    }
                    protocolVariant.setLocation(protocol.getLocation());
                    protocolVariant.setSize(protocol.getSize());
                    protocolVariant.setMyColor(protocol.getMyColor());
                    protocolVariant.setPapers(protocol.getPapers());
                    protocolVariant.setParameters(protocol.getParameters());
                    protocolVariant.setParameterGroups(protocol.getParameterGroups());
                    new ExperimentDesignOntologyAPI().createProtocolVariant(protocolVariant);
                }
                catch (ProtocolVariantExistsException protocolVariantExistsException) {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Protocol with name: " + dialog.getName() + " already exists. Please choose a different name"));
                    this.openDialog(protocol);
                }
                catch (Exception e) {
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Could not save it as a protocol variant. ", (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Could not save it as a protocol variant. " + e));
                }
            }
        }
    }
}

