/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.figureparts.ColorMapRamp;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.widgets.heatmap.GritsPredefinedColorMap;

public class ColorMapCanvas
extends Canvas {
    LightweightSystem lws;
    ColorMapRamp colorMapRamp;
    ColorMap colorMap;
    Double min = 0.0;
    Double max = 255.0;

    public ColorMapCanvas(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    private void init() {
        this.lws = new LightweightSystem();
        this.lws.setControl((Canvas)this);
    }

    public void initializeRamp(Double min, Double max, ColorMap colorMap) {
        this.colorMapRamp = new ColorMapRamp();
        this.colorMapRamp.setColorMap(colorMap);
        this.colorMapRamp.setMin(min.doubleValue());
        this.colorMapRamp.setMax(max.doubleValue());
        this.lws.setContents((IFigure)this.colorMapRamp);
    }

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(100, 200);
        shell.setLayout((Layout)new FillLayout());
        shell.open();
        ColorMapCanvas colorMapRamp = new ColorMapCanvas((Composite)shell, 0);
        ColorMap colorMap = new ColorMap();
        colorMap.setColorMap(GritsPredefinedColorMap.BlueRedYelow.getMap());
        colorMapRamp.initializeRamp(-100.0, 100.0, colorMap);
        colorMapRamp.setBounds(shell.getClientArea());
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

