/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ISeries;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.series.SeriesSet;

public class AxisSet
implements IAxisSet {
    private HashMap<Integer, Axis> xAxisMap;
    private HashMap<Integer, Axis> yAxisMap;
    private Chart chart;

    public AxisSet(Chart chart) {
        this.chart = chart;
        this.xAxisMap = new HashMap();
        this.yAxisMap = new HashMap();
        Axis xAxis = new Axis(0, IAxis.Direction.X, chart);
        Axis yAxis = new Axis(0, IAxis.Direction.Y, chart);
        this.xAxisMap.put(0, xAxis);
        this.yAxisMap.put(0, yAxis);
    }

    private HashMap<Integer, Axis> getAxisMap(IAxis.Direction direction) {
        if (direction == IAxis.Direction.X) {
            return this.xAxisMap;
        }
        return this.yAxisMap;
    }

    @Override
    public int createXAxis() {
        return this.createAxis(IAxis.Direction.X);
    }

    @Override
    public int createYAxis() {
        return this.createAxis(IAxis.Direction.Y);
    }

    private int createAxis(IAxis.Direction direction) {
        int id = this.getUniqueId(direction);
        Axis axis = new Axis(id, direction, this.chart);
        this.getAxisMap(direction).put(id, axis);
        this.chart.updateLayout();
        SeriesSet series = (SeriesSet)this.chart.getSeriesSet();
        if (series != null) {
            series.compressAllSeries();
        }
        return id;
    }

    private int getUniqueId(IAxis.Direction direction) {
        Set<Integer> keySet = this.getAxisMap(direction).keySet();
        int i = 0;
        while (keySet.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public IAxis getXAxis(int id) {
        return this.getAxis(id, IAxis.Direction.X);
    }

    @Override
    public IAxis getYAxis(int id) {
        return this.getAxis(id, IAxis.Direction.Y);
    }

    private IAxis getAxis(int id, IAxis.Direction direction) {
        return this.getAxisMap(direction).get(id);
    }

    @Override
    public IAxis[] getXAxes() {
        Collection<Axis> values = this.xAxisMap.values();
        return values.toArray(new Axis[values.size()]);
    }

    @Override
    public IAxis[] getYAxes() {
        Collection<Axis> values = this.yAxisMap.values();
        return values.toArray(new Axis[values.size()]);
    }

    @Override
    public IAxis[] getAxes() {
        ArrayList<Axis> axes = new ArrayList<Axis>();
        axes.addAll(this.xAxisMap.values());
        axes.addAll(this.yAxisMap.values());
        return axes.toArray(new Axis[axes.size()]);
    }

    @Override
    public int[] getXAxisIds() {
        return this.getAxisIds(IAxis.Direction.X);
    }

    @Override
    public int[] getYAxisIds() {
        return this.getAxisIds(IAxis.Direction.Y);
    }

    private int[] getAxisIds(IAxis.Direction direction) {
        Set<Integer> keySet = this.getAxisMap(direction).keySet();
        Integer[] array = keySet.toArray(new Integer[keySet.size()]);
        int[] ids = new int[array.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = array[i];
        }
        Arrays.sort(ids);
        return ids;
    }

    @Override
    public void deleteXAxis(int id) {
        this.deleteAxis(id, IAxis.Direction.X);
    }

    @Override
    public void deleteYAxis(int id) {
        this.deleteAxis(id, IAxis.Direction.Y);
    }

    private void deleteAxis(int id, IAxis.Direction direction) {
        if (id == 0) {
            SWT.error((int)7);
        }
        if (this.getAxisMap(direction).get(id) == null) {
            throw new IllegalArgumentException("Given axis id doesn't exist");
        }
        ((Axis)this.getAxis(id, direction)).dispose();
        this.getAxisMap(direction).remove(id);
        for (ISeries series : this.chart.getSeriesSet().getSeries()) {
            if (direction == IAxis.Direction.X) {
                if (series.getXAxisId() != id) continue;
                series.setXAxisId(0);
                continue;
            }
            if (series.getYAxisId() != id) continue;
            series.setYAxisId(0);
        }
        this.chart.updateLayout();
    }

    @Override
    public void adjustRange() {
        for (IAxis axis : this.getAxes()) {
            ((Axis)axis).adjustRange(false);
        }
        this.chart.updateLayout();
    }

    @Override
    public void zoomIn() {
        for (IAxis axis : this.getAxes()) {
            axis.zoomIn();
        }
    }

    @Override
    public void zoomOut() {
        for (IAxis axis : this.getAxes()) {
            axis.zoomOut();
        }
    }

    public void updateLayoutData() {
        for (IAxis axis : this.getAxes()) {
            ((Axis)axis).updateLayoutData();
        }
    }

    public void refresh() {
        for (IAxis axis : this.getAxes()) {
            ((Axis)axis).refresh();
        }
    }

    public void dispose() {
        for (IAxis axis : this.getAxes()) {
            ((Axis)axis).dispose();
        }
    }
}

