/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.ChartTitle;
import org.swtchart.internal.Legend;
import org.swtchart.internal.PlotArea;
import org.swtchart.internal.Util;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.axis.AxisTickLabels;
import org.swtchart.internal.axis.AxisTickMarks;
import org.swtchart.internal.axis.AxisTitle;

public class ChartLayout
extends Layout {
    private int titleHeight;
    private int titleWidth;
    private int legendWidth;
    private int legendHeight;
    private int bottomAxisHeight;
    private int topAxisHeight;
    private int leftAxisWidth;
    private int rightAxisWidth;
    private int plotAreaWidth;
    private int plotAreaHeight;
    private ChartTitle title;
    private Legend legend;
    private PlotArea plot;
    private Axis[] axes;
    private Axis[] horizontalAxes;
    private Axis[] verticalAxes;
    private Map<Axis, AxisLayoutData> axisLayoutDataMap;
    private int bottomAxisOffset = 0;
    private int topAxisOffset = 0;
    private int leftAxisOffset = 0;
    private int rightAxisOffset = 0;
    public static final int MARGIN = 5;
    public static final int PADDING = 5;

    public ChartLayout() {
        this.initWidgetSizeVariables();
        this.axisLayoutDataMap = new HashMap<Axis, AxisLayoutData>();
    }

    private void initWidgetSizeVariables() {
        this.titleHeight = 0;
        this.titleWidth = 0;
        this.bottomAxisHeight = 0;
        this.topAxisHeight = 0;
        this.leftAxisWidth = 0;
        this.rightAxisWidth = 0;
        this.legendWidth = 0;
        this.legendHeight = 0;
        this.plotAreaWidth = 0;
        this.plotAreaHeight = 0;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(wHint, hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (!this.parseControls(composite)) {
            return;
        }
        Rectangle r = composite.getClientArea();
        this.initWidgetSizeVariables();
        this.initTitleAndLegendSize();
        this.initAxisSize();
        this.computePlotAreaSize(r);
        this.computeAxisSize(r);
        this.adjustForRotatedTickLabels(r);
        this.adjustForMostLeftRightTickLabel(r);
        this.layoutTitle(r);
        this.layoutLegend(r);
        this.layoutPlot(r);
        this.layoutAxes(r);
    }

    private boolean parseControls(Composite composite) {
        for (Control child : composite.getChildren()) {
            if (child instanceof Legend) {
                this.legend = (Legend)child;
                continue;
            }
            if (!(child instanceof PlotArea)) continue;
            this.plot = (PlotArea)child;
        }
        if (composite instanceof Chart) {
            IAxisSet axisSet = ((Chart)composite).getAxisSet();
            if (axisSet != null) {
                this.axes = (Axis[])axisSet.getAxes();
                if (((Chart)composite).getOrientation() == 256) {
                    this.horizontalAxes = (Axis[])axisSet.getXAxes();
                    this.verticalAxes = (Axis[])axisSet.getYAxes();
                } else {
                    this.verticalAxes = (Axis[])axisSet.getXAxes();
                    this.horizontalAxes = (Axis[])axisSet.getYAxes();
                }
            }
            this.title = (ChartTitle)((Chart)composite).getTitle();
        }
        return this.title != null && this.legend != null && this.plot != null && this.axes != null;
    }

    private void initTitleAndLegendSize() {
        this.titleWidth = this.title.getLayoutData().widthHint;
        this.titleHeight = this.title.getLayoutData().heightHint;
        this.legendWidth = ((ChartLayoutData)this.legend.getLayoutData()).widthHint;
        this.legendHeight = ((ChartLayoutData)this.legend.getLayoutData()).heightHint;
    }

    private void initAxisSize() {
        this.axisLayoutDataMap.clear();
        for (Axis axis : this.axes) {
            AxisLayoutData layoutData = new AxisLayoutData(axis);
            if (layoutData.titleLayoutdata == null || layoutData.tickLabelsLayoutdata == null || layoutData.tickMarksLayoutdata == null) continue;
            this.axisLayoutDataMap.put(axis, layoutData);
            IAxis.Position position = axis.getPosition();
            if (position == IAxis.Position.Primary && axis.isHorizontalAxis()) {
                this.bottomAxisHeight += layoutData.titleLayoutdata.heightHint + layoutData.tickLabelsLayoutdata.heightHint + layoutData.tickMarksLayoutdata.heightHint;
                continue;
            }
            if (position == IAxis.Position.Secondary && axis.isHorizontalAxis()) {
                this.topAxisHeight += layoutData.titleLayoutdata.heightHint + layoutData.tickLabelsLayoutdata.heightHint + layoutData.tickMarksLayoutdata.heightHint;
                continue;
            }
            if (position == IAxis.Position.Primary && !axis.isHorizontalAxis()) {
                this.leftAxisWidth += layoutData.titleLayoutdata.widthHint + layoutData.tickLabelsLayoutdata.widthHint + layoutData.tickMarksLayoutdata.widthHint;
                continue;
            }
            if (position != IAxis.Position.Secondary || axis.isHorizontalAxis()) continue;
            this.rightAxisWidth += layoutData.titleLayoutdata.widthHint + layoutData.tickLabelsLayoutdata.widthHint + layoutData.tickMarksLayoutdata.widthHint;
        }
    }

    private void computePlotAreaSize(Rectangle r) {
        int legendPosition = this.legend.getPosition();
        this.plotAreaWidth = r.width - this.leftAxisWidth - this.rightAxisWidth - (legendPosition == 16384 || legendPosition == 131072 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0) - 10;
        this.plotAreaHeight = r.height - this.bottomAxisHeight - this.topAxisHeight - this.titleHeight - 10 - (this.titleHeight == 0 ? 0 : 5) - (legendPosition == 128 || legendPosition == 1024 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
    }

    private void computeAxisSize(Rectangle r) {
        this.updateVerticalAxisTick();
        for (Axis axis : this.verticalAxes) {
            int tickLabelMaxLength = axis.getTick().getAxisTickLabels().getTickLabelMaxLength();
            AxisLayoutData axisLayout = this.axisLayoutDataMap.get(axis);
            axisLayout.tickLabelsLayoutdata.widthHint += tickLabelMaxLength;
            if (axis.getPosition() == IAxis.Position.Primary) {
                this.leftAxisWidth += tickLabelMaxLength;
                continue;
            }
            this.rightAxisWidth += tickLabelMaxLength;
        }
        this.computePlotAreaSize(r);
        this.updateHorizontalAxisTick();
    }

    private void adjustForRotatedTickLabels(Rectangle r) {
        for (Axis axis : this.horizontalAxes) {
            double angle = axis.getTick().getTickLabelAngle();
            if (angle == 0.0) continue;
            int tickLabelMaxLength = axis.getTick().getAxisTickLabels().getTickLabelMaxLength();
            AxisLayoutData layoutData = this.axisLayoutDataMap.get(axis);
            int height = 5 + (int)((double)tickLabelMaxLength * Math.sin(Math.toRadians(angle)) + (double)Util.getExtentInGC((Font)layoutData.axisTickLabels.getFont(), (String)"dummy").y * Math.cos(Math.toRadians(angle)));
            int delta = height - layoutData.tickLabelsLayoutdata.heightHint;
            layoutData.tickLabelsLayoutdata.heightHint = height;
            if (axis.getPosition() == IAxis.Position.Primary) {
                this.bottomAxisHeight += delta;
            } else {
                this.topAxisHeight += delta;
            }
            this.computePlotAreaSize(r);
            this.updateVerticalAxisTick();
        }
    }

    private void adjustForMostLeftRightTickLabel(Rectangle r) {
        int rightAxisMarginHint = 0;
        int leftAxisMarginHint = 0;
        for (Axis axis : this.horizontalAxes) {
            rightAxisMarginHint = Math.max(rightAxisMarginHint, axis.getTick().getAxisTickLabels().getRightMarginHint(this.plotAreaWidth));
            leftAxisMarginHint = Math.max(leftAxisMarginHint, axis.getTick().getAxisTickLabels().getLeftMarginHint(this.plotAreaWidth));
        }
        if ((this.legendWidth == 0 || this.legend.getPosition() != 131072) && this.rightAxisWidth < rightAxisMarginHint) {
            this.rightAxisWidth = rightAxisMarginHint;
            this.computePlotAreaSize(r);
            this.updateHorizontalAxisTick();
        }
        if ((this.legendWidth == 0 || this.legend.getPosition() != 16384) && this.leftAxisWidth < leftAxisMarginHint) {
            this.leftAxisWidth = leftAxisMarginHint;
            this.computePlotAreaSize(r);
            this.updateHorizontalAxisTick();
        }
    }

    private void updateHorizontalAxisTick() {
        for (Axis axis : this.horizontalAxes) {
            axis.getTick().updateTick(this.plotAreaWidth);
        }
    }

    private void updateVerticalAxisTick() {
        for (Axis axis : this.verticalAxes) {
            axis.getTick().updateTick(this.plotAreaHeight);
        }
    }

    private void layoutTitle(Rectangle r) {
        int x = (int)((double)(r.width - this.titleWidth) / 2.0);
        int y = 5;
        int width = this.titleWidth;
        int height = this.titleHeight;
        this.title.setBounds(x, y, width, height);
    }

    private void layoutLegend(Rectangle r) {
        int y;
        int x;
        int legendPosition = this.legend.getPosition();
        int tHeight = this.titleHeight + (this.titleHeight == 0 ? 0 : 5);
        if (legendPosition == 131072) {
            x = r.width - this.legendWidth - 5;
            y = (tHeight + r.height - this.legendHeight) / 2;
        } else if (legendPosition == 16384) {
            x = 5;
            y = (tHeight + r.height - this.legendHeight) / 2;
        } else if (legendPosition == 128) {
            x = (r.width - this.legendWidth) / 2;
            y = tHeight + 5;
        } else if (legendPosition == 1024) {
            x = (r.width - this.legendWidth) / 2;
            y = r.height - this.legendHeight - 5;
        } else {
            throw new IllegalStateException();
        }
        int width = this.legendWidth;
        int height = this.legendHeight;
        if (y < tHeight) {
            y = tHeight;
        }
        this.legend.setBounds(x, y, width, height);
    }

    private void layoutPlot(Rectangle r) {
        int legendPosition = this.legend.getPosition();
        int x = this.leftAxisWidth + 5 + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisHeight + 5 + (this.titleHeight == 0 ? 0 : 5) + (legendPosition == 128 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.plot.setBounds(x, y, this.plotAreaWidth, this.plotAreaHeight);
    }

    private void layoutAxes(Rectangle r) {
        this.bottomAxisOffset = 0;
        this.topAxisOffset = 0;
        this.leftAxisOffset = 0;
        this.rightAxisOffset = 0;
        for (Axis axis : this.axes) {
            AxisLayoutData layoutData = this.axisLayoutDataMap.get(axis);
            IAxis.Position position = axis.getPosition();
            if (position == IAxis.Position.Primary && axis.isHorizontalAxis()) {
                this.layoutBottomAxis(r, layoutData);
                continue;
            }
            if (position == IAxis.Position.Secondary && axis.isHorizontalAxis()) {
                this.layoutTopAxis(r, layoutData);
                continue;
            }
            if (position == IAxis.Position.Primary && !axis.isHorizontalAxis()) {
                this.layoutLeftAxis(r, layoutData);
                continue;
            }
            if (position != IAxis.Position.Secondary || axis.isHorizontalAxis()) continue;
            this.layoutRightAxis(r, layoutData);
        }
    }

    private void layoutBottomAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int height = layoutData.titleLayoutdata.heightHint;
        int x = this.leftAxisWidth + 5 + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = r.height - height - this.bottomAxisOffset - 5 - (legendPosition == 1024 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.bottomAxisOffset += height;
        if (y - layoutData.tickLabelsLayoutdata.heightHint - layoutData.tickMarksLayoutdata.heightHint < this.titleHeight + (this.titleHeight == 0 ? 0 : 5)) {
            y = this.titleHeight + (this.titleHeight == 0 ? 0 : 5) + layoutData.tickLabelsLayoutdata.heightHint + layoutData.tickMarksLayoutdata.heightHint;
        }
        int width = layoutData.titleLayoutdata.widthHint;
        int titleX = x + (this.plotAreaWidth - width) / 2;
        layoutData.axisTitle.setBounds(titleX, y, width, height);
        height = layoutData.tickLabelsLayoutdata.heightHint;
        this.bottomAxisOffset += height;
        layoutData.axisTickLabels.setBounds(0, y -= height, r.width, height);
        height = layoutData.tickMarksLayoutdata.heightHint;
        this.bottomAxisOffset += height;
        layoutData.axisTickMarks.setBounds(x, y -= height, this.plotAreaWidth, height);
    }

    private void layoutTopAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int height = layoutData.titleLayoutdata.heightHint;
        int x = this.leftAxisWidth + 5 + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisOffset + 5 + (this.titleHeight == 0 ? 0 : 5);
        this.topAxisOffset += height;
        int width = layoutData.titleLayoutdata.widthHint;
        int titleX = x + (this.plotAreaWidth - width) / 2;
        layoutData.axisTitle.setBounds(titleX, y, width, height);
        y += height;
        height = layoutData.tickLabelsLayoutdata.heightHint;
        this.topAxisOffset += height;
        layoutData.axisTickLabels.setBounds(0, y, r.width, height);
        y += height;
        height = layoutData.tickMarksLayoutdata.heightHint;
        this.topAxisOffset += height;
        layoutData.axisTickMarks.setBounds(x, y, this.plotAreaWidth, height);
    }

    private void layoutLeftAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int yAxisMargin = 10;
        int width = layoutData.titleLayoutdata.widthHint;
        int x = 5 + this.leftAxisOffset + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisHeight + 5 + (this.titleHeight == 0 ? 0 : 5) + (legendPosition == 128 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.leftAxisOffset += width;
        int height = layoutData.titleLayoutdata.heightHint;
        int titleY = y + (this.plotAreaHeight - height) / 2;
        layoutData.axisTitle.setBounds(x, titleY, width, height);
        x += width;
        width = layoutData.tickLabelsLayoutdata.widthHint;
        this.leftAxisOffset += width;
        layoutData.axisTickLabels.setBounds(x, y - yAxisMargin, width, this.plotAreaHeight + yAxisMargin * 2);
        x += width;
        width = layoutData.tickMarksLayoutdata.widthHint;
        this.leftAxisOffset += width;
        layoutData.axisTickMarks.setBounds(x, y, width, this.plotAreaHeight);
    }

    private void layoutRightAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int yAxisMargin = 10;
        int width = layoutData.titleLayoutdata.widthHint;
        int x = r.width - width - this.rightAxisOffset - 5 - (legendPosition == 131072 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisHeight + 5 + (this.titleHeight == 0 ? 0 : 5) + (legendPosition == 128 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.rightAxisOffset += width;
        int height = layoutData.titleLayoutdata.heightHint;
        int titleY = y + (this.plotAreaHeight - height) / 2;
        layoutData.axisTitle.setBounds(x, titleY, width, height);
        width = layoutData.tickLabelsLayoutdata.widthHint;
        this.rightAxisOffset += width;
        layoutData.axisTickLabels.setBounds(x -= width, y - yAxisMargin, width, this.plotAreaHeight + yAxisMargin * 2);
        width = layoutData.tickMarksLayoutdata.widthHint;
        this.rightAxisOffset += width;
        layoutData.axisTickMarks.setBounds(x -= width, y, width, this.plotAreaHeight);
    }

    private static class AxisLayoutData {
        public AxisTickMarks axisTickMarks;
        public AxisTickLabels axisTickLabels;
        public AxisTitle axisTitle;
        public ChartLayoutData titleLayoutdata;
        public ChartLayoutData tickLabelsLayoutdata;
        public ChartLayoutData tickMarksLayoutdata;

        public AxisLayoutData(Axis axis) {
            this.axisTickMarks = axis.getTick().getAxisTickMarks();
            this.axisTickLabels = axis.getTick().getAxisTickLabels();
            this.axisTitle = (AxisTitle)axis.getTitle();
            this.titleLayoutdata = this.axisTitle.getLayoutData();
            this.tickLabelsLayoutdata = this.axisTickLabels.getLayoutData();
            this.tickMarksLayoutdata = this.axisTickMarks.getLayoutData();
        }
    }
}

