/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.merge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.editor.MergeReportEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeTableData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergedQrtPCR;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;
import org.grits.toolbox.entry.qrtpcr.table.merge.MergeNatTable;

public class MergeReportTableBase {
    Double lowerThreshold = QrtPCRPreferencePage.THRESHOLD_PREFERENCE;
    Double stDevCutOff = QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE;
    MergedQrtPCR mergeData;
    private MergeReportEditor editor;

    public MergeReportTableBase(MergeReportEditor editor) {
        this.editor = editor;
    }

    public void setLowerThreshold(Double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    public void setMergeData(MergedQrtPCR mergeData) {
        this.mergeData = mergeData;
    }

    public Control createControl(Composite parent) {
        ArrayList<List<GRITSColumnHeader>> columnList = new ArrayList<List<GRITSColumnHeader>>();
        this.addHeaders(columnList, this.mergeData.getAliasList());
        ArrayList<TableData> allData = new ArrayList<TableData>();
        for (Gene gene : this.mergeData.getQrtPCRGeneListMap().keySet()) {
            if (gene.getIsCommon().booleanValue() || gene.getIsControl().booleanValue()) continue;
            MergeTableData myTableData = new MergeTableData(gene, this.mergeData.getQrtPCRGeneListMap().get(gene));
            allData.add(myTableData);
        }
        ArrayList<String> aliasses = new ArrayList<String>();
        for (String string : this.mergeData.getAliasList().values()) {
            aliasses.add(string);
        }
        MergeNatTable natTable = new MergeNatTable(parent, this.editor, columnList, aliasses);
        natTable.setMasterTable(true);
        natTable.setTableData(allData);
        natTable.setLowerThreshold(this.lowerThreshold);
        natTable.setStDevCutOff(this.stDevCutOff);
        natTable.setRawData(false);
        natTable.initializeComponents();
        return natTable;
    }

    private void addHeaders(List<List<GRITSColumnHeader>> columnList, Map<String, String> aliasList) {
        ArrayList<GRITSColumnHeader> firstLevelColumns = new ArrayList<GRITSColumnHeader>();
        GRITSColumnHeader header = new GRITSColumnHeader("", "Info");
        firstLevelColumns.add(header);
        firstLevelColumns.add(header);
        for (String key : aliasList.keySet()) {
            header = new GRITSColumnHeader(aliasList.get(key), aliasList.get(key));
            firstLevelColumns.add(header);
            firstLevelColumns.add(header);
        }
        ArrayList<GRITSColumnHeader> secondLevelColumns = new ArrayList<GRITSColumnHeader>();
        header = new GRITSColumnHeader("Gene Identifier", "Gene Identifier");
        header.setIsGrouped(false);
        secondLevelColumns.add(header);
        header = new GRITSColumnHeader("Gene Symbol", "Gene Symbol");
        header.setIsGrouped(false);
        secondLevelColumns.add(header);
        int i = 0;
        while (i < aliasList.size()) {
            header = new GRITSColumnHeader("Average", "Average");
            secondLevelColumns.add(header);
            header = new GRITSColumnHeader("St Dev - Adjusted", "St Dev - Adjusted");
            secondLevelColumns.add(header);
            ++i;
        }
        columnList.add(firstLevelColumns);
        columnList.add(secondLevelColumns);
    }
}

