/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation.util;

import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.AnnotationEntity;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation;

public class AnnotationToString {
    public String composition(PeakAnnotation peakAnnotation) {
        AnnotationEntity annotationEntity2 = null;
        String string = "";
        for (AnnotationEntity annotationEntity2 : peakAnnotation.getResidues()) {
            string = string + String.format("%s%d", annotationEntity2.getId(), annotationEntity2.getNumber());
        }
        if (peakAnnotation.getDerivatisation() != null && !peakAnnotation.getDerivatisation().equals("none")) {
            string = string + "-" + peakAnnotation.getDerivatisation().toUpperCase();
        }
        return string;
    }

    public String smallMolecules(PeakAnnotation peakAnnotation) {
        String string = "";
        AnnotationEntity annotationEntity2 = null;
        for (AnnotationEntity annotationEntity2 : peakAnnotation.getGain()) {
            if (annotationEntity2.getNumber() > 1) {
                string = string + String.format("+%d%s", annotationEntity2.getNumber(), annotationEntity2.getId());
                continue;
            }
            string = string + "+" + annotationEntity2.getId();
        }
        for (AnnotationEntity annotationEntity2 : peakAnnotation.getLoss()) {
            if (annotationEntity2.getNumber() > 1) {
                string = string + String.format("-%d%s", annotationEntity2.getNumber(), annotationEntity2.getId());
                continue;
            }
            string = string + "-" + annotationEntity2.getId();
        }
        return string;
    }

    public String chargedIon(PeakAnnotation peakAnnotation) {
        String string = "";
        AnnotationEntity annotationEntity2 = null;
        int n = 0;
        for (AnnotationEntity annotationEntity2 : peakAnnotation.getIons()) {
            string = annotationEntity2.getNumber() > 1 ? string + String.format(";%d%s", annotationEntity2.getNumber(), annotationEntity2.getId()) : string + ";" + annotationEntity2.getId();
            n += annotationEntity2.getNumber();
        }
        if (peakAnnotation.getIonExchange().size() > 0) {
            string = peakAnnotation.getIonExchange().size() > 1 ? string + String.format(";-%dH+", peakAnnotation.getIonExchange().size()) : string + ";-H+";
            for (AnnotationEntity annotationEntity2 : peakAnnotation.getIonExchange()) {
                if (annotationEntity2.getNumber() > 1) {
                    string = string + String.format(";%d%s", annotationEntity2.getNumber(), annotationEntity2.getId());
                    continue;
                }
                string = string + ";" + annotationEntity2.getId();
            }
        }
        if (string.length() > 0) {
            return string.substring(1);
        }
        return "";
    }

    public String ion(PeakAnnotation peakAnnotation) {
        String string = "";
        AnnotationEntity annotationEntity2 = null;
        for (AnnotationEntity annotationEntity2 : peakAnnotation.getFragments()) {
            string = string + ";" + annotationEntity2.getId();
        }
        if (string.length() > 0) {
            return string.substring(1);
        }
        return "";
    }
}

