/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.om.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.io.xml.StringBooleanMapAdapter;
import org.grits.toolbox.ms.om.io.xml.StringDoubleMapAdapter;
import org.grits.toolbox.ms.om.io.xml.StringIntegerMapAdapter;
import org.grits.toolbox.ms.om.io.xml.StringStringMapAdapter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;

@XmlRootElement(name="method")
public class Method {
    public static final String ANNOTATION_TYPE_GLYCAN = "GLYCAN";
    public static final String ANNOTATION_TYPE_GLYCOPEPTIDE = "GLYCOPEPTIDE";
    public static final String ANNOTATION_TYPE_GLYCOLIPID = "GLYCOLIPID";
    public static final String ANNOTATION_SRC_SIMGLYCAN = "SimGlycan";
    public static final String ANNOTATION_SRC_SIMIAN = "GRITS";
    public static final String MS_TYPE_INFUSION = "Direct Infusion";
    public static final String MS_TYPE_INFUSION_LABEL = "Tandem MS (MS2, MS3,...)";
    public static final String MS_TYPE_LC = "LC-MS/MS";
    public static final String MS_TYPE_LC_LABEL = "LC-MS/MS";
    public static final String MS_TYPE_TIM = "Total Ion Mapping (TIM)";
    public static final String MS_TYPE_TIM_LABEL = "Total Ion Mapping (TIM)";
    public static final String MS_TYPE_MSPROFILE = "MS Profile";
    public static final String MS_TYPE_MSPROFILE_LABEL = "MS Profile";
    public static final String[] MS_TYPES = new String[]{"Tandem MS (MS2, MS3,...)", "Total Ion Mapping (TIM)", "LC-MS/MS", "MS Profile"};
    private String m_version = "1.02";
    private String m_annotationType = null;
    private String m_annotationSource = null;
    private String m_msType = null;
    private Boolean m_monoisotopic = Boolean.TRUE;
    private Double m_accuracy = null;
    private Boolean m_accuracyPpm = Boolean.TRUE;
    private Double m_fragAccuracy = null;
    private Boolean m_fragAccuracyPpm = Boolean.TRUE;
    private Boolean m_trustMzCharge = Boolean.TRUE;
    private Double m_shift = null;
    private Double m_intensityCutoff = null;
    private Double m_precursorIntensityCutoff = null;
    private String m_intensityCutoffType = null;
    private String m_precursorIntensityCutoffType = null;
    @XmlElement(name="ion")
    private List<IonSettings> m_ions = new ArrayList<IonSettings>();
    @XmlElement(name="ionExchange")
    private List<IonSettings> m_ionExchanges = new ArrayList<IonSettings>();
    private List<MoleculeSettings> m_neutralLoss = new ArrayList<MoleculeSettings>();
    @XmlElement(name="AnalyteSetting")
    private List<AnalyteSettings> m_analyteSettings = new ArrayList<AnalyteSettings>();
    private Integer m_maxIonCount = null;
    private Integer m_maxIonExchangeCount = null;
    @XmlElement(name="methodCustomExtraData")
    private List<CustomExtraData> m_MethodCustomExtraData = new ArrayList<CustomExtraData>();
    @XmlTransient
    private FilterSetting filterSetting;
    private HashMap<String, Integer> m_integerProp = new HashMap();
    private HashMap<String, Double> m_doubleProp = new HashMap();
    private HashMap<String, String> m_stringProp = new HashMap();
    private HashMap<String, Boolean> m_booleanProp = new HashMap();

    public static String getMsTypeByLabel(String label) {
        if (label.equals(MS_TYPE_INFUSION_LABEL)) {
            return MS_TYPE_INFUSION;
        }
        if (label.equals("LC-MS/MS")) {
            return "LC-MS/MS";
        }
        if (label.equals("MS Profile")) {
            return "MS Profile";
        }
        if (label.equals("Total Ion Mapping (TIM)")) {
            return "Total Ion Mapping (TIM)";
        }
        return null;
    }

    public static String getMsLabelByType(String msType) {
        if (msType.equals(MS_TYPE_INFUSION)) {
            return MS_TYPE_INFUSION_LABEL;
        }
        if (msType.equals("LC-MS/MS")) {
            return "LC-MS/MS";
        }
        if (msType.equals("MS Profile")) {
            return "MS Profile";
        }
        if (msType.equals("Total Ion Mapping (TIM)")) {
            return "Total Ion Mapping (TIM)";
        }
        return null;
    }

    @XmlTransient
    public List<CustomExtraData> getMethodCustomExtraData() {
        return this.m_MethodCustomExtraData;
    }

    public void setCustomMethodExtraData(List<CustomExtraData> a_MethodCustomExtraData) {
        this.m_MethodCustomExtraData = a_MethodCustomExtraData;
    }

    @Deprecated
    @XmlElement(name="filterSetting")
    public FilterSetting getFilterSetting() {
        return null;
    }

    public void setFilterSetting(FilterSetting filterSetting) {
        for (AnalyteSettings setting : this.getAnalyteSettings()) {
            if (setting.getGlycanSettings() == null) continue;
            setting.getGlycanSettings().setFilterSetting(filterSetting);
        }
    }

    public Boolean getMonoisotopic() {
        return this.m_monoisotopic;
    }

    @XmlAttribute(name="monoisotopic")
    public void setMonoisotopic(Boolean a_monoisotopic) {
        this.m_monoisotopic = a_monoisotopic;
    }

    public Double getAccuracy() {
        return this.m_accuracy;
    }

    @XmlAttribute(name="accuracy")
    public void setAccuracy(Double a_accuracy) {
        this.m_accuracy = a_accuracy;
    }

    public Boolean getAccuracyPpm() {
        return this.m_accuracyPpm;
    }

    @XmlAttribute(name="accuracyPpm")
    public void setAccuracyPpm(Boolean a_accuracyPpm) {
        this.m_accuracyPpm = a_accuracyPpm;
    }

    public Double getShift() {
        return this.m_shift;
    }

    @XmlAttribute(name="shift")
    public void setShift(Double a_shift) {
        this.m_shift = a_shift;
    }

    @XmlTransient
    public List<IonSettings> getIons() {
        return this.m_ions;
    }

    public void setIons(List<IonSettings> a_ions) {
        this.m_ions = a_ions;
    }

    @XmlTransient
    public List<IonSettings> getIonExchanges() {
        return this.m_ionExchanges;
    }

    public void setIonExchanges(List<IonSettings> a_ionExchanges) {
        this.m_ionExchanges = a_ionExchanges;
    }

    public List<MoleculeSettings> getNeutralLoss() {
        return this.m_neutralLoss;
    }

    public void setNeutralLoss(List<MoleculeSettings> a_neutralLoss) {
        this.m_neutralLoss = a_neutralLoss;
    }

    public String getAnnotationType() {
        return this.m_annotationType;
    }

    @XmlAttribute(name="annotationType")
    public void setAnnotationType(String a_annotationType) {
        this.m_annotationType = a_annotationType;
    }

    public Integer getMaxIonCount() {
        return this.m_maxIonCount;
    }

    @XmlAttribute(name="maxIonCount")
    public void setMaxIonCount(Integer a_maxIonCount) {
        this.m_maxIonCount = a_maxIonCount;
    }

    public Integer getMaxIonExchangeCount() {
        return this.m_maxIonExchangeCount;
    }

    @XmlAttribute(name="maxIonExchangeCount")
    public void setMaxIonExchangeCount(Integer a_maxIonExchangeCount) {
        this.m_maxIonExchangeCount = a_maxIonExchangeCount;
    }

    @XmlTransient
    public List<AnalyteSettings> getAnalyteSettings() {
        return this.m_analyteSettings;
    }

    public void setAnalyteSettings(List<AnalyteSettings> a_analyteSettings) {
        this.m_analyteSettings = a_analyteSettings;
    }

    public String getAnnotationSource() {
        return this.m_annotationSource;
    }

    @XmlAttribute(name="annotationSrc")
    public void setAnnotationSource(String annotationSource) {
        this.m_annotationSource = annotationSource;
    }

    public String getMsType() {
        return this.m_msType;
    }

    @XmlAttribute(name="msType")
    public void setMsType(String m_msType) {
        this.m_msType = m_msType;
    }

    public Boolean getFragAccuracyPpm() {
        return this.m_fragAccuracyPpm;
    }

    @XmlAttribute(name="fragAccuracyPpm")
    public void setFragAccuracyPpm(Boolean m_FragAccuracyPpm) {
        this.m_fragAccuracyPpm = m_FragAccuracyPpm;
    }

    public Double getFragAccuracy() {
        return this.m_fragAccuracy;
    }

    @XmlAttribute(name="fragAccuracy")
    public void setFragAccuracy(Double m_FragAccuracy) {
        this.m_fragAccuracy = m_FragAccuracy;
    }

    public Boolean getTrustMzCharge() {
        return this.m_trustMzCharge;
    }

    @XmlAttribute(name="trustCharge")
    public void setTrustMzCharge(Boolean m_trustMzCharge) {
        this.m_trustMzCharge = m_trustMzCharge;
    }

    @XmlJavaTypeAdapter(value=StringIntegerMapAdapter.class)
    public HashMap<String, Integer> getIntegerProp() {
        return this.m_integerProp;
    }

    public void setIntegerProp(HashMap<String, Integer> a_integerProp) {
        this.m_integerProp = a_integerProp;
    }

    @XmlJavaTypeAdapter(value=StringDoubleMapAdapter.class)
    public HashMap<String, Double> getDoubleProp() {
        return this.m_doubleProp;
    }

    public void setDoubleProp(HashMap<String, Double> a_doubleProp) {
        this.m_doubleProp = a_doubleProp;
    }

    @XmlJavaTypeAdapter(value=StringStringMapAdapter.class)
    public HashMap<String, String> getStringProp() {
        return this.m_stringProp;
    }

    public void setStringProp(HashMap<String, String> a_stringProp) {
        this.m_stringProp = a_stringProp;
    }

    @XmlJavaTypeAdapter(value=StringBooleanMapAdapter.class)
    public HashMap<String, Boolean> getBooleanProp() {
        return this.m_booleanProp;
    }

    public void setBooleanProp(HashMap<String, Boolean> a_booleanProp) {
        this.m_booleanProp = a_booleanProp;
    }

    public boolean addIntegerProp(String a_key, Integer a_value) {
        boolean t_overwrite = false;
        if (this.m_integerProp.get(a_key) != null) {
            t_overwrite = true;
        }
        this.m_integerProp.put(a_key, a_value);
        return t_overwrite;
    }

    public boolean addDoubleProp(String a_key, Double a_value) {
        boolean t_overwrite = false;
        if (this.m_doubleProp.get(a_key) != null) {
            t_overwrite = true;
        }
        this.m_doubleProp.put(a_key, a_value);
        return t_overwrite;
    }

    public boolean addbooleanProp(String a_key, Boolean a_value) {
        boolean t_overwrite = false;
        if (this.m_booleanProp.get(a_key) != null) {
            t_overwrite = true;
        }
        this.m_booleanProp.put(a_key, a_value);
        return t_overwrite;
    }

    public String getVersion() {
        return this.m_version;
    }

    @XmlAttribute(name="version")
    public void setVersion(String a_version) {
        this.m_version = a_version;
    }

    public Double getIntensityCutoff() {
        return this.m_intensityCutoff;
    }

    @XmlAttribute(name="intensityCutoff")
    public void setIntensityCutoff(Double m_intensityCutoff) {
        this.m_intensityCutoff = m_intensityCutoff;
    }

    public Double getPrecursorIntensityCutoff() {
        return this.m_precursorIntensityCutoff;
    }

    @XmlAttribute(name="precursorIntensityCutoff")
    public void setPrecursorIntensityCutoff(Double m_intensityCutoff) {
        this.m_precursorIntensityCutoff = m_intensityCutoff;
    }

    public String getIntensityCutoffType() {
        return this.m_intensityCutoffType;
    }

    @XmlAttribute(name="intensityCutoffType")
    public void setIntensityCutoffType(String m_intensityCutoffType) {
        this.m_intensityCutoffType = m_intensityCutoffType;
    }

    public String getPrecursorIntensityCutoffType() {
        return this.m_precursorIntensityCutoffType;
    }

    @XmlAttribute(name="precursorIntensityCutoffType")
    public void setPrecursorIntensityCutoffType(String m_precursorIntensityCutoffType) {
        this.m_precursorIntensityCutoffType = m_precursorIntensityCutoffType;
    }
}

