/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MaintainTableColumnRatioListener
implements ControlListener {
    private Logger logger = Logger.getLogger(MaintainTableColumnRatioListener.class);
    private int minWidth = 0;
    private final int TABLE_EXTRA_PADDING = 5;
    private static final int COLUMN_FALL_BACK_WIDTH = 10;
    private List<Integer> ratios = null;
    private int ratioDenominator = 0;

    public MaintainTableColumnRatioListener(int minWidth, int ... relativeWidths) {
        this.minWidth = minWidth;
        this.ratios = new ArrayList<Integer>();
        int i = 0;
        int[] nArray = relativeWidths;
        int n = relativeWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int relativeWidth = nArray[n2];
            relativeWidth = relativeWidth < 1 ? 1 : relativeWidth;
            this.ratios.add(i++, relativeWidth);
            this.ratioDenominator += relativeWidth;
            ++n2;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.logger.debug((Object)"- START : Resizing columns.");
        try {
            Table table = (Table)e.getSource();
            if (table.getColumns().length == this.ratios.size()) {
                int totalWidth = Math.max(table.getSize().x - 5, this.minWidth);
                totalWidth -= 20;
                int index = 0;
                TableColumn[] columns = table.getColumns();
                int width = 0;
                int widthTillLastColumn = 0;
                while (index < table.getColumnCount() - 1) {
                    width = totalWidth / this.ratioDenominator * this.ratios.get(index);
                    columns[index].setWidth(width);
                    widthTillLastColumn += width;
                    ++index;
                }
                int remainingWidth = totalWidth - widthTillLastColumn;
                if (remainingWidth >= 0) {
                    columns[index].setWidth(remainingWidth);
                } else {
                    columns[index].setWidth(10);
                    this.logger.error((Object)"Negative width values");
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resizing columns.");
    }
}

