/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare;

public class ConvertImageUnits {
    public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
    public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;
    public static final int PIXELS_PER_INCH = 96;
    public static final double PIXELS_PER_MILLIMETRES = 3.78;
    public static final double POINTS_PER_MILLIMETRE = 2.83;
    public static final double CELL_BORDER_WIDTH_MILLIMETRES = 2.0;
    public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    public static final int UNIT_OFFSET_LENGTH = 7;
    public static final int[] UNIT_OFFSET_MAP;

    static {
        int[] nArray = new int[7];
        nArray[1] = 36;
        nArray[2] = 73;
        nArray[3] = 109;
        nArray[4] = 146;
        nArray[5] = 182;
        nArray[6] = 219;
        UNIT_OFFSET_MAP = nArray;
    }

    public static short pixel2WidthUnits(int pxs) {
        short widthUnits = (short)(256 * (pxs / 7));
        widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
        return widthUnits;
    }

    public static int widthUnits2Pixel(short widthUnits) {
        int pixels = widthUnits / 256 * 7;
        int offsetWidthUnits = widthUnits % 256;
        return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
    }

    public static double widthUnits2Millimetres(short widthUnits) {
        return (double)ConvertImageUnits.widthUnits2Pixel(widthUnits) / 3.78;
    }

    public static int millimetres2WidthUnits(double millimetres) {
        return ConvertImageUnits.pixel2WidthUnits((int)(millimetres * 3.78));
    }

    public static int pointsToPixels(double points) {
        return (int)Math.round(points / 72.0 * 96.0);
    }

    public static double pointsToMillimeters(double points) {
        return points / 72.0 * 25.4;
    }
}

