/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectAction;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class AddEditEventDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(AddEditEventDialog.class);
    private ProjectEvent projectEvent = null;
    private ComboViewer actionCombo = null;
    private Text descriptionText = null;

    public AddEditEventDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setProjectEvent(ProjectEvent projectEvent) {
        this.projectEvent = projectEvent;
    }

    public ProjectEvent getProjectEvent() {
        return this.projectEvent;
    }

    public Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginTop = 20;
        layout.marginBottom = 20;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.getShell().setText("Event");
        this.setTitle("Project Event");
        if (this.projectEvent == null) {
            this.setMessage("Create a new Event");
            this.projectEvent = new ProjectEvent();
            ProjectAction projectAction = new ProjectAction();
            projectAction.setAction(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ACTION).getDefaultValue());
            this.projectEvent.setProjectAction(projectAction);
            this.projectEvent.setDescription("");
        } else if (this.projectEvent.getProjectAction() == null) {
            this.projectEvent.setProjectAction(new ProjectAction());
        } else if (this.projectEvent.getProjectAction().getAction() != null) {
            this.setMessage(this.projectEvent.getProjectAction().getAction());
        }
        this.actionCombo = this.createComboLine(composite, "Action");
        this.setInputInCombo(this.actionCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ACTION).getAllValues());
        this.actionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEditEventDialog.this.projectEvent.getProjectAction().setAction(AddEditEventDialog.this.actionCombo.getCombo().getText());
            }
        });
        this.descriptionText = this.createTextLine(composite, "Description");
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditEventDialog.this.projectEvent.setDescription(((Text)e.getSource()).getText().trim());
            }
        });
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.grabExcessVerticalSpace = false;
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        this.selectInCombo(this.actionCombo, this.projectEvent.getProjectAction().getAction());
        if (this.projectEvent.getDescription() != null) {
            this.descriptionText.setText(this.projectEvent.getDescription());
        }
        logger.debug((Object)"END   : Creating Event Dialog");
        return composite;
    }

    private void selectInCombo(ComboViewer comboViewer, String value) {
        int selectionIndex = -1;
        int i = 0;
        String[] stringArray = comboViewer.getCombo().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (Objects.equals(item, value)) {
                selectionIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        comboViewer.getCombo().select(selectionIndex);
    }

    private void setInputInCombo(ComboViewer comboViewer, Set<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(values);
        Collections.sort(valueList);
        String[] items = new String[valueList.size()];
        int i = 0;
        for (String value : valueList) {
            items[i++] = value;
        }
        comboViewer.getCombo().setItems(items);
    }

    private Text createTextLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        Text text = new Text(composite, 2624);
        GridData newEventData = new GridData(768);
        newEventData.grabExcessHorizontalSpace = true;
        newEventData.horizontalSpan = 1;
        newEventData.verticalSpan = 1;
        newEventData.heightHint = 80;
        newEventData.widthHint = 200;
        text.setLayoutData((Object)newEventData);
        return text;
    }

    private ComboViewer createComboLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newEventData = new GridData(768);
        newEventData.grabExcessHorizontalSpace = true;
        newEventData.horizontalSpan = 1;
        newEventData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newEventData);
        return comboViewer;
    }
}

