/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Singleton
public class GritsPreferenceStore
implements IGritsPreferenceStore {
    private static final Logger logger = Logger.getLogger(GritsPreferenceStore.class);
    @Inject
    IEclipseContext eclipseContext;

    @Override
    public PreferenceEntity getPreferenceEntity(String preferenceName) throws UnsupportedVersionException {
        logger.info((Object)("Reading preference : " + preferenceName));
        PreferenceEntity preferenceEntity = null;
        Element preferenceElement = this.getPreferenceElement(preferenceName);
        if (preferenceElement != null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PreferenceEntity.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                preferenceEntity = (PreferenceEntity)unmarshaller.unmarshal((Reader)new StringReader(new XMLOutputter().outputString(preferenceElement)));
                if (preferenceEntity.getVersion() == null) {
                    logger.fatal((Object)("Version was not found for the preference : " + preferenceName));
                    throw new UnsupportedVersionException("Version was not found for the preference : " + preferenceName, null);
                }
            }
            catch (JAXBException e) {
                String errorMessage = "The preference object : " + preferenceName + " could not be read from xml.\n" + e.getMessage();
                logger.error((Object)errorMessage, (Throwable)e);
                throw new UnsupportedVersionException(errorMessage, (Exception)((Object)e), null);
            }
        }
        return preferenceEntity;
    }

    @Override
    public Element getPreferenceElement(String preferenceName) {
        logger.info((Object)("Reading preference xml element : " + preferenceName));
        if (preferenceName == null) {
            return null;
        }
        try {
            Document document = this.getDocument();
            Element preferenceElement = null;
            for (Object childElement : document.getRootElement().getChildren()) {
                if (!(childElement instanceof Element) || !preferenceName.equals(((Element)childElement).getAttributeValue("name"))) continue;
                preferenceElement = (Element)childElement;
                break;
            }
            return preferenceElement;
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean savePreference(PreferenceEntity preferenceEntity) {
        try {
            if (preferenceEntity != null && preferenceEntity.getName() != null && preferenceEntity.getVersion() != null) {
                logger.info((Object)("Saving preference : " + preferenceEntity.getName()));
                Element preferenceElement = new Element("preference");
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                attributes.add(new Attribute("name", preferenceEntity.getName()));
                attributes.add(new Attribute("version", preferenceEntity.getVersion()));
                preferenceElement.setAttributes(attributes);
                preferenceElement.setText(preferenceEntity.getValue());
                boolean saved = this.savePreference(preferenceElement);
                if (saved) {
                    IEventBroker eventBroker = (IEventBroker)this.eclipseContext.get(IEventBroker.class);
                    if (eventBroker != null) {
                        eventBroker.post("preference_value_changed_in_grits", (Object)preferenceEntity.getName());
                    }
                } else {
                    logger.error((Object)("Preference could not be saved : " + preferenceEntity.getName()));
                }
                return saved;
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("The preference entity could not be serialized as xml." + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    private boolean savePreference(Element preferenceElement) {
        boolean saved = false;
        try {
            String preferenceName = preferenceElement == null ? null : preferenceElement.getAttributeValue("name");
            Document document = this.getDocument();
            if (document != null && preferenceName != null) {
                Element preferences = document.getRootElement();
                GritsPreferenceStore.removeChildren(preferences, preferenceName);
                preferences.getChildren().add(preferenceElement);
                this.saveDocument(document);
                saved = true;
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return saved;
    }

    @Override
    public boolean removePreference(String preferenceName) {
        logger.info((Object)("Removing preference : " + preferenceName));
        try {
            Document document = this.getDocument();
            if (document != null && preferenceName != null) {
                boolean removed = GritsPreferenceStore.removeChildren(document.getRootElement(), preferenceName);
                this.saveDocument(document);
                return removed;
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static boolean removeChildren(Element parentElement, String childName) {
        ArrayList<Element> elementsToRemove = new ArrayList<Element>();
        if (parentElement != null && childName != null) {
            for (Object ch : parentElement.getChildren()) {
                if (!(ch instanceof Element) || !childName.equals(((Element)ch).getAttributeValue("name"))) continue;
                elementsToRemove.add((Element)ch);
            }
            for (Element ele : elementsToRemove) {
                parentElement.removeContent((Content)ele);
            }
        }
        return !elementsToRemove.isEmpty();
    }

    private Document getDocument() {
        Document document = null;
        try {
            File preferenceFile = new File(PREFERENCE_LOCATION);
            if (preferenceFile.exists() && preferenceFile.isFile()) {
                if (preferenceFile.isHidden() && System.getProperty("os.name").startsWith("Windows")) {
                    Files.setAttribute(preferenceFile.toPath(), "dos:hidden", false, new LinkOption[0]);
                }
                document = new SAXBuilder().build(preferenceFile);
            } else {
                logger.info((Object)("Preference file does not exist. Creating new preference file : " + PREFERENCE_LOCATION));
                document = new Document(new Element("preferences"));
                this.saveDocument(document);
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error reading Preference file.\n" + ex.getMessage()), (Throwable)ex);
            document = null;
        }
        return document;
    }

    private void saveDocument(Document document) throws IOException {
        block5: {
            logger.info((Object)("Saving Preference file to : " + PREFERENCE_LOCATION));
            FileWriter fileWriter = null;
            try {
                try {
                    XMLOutputter xmlOutput = new XMLOutputter();
                    xmlOutput.setFormat(Format.getPrettyFormat());
                    fileWriter = new FileWriter(PREFERENCE_LOCATION);
                    xmlOutput.output(document, (Writer)fileWriter);
                    fileWriter.close();
                }
                catch (IOException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    IOUtils.closeQuietly(fileWriter);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fileWriter);
        }
    }
}

