/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.dataShare;

import org.apache.log4j.Logger;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.EditorPart;
import org.grits.toolbox.core.dataShare.PropertyHandler;

public class GritsEditorTracker
implements IPartListener {
    private static final Logger logger = Logger.getLogger(GritsEditorTracker.class);

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part instanceof EditorPart) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IPerspectiveDescriptor currentPerspective = page.getPerspective();
            String currentPerspectiveId = currentPerspective.getId();
            String newPerspectiveId = "org.grits.toolbox.core.perspective.projectexplorer";
            EditorPart editor = (EditorPart)part;
            String editorClass = editor.getClass().getName();
            if (editorClass.contains("experimentdesigner")) {
                logger.debug((Object)"Switching into org.grits.toolbox.editor.experimentdesigner.designPerspective1");
                newPerspectiveId = "org.grits.toolbox.editor.experimentdesigner.designPerspective1";
            } else if (editorClass.contains("glycanarray")) {
                newPerspectiveId = "uk.ac.imperial.glycosciences.glycanarray.perspective";
            } else if (editorClass.contains("qrtpcr")) {
                newPerspectiveId = "org.grits.toolbox.entry.qrtpcr.perspective";
            }
            if (!newPerspectiveId.equals(currentPerspectiveId)) {
                if ("org.grits.toolbox.core.perspective.projectexplorer".equals(newPerspectiveId)) {
                    PropertyHandler.changePerspective(newPerspectiveId);
                    PropertyHandler.changePerspective(String.valueOf(newPerspectiveId) + ".<Default Perspective>");
                } else {
                    try {
                        PlatformUI.getWorkbench().showPerspective(newPerspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        if (newPerspectiveId.contains("experimentdesigner")) {
                            PropertyHandler.changePerspective("org.grits.toolbox.editor.experimentdesigner.designPerspective.<Experiment Design>");
                        }
                    }
                    catch (WorkbenchException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        PropertyHandler.changePerspective("org.grits.toolbox.core.perspective.projectexplorer");
                    }
                }
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

