/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;

public class LoggerStream
extends PrintStream {
    final PrintStream stream;

    public LoggerStream(AbstractLogger logger, Level level) {
        super(System.out);
        this.stream = new PrintStream(new HelperStream(logger, null, level), true);
    }

    public LoggerStream(AbstractLogger logger, Marker marker, Level level) {
        super(System.out);
        this.stream = new PrintStream(new HelperStream(logger, marker, level), true);
    }

    @Override
    public void write(int b) {
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.stream.write(b, off, len);
    }

    @Override
    public void flush() {
        this.stream.flush();
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public void print(boolean b) {
        this.stream.print(b);
    }

    @Override
    public void print(char c) {
        this.stream.print(c);
    }

    @Override
    public void print(int i) {
        this.stream.print(i);
    }

    @Override
    public void print(long l) {
        this.stream.print(l);
    }

    @Override
    public void print(float f) {
        this.stream.print(f);
    }

    @Override
    public void print(double d) {
        this.stream.print(d);
    }

    @Override
    public void print(char[] s) {
        this.stream.print(s);
    }

    @Override
    public void print(String s) {
        this.stream.print(s);
    }

    @Override
    public void print(Object obj) {
        this.stream.print(obj);
    }

    @Override
    public void println() {
        this.stream.println();
    }

    @Override
    public void println(boolean x) {
        this.stream.println(x);
    }

    @Override
    public void println(char x) {
        this.stream.println(x);
    }

    @Override
    public void println(int x) {
        this.stream.println(x);
    }

    @Override
    public void println(long x) {
        this.stream.println(x);
    }

    @Override
    public void println(float x) {
        this.stream.println(x);
    }

    @Override
    public void println(double x) {
        this.stream.println(x);
    }

    @Override
    public void println(char[] x) {
        this.stream.println(x);
    }

    @Override
    public void println(String x) {
        this.stream.println(x);
    }

    @Override
    public void println(Object x) {
        this.stream.println(x);
    }

    @Override
    public LoggerStream printf(String format, Object ... args) {
        this.stream.printf(format, args);
        return this;
    }

    @Override
    public LoggerStream printf(Locale l, String format, Object ... args) {
        this.stream.printf(l, format, args);
        return this;
    }

    @Override
    public LoggerStream append(char c) {
        this.stream.append(c);
        return this;
    }

    @Override
    public LoggerStream append(CharSequence csq) {
        this.stream.append(csq);
        return this;
    }

    @Override
    public LoggerStream append(CharSequence csq, int start, int end) {
        this.stream.append(csq, start, end);
        return this;
    }

    @Override
    public LoggerStream format(String format, Object ... args) {
        this.stream.format(format, args);
        return this;
    }

    @Override
    public LoggerStream format(Locale l, String format, Object ... args) {
        this.stream.format(l, format, args);
        return this;
    }

    @Override
    public boolean checkError() {
        return this.stream.checkError();
    }

    public String toString() {
        return "LoggerStream{stream=" + this.stream + '}';
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.stream.equals(((LoggerStream)other).stream);
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    private static class HelperStream
    extends ByteArrayOutputStream {
        private static final String FQCN = LoggerStream.class.getName();
        private final AbstractLogger logger;
        private final Level level;
        private final Marker marker;

        private HelperStream(AbstractLogger logger, Marker marker, Level level) {
            this.logger = logger;
            this.marker = marker;
            this.level = level;
        }

        private void log(int upTo) {
            if (upTo < 0 || upTo >= this.count) {
                throw new IndexOutOfBoundsException();
            }
            Message message = this.logger.getMessageFactory().newMessage(this.extractLine(upTo));
            this.logger.log(this.marker, FQCN, this.level, message, null);
        }

        private String extractLine(int upTo) {
            String line = new String(this.buf, 0, upTo);
            this.leftShiftBuffer(upTo + 1);
            return line;
        }

        private void leftShiftBuffer(int numBytes) {
            int remaining = this.count - numBytes;
            if (remaining > 0) {
                System.arraycopy(this.buf, numBytes, this.buf, 0, remaining);
                this.count = remaining + 1;
            } else {
                this.reset();
            }
        }

        @Override
        public synchronized void write(int b) {
            if (b == 13) {
                return;
            }
            super.write(b);
            if (b == 10) {
                this.log(this.count - 1);
            }
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            for (int i = 0; i < len; ++i) {
                this.write(b[off + i]);
            }
        }
    }
}

