/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import org.eurocarbdb.application.glycanbuilder.AndOperator;
import org.eurocarbdb.application.glycanbuilder.ConditionFactory;
import org.eurocarbdb.application.glycanbuilder.LinkageMatcher;
import org.eurocarbdb.application.glycanbuilder.NegationOperator;
import org.eurocarbdb.application.glycanbuilder.OrOperator;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.TrueCondition;
import org.eurocarbdb.application.glycanbuilder.XOrOperator;

class OperatorFactory {
    OperatorFactory() {
    }

    public static LinkageMatcher fromString(String init) throws Exception {
        init = TextUtils.trim(init);
        init = TextUtils.removeTrailingParentheses(init);
        if ((init = TextUtils.trim(init)).equals("")) {
            return new TrueCondition();
        }
        int ind = TextUtils.findFirstOfWithParentheses(init, "&|^");
        if (ind != -1) {
            String lop = init.substring(0, ind);
            char op = init.charAt(ind);
            String rop = init.substring(ind + 1);
            if (op == '&') {
                return new AndOperator(OperatorFactory.fromString(lop), OperatorFactory.fromString(rop));
            }
            if (op == '|') {
                return new OrOperator(OperatorFactory.fromString(lop), OperatorFactory.fromString(rop));
            }
            if (op == '^') {
                return new XOrOperator(OperatorFactory.fromString(lop), OperatorFactory.fromString(rop));
            }
            throw new Exception("Memory error");
        }
        if (init.startsWith("!")) {
            return new NegationOperator(OperatorFactory.fromString(init.substring(1)));
        }
        return ConditionFactory.fromString(init);
    }
}

