/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.FragmentSource;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentEntry
implements Comparable<FragmentEntry>,
SAXUtils.SAXWriter {
    public Glycan fragment;
    public String name;
    public Double mass;
    public Double mz_ratio;
    public String structure;
    public Double score;
    public FragmentSource source;

    public FragmentEntry() {
        this.fragment = null;
        this.name = "";
        this.mass = 0.0;
        this.mz_ratio = 0.0;
        this.structure = "";
        this.score = 0.0;
        this.source = null;
    }

    public FragmentEntry(Glycan _fragment, String _name) {
        this.fragment = _fragment != null ? _fragment.clone() : null;
        this.name = _name != null ? _name : "";
        this.mass = this.fragment != null ? this.fragment.computeMass() : 0.0;
        this.mz_ratio = this.fragment != null ? this.fragment.computeMZ() : 0.0;
        this.structure = this.fragment != null ? this.fragment.toString() : "";
        this.score = 0.0;
        this.source = null;
    }

    public FragmentEntry(Glycan _fragment, String _name, double _score) {
        this.fragment = _fragment != null ? _fragment.clone() : null;
        this.name = _name != null ? _name : "";
        this.mass = this.fragment != null ? this.fragment.computeMass() : 0.0;
        this.mz_ratio = this.fragment != null ? this.fragment.computeMZ() : 0.0;
        this.structure = this.fragment != null ? this.fragment.toString() : "";
        this.score = _score;
        this.source = null;
    }

    public FragmentEntry(Glycan _fragment, String _name, double _mass, double _mz_ratio, String _structure) {
        this.fragment = _fragment != null ? _fragment.clone() : null;
        this.name = _name != null ? _name : "";
        this.mass = _mass;
        this.mz_ratio = _mz_ratio;
        this.structure = _structure != null ? _structure : "";
        this.score = 0.0;
        this.source = null;
    }

    public FragmentEntry(Glycan _fragment, String _name, double _mass, double _mz_ratio, String _structure, double _score) {
        this.fragment = _fragment != null ? _fragment.clone() : null;
        this.name = _name != null ? _name : "";
        this.mass = _mass;
        this.mz_ratio = _mz_ratio;
        this.structure = _structure != null ? _structure : "";
        this.score = _score;
        this.source = null;
    }

    public FragmentEntry clone() {
        FragmentEntry ret = new FragmentEntry();
        ret.fragment = this.fragment != null ? this.fragment.clone() : null;
        ret.name = this.name;
        ret.mass = this.mass;
        ret.mz_ratio = this.mz_ratio;
        ret.structure = this.structure;
        ret.score = this.score;
        ret.source = this.source;
        return ret;
    }

    @Override
    public int compareTo(FragmentEntry fe) {
        if (fe == null) {
            return 1;
        }
        if (this.score > fe.score) {
            return -1;
        }
        if (this.score < fe.score) {
            return 1;
        }
        if (this.mz_ratio < fe.mz_ratio) {
            return -1;
        }
        if (this.mz_ratio > fe.mz_ratio) {
            return 1;
        }
        if (this.fragment == null && fe.fragment == null) {
            return 0;
        }
        if (this.fragment == null && fe.fragment != null) {
            return -1;
        }
        return this.fragment.compareTo(fe.fragment);
    }

    public boolean isEmpty() {
        return this.fragment == null || this.fragment.isEmpty();
    }

    public Glycan getFragment() {
        return this.fragment;
    }

    public Double getMass() {
        return this.mass;
    }

    public Double getMZ() {
        return this.mz_ratio;
    }

    public String getName() {
        return this.name;
    }

    public String getStructure() {
        return this.structure;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(double d) {
        this.score = d;
    }

    public FragmentSource getSource() {
        return this.source;
    }

    public void setSource(FragmentSource s) {
        this.source = s;
    }

    public IonCloud getCharges() {
        return this.fragment.getMassOptions().ION_CLOUD;
    }

    public IonCloud getNeutralExchanges() {
        return this.fragment.getMassOptions().NEUTRAL_EXCHANGES;
    }

    public FragmentEntry and(IonCloud charges) {
        FragmentEntry ret = this.clone();
        ret.setCharges(charges);
        return ret;
    }

    public FragmentEntry and(IonCloud charges, IonCloud exchanges) {
        FragmentEntry ret = this.clone();
        ret.setCharges(charges, exchanges);
        return ret;
    }

    public void setCharges(IonCloud charges) {
        this.setCharges(charges, new IonCloud(), true);
    }

    public void setCharges(IonCloud charges, IonCloud exchanges) {
        this.setCharges(charges, exchanges, true);
    }

    public void setCharges(IonCloud charges, IonCloud exchanges, boolean update_mz) {
        if (this.fragment != null) {
            this.fragment.getMassOptions().ION_CLOUD = charges;
            this.fragment.getMassOptions().NEUTRAL_EXCHANGES = exchanges;
            this.structure = this.fragment.toString();
            if (update_mz) {
                this.mz_ratio = charges.computeMZ(exchanges.getIonsMass() + this.mass);
            }
        }
    }

    public void updateMass() {
        IonCloud charges = this.fragment.getMassOptions().ION_CLOUD;
        IonCloud exchanges = this.fragment.getMassOptions().NEUTRAL_EXCHANGES;
        this.mass = this.fragment.computeMass();
        this.mz_ratio = charges.computeMZ(exchanges.getIonsMass() + this.mass);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FragmentEntry)) {
            return false;
        }
        FragmentEntry fe = (FragmentEntry)other;
        if (this.fragment == null) {
            return fe.fragment == null;
        }
        return Math.abs(this.mass - fe.mass) < 0.005 && this.fragment.equalsStructure(fe.fragment) && this.name.equals(fe.name);
    }

    public int hashCode() {
        int ret = 0;
        ret += this.mass.hashCode();
        ret += this.fragment.hashCode();
        return ret += this.name.hashCode();
    }

    public String toString() {
        return "" + this.name + " " + this.mass + " " + this.score + " " + this.structure;
    }

    public static FragmentEntry fromXML(Node fe_node) throws Exception {
        FragmentEntry ret = new FragmentEntry();
        ret.structure = XMLUtils.getAttribute(fe_node, "fragment");
        ret.name = XMLUtils.getAttribute(fe_node, "name");
        ret.mass = Double.valueOf(XMLUtils.getAttribute(fe_node, "mass"));
        ret.mz_ratio = Double.valueOf(XMLUtils.getAttribute(fe_node, "mz_ratio"));
        Glycan glycan = ret.fragment = ret.structure.length() > 0 ? Glycan.fromString(ret.structure, new MassOptions()) : null;
        if (XMLUtils.getAttribute(fe_node, "score") != null) {
            ret.score = Double.valueOf(XMLUtils.getAttribute(fe_node, "score"));
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element fe_node = document.createElement("FragmentEntry");
        if (fe_node == null) {
            return null;
        }
        fe_node.setAttribute("fragment", this.fragment != null ? this.fragment.toString() : "");
        fe_node.setAttribute("name", this.name);
        fe_node.setAttribute("mass", this.mass.toString());
        fe_node.setAttribute("mz_ratio", this.mz_ratio.toString());
        fe_node.setAttribute("score", this.score.toString());
        return fe_node;
    }

    @Override
    public void write(TransformerHandler th) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "fragment", "CDATA", this.fragment != null ? this.fragment.toString() : "");
        atts.addAttribute("", "", "name", "CDATA", this.name);
        atts.addAttribute("", "", "mass", "CDATA", this.mass.toString());
        atts.addAttribute("", "", "mz_ratio", "CDATA", this.mz_ratio.toString());
        atts.addAttribute("", "", "score", "CDATA", this.score.toString());
        th.startElement("", "", "FragmentEntry", atts);
        th.endElement("", "", "FragmentEntry");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "FragmentEntry";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            FragmentEntry ret = new FragmentEntry();
            ret.structure = this.stringAttribute(atts, "fragment", "");
            ret.name = this.stringAttribute(atts, "name", "");
            ret.mass = this.doubleAttribute(atts, "mass", 0.0);
            ret.mz_ratio = this.doubleAttribute(atts, "mz_ratio", 0.0);
            ret.score = this.doubleAttribute(atts, "score", 0.0);
            ret.fragment = ret.structure.length() > 0 ? Glycan.fromString(ret.structure, new MassOptions()) : null;
            this.object = ret;
        }
    }
}

