/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.mycustom.file.reader.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.file.scan.data.ScanView;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.widgets.tools.NotifyingProcess;

public class MyCustomFileReader
extends NotifyingProcess
implements IMSAnnotationFileReader {
    private static final Logger logger = Logger.getLogger(MyCustomFileReader.class);

    public boolean isValid(MSFile file) {
        Scanner s = this.getScannerFile(file.getFileName());
        return s != null;
    }

    public List<Scan> readMSFile(MSFile file) {
        List<Scan> lScans = this.getScanFromMyFile(file.getFileName());
        return lScans;
    }

    public List<Scan> readMSFile(MSFile file, int scanNumber) {
        List<Scan> scans = this.readMSFile(file);
        ArrayList<Scan> lScans = new ArrayList<Scan>();
        for (Scan scan : scans) {
            if (scan.getScanNo() != scanNumber) continue;
            lScans.add(scan);
        }
        return lScans;
    }

    public List<Scan> readMSFile(MSFile file, int msLevel, int parentScanNum, int scanNum) {
        List<Scan> scans = this.readMSFile(file);
        ArrayList<Scan> lScans = new ArrayList<Scan>();
        for (Scan scan : scans) {
            if (parentScanNum >= 0 && scan.getParentScan() != null && scan.getParentScan() == parentScanNum) {
                lScans.add(scan);
            }
            if (msLevel > 0 && scan.getMsLevel() == msLevel) {
                lScans.add(scan);
            }
            if (scanNum < 0 || scan.getScanNo() != scanNum) continue;
            lScans.add(scan);
        }
        return lScans;
    }

    public List<Integer> getScanList(MSFile file, int scanNumber) {
        List<Scan> lScans = this.readMSFile(file);
        ArrayList<Integer> lScanNos = new ArrayList<Integer>();
        for (Scan s : lScans) {
            lScanNos.add(s.getScanNo());
        }
        return lScanNos;
    }

    public Integer getMaxScanNumber(MSFile file) {
        List<Scan> lScans = this.readMSFile(file);
        int iMaxScanNum = Integer.MIN_VALUE;
        for (Scan s : lScans) {
            if (s.getScanNo() <= iMaxScanNum) continue;
            iMaxScanNum = s.getScanNo();
        }
        return iMaxScanNum;
    }

    public Integer getMinScanNumber(MSFile file) {
        List<Scan> lScans = this.readMSFile(file);
        int iMinScanNum = Integer.MAX_VALUE;
        for (Scan s : lScans) {
            if (s.getScanNo() >= iMinScanNum) continue;
            iMinScanNum = s.getScanNo();
        }
        return iMinScanNum;
    }

    public Integer getMinMSLevel(MSFile file) {
        List<Scan> lScans = this.readMSFile(file);
        int iMinMSLevel = Integer.MAX_VALUE;
        for (Scan s : lScans) {
            if (s.getScanNo() <= 0 || s.getMsLevel() >= iMinMSLevel) continue;
            iMinMSLevel = s.getMsLevel();
        }
        return iMinMSLevel;
    }

    public boolean hasMS1Scan(MSFile file) {
        List<Scan> lScans = this.readMSFile(file);
        for (Scan s : lScans) {
            if (s.getScanNo() <= 0 || s.getMsLevel() != 1) continue;
            return true;
        }
        return false;
    }

    private int countScansByMSLevel(List<Scan> lScans, int iMSLevel) {
        int iNumScans = 0;
        if (lScans != null) {
            for (Scan s : lScans) {
                if (s.getScanNo() <= 0 || s.getMsLevel() != iMSLevel) continue;
                ++iNumScans;
            }
        }
        return iNumScans;
    }

    public int getNumMS1Scans(MSFile file) {
        try {
            List<Scan> lScans = this.readMSFile(file);
            return this.countScansByMSLevel(lScans, 1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    public int getNumMS2Scans(MSFile file) {
        try {
            List<Scan> lScans = this.readMSFile(file);
            return this.countScansByMSLevel(lScans, 2);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    public List<ScanView> readMSFileForView(MSFile file, int msLevel, int parentScanNum, int scanNum) {
        try {
            this.updateListeners("Reading XML file", -1);
            List<Scan> scans = this.readMSFile(file, msLevel, parentScanNum, scanNum);
            ArrayList<ScanView> scansViewList = new ArrayList<ScanView>();
            for (Scan scan : scans) {
                ScanView scanView = new ScanView();
                scanView.setMsLevel(scan.getMsLevel());
                scanView.setScanNo(scan.getScanNo());
                scanView.setParentScan(scan.getParentScan());
                if (scan.getPrecursor() != null) {
                    scanView.setPreCursorIntensity(scan.getPrecursor().getIntensity());
                    scanView.setPreCursorMz(scan.getPrecursor().getMz());
                } else {
                    scanView.setPreCursorIntensity(Double.valueOf(1.0));
                    scanView.setPreCursorMz(Double.valueOf(-1.0));
                }
                scanView.setRetentionTime(scan.getRetentionTime());
                if (!scan.getSubScans().isEmpty()) {
                    scanView.setSubScans(this.readMSFileForView(file, -1, scan.getScanNo(), -1));
                }
                scansViewList.add(scanView);
            }
            if (scansViewList != null) {
                Collections.sort(scansViewList);
            }
            if (scansViewList.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scansViewList;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public Scan getFirstMS1Scan(MSFile file) {
        List<Scan> lScans = this.readMSFile(file);
        for (Scan s : lScans) {
            if (s.getMsLevel() != 1) continue;
            return s;
        }
        return null;
    }

    protected Scanner getScannerFile(String specFileName) {
        Scanner sc = null;
        File specFile = new File(specFileName);
        try {
            sc = new Scanner(specFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return sc;
    }

    public List<Scan> getScanFromMyFile(String specFilename) {
        Scanner sc = this.getScannerFile(specFilename);
        if (sc == null) {
            return null;
        }
        double mPrecursor = -1.0;
        String mMetal = "";
        String currentLine = sc.nextLine().trim();
        while (currentLine.startsWith("#") || currentLine.isEmpty()) {
            if (currentLine.startsWith("# Metal:")) {
                mMetal = currentLine.substring(9);
                if (mMetal.equals("H")) {
                    mMetal = "Proton";
                }
            } else if (currentLine.startsWith("# Precursor:")) {
                String[] fields = currentLine.substring(13).split(";");
                String temp = String.valueOf(mMetal) + "+";
                if (mMetal.equals("Proton")) {
                    temp = "H+";
                }
                String[] stringArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    int idx = (p = p.trim()).indexOf(temp);
                    if (idx != -1) {
                        mPrecursor = Double.valueOf(p.substring(idx + temp.length() + 1));
                    }
                    ++n2;
                }
            }
            currentLine = sc.nextLine().trim();
        }
        Scan ms1Scan = new Scan();
        ms1Scan.setMsLevel(Integer.valueOf(1));
        ms1Scan.setScanNo(Integer.valueOf(1));
        ms1Scan.setActivationMethode("CID");
        ms1Scan.setRetentionTime(Double.valueOf(0.0));
        ms1Scan.setTotalNumPeaks(Integer.valueOf(1));
        Peak precursor = new Peak();
        precursor.setCharge(Integer.valueOf(1));
        precursor.setIsPrecursor(true);
        precursor.setPrecursorMz(Double.valueOf(mPrecursor));
        precursor.setMz(Double.valueOf(mPrecursor));
        precursor.setIntensity(Double.valueOf(1.0));
        precursor.setId(Integer.valueOf(1));
        Scan ms2Scan = new Scan();
        ms2Scan.setMsLevel(Integer.valueOf(2));
        ms2Scan.setScanNo(Integer.valueOf(2));
        ms2Scan.setIsCentroided(Boolean.valueOf(true));
        ms2Scan.setActivationMethode("CID");
        ms1Scan.getSubScans().add(2);
        ms1Scan.getPeaklist().add(precursor);
        ms2Scan.setPrecursor(precursor);
        ArrayList<Peak> peakList = new ArrayList<Peak>();
        int iPeakCnt = 2;
        while (sc.hasNextLine()) {
            Scanner lineSc = new Scanner(sc.nextLine().trim());
            if (!lineSc.hasNext()) continue;
            double rawMZ = lineSc.nextDouble();
            int rawZ = Character.getNumericValue(lineSc.next().charAt(0));
            double intensity = lineSc.nextDouble();
            lineSc.close();
            Peak peak = new Peak();
            peak.setCharge(Integer.valueOf(rawZ));
            peak.setMz(Double.valueOf(rawMZ));
            peak.setIntensity(Double.valueOf(intensity));
            peak.setId(Integer.valueOf(iPeakCnt++));
            peakList.add(peak);
        }
        ms2Scan.setPeaklist(peakList);
        ms2Scan.setTotalNumPeaks(Integer.valueOf(peakList.size()));
        ms2Scan.setParentScan(Integer.valueOf(1));
        ms2Scan.setPrecursor(precursor);
        sc.close();
        ArrayList<Scan> scans = new ArrayList<Scan>();
        scans.add(ms1Scan);
        scans.add(ms2Scan);
        return scans;
    }
}

