/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.KCF;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.io.KCF.KCFMonosaccharideDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.HexoseDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.PrefixDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.MonosaccharideNotationAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.SubstituentIUPACNotationAnalyzer;

public class KCFNotationToIUPACNotation {
    public String start(String _input) throws GlyCoImporterException, GlycanException, TrivialNameException {
        Matcher matHead;
        Matcher matUlo;
        Matcher matDeoxy;
        Matcher unsat;
        Matcher matAnhydro;
        String ulosonic = "";
        String ringSize = "";
        String tailStatus = "";
        boolean haveMod = false;
        KCFMonosaccharideDescriptor firstUnit = null;
        String firstConfig = "";
        KCFMonosaccharideDescriptor secondUnit = null;
        String secondConfig = "";
        Enum superClass = null;
        ArrayList<String> subs = new ArrayList<String>();
        ArrayList<String> mods = new ArrayList<String>();
        if (!MonosaccharideNotationAnalyzer.start(_input)) {
            throw new GlyCoImporterException(String.valueOf(_input) + " is not found!");
        }
        Matcher prefixSub = Pattern.compile("(\\d)-([CO])-([Ff]ormyl|[Mm]ethyl)").matcher(_input);
        if (prefixSub.find()) {
            BaseSubstituentTemplate subT;
            if (prefixSub.group(3).equalsIgnoreCase("formyl")) {
                subT = BaseSubstituentTemplate.FORMYL;
                subs.add(String.valueOf(prefixSub.group(1)) + subT.getIUPACnotation());
                _input = _input.replace(prefixSub.group(), "");
            }
            if (prefixSub.group(3).equalsIgnoreCase("methyl")) {
                subT = BaseSubstituentTemplate.METHYL;
                subs.add(String.valueOf(prefixSub.group(1)) + subT.getIUPACnotation());
                _input = _input.replace(prefixSub.group(), "");
            }
        }
        if ((matAnhydro = Pattern.compile("-?(\\d,\\d-Anhydro)-").matcher(_input)).find()) {
            mods.add(matAnhydro.group(1));
            _input = _input.replace(matAnhydro.group(), "");
        }
        if ((unsat = Pattern.compile("-?(\\d)-?(enx|en)-").matcher(_input)).find()) {
            haveMod = true;
            subs.add(String.valueOf(unsat.group(1)) + unsat.group(2));
            _input = _input.replace(unsat.group(), "");
        }
        if ((matDeoxy = Pattern.compile("([\\d,]+)+(d|-deoxy-)+").matcher(_input)).find()) {
            haveMod = true;
            mods.add(this.analyzeDeoxy(matDeoxy.group(1)));
            _input = _input.replace(matDeoxy.group(), "");
        }
        if ((matUlo = Pattern.compile("-?([\\d,]+)-?(.*ulo)").matcher(_input)).find()) {
            haveMod = true;
            String[] stringArray = matUlo.group(1).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String unit = stringArray[n2];
                ulosonic = String.valueOf(ulosonic) + unit + "ulo";
                ++n2;
            }
            _input = _input.replace(matUlo.group(), "");
        }
        if ((matHead = Pattern.compile("(-(ol|onic|aric|uronic))").matcher(_input)).find()) {
            tailStatus = matHead.group(1);
            _input = _input.replace(matHead.group(), "");
        }
        int count = 0;
        Enum[] enumArray = KCFMonosaccharideDescriptor.values();
        int n = enumArray.length;
        int n3 = 0;
        while (n3 < n) {
            KCFMonosaccharideDescriptor values = enumArray[n3];
            String code = "";
            String config = "";
            if (_input.contains(values.getCode())) {
                config = this.extractConfiguration(_input, values.getCode());
                ringSize = this.extractRingSize(_input, values.getCode());
                code = values.getCode();
                _input = _input.replace(String.valueOf(config) + values.getCode() + ringSize, "");
                if (values.equals((Object)KCFMonosaccharideDescriptor.THO)) {
                    values = KCFMonosaccharideDescriptor.THR;
                    code = values.getCode();
                }
                ++count;
            }
            if (_input.contains(values.getCode().toLowerCase())) {
                config = this.extractConfiguration(_input, values.getCode().toLowerCase());
                ringSize = this.extractRingSize(_input, values.getCode().toLowerCase());
                code = values.getCode().toLowerCase();
                _input = _input.replace(String.valueOf(config) + values.getCode().toLowerCase() + ringSize, "");
                if (values.equals((Object)KCFMonosaccharideDescriptor.THO)) {
                    values = KCFMonosaccharideDescriptor.THR;
                    code = values.getCode().toLowerCase();
                }
                ++count;
            }
            if (!code.equals("")) {
                if (count == 1) {
                    firstUnit = values;
                } else {
                    secondUnit = values;
                }
            }
            if (!config.equals("")) {
                if (count == 1) {
                    firstConfig = config;
                } else {
                    secondConfig = config;
                }
            }
            ++n3;
        }
        enumArray = SuperClass.values();
        n = enumArray.length;
        n3 = 0;
        while (n3 < n) {
            Enum values = enumArray[n3];
            if (_input.contains(((SuperClass)values).getSuperClass())) {
                ringSize = this.extractRingSize(_input, ((SuperClass)values).getSuperClass());
                String config = this.extractConfiguration(_input, ((SuperClass)values).getSuperClass());
                superClass = values;
                if (firstUnit == null && secondUnit == null) {
                    firstConfig = config;
                }
                _input = _input.replace(String.valueOf(config) + ((SuperClass)values).getSuperClass() + ringSize, "");
            }
            ++n3;
        }
        SubstituentIUPACNotationAnalyzer subAna = new SubstituentIUPACNotationAnalyzer();
        subs.addAll(subAna.resolveSubstituents(this.trimHyphen(_input), true));
        StringBuilder notation = new StringBuilder();
        notation = this.appendPrefixAnnotations(notation, mods);
        if (firstUnit != null) {
            notation = this.appendCoreNotation(notation, this.modifyConfiguration(firstConfig, firstUnit.getCode()), firstUnit, superClass != null);
        }
        if (firstUnit == null && secondUnit == null) {
            notation.append(String.valueOf(firstConfig.equals("D/L") || firstConfig.equals("") ? "?" : firstConfig) + "-");
        }
        if (secondUnit != null) {
            notation.append("-?-");
            if (secondConfig.equals("")) {
                secondConfig = this.modifyConfiguration(firstConfig, secondUnit.getCode());
            }
            notation = this.appendCoreNotation(notation, secondConfig, secondUnit, true);
        }
        if (superClass != null) {
            notation.append(((SuperClass)superClass).getSuperClass());
        }
        notation.append(ulosonic);
        if (secondUnit != null) {
            ringSize = this.modifyRingSize(ringSize, secondConfig, secondUnit);
        }
        if (firstUnit != null && secondUnit == null) {
            ringSize = this.modifyRingSize(ringSize, firstConfig, firstUnit);
        }
        if (firstUnit == null && secondUnit == null && superClass != null) {
            ringSize = "p";
        }
        notation.append(ringSize);
        String code = "";
        if (firstUnit != null && secondUnit == null) {
            code = firstUnit.getCode();
        }
        if (secondUnit != null) {
            code = secondUnit.getCode();
        }
        notation = this.appendAcidicStatus(notation, subs, code);
        notation.append(tailStatus);
        return notation.toString();
    }

    private StringBuilder appendAcidicStatus(StringBuilder _sb, ArrayList<String> _subs, String _code) throws GlyCoImporterException {
        String nativeSub = "";
        HexoseDescriptor hexDesc = HexoseDescriptor.forTrivialName(_code);
        for (String unit : _subs) {
            if (unit.matches("\\d.*")) continue;
            nativeSub = unit;
        }
        if (nativeSub.equals("A") || nativeSub.matches("N(Ac|Fo\\w*)?A") || nativeSub.matches("AN(Ac|Fo\\w*)?")) {
            _subs.remove(nativeSub);
            _sb.append("A");
            if (nativeSub.endsWith("A")) {
                nativeSub = nativeSub.substring(0, nativeSub.length() - 1);
            }
            if (nativeSub.startsWith("A") && !nativeSub.equals("A")) {
                nativeSub = nativeSub.substring(1, nativeSub.length());
            }
            if (!nativeSub.equals("A")) {
                _subs.add(nativeSub);
            }
        }
        String modifiedSub = this.modifySubstituentNotation(nativeSub);
        if (hexDesc != null) {
            if (nativeSub.matches("[GA]c") && hexDesc.equals((Object)HexoseDescriptor.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(String.valueOf(5) + modifiedSub);
            }
            if (nativeSub.matches("N[AG]c") && hexDesc.equals((Object)HexoseDescriptor.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(modifiedSub.replaceFirst("N", "5"));
            }
            if (nativeSub.matches("[GA]c") && !hexDesc.equals((Object)HexoseDescriptor.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(String.valueOf(2) + modifiedSub);
            }
            if (nativeSub.matches("(?!NAc)N\\w+") && !hexDesc.equals((Object)HexoseDescriptor.NEU)) {
                _subs.remove(nativeSub);
                _subs.add(String.valueOf(2) + modifiedSub);
            }
            if ((nativeSub.equals("N") || nativeSub.equals("NAc")) && !hexDesc.equals((Object)HexoseDescriptor.NEU)) {
                _subs.remove(nativeSub);
                _sb.append(modifiedSub);
            }
        } else if (nativeSub.startsWith("N")) {
            _subs.remove(nativeSub);
            _subs.add(String.valueOf(2) + modifiedSub);
        }
        LinkedHashMap<String, ArrayList> sortedSubs = new LinkedHashMap<String, ArrayList>();
        Collections.sort(_subs);
        for (String unit : _subs) {
            ArrayList positions;
            Matcher matSub = Pattern.compile("([\\d,]+)+([(\\w]+.*)").matcher(unit);
            if (!matSub.find()) continue;
            String subNode = this.modifySubstituentNotation(matSub.group(2));
            if (!sortedSubs.containsKey(subNode)) {
                positions = new ArrayList();
                positions.add(matSub.group(1));
                sortedSubs.put(subNode, positions);
                continue;
            }
            positions = (ArrayList)sortedSubs.get(subNode);
            positions.add(matSub.group(1));
            sortedSubs.put(subNode, positions);
        }
        for (String key : sortedSubs.keySet()) {
            StringBuilder sub = new StringBuilder();
            Iterator iterPos = ((ArrayList)sortedSubs.get(key)).iterator();
            while (iterPos.hasNext()) {
                sub.append((String)iterPos.next());
                if (!iterPos.hasNext()) continue;
                sub.append(",");
            }
            sub.append(key);
            if (((ArrayList)sortedSubs.get(key)).size() > 1) {
                sub.append(((ArrayList)sortedSubs.get(key)).size());
            }
            _sb.append((CharSequence)sub);
        }
        return _sb;
    }

    private StringBuilder appendCoreNotation(StringBuilder _sb, String _configuration, KCFMonosaccharideDescriptor _kcfDesc, boolean _isLowCase) {
        if (_configuration != null && _kcfDesc != null) {
            _sb.append(_configuration);
            _sb.append("-");
            _sb.append(_isLowCase ? _kcfDesc.getCode().toLowerCase() : _kcfDesc.getCode());
        }
        return _sb;
    }

    private StringBuilder appendPrefixAnnotations(StringBuilder _sb, ArrayList<String> _mods) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (String unit : _mods) {
            String[] items = unit.split("-");
            sorted.put(items[1], items[0]);
        }
        for (String key : sorted.keySet()) {
            _sb.append(String.valueOf((String)sorted.get(key)) + "-" + key + "-");
        }
        return _sb;
    }

    private String modifySubstituentNotation(String _subNotation) throws GlyCoImporterException {
        BaseSubstituentTemplate subT;
        if (_subNotation.matches("N?diMe")) {
            _subNotation = _subNotation.replaceFirst("di", "Di");
        }
        if ((subT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(_subNotation)) == null) {
            subT = BaseSubstituentTemplate.forGlycoCTNotationWithIgnore(_subNotation);
        }
        if (subT == null && _subNotation.startsWith("N")) {
            _subNotation = _subNotation.replaceFirst("N", "N-");
            subT = BaseSubstituentTemplate.forGlycoCTNotationWithIgnore(_subNotation);
        }
        if (subT == null) {
            if (_subNotation.equals("Me")) {
                subT = BaseSubstituentTemplate.METHYL;
            }
            if (_subNotation.contains("Pyr") || _subNotation.contains("pyr")) {
                if (_subNotation.startsWith("(R")) {
                    subT = BaseSubstituentTemplate.R_PYRUVATE;
                }
                if (_subNotation.startsWith("(S")) {
                    subT = BaseSubstituentTemplate.S_PYRUVATE;
                }
                if (_subNotation.startsWith("Pyr") || _subNotation.startsWith("pyr")) {
                    subT = BaseSubstituentTemplate.X_PYRUVATE;
                }
            }
        }
        if (subT == null) {
            return _subNotation;
        }
        return subT.getIUPACnotation();
    }

    private String modifyConfiguration(String _configuration, String _notation) {
        if (_configuration.equals("D/L") || _configuration.equals("L/D")) {
            return "?";
        }
        if (_notation.contains("Col") || _notation.contains("Asc")) {
            return "L";
        }
        if (!_configuration.equals("")) {
            return _configuration;
        }
        return "D";
    }

    private String modifyRingSize(String _ringSize, String _config, KCFMonosaccharideDescriptor _kcfDesc) {
        if (!_ringSize.equals("")) {
            return _ringSize;
        }
        if (_kcfDesc.equals((Object)KCFMonosaccharideDescriptor.THR) || _kcfDesc.equals((Object)KCFMonosaccharideDescriptor.ERY) || _kcfDesc.equals((Object)KCFMonosaccharideDescriptor.API) || _kcfDesc.equals((Object)KCFMonosaccharideDescriptor.THO)) {
            return "f";
        }
        return "p";
    }

    private String extractRingSize(String _kcfNotation, String _notation) {
        String ringSize = "";
        Matcher matRing = Pattern.compile(String.valueOf(_notation) + "([pf?])" + ".*").matcher(_kcfNotation);
        if (matRing.find()) {
            ringSize = matRing.group(1);
        }
        return ringSize;
    }

    private String extractConfiguration(String _kcfNotation, String _notation) {
        String configuration = "";
        Matcher matConfig = Pattern.compile("([DL/?]+)-?" + _notation + ".*").matcher(_kcfNotation);
        if (matConfig.find()) {
            configuration = matConfig.group(1);
        }
        return configuration;
    }

    private String analyzeDeoxy(String _position) throws TrivialNameException {
        PrefixDescriptor preDesc = PrefixDescriptor.forNumber(_position.split(",").length);
        return String.valueOf(_position) + "-" + preDesc.getPrefix() + "deoxy";
    }

    private String trimHyphen(String _notation) {
        _notation = _notation.replaceAll("-", "");
        return _notation;
    }
}

