/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.nebula.visualization.xygraph.Messages;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AnnotationConfigPage {
    private IXYGraph xyGraph;
    private Annotation annotation;
    private Text nameText;
    private Button snapToTrace;
    private Button useDefaultColorButton;
    private Combo xAxisOrTraceCombo;
    private Combo yAxisCombo;
    private ColorSelector colorSelector;
    private Font font;
    private Combo cursorLineCombo;
    private Button showNameButton;
    private Button showSampleInfoButton;
    private Button showPositionButton;
    private Label fontLabel;
    private Composite composite;
    private Label xAxisLabel;
    private Label yAxisLabel;
    private Label colorLabel;

    public AnnotationConfigPage(IXYGraph xyGraph, Annotation annotation) {
        this.xyGraph = xyGraph;
        this.annotation = annotation;
        this.font = annotation.getFont();
    }

    public void createPage(final Composite composite) {
        this.composite = composite;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.Annotation_Name);
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(composite, 2052);
        this.nameText.setToolTipText(Messages.Annotation_NameTT);
        this.nameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.snapToTrace = new Button(composite, 32);
        this.snapToTrace.setText(Messages.Annotation_Snap);
        this.snapToTrace.setToolTipText(Messages.Annotation_SnapTT);
        this.snapToTrace.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.xAxisLabel = new Label(composite, 0);
        this.xAxisLabel.setLayoutData((Object)new GridData());
        this.xAxisOrTraceCombo = new Combo(composite, 4);
        this.xAxisOrTraceCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.yAxisLabel = new Label(composite, 0);
        this.yAxisLabel.setText(Messages.Annotation_YAxis);
        this.yAxisLabel.setLayoutData((Object)new GridData());
        this.yAxisCombo = new Combo(composite, 4);
        this.yAxisCombo.setToolTipText(Messages.Annotation_YAxisSnapTT);
        this.yAxisCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.snapToTrace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnnotationConfigPage.this.snapToTrace.getSelection()) {
                    AnnotationConfigPage.this.xAxisLabel.setText(Messages.Annotation_Trace);
                    AnnotationConfigPage.this.xAxisOrTraceCombo.setToolTipText(Messages.Annotation_TraceSnapTT);
                } else {
                    AnnotationConfigPage.this.xAxisLabel.setText(Messages.Annotation_XAxis);
                    AnnotationConfigPage.this.xAxisOrTraceCombo.setToolTipText(Messages.Annotation_XAxisSnapTT);
                }
                AnnotationConfigPage.this.xAxisOrTraceCombo.removeAll();
                if (AnnotationConfigPage.this.snapToTrace.getSelection()) {
                    for (Trace trace : AnnotationConfigPage.this.xyGraph.getPlotArea().getTraceList()) {
                        AnnotationConfigPage.this.xAxisOrTraceCombo.add(trace.getName());
                    }
                } else {
                    for (Axis axis : AnnotationConfigPage.this.xyGraph.getXAxisList()) {
                        AnnotationConfigPage.this.xAxisOrTraceCombo.add(axis.getTitle());
                    }
                }
                AnnotationConfigPage.this.xAxisOrTraceCombo.select(0);
                if (AnnotationConfigPage.this.annotation.isFree() && !AnnotationConfigPage.this.snapToTrace.getSelection()) {
                    AnnotationConfigPage.this.xAxisOrTraceCombo.select(AnnotationConfigPage.this.xyGraph.getXAxisList().indexOf(AnnotationConfigPage.this.annotation.getXAxis()));
                } else if (!AnnotationConfigPage.this.annotation.isFree() && AnnotationConfigPage.this.snapToTrace.getSelection()) {
                    AnnotationConfigPage.this.xAxisOrTraceCombo.select(AnnotationConfigPage.this.xyGraph.getPlotArea().getTraceList().indexOf(AnnotationConfigPage.this.annotation.getTrace()));
                }
                AnnotationConfigPage.this.yAxisLabel.setVisible(!AnnotationConfigPage.this.snapToTrace.getSelection());
                AnnotationConfigPage.this.yAxisCombo.setVisible(!AnnotationConfigPage.this.snapToTrace.getSelection());
                composite.layout(true, true);
            }
        });
        this.useDefaultColorButton = new Button(composite, 32);
        this.useDefaultColorButton.setText(Messages.Annotation_ColorFromYAxis);
        this.useDefaultColorButton.setLayoutData((Object)new GridData(4, 0, false, false, 2, 1));
        this.colorLabel = new Label(composite, 0);
        this.colorLabel.setText(Messages.Annotation_Color);
        this.colorLabel.setLayoutData((Object)new GridData());
        this.colorSelector = new ColorSelector(composite);
        this.colorSelector.getButton().setLayoutData((Object)new GridData());
        this.useDefaultColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationConfigPage.this.colorSelector.getButton().setVisible(!AnnotationConfigPage.this.useDefaultColorButton.getSelection());
                AnnotationConfigPage.this.colorLabel.setVisible(!AnnotationConfigPage.this.useDefaultColorButton.getSelection());
            }
        });
        this.fontLabel = new Label(composite, 0);
        this.fontLabel.setLayoutData((Object)new GridData());
        Button fontButton = new Button(composite, 8);
        fontButton.setText(Messages.Annotation_ChangeFont);
        fontButton.setLayoutData((Object)new GridData());
        fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                fontDialog.setEffectsVisible(false);
                if (AnnotationConfigPage.this.font != null) {
                    fontDialog.setFontList(AnnotationConfigPage.this.font.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    AnnotationConfigPage.this.font = XYGraphMediaFactory.getInstance().getFont(fontData);
                    AnnotationConfigPage.this.fontLabel.setFont(AnnotationConfigPage.this.font);
                    AnnotationConfigPage.this.fontLabel.setText(String.valueOf(Messages.Annotation_Font) + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        Label cursorLineLabel = new Label(composite, 0);
        cursorLineLabel.setText(Messages.Annotation_Cursor);
        cursorLineLabel.setLayoutData((Object)new GridData());
        this.cursorLineCombo = new Combo(composite, 4);
        this.cursorLineCombo.setItems(Annotation.CursorLineStyle.stringValues());
        this.cursorLineCombo.setLayoutData((Object)new GridData());
        this.showNameButton = new Button(composite, 32);
        this.showNameButton.setText(Messages.Annotation_ShowName);
        this.showNameButton.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.showSampleInfoButton = new Button(composite, 32);
        this.showSampleInfoButton.setText(Messages.Annotation_ShowInfo);
        this.showSampleInfoButton.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.showPositionButton = new Button(composite, 32);
        this.showPositionButton.setText(Messages.Annotation_ShowPosition);
        this.showPositionButton.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.initialize();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void applyChanges() {
        this.annotation.setName(this.nameText.getText());
        if (this.snapToTrace.getSelection()) {
            this.annotation.setTrace(this.xyGraph.getPlotArea().getTraceList().get(this.xAxisOrTraceCombo.getSelectionIndex()));
        } else {
            this.annotation.setFree(this.xyGraph.getXAxisList().get(this.xAxisOrTraceCombo.getSelectionIndex()), this.xyGraph.getYAxisList().get(this.yAxisCombo.getSelectionIndex()));
        }
        if (!this.useDefaultColorButton.getSelection()) {
            this.annotation.setAnnotationColor(XYGraphMediaFactory.getInstance().getColor(this.colorSelector.getColorValue()));
        } else {
            this.annotation.setAnnotationColor(null);
        }
        this.annotation.setFont(this.font);
        this.annotation.setCursorLineStyle(Annotation.CursorLineStyle.values()[this.cursorLineCombo.getSelectionIndex()]);
        this.annotation.setShowName(this.showNameButton.getSelection());
        this.annotation.setShowSampleInfo(this.showSampleInfoButton.getSelection());
        this.annotation.setShowPosition(this.showPositionButton.getSelection());
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    private void initialize() {
        this.nameText.setText(this.annotation.getName());
        this.nameText.setSelection(0, this.nameText.getText().length());
        this.snapToTrace.setSelection(!this.annotation.isFree());
        this.xAxisLabel.setText(this.snapToTrace.getSelection() ? Messages.Annotation_Trace : Messages.Annotation_XAxis);
        this.xAxisOrTraceCombo.removeAll();
        if (!this.annotation.isFree()) {
            for (Trace trace : this.xyGraph.getPlotArea().getTraceList()) {
                this.xAxisOrTraceCombo.add(trace.getName());
            }
            this.xAxisOrTraceCombo.select(this.xyGraph.getPlotArea().getTraceList().indexOf(this.annotation.getTrace()));
        } else {
            for (Axis axis : this.xyGraph.getXAxisList()) {
                this.xAxisOrTraceCombo.add(axis.getTitle());
            }
            this.xAxisOrTraceCombo.select(this.xyGraph.getXAxisList().indexOf(this.annotation.getXAxis()));
        }
        for (Axis axis : this.xyGraph.getYAxisList()) {
            this.yAxisCombo.add(axis.getTitle());
        }
        this.yAxisCombo.select(this.xyGraph.getYAxisList().indexOf(this.annotation.getYAxis()));
        this.yAxisLabel.setVisible(!this.snapToTrace.getSelection());
        this.yAxisCombo.setVisible(!this.snapToTrace.getSelection());
        this.useDefaultColorButton.setSelection(this.annotation.getAnnotationColor() == null);
        this.colorLabel.setVisible(!this.useDefaultColorButton.getSelection());
        this.colorSelector.getButton().setVisible(this.annotation.getAnnotationColor() != null);
        this.colorSelector.setColorValue(this.annotation.getAnnotationColor() == null ? this.annotation.getYAxis().getForegroundColor().getRGB() : this.annotation.getAnnotationColor().getRGB());
        this.fontLabel.setText(String.valueOf(Messages.Annotation_Font) + (this.font == null ? Messages.Annotation_SystemDefault : this.font.getFontData()[0].getName()));
        this.fontLabel.setFont(this.font);
        this.cursorLineCombo.select(this.annotation.getCursorLineStyle().getIndex());
        this.showNameButton.setSelection(this.annotation.isShowName());
        this.showSampleInfoButton.setSelection(this.annotation.isShowSampleInfo());
        this.showPositionButton.setSelection(this.annotation.isShowPosition());
    }
}

