/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.annotation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.LipidSettings;

public class GlycolipidDatabaseSettingsTableComposite
extends Composite {
    List<AnalyteSettings> analyteSettings = new ArrayList<AnalyteSettings>();
    TableViewer settingsTableViewer;

    public GlycolipidDatabaseSettingsTableComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setAnalyteSettings(List<AnalyteSettings> analyteSettings) {
        this.analyteSettings = analyteSettings;
        if (this.settingsTableViewer != null) {
            this.settingsTableViewer.setInput(analyteSettings);
            this.settingsTableViewer.refresh();
        }
    }

    public List<AnalyteSettings> getAnalyteSettings() {
        return this.analyteSettings;
    }

    public TableViewer getSettingsTableViewer() {
        return this.settingsTableViewer;
    }

    public void createTable() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        this.setLayout((Layout)layout);
        this.settingsTableViewer = new TableViewer((Composite)this, 67584);
        Table settingsTable = this.settingsTableViewer.getTable();
        GridData gd_table_2 = new GridData(4, 4, true, true, 1, 1);
        gd_table_2.heightHint = 80;
        settingsTable.setLayoutData((Object)gd_table_2);
        settingsTable.setHeaderVisible(true);
        settingsTable.setLinesVisible(true);
        this.addTableViewerColumn(this.settingsTableViewer, "Glycan Database Name", 200, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AnalyteSettings)) {
                    return "";
                }
                GlycanSettings gSettings = ((AnalyteSettings)element).getGlycanSettings();
                if (gSettings == null || gSettings.getFilter() == null) {
                    return "";
                }
                String dbName = gSettings.getFilter().getDatabase();
                if (dbName.lastIndexOf(File.separator) != -1) {
                    dbName = dbName.substring(dbName.lastIndexOf(File.separator) + 1);
                }
                return String.valueOf(dbName) + " (Ver. " + (gSettings.getFilter().getVersion() != null ? gSettings.getFilter().getVersion() : "1.0") + ")";
            }
        });
        this.addTableViewerColumn(this.settingsTableViewer, "Glycan Filter", 200, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AnalyteSettings)) {
                    return "";
                }
                GlycanSettings gSettings = ((AnalyteSettings)element).getGlycanSettings();
                if (gSettings != null && gSettings.getFilterSetting() != null) {
                    return gSettings.getFilterSetting().getName() != null ? gSettings.getFilterSetting().getName() : gSettings.getFilterSetting().getFilter().toString();
                }
                return "";
            }
        });
        this.addTableViewerColumn(this.settingsTableViewer, "Lipid Database Name", 200, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AnalyteSettings)) {
                    return "";
                }
                LipidSettings lSettings = ((AnalyteSettings)element).getLipidSettings();
                if (lSettings == null || lSettings.getDatabase() == null) {
                    return "";
                }
                String dbName = lSettings.getDatabase().getURI();
                if (dbName.lastIndexOf(File.separator) != -1) {
                    dbName = dbName.substring(dbName.lastIndexOf(File.separator) + 1);
                }
                return dbName;
            }
        });
        this.addTableViewerColumn(this.settingsTableViewer, "Derivatization Name", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AnalyteSettings)) {
                    return "";
                }
                GlycanSettings gSettings = ((AnalyteSettings)element).getGlycanSettings();
                if (gSettings != null) {
                    return gSettings.getPerDerivatisationType();
                }
                LipidSettings lSettings = ((AnalyteSettings)element).getLipidSettings();
                if (lSettings != null) {
                    return lSettings.getPerDerivatisationType();
                }
                return "";
            }
        });
        this.settingsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.settingsTableViewer.setInput(this.getAnalyteSettings());
    }

    private TableViewerColumn addTableViewerColumn(TableViewer a_settingsTV, String a_text, int a_iWidth, ColumnLabelProvider a_labelProvider) {
        TableViewerColumn t_col = new TableViewerColumn(a_settingsTV, 0);
        t_col.getColumn().setText(a_text);
        t_col.getColumn().setWidth(a_iWidth);
        t_col.setLabelProvider((CellLabelProvider)a_labelProvider);
        return t_col;
    }
}

